// The template and inlines for the -*- C++ -*- complex number classes.

// Copyright (C) 1997-1999 Cygnus Solutions
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

// As a special exception, you may use this file as part of a free software
// library without restriction.  Specifically, if other files instantiate
// templates or use macros or inline functions from this file, or you compile
// this file and link it with other files to produce an executable, this
// file does not by itself cause the resulting executable to be covered by
// the GNU General Public License.  This exception does not however
// invalidate any other reasons why the executable file might be covered by
// the GNU General Public License.


#include <bits/std_complex.h>
#include <bits/std_cmath.h>
// This is a ISO C 9X header.
#include <math/mathconf.h>
#undef complex

#ifndef FLT
# define FLT double
# define FCT(name) name
#endif

namespace std
{

template <class T, class charT, class traits>
basic_istream <charT, traits> &
operator >> (basic_istream<charT, traits> &__is, complex<T> &__x)
{
  // XXX TODO
  return __is;
}

template <class charT, class traits>
basic_ostream<charT, traits> &
operator << (basic_ostream<charT, traits> &__os, const complex<FLT> &__x)
{
  basic_ostringstream<charT, traits> __s;
  __s.flags (__os.flags ());
#ifdef _G_HAVE_LOCALE
  __s.imbue (__os.getloc ());
#endif
  __s.precision (__os.precision ());
  __s << '(' << __x.real () << "," << __x.imag () << ')' << ends;
  return __os << __s.str ();
}


FLT
abs (const complex<FLT> &x)
{
  return FCT(__mycabs) (x.__value ());
}

FLT
arg (const complex<FLT> &x)
{
  return FCT(carg) (x.__value ());
}

complex<FLT>
polar (const FLT &rho, const FLT &theta)
{
#if defined _G_HAVE_SINCOS && !defined __osf__
  /* Although sincos does exist on OSF3.2 and OSF4.0 we cannot use it
     since the necessary types are not defined in the headers.  */
  FLT __sinx, __cosx;
  FCT(sincos) (theta, &__sinx, &__cosx);
  return complex<FLT> (rho * __cosx, rho * __sinx);
#else
  return complex<FLT> (rho * FCT(cos) (theta), rho * FCT(sin) (theta));
#endif
}

complex<FLT>
cos (const complex<FLT> &x)
{
  return complex<FLT> (FCT(ccos) (x.__value ()));
}

complex<FLT>
cosh (const complex<FLT> &x)
{
  return complex<FLT> (FCT(ccosh) (x.__value ()));
}

complex<FLT>
exp (const complex<FLT> &x)
{
  return complex<FLT> (FCT(cexp) (x.__value ()));
}

complex<FLT>
log (const complex<FLT> &x)
{
  return complex<FLT> (FCT(c_log) (x.__value ()));
}

complex<FLT>
log10 (const complex<FLT> &x)
{
#ifdef _G_HAVE_CLOG10
  return complex<FLT> (FCT(clog10) (x.__value ()));
#else
  // This is very weak !!!
  return complex<FLT> (FCT(c_log) (x.__value () / FCT(log) (10.0)));
#endif
}

complex<FLT>
pow (const complex<FLT> &x, int n)
{
  return complex<FLT> (FCT(cexp) (n * FCT(c_log) (x.__value ())));
}

complex<FLT>
pow (const complex<FLT> &x, const FLT &y)
{
  return complex<FLT> (FCT(cexp) (y * FCT(c_log) (x.__value ())));
}

complex<FLT>
pow (const complex<FLT> &x, const complex<FLT> &y)
{
  return complex<FLT> (FCT(cpow) (x.__value (), y.__value ()));
}

complex<FLT>
pow (const FLT &x, const complex<FLT> &y)
{
  return complex<FLT> (FCT(cexp) (y.__value () * FCT(log) (x)));
}

complex<FLT>
sin (const complex<FLT> &x)
{
  return complex<FLT> (FCT(sin) (x.__value ()));
}

complex<FLT>
sinh (const complex<FLT> &x)
{
  return complex<FLT> (FCT(sinh) (x.__value ()));
}

complex<FLT>
sqrt (const complex<FLT> &x)
{
  return complex<FLT> (FCT(sqrt) (x.__value ()));
}

complex<FLT>
tan (const complex<FLT> &x)
{
  return complex<FLT> (FCT(tan) (x.__value ()));
}

complex<FLT>
tanh (const complex<FLT> &x)
{
  return complex<FLT> (FCT(tanh) (x.__value ()));
}

} // namespace std
