
// 981027 ncm work with libstdc++v3

#include <iostream>
#include <locale>
#include <iomanip>
#ifdef DEBUG_ASSERT
#include <assert.h>
#endif

struct MyNP : std::numpunct<char>
{
  string do_truename() const;
  string do_falsename() const;
};

string MyNP::do_truename()  const { static string s("yea"); return s; }
string MyNP::do_falsename() const { static string s("nay"); return s; }

void test01()
{
  std::cout << true << " " << false << endl;
  std::cout << std::boolalpha;
  std::cout << true << " " << false << endl;

  std::cout << ":" << std::setw(6) << std::internal << true << ":" << endl;
  std::cout << ":" << std::setw(6) << std::left << true << ":" << endl;
  std::cout << ":" << std::setw(6) << std::right << false << ":" << endl;
  std::cout << std::noboolalpha;
  std::cout << ":" << std::setw(3) << std::internal << true << ":" << endl;
  std::cout << ":" << std::setw(3) << std::left << true << ":" << endl;
  std::cout << ":" << std::setw(3) << std::right << false << ":" << endl;

  std::cout.imbue(locale(locale(), new MyNP));

  std::cout << std::boolalpha;
  std::cout << true << " " << false << endl;

  std::cout << ":" << std::setw(6) << std::internal << true << ":" << endl;
  std::cout << ":" << std::setw(6) << std::left << true << ":" << endl;
  std::cout << ":" << std::setw(6) << std::right << false << ":" << endl;

#ifdef DEBUG_ASSERT
  assert (std::cout.good());
#endif
}

int main() {
  test01();
  return 0;
}

