
// Copyright (C) 1998 Cygnus Solutions
//
// This file is part of the libstdc++ version 3 distribution.
//
// This software is a copyrighted work licensed under the terms of the
// Cygnus libstdc++ license. Please consult the file LICENSE.STD for
// details.

#ifndef _CPP_BITS_UTILITY_H
#define _CPP_BITS_UTILITY_H 1

// #include <bits/std_climits.h>
// #include <bits/std_cstddef.h>

namespace std {
  // _Count_ones: compile-time computation of number of 1-bits in a value N
  //   This takes only 5 (or 6) instantiations, doing recursive descent
  //     in parallel -- ncm

  template<unsigned _Num, int _Shift = (sizeof(unsigned)*CHAR_BIT)/2,
           unsigned _Mask = (~0u>>_Shift)>
    struct _Count_ones;
  template<unsigned _Num, unsigned _Mask>
    struct _Count_ones<_Num,0,_Mask> { static const unsigned _S_count = _Num; };
  template<unsigned _Num, int _Shift, unsigned _Mask>
    struct _Count_ones {
      static const unsigned _S_halfcount =
        _Count_ones<_Num, _Shift/2, (_Mask^((~_Mask)>>(_Shift/2))) >::_S_count;
      static const unsigned _S_count
        = (_S_halfcount&_Mask) + ((_S_halfcount>>_Shift)&_Mask);
  };

#if _G_USE_EXCEPTIONS
// Internal functions for string implementation.
  extern void __out_of_range (const char *__str);
  extern void __length_error (const char *__str);

# define __OUTOFRANGE(__cond) \
  do { if (__cond) __out_of_range (#__cond); } while (0)
# define __LENGTHERROR(__cond) \
  do { if (__cond) __length_error (#__cond); } while (0)
#else
# include <bits/std_cassert.h>
# define __OUTOFRANGE(__cond) assert (!(__cond))
# define __LENGTHERROR(__cond) assert (!(__cond))
#endif

#ifdef _G_NO_MBSTATE_T
typedef long mbstate_t;
#endif

} // namespace std

#endif /* _CPP_BITS_UTILITY_ */
