// String based streams -*- C++ -*-

// Copyright (C) 1997,1998 Cygnus Solutions
//
// This file is part of the libstdc++ version 3 distribution.
//
// This software is a copyrighted work licensed under the terms of the
// Cygnus libstdc++ license. Please consult the file LICENSE.STD for
// details.

//
// ISO C++ 14882: 27.7  String-based streams
//

#ifndef _CPP_SSTREAM_TCC
#define _CPP_SSTREAM_TCC	1

#include <bits/std_sstream.h>

namespace std {

  template <class _CharT, class _Traits, class _Allocator>
    basic_stringbuf<_CharT,_Traits,_Allocator>::basic_stringbuf(
        const basic_string<_CharT,_Traits,_Allocator>& __str,
        ios_base::openmode __which)
      : basic_streambuf<_CharT,_Traits> (), _M_mode (__which)
      {
	this->sputn (__str.c_str (), __str.length ());
	if (_M_mode & ios_base::out)
	  ;	// ### TODO, maybe already done
	if (_M_mode & ios_base::in)
	  this->setg (this->pbase (), this->pptr (), this->epptr ());
      }

  template <class _CharT, class _Traits, class _Allocator>
    basic_string<_CharT,_Traits,_Allocator>
    basic_stringbuf<_CharT,_Traits,_Allocator>::str () const
  {
    typedef basic_string<_CharT,_Traits,_Allocator> string_type;
    bool __out = (_M_mode & ios_base::out);
    off_type __len = __out ?
      this->pptr () - this->pbase () :  this->gptr () - this->eback ();
    return (__len == 0) ? string_type () :
      string_type (__out ? this->pbase () : this->eback (), __len);
  }

  template <class _CharT, class _Traits, class _Allocator>
    void
    basic_stringbuf<_CharT,_Traits,_Allocator>::
      str (const basic_string<_CharT,_Traits,_Allocator>& __s)
  {
    this->setg (_IO_buf_base, _IO_buf_base, _IO_buf_base);
    this->setp (_IO_buf_base, _IO_buf_end);

    this->sputn (__s.c_str (), __s.length ());
    if (_M_mode & ios_base::out)
      ;	// ### TODO, maybe already done
    if (_M_mode & ios_base::in)
      this->setg (this->pbase (), this->pptr (), this->epptr ());
  }

} // namespace std

#endif	/* _CPP_SSTREAM_TCC */


