// The template and inlines for the -*- C++ -*- gslice_array class.

// Copyright (C) 1997,1998 Cygnus Solutions
//
// This file is part of the libstdc++ version 3 distribution.
//
// This software is a copyrighted work licensed under the terms of the
// Cygnus libstdc++ license. Please consult the file LICENSE.STD for
// details.

// Written by Gabriel Dos Reis <Gabriel.Dos-Reis@DPTMaths.ENS-Cachan.Fr>

#ifndef _CPP_BITS_GSLICE_ARRAY
#define _CPP_BITS_GSLICE_ARRAY

namespace std {

template<typename _Tp> class gslice_array
{
public:
    typedef _Tp value_type;

    void operator=  (const valarray<_Tp>&) const;
    void operator*= (const valarray<_Tp>&) const;
    void operator/= (const valarray<_Tp>&) const;
    void operator%= (const valarray<_Tp>&) const;
    void operator+= (const valarray<_Tp>&) const;
    void operator-= (const valarray<_Tp>&) const;
    void operator^= (const valarray<_Tp>&) const;
    void operator&= (const valarray<_Tp>&) const;
    void operator|= (const valarray<_Tp>&) const;
    void operator<<=(const valarray<_Tp>&) const;
    void operator>>=(const valarray<_Tp>&) const;
    void operator=(const _Tp&);

    template<class _Expr>
      void operator= (const _Meta<_Expr,_Tp>&) const;
    template<class _Expr>
      void operator*= (const _Meta<_Expr,_Tp>&) const;
    template<class _Expr>
      void operator/= (const _Meta<_Expr,_Tp>&) const;
    template<class _Expr>
      void operator%= (const _Meta<_Expr,_Tp>&) const;
    template<class _Expr>
      void operator+= (const _Meta<_Expr,_Tp>&) const;
    template<class _Expr>
      void operator-= (const _Meta<_Expr,_Tp>&) const;
    template<class _Expr>
      void operator^= (const _Meta<_Expr,_Tp>&) const;
    template<class _Expr>
      void operator&= (const _Meta<_Expr,_Tp>&) const;
    template<class _Expr>
      void operator|= (const _Meta<_Expr,_Tp>&) const;
    template<class _Expr>
      void operator<<= (const _Meta<_Expr,_Tp>&) const;
    template<class _Expr>
      void operator>>= (const _Meta<_Expr,_Tp>&) const;
        
    ~gslice_array();

private:
    gslice_array ();
    gslice_array (const gslice_array&);
    gslice_array& operator= (const gslice_array&);
    gslice_array (_Array<_Tp>, const gslice& );

    _Array<_Tp>    _M_array;
    const gslice& _M_gs;

    friend class valarray<_Tp>;
};

template<typename _Tp>
inline gslice_array<_Tp>::gslice_array (_Array<_Tp> __a, const gslice& __g)
        : _M_array (__a), _M_gs (__g) {}

template<typename _Tp>
inline gslice_array<_Tp>::~gslice_array () {}

template<typename _Tp>
inline void
gslice_array<_Tp>::operator= (const _Tp& __t) 
{ 
  __valarray_fill (_M_array, _M_gs._M_index, _M_gs._M_index_size, __t); 
}

template<typename _Tp>
inline void
gslice_array<_Tp>::operator= (const valarray<_Tp>& __v) const
{
  __valarray_copy (_Array<_Tp> (__v), __v.size (), _M_array, _M_gs._M_index);
}

template<typename _Tp>
template<class E>
inline void
gslice_array<_Tp>::operator= (const _Meta<E, _Tp>& __e) const
{
  __valarray_copy (__e, _M_gs._M_index_size, _M_array, _M_gs._M_index);
}

#undef _DEFINE_VALARRAY_OPERATOR
#define _DEFINE_VALARRAY_OPERATOR(op, name)				\
template<typename _Tp>							\
inline void								\
gslice_array<_Tp>::operator##op##= (const valarray<_Tp>& __v) const	\
{									\
    _Array_augmented_##name (_M_array, _M_gs._M_index,			\
                              _Array<_Tp> (__v), __v.size ());		\
}									\
									\
template<typename _Tp> template<class E>					\
inline void 								\
gslice_array<_Tp>::operator##op##= (const _Meta<E, _Tp>& __e) const	\
{									\
    _Array_augmented_##name (_M_array, _M_gs._M_index, __e,		\
                              _M_gs._M_index_size);			\
}

_DEFINE_VALARRAY_OPERATOR(*, multiplies)
_DEFINE_VALARRAY_OPERATOR(/, divides)    
_DEFINE_VALARRAY_OPERATOR(%, modulus)
_DEFINE_VALARRAY_OPERATOR(+, plus)    
_DEFINE_VALARRAY_OPERATOR(-, minus)
_DEFINE_VALARRAY_OPERATOR(^, xor)
_DEFINE_VALARRAY_OPERATOR(&, and)
_DEFINE_VALARRAY_OPERATOR(|, or)
_DEFINE_VALARRAY_OPERATOR(<<, shift_left)
_DEFINE_VALARRAY_OPERATOR(>>, shift_right)

#undef _DEFINE_VALARRAY_OPERATOR

} // std::

#endif /* _CPP_BITS_GSLICE_ARRAY */

// Local Variables:
// mode:c++
// End:
