/*
 *  graph.c
 *  graph module
 */
#define XGRAB
#define BAL_SCHED
#define CACHE_OPT

#ifdef BAL_SCHED
#include <stdio.h>
#include "config.h"
#include "rtl.h"
#include "tree.h"
#include "predicate.h"
#include "graph.h"
#include "balsched.h"

#ifndef FALSE
#define FALSE  0
#endif
#ifndef TRUE
#define TRUE   1
#endif

#define OUTFILE stdout

extern FILE *loop_dump_stream;

extern int *insn_priority;
#define INSN_PRIORITY(INSN) (insn_priority[INSN_UID (INSN)])

extern float *insn_weight;
#define INSN_WEIGHT(INSN) (insn_weight[INSN_UID (INSN)])

extern int *insn_ref_count;
#define INSN_REF_COUNT(INSN) (insn_ref_count[INSN_UID (INSN)])

extern int *insn_load_level;
#define INSN_LOAD_LEVEL(INSN) (insn_load_level[INSN_UID (INSN)])

extern int *insn_on_stack;
#define INSN_ON_STACK(INSN) (insn_on_stack[INSN_UID (INSN)])

extern int *insn_curr_bblock;
#define INSN_CURR_BBLOCK(INSN) (insn_curr_bblock[INSN_UID (INSN)])

#define INSN_CCINFO(INSN)  ((find_set (INSN_SET_OBJ (insn)))->cc)

#define CC_NUMLOADS(CC)  (CC->num_loads)

int last_cc_num = 0;

extern int blocknum;
extern char *curr_function_name;
extern char *dump_base_name;
extern char *contrib_output;

#ifndef __GNUC__
#define __inline
#endif

/*#define MAX(A,B)  (A > B ? A : B)
*/
/*
 * Traverse the dependency DAG (LOG_LINKS) and create the
 * INV_LINKS for the inverse dependency relationship
 */

void
create_inv_links (tail, prev_head)
     rtx tail;
     rtx prev_head;
{
  rtx insn;
  rtx link;
  rtx newlink;
  rtx elem;

  for (insn = tail; insn != prev_head; insn = PREV_INSN (insn))
    {
      if (GET_RTX_CLASS (GET_CODE (insn)) == 'i')
	INV_LINKS (insn) = NULL;
    }

  for (insn = tail; insn != prev_head; insn = PREV_INSN (insn))
    {
      if (GET_RTX_CLASS (GET_CODE (insn)) == 'i')
	{
	  for (link = LOG_LINKS (insn); link; link = XEXP (link, 1))
	    {
	      elem = XEXP (link, 0);
	      /* insn is dependent on elem, so add an inverse link
		 to elem */
	      newlink = rtx_alloc (INSN_LIST);
	      XEXP (newlink, 0) = insn;
	      XEXP (newlink, 1) = INV_LINKS (elem);
	      INV_LINKS (elem) = newlink;
	    }
	}
    }
}

/*
 * Mark all nodes as NOT_REMOVED
 */

void
unremove_all (tail, prev_head)
     rtx tail;
     rtx prev_head;
{
  rtx insn;

  for (insn = tail; insn != prev_head; insn = PREV_INSN (insn))
    INSN_REMOVED (insn) = NOT_REMOVED;
}

/*
 * Mark all nodes as NOT_REMOVED
 */

void
clear_sets (tail, prev_head)
     rtx tail;
     rtx prev_head;
{
  rtx insn;

  for (insn = tail; insn != prev_head; insn = PREV_INSN (insn))
    INSN_SET_OBJ (insn) = NULL;
}

/* Don't do it recursively if possible, to speed it up */
/* 
 * Mark insn's predecessors as removed 
 */

void
remove_predecessors (insn)
     rtx insn;
{
  rtx link;
  rtx elem;

  /* Actually don't need three states...REMOVED and NOT_REMOVED are
     sufficient */
  INSN_REMOVED (insn) = VISITED;
  if (GET_RTX_CLASS (GET_CODE (insn)) == 'i')
    {
      for (link = LOG_LINKS (insn); link; link = XEXP (link, 1))
	{
	  elem = XEXP (link, 0);
	  if ((INSN_REMOVED (elem) == NOT_REMOVED) &&
	      (INSN_CURR_BBLOCK (elem) == 1))
	    {
	      remove_predecessors (elem);
	    }
	}
    }      
/*
  fprintf (stderr, "Removing insn %d\n", INSN_UID (insn));
*/
  INSN_REMOVED (insn) = REMOVED;
  /* Make sure that this removes all nodes correctly */
}

/*
 * Mark insn's successors as removed from the graph
 */

void
remove_successors (insn)
     rtx insn;
{
  rtx link;
  rtx elem;

  /* Actually don't need three states...REMOVED and NOT_REMOVED are
     sufficient */
  INSN_REMOVED (insn) = VISITED;
  if (GET_RTX_CLASS (GET_CODE (insn)) == 'i')
    {
      for (link = INV_LINKS (insn); link; link = XEXP (link, 1))
	{
	  elem = XEXP (link, 0);
	  if (INSN_REMOVED (elem) == NOT_REMOVED)
	    {
	      remove_successors (elem);
	    }
	}
    }
      
  INSN_REMOVED (insn) = REMOVED;
/*
  fprintf (stderr, "Removing insn %d\n", INSN_UID (insn));
*/
  /* Make sure that this removes all nodes correctly */
}

/*
 * Initialize all weights to 1
 */

void
init_weights (tail, prev_head)
     rtx tail;
     rtx prev_head;
{
  rtx insn;

  for (insn = tail; insn != prev_head; insn = PREV_INSN (insn))
    {
#ifdef NOBSA_SPILL_CODE
      /* Spill code should not be balanced scheduled, so
	 turn off bsa for the load and give it a fixed latency. */
      if (jlo_nobsa_spill_code && is_load (insn) &&
	  (!INSN_NOT_SPILL_LOAD (insn)))
	{
	  INSN_TURN_OFF_BSA (insn) = 1;
	  fprintf (stderr, "Turning off spill load %d\n", INSN_UID (insn));
	}
#endif      
#ifdef CACHE_OPT
      if (is_load (insn) &&
	  (INSN_TURN_OFF_BSA (insn)))
	{
	  INSN_WEIGHT (insn) = CACHE_HIT_TIME;
	} else {
	  INSN_WEIGHT (insn) = 1.0;
	}
#else
      INSN_WEIGHT (insn) = 1.0;
#endif
    }
}


/* 
 * Call this function once before beginning the BSAlgorithm in order
 * to set up the graph datastructures correctly 
 */

void 
graph_init (tail, prev_head)
     rtx tail;
     rtx prev_head;
{
/*  fprintf (OUTFILE, "In graph_init...\n");
*/
  unremove_all (tail, prev_head);
  clear_sets (tail, prev_head);
  create_inv_links (tail, prev_head);
#ifdef XGRAB
  if ((reload_completed == 0) && dump_xgrab_output)
    output_xgrab_file (tail, prev_head);
  if ((reload_completed == 1) && dump_xgrab_output2)
    output_xgrab_file (tail, prev_head);
#endif
  init_weights (tail, prev_head);
}


/*
 *****************************************************************8
 *  Disjoint sets functions
 *****************************************************************8
 */

set_obj 
set_obj_alloc ()
{
  set_obj obj;

  obj = (set_obj) malloc (sizeof (struct set_obj_def));
  if (obj == NULL)
    {
      fprintf (stderr, "ERROR in set_obj_alloc (): malloc failed\n");
    }
  obj->parent = NULL;
  obj->rank = 0;
  obj->insn = NULL;
  obj->visited = WHITE;
  obj->level = 0;
  obj->cc = (cc_info) malloc (sizeof (struct cc_info_def));
  obj->cc->num_loads = 0;
  obj->cc->cc_num = last_cc_num++;
  obj->cc->min_level = CC_MIN_LEVEL_INIT;
  obj->cc->max_level = CC_MAX_LEVEL_INIT;
  return obj;
}

set_obj
make_set (insn)
     rtx insn;
{
  set_obj obj;

  obj = set_obj_alloc ();
  obj->parent = obj;
  obj->rank = 0;
  obj->insn = insn;
  obj->visited = WHITE;
  obj->level = 0; 
  
  return obj;
}

/* Returns the representative for the set to which obj belongs */

set_obj
find_set (obj)
     set_obj obj;
{
  if (obj == NULL)
    {
      fprintf (stderr, "ERROR in find_set: set_obj is NULL\n");
    }

  if (obj != obj->parent)
    {
      if (obj->parent == NULL)
	{
	  fprintf (stderr, "ERROR in find_set: obj->parent is NULL\n");
	}
      obj->parent = find_set (obj->parent);
    }
  return obj->parent;
}

void
link_sets (set1, set2)
     set_obj set1;
     set_obj set2;
{
  if (set1->rank > set2->rank)
    {
      set2->parent = set1;
      if (set2->cc != NULL)
	{
	  set1->cc->min_level = MIN (set1->cc->min_level, set2->cc->min_level);
	  set1->cc->max_level = MAX (set1->cc->max_level, set2->cc->max_level);
	  free (set2->cc);
	  set2->cc = NULL;
	}
    } else {
      set1->parent = set2;
      if (set1->cc != NULL)
	{
	  set2->cc->min_level = MIN (set1->cc->min_level, set2->cc->min_level);
	  set2->cc->max_level = MAX (set1->cc->max_level, set2->cc->max_level);
	  free (set1->cc);
	  set1->cc = NULL;
	}
      if (set1->rank == set2->rank)
	(set2->rank)++;
    }
}

int
union_sets (set1, set2)
     set_obj set1;
     set_obj set2;
{
  set_obj obj1;
  set_obj obj2;

  obj1 = find_set (set1);
  obj2 = find_set (set2);
  if (obj1 == obj2)
    {
      return SAME_SET;
    } else {
      link_sets (obj1, obj2);
      return DIFFERENT_SETS;
    }
}


void 
create_sets (tail, prev_head)
     rtx tail;
     rtx prev_head;
{
  rtx insn;

  for (insn = tail;
       insn != prev_head; 
       insn = PREV_INSN (insn))
    {
      if ((GET_RTX_CLASS (GET_CODE (insn)) == 'i') &&
	  (!INSN_REMOVED (insn)))
	{
	  INSN_SET_OBJ (insn) = make_set (insn);
/*	  fprintf (OUTFILE, "Set made for insn %d\n", INSN_UID (insn));
	} else {
	  fprintf (OUTFILE, 
	  "Set NOT made for insn %d (removed or not insn)\n", 
		   INSN_UID (insn));
*/
	}
    }
}

/*
 *  Connected component stuff
 *
 *  Builds the connected components sets 
 * 
 */


void
build_connected_components (tail, prev_head)
     rtx tail;
     rtx prev_head;
{
  rtx insn;
  rtx link;
  rtx elem;
/*  int numsets;*/
  set_obj obj1;
  set_obj obj2;

/*  fprintf (OUTFILE, "In build_connected_components...\n");
*/
  /* Create the connected components */
  for (insn = tail; insn != prev_head; insn = PREV_INSN (insn))
    {
      if ((GET_RTX_CLASS (GET_CODE (insn)) == 'i') &&
	  (!INSN_REMOVED (insn)))
	{
	  for (link = LOG_LINKS(insn); link; link = XEXP (link, 1))
	    {
	      elem = XEXP (link, 0);
	      if (!(INSN_REMOVED (elem)) &&
		  (INSN_CURR_BBLOCK (elem) == 1)) 
		{
		  obj1 = INSN_SET_OBJ (insn);
		  if (obj1 == NULL)
		    {
		      fprintf (OUTFILE, 
			       "Insn %d has NULL set obj at creating cc\n",
			       INSN_UID (insn));
		    }
		  obj2 = INSN_SET_OBJ (elem);
		  if (obj2 == NULL)
		    {
		      fprintf (OUTFILE, 
			       "Elem %d has NULL set obj at creating cc\n",
			       INSN_UID (elem));
		    }
		  if (union_sets (obj1, obj2) !=
		      SAME_SET)
		    {
/*		      numsets--;*/
		    }
		}
	    }
	}
    }
/*  print_insns (tail, prev_head);*/
}

/* Clear all the visited flags */ 

void clear_visited_flags(tail, prev_head)
     rtx tail;
     rtx prev_head;
{
  rtx insn;

  for (insn = tail; insn != prev_head; insn = PREV_INSN (insn))  
    {
      if ((!INSN_REMOVED (insn)) && 
	  (INSN_SET_OBJ (insn) != NULL))
	{
	  (INSN_SET_OBJ (insn))->visited = WHITE;
	}
    }
}

void init_levels(tail, prev_head)
     rtx tail;
     rtx prev_head;
{
  rtx insn;

  for (insn = tail; insn != prev_head; insn = PREV_INSN (insn))  
    {
      if ((!INSN_REMOVED (insn)) && 
	  (INSN_SET_OBJ (insn) != NULL))
	{
#ifdef CACHE_OPT
	  if (is_load (insn) &&
	      (!INSN_TURN_OFF_BSA (insn)))
#else
	  if (is_load (insn))
#endif
	    (INSN_SET_OBJ (insn))->level = 1;
	  else
	    (INSN_SET_OBJ (insn))->level = 0;
	}
    }
}



/*
 * Iterate over the connected components.  
 */

void iterate (tail, prev_head, curr) 
     rtx tail;
     rtx prev_head;
     rtx curr;
{
  rtx insn;
  int chances = 0;
  cc_info cc;
  rtx src, dst;
  int num_loads = 0;
  set_obj obj;
  float added_weight = 0;

/*  fprintf (OUTFILE, "In iterate (insn %d)...\n", INSN_UID (curr));
*/
  for (insn = tail; insn != prev_head; insn = PREV_INSN (insn))
    {
      if ((GET_RTX_CLASS (GET_CODE (insn)) == 'i') &&
	  (!INSN_REMOVED (insn)))
	{
	  cc = INSN_CCINFO (insn);
	  chances = MAX (chances, (cc->max_level - cc->min_level + 1));
	}
#ifdef OLD
/**/
/*      fprintf (OUTFILE, "Insn %d, ref count %d, removed %d\n", 
	       INSN_UID (insn), INSN_REF_COUNT (insn), INSN_REMOVED (insn));
*/
      if ((GET_RTX_CLASS (GET_CODE (insn)) == 'i') &&
	  (is_leaf (insn) == IS_LEAF) &&
	  (!INSN_REMOVED (insn)))
	{
	  
	  /* This insn is a leaf node in the connected component */
	  /* Begin analysis of this connected component */

	  /* Use LOG_LINKS to do a (reverse) DFS up the CC to find the
	     longest load path, and store this value in the cc_info */
	  chances = longest_load_path (insn);

	  if ((obj = INSN_SET_OBJ (insn)) == NULL)
	    {
	      fprintf (OUTFILE, "Insn %d has NULL set_obj in iterate\n",
		       INSN_UID (insn));
	    }
	  cc = INSN_CCINFO (insn);
	  if (cc != NULL)
	    {
	      CC_NUMLOADS (cc) = MAX (CC_NUMLOADS (cc), chances);
	    } else {
	      printf("ERROR: connected component info for insn %d is NULL\n",
		     INSN_UID (insn));
	    }

	}
#endif
    }
  
  /* Find all the loads and update their weights */

  for (insn = tail; insn != prev_head; insn = PREV_INSN (insn))
    {
#ifdef CACHE_OPT
      if ((!INSN_REMOVED (insn)) &&
	  (is_load (insn)) &&
	  (!INSN_TURN_OFF_BSA (insn)))
#else
      if ((!INSN_REMOVED (insn)) &&
	  (is_load (insn)))
#endif
	{
	  if (INSN_SET_OBJ (insn) == NULL)
	    {
	      fprintf (OUTFILE, "*********************");
	      fprintf (OUTFILE, "Insn %d has no set object in iterate...");
	      fprintf (OUTFILE, "removed = %d\n", INSN_REMOVED (insn));
	    }
	  num_loads = CC_NUMLOADS (INSN_CCINFO (insn));
/*	  fprintf (OUTFILE, "Update found a load, insn %d\n", INSN_UID (insn));
	  if (num_loads == 0)
	    {
	      fprintf (stderr, 
		      "Weird error:  Found a load, but num_loads == 0\n");
	    }
*/
/*	  added_weight = (1/CC_NUMLOADS (INSN_CCINFO (insn)));*/
	  cc = INSN_CCINFO (insn);
	  if (cc == NULL)
	    {
	      fprintf (stderr, "Load insn %d has NULL cc\n", INSN_UID (insn));
	    }
	  
/*	  if ((cc->max_level == CC_MAX_LEVEL_INIT) &&
	      (cc->min_level == CC_MIN_LEVEL_INIT))
	    {
	      chances = 1;
	    } else {*/
	      chances = cc->max_level - cc->min_level + 1;
/*	    }*/
	  if (chances <= 0)
	    {
	      fprintf (stderr, 
		      "Weird error:  Found a load, but chances <= 0\n");
	      fprintf (stderr, "Max level = %d, min level = %d\n",
		       cc->max_level, cc->min_level);

	    } else {
	      added_weight = (1.0/chances);
	    }

	  if (contrib_output)
	    {
	      fprintf (OUTFILE, 
		       "Insn %d contributing %.2f (%d) to weight of load %d\n",
		       INSN_UID (curr), added_weight, chances, 
		       INSN_UID (insn));
	    }
	  INSN_WEIGHT (insn) += added_weight;
	  if (INSN_WEIGHT (insn) < 0.0)
	    {
	      fprintf (stderr, "Load insn %d has a negative weight %.2f\n",
		       INSN_UID (insn), INSN_WEIGHT (insn));
	    } 
	}
    }
}

/* 
 * Do a DFS-like search up the LOG_LINKS of insn to find the length
 * of the longest load path (most loads).
 * This function assumes that insn is not removed, but we check to see
 * if the children of the LOG_LINKS are removed before recursively calling
 * the function again.
 */

int
longest_load_path (insn)
     rtx insn;
{
  int numloads = 0;
  rtx elem;
  rtx link;
  rtx src;
  rtx dst;

/*  fprintf (OUTFILE, "In longest_load_path...\n");*/
  if (GET_RTX_CLASS (GET_CODE (insn)) == 'i')
    {
      for (link = LOG_LINKS (insn); link; link = XEXP (link, 1))
	{
	  elem = XEXP (link, 0);
	  if (!INSN_REMOVED(elem))
	    {
	      numloads = MAX (numloads, longest_load_path (elem));
	    }
	}
      /***********/
#ifdef CACHE_OPT
      if (is_load (insn) &&
	  !INSN_TURN_OFF_BSA (insn))
#else
      if (is_load (insn))
#endif
	{
	  numloads++; 
/*	  printf("Found a load, insn %d, numloads=%d\n", 
		 INSN_UID (insn), numloads);
*/
	}
    } else {
      fprintf (OUTFILE, "Tried longest_load_path on non-INSN\n");
    }
  return numloads;
}

void
free_connected_components (tail, prev_head)
     rtx tail;
     rtx prev_head;
{
  rtx insn;
  set_obj obj;

/*  fprintf (OUTFILE, "In free_connected_components...\n");
*/
  for (insn = tail; insn != prev_head; insn = PREV_INSN (insn))
    {
      if (GET_RTX_CLASS (GET_CODE (insn)) == 'i')
	{
	  if (!INSN_REMOVED (insn))
	    {
	      obj = INSN_SET_OBJ (insn);
	      if (obj == NULL)
		{
		  fprintf (stderr, 
			   "Something's wrong in free_connected_components: ");
		  fprintf (stderr, "obj == NULL\n");
		} else {
		  if (obj->cc != NULL)
		    free (obj->cc);
		  free (obj);
/*		  fprintf (OUTFILE, "Freeing set_obj for insn %d\n",
			   INSN_UID (insn));
			      */
		  
		  INSN_SET_OBJ (insn) = NULL;
		}	      
	    }
	}
    }
}

void
print_insns (tail, prev_head)
     rtx tail;
     rtx prev_head;
{
  rtx insn;
  set_obj obj;
  cc_info cc;

  fprintf (OUTFILE, "In print_insns...\n"); fflush(OUTFILE);

  for (insn = tail; insn != prev_head; insn = PREV_INSN (insn))
    {
      obj = INSN_SET_OBJ (insn);
      fprintf (OUTFILE, "Insn %d, \tremoved=%d, ",
	       INSN_UID (insn), INSN_REMOVED (insn));
      if (obj != NULL) 
	{
	  fprintf (OUTFILE, "level=%d, ", obj->level);
	  if ((cc = INSN_CCINFO (insn)) != NULL)
	    {
	      fprintf (OUTFILE, "cc_num %d (%d, %d)\n", 
		       cc->cc_num, cc->min_level, cc->max_level);
	    } else {
	      fprintf (OUTFILE, "cc NULL\n");
	    }
	} else {
	  fprintf (OUTFILE, "set obj NULL\n");
	}
    } 
  fprintf (OUTFILE, "print_insns done...\n");
}

int
is_leaf (insn)
     rtx insn;
{
  rtx elem;
  
  if (GET_RTX_CLASS (GET_CODE (insn)) == 'i')
    {
      for (elem = INV_LINKS (insn); elem; elem = XEXP (elem, 1))
	{
	  if (!INSN_REMOVED (XEXP (elem, 0)))
	    {
	      return NOT_LEAF;
	    }
	}
      return IS_LEAF;
    } else {
      return NOT_LEAF;
    }
}



void
print_weights (tail, prev_head)
     rtx tail;
     rtx prev_head;
{
  rtx insn;
  rtx src;
  rtx dst;

 fprintf (OUTFILE, "In print_weights...\n"); fflush(OUTFILE);

  for (insn = tail; insn != prev_head; insn = PREV_INSN (insn))
    {
      fprintf (OUTFILE, "Insn %d, ", INSN_UID (insn));
      if (GET_CODE (insn) == INSN)
	{
	  fprintf (OUTFILE, "\tweight=%.2f, \tpriority=%d, \tcode=%d, ",
		   INSN_WEIGHT (insn),
		   INSN_PRIORITY (insn),
		   GET_CODE (PATTERN (insn))); 
	}
      if (is_load (insn))
	{
#ifdef CACHE_OPT
	  if (INSN_TURN_OFF_BSA (insn))
	    fprintf (OUTFILE, "is a load, but bsa turned off for it\n");
	  else
	    fprintf (OUTFILE, "is a load, with bsa turned on for it\n");
	    
#else
	  fprintf (OUTFILE, "is a load\n");
#endif
	} else {
	  fprintf (OUTFILE, "is NOT a load\n");
	}
    } 
  fprintf (OUTFILE, "print_weights done...\n");
}


__inline int 
is_load(insn)
     rtx insn;
{
  rtx src, dst;

  if ((GET_CODE (insn) == INSN) &&
      (GET_CODE (PATTERN (insn)) == SET))
    {
      src = SET_SRC (PATTERN (insn));
      dst = SET_DEST (PATTERN (insn));
      
      if (((GET_CODE (src) == MEM) || 
	   ((GET_CODE (src) == FLOAT) &&
	    (GET_CODE (XEXP (src, 0)) == MEM))) &&
	  ((GET_CODE (dst) == REG) ||
	   (GET_CODE (dst) == SUBREG)))
	return TRUE;
    }
  
  return FALSE;
}

__inline int 
is_store(insn)
     rtx insn;
{
  rtx src, dst;

  if ((GET_CODE (insn) == INSN) &&
      (GET_CODE (PATTERN (insn)) == SET))
    {
      src = SET_SRC (PATTERN (insn));
      dst = SET_DEST (PATTERN (insn));
      
      if (((GET_CODE (dst) == MEM) || 
	   ((GET_CODE (dst) == FLOAT) &&
	    (GET_CODE (XEXP (dst, 0)) == MEM))))
	return TRUE;
    }
  
  return FALSE;
}

__inline int 
is_use(insn)
     rtx insn;
{
  rtx src, dst;

  if ((GET_CODE (insn) == INSN) &&
      (GET_CODE (PATTERN (insn)) == USE))
    {
      return TRUE;
    } else {
      return FALSE;
    }
}

__inline int 
is_asm_op(insn)
     rtx insn;
{
  rtx src, dst;

  if ((GET_CODE (insn) == INSN) &&
      (GET_CODE (PATTERN (insn)) == ASM_OPERANDS))
    {
      return TRUE;
    } else {
      return FALSE;
    }
}

__inline int 
is_clobber(insn)
     rtx insn;
{
  rtx src, dst;

  if ((GET_CODE (insn) == INSN) &&
      (GET_CODE (PATTERN (insn)) == CLOBBER))
    {
      return TRUE;
    } else {
      return FALSE;
    }
}

/*
 * Assign each node a level corresponding to the maximum number of loads
 * on a path between this node an a leaf.
 */

void assign_levels (tail, prev_head)
     rtx tail;
     rtx prev_head;
{
  rtx insn;
/*
 * Use a bottom-up topological traversal of the DAG using the LOG_LINKS
 * to filter the levels upwards. 
 */

  stack st;
  rtx elem;
  rtx link;
  int load_level;
  set_obj obj;
  cc_info cc;

  st = stack_create ();
  /* Each insn has a level.  We initialize the level to -1, and it will
     get changed only when the correct level has been found. */

  for (insn = tail; insn != prev_head; insn = PREV_INSN (insn))
    {
      if ((!INSN_REMOVED (insn)) &&
	  (GET_RTX_CLASS (GET_CODE (insn)) == 'i'))
	{
	  INSN_ON_STACK (insn) = FALSE;
	  INSN_LOAD_LEVEL (insn) = -1;
	  if (is_leaf (insn) == IS_LEAF)
	    {
	      /* Can't simply check the INV_LINKS, because if all the
		 successors are removed, then it's a leaf too. */
/*
	      fprintf (stderr, "Initially pushing %d...\n", INSN_UID (insn));
*/
	      stack_push (st, insn);
	      INSN_ON_STACK (insn) = TRUE;
	    }
	}
    }

  while (!stack_empty (st))
    {
      insn = stack_pop (st);
/*
      fprintf (stderr, "Popped %d...\n", INSN_UID (insn));
*/
      INSN_ON_STACK (insn) = FALSE;
      load_level = 0;
      for (link = INV_LINKS (insn); link; link = XEXP (link, 1))
	{
	  elem = XEXP (link, 0);
/*	  if ((!INSN_REMOVED (insn)) &&
	      (GET_RTX_CLASS (GET_CODE (insn)) == 'i'))
*/
	  if ((!INSN_REMOVED (elem)) &&
	      (GET_RTX_CLASS (GET_CODE (elem)) == 'i'))
	    {
	      if (INSN_LOAD_LEVEL (elem) == -1)
		{
		  /* insn elem not processed yet, so insn is not ready yet  */
		  break;
		} else {
		  load_level = MAX (load_level,
				    INSN_LOAD_LEVEL (elem));
		}
	    }
	}
      if (link == NULL)
	{
	  /* All successors already done */
/*
	  fprintf (stderr, "Insn %d done, load_level = %d...\n", 
		   INSN_UID (insn), load_level);
*/


#ifdef CACHE_OPT
	  if (is_load (insn) &&
	      !INSN_TURN_OFF_BSA (insn))
#else
	  if (is_load (insn))
#endif
	    {
	      INSN_LOAD_LEVEL (insn) = load_level + 1;

	  /* Only update the min/max levels for load instructions.
	     This insures that the min and max level values correspond
	     to the min and max levels of the loads in the connected
	     components */
	      
	      obj = INSN_SET_OBJ (insn);
	      if (obj == NULL)
		{
		  fprintf (OUTFILE, 
			   "NULL Set object for insn %d in assign_levels\n",
			   INSN_UID (insn));
		} else {
		  obj->level = INSN_LOAD_LEVEL (insn);
		  cc = INSN_CCINFO (insn);
		  if (cc != NULL)
		    {
		      cc->min_level = MIN (cc->min_level, 
					   INSN_LOAD_LEVEL (insn));
		      cc->max_level = MAX (cc->max_level, 
					   INSN_LOAD_LEVEL (insn));
/*
		      fprintf (stderr, "min = %d, max = %d for load %d\n",
			       cc->min_level, cc->max_level, INSN_UID (insn));
*/
		    } else {
		      fprintf (stderr, 
			       "cc NULL in assign_levels for insn %d\n",
			       INSN_UID (insn));
		      abort();
		    }
		}
	    } else {
	      INSN_LOAD_LEVEL (insn) = load_level;
	    } 
	  /* Push all unremoved predecessors onto stack */
	  
	  for (link = LOG_LINKS (insn); link; link = XEXP (link, 1))
	    {
	      elem = XEXP (link, 0);
	      if (!INSN_REMOVED (elem))
		{
		  if (!INSN_ON_STACK (elem) && 
		      (INSN_CURR_BBLOCK (elem) == 1))
		    {
		      if (GET_RTX_CLASS (GET_CODE (insn)) == 'i')
			{
/*
			  fprintf (stderr, "Pushing %d...\n", INSN_UID (elem));
*/

			  stack_push (st, elem);
			  INSN_ON_STACK (elem) = TRUE;
			}
		    } else {
/*
		      fprintf (stderr, "NOT pushing %d...\n", INSN_UID (elem));
*/
		    }
		}
	    }
	}
    }

  stack_free (st);
/*  for (insn = tail; insn != prev_head; insn = PREV_INSN (insn))
    {
      if ((!INSN_REMOVED (insn)) &&
	  (is_leaf (insn) == IS_LEAF))
	{
	  oldtraverse (insn, 0);
	}
    }*/
}


/*
 * Filter the load level up the dependency DAG
 */

void oldtraverse (insn, level)
     rtx insn;
     int level;
{
  set_obj obj;
  rtx elem;
  rtx link;
  cc_info cc;
  
  fprintf (stderr, "oldtraverse with: %d, level %d\n", INSN_UID (insn), level);
 
  obj = INSN_SET_OBJ (insn);
  if (obj == NULL)
    {
      fprintf (OUTFILE, "NULL Set object in traverse");
    } else {
      if (is_load (insn))
	{
	  if (level >= obj->level)
	    {
	      obj->level = level + 1;
	    }

	  /* Only update the min/max levels for load instructions.
	     This insures that the min and max level values correspond
	     to the min and max levels of the loads in the connected
	     components */

	  cc = INSN_CCINFO (insn);
	  if (cc != NULL)
	    {
	      cc->min_level = MIN (cc->min_level, obj->level);
	      cc->max_level = MAX (cc->max_level, obj->level);
	    } else {
	      fprintf (stderr, "cc NULL in traverse for insn %d\n",
		       INSN_UID (insn));
	      abort();
	    }
	} else {
	  if (level > obj->level)
	    {
	      obj->level = level;
	    }
	}
      
      if (GET_RTX_CLASS (GET_CODE (insn)) == 'i')
	{
	  for (link = LOG_LINKS (insn); link; link = XEXP (link, 1))
	    {
	      elem = XEXP (link, 0);
	      if (!INSN_REMOVED(elem))
		{
		  oldtraverse (elem, obj->level);
		}
	    }
	}
    }
}

stack 
stack_create ()
{
  stack st;

  st = (stack) malloc (sizeof (struct stack_def));
  st->pContents = (rtx *) malloc (INITIAL_STACK_SIZE * sizeof (rtx));
  st->currentSize = 0;
  st->maxSize = INITIAL_STACK_SIZE;

  return st;
}

void 
stack_push (st, insn)
     stack st;
     rtx insn;
{
  int i;
  rtx *pTemp;

  if (st->currentSize == st->maxSize)
    {
      st->maxSize <<= 1;
      pTemp = (rtx *) malloc ((st->maxSize) * sizeof (rtx));

      for (i=0; i < st->currentSize; i++)
	pTemp[i] = st->pContents[i];
      
      free (st->pContents);
      st->pContents = pTemp;
    }

  st->pContents[st->currentSize++] = insn;
}
  

rtx 
stack_pop (st)
     stack st;
{
  if (st->currentSize == 0)
    {
      fprintf (stderr, "stack_pop called on an empty stack\n");
      return NULL;
    } else {
      st->currentSize--;
      return st->pContents[st->currentSize];
    }
}

int
stack_empty (st)
     stack st;
{
  if (st->currentSize == 0)
    return TRUE;
  else
    return FALSE;
}

void 
stack_free (st)
     stack st;
{
  free (st->pContents);
  free (st);
}

void
stack_print (st)
     stack st;
{
  int i;

  fprintf (OUTFILE, "Stack:  ");
  for (i = 0; i < st->currentSize; i++)
    {
      fprintf (OUTFILE, "%d ", INSN_UID (st->pContents[i]));
    }
  fprintf (OUTFILE, "\n\n");
}

void output_xgrab_file (tail, prev_head)
     rtx tail;
     rtx prev_head;
{
  FILE *file;
  rtx insn;
  rtx link;
  rtx elem;
  int len = 0;
  char *filename;

  filename = (char *) malloc (200*sizeof(char));

  if (reload_completed == 0)
    {
      if (curr_function_name)
	sprintf (filename, "%s.%s.%d", dump_base_name, 
		 curr_function_name, blocknum);
      else
	sprintf (filename, "%s.nullfunc.%d", dump_base_name,
		 curr_function_name, blocknum);
    } else {
      if (curr_function_name)
	sprintf (filename, "%s.%s.%d.reload", dump_base_name, 
		 curr_function_name, blocknum);
      else
	sprintf (filename, "%s.nullfunc.%d.reload", dump_base_name,
		 curr_function_name, blocknum);
    }

  file = fopen (filename, "w");
  if (file == 0)
    {
      fprintf (stderr, "Unable to open file %s\n", filename);
      abort ();
    }
  
  fprintf (file, "*NAME*\n");

  if (curr_function_name)
    {
      fprintf (file, "Function %s, ", curr_function_name);
    } 
  fprintf (file, "BB number %d\n", blocknum);
  fprintf (file, "*NODES*\n");
  fprintf (file, "label\n");

  /* Add a node to label the graph */
  if (curr_function_name)
    fprintf (file, "%s.%s.%d\n", dump_base_name, 
	     curr_function_name, blocknum);
  else
    fprintf (file, "%s.nullfunc.%d\n", dump_base_name,
	     curr_function_name, blocknum);

  for (insn = tail; insn != prev_head; insn = PREV_INSN (insn))
    {
      if (GET_RTX_CLASS (GET_CODE (insn)) == 'i')
	{
	  fprintf (file, "%d ", INSN_UID (insn));
	  if (is_load (insn))
	    {
#ifdef CACHE_OPT
	      if (INSN_TURN_OFF_BSA (insn))
		fprintf (file, "\"%d LOAD (off)\"\n", INSN_UID (insn));
	      else
		fprintf (file, "\"%d LOAD (on)\"\n", INSN_UID (insn));
		
#else
	      fprintf (file, "\"%d LOAD\"\n", INSN_UID (insn));
#endif	      
	    } else {
	      if (is_use (insn))
		{
		  fprintf (file, "\"%d USE\"\n", INSN_UID (insn));
		} else {
		  fprintf (file, "\n");
		}
	    }
	}
    }  
  fprintf (file, "*EDGES*\n");
  fprintf (file, "label\n");
  for (insn = tail; insn != prev_head; insn = PREV_INSN (insn))
    {
      if (GET_RTX_CLASS (GET_CODE (insn)) == 'i')
	{
	  for (link = INV_LINKS (insn); link; link = XEXP (link, 1))
	    {
	      elem = XEXP (link, 0);
	      fprintf (file, "%d\t%d\n", INSN_UID (insn), INSN_UID (elem));
	    }
	}
    }  

  fclose (file);
}

/*
 * Split rtl macros.
 *
 * Convert store insns that don't store registers into a pair of insns
 * where a register is used as an intermediate step.  
 * So (SET (MEM ...) (a non-reg)) gets converted to 
 * (SET temp (...)) (SET (MEM ...) (...))
 */ 
void 
graph_split_insns (insns)
     rtx insns;
{
  rtx insn;
  rtx new_load;
  rtx new_store;
  rtx temp;
  rtx src;
  rtx dest;
  int mode;
  rtx new_reg;
  rtx load_pattern;
  rtx newlink;

  for (insn = insns; insn; insn = NEXT_INSN (insn))
    {
      if (GET_RTX_CLASS (GET_CODE (insn)) == 'i')
	{
	  LOG_LINKS (insn) = NULL;
	  if ((GET_CODE (insn) == CALL_INSN) ||
	      (GET_CODE (PATTERN (insn)) == PARALLEL)) 
	    {
	      REG_NOTES (insn) = NULL;
	    }
	}

      if ((GET_RTX_CLASS (GET_CODE (insn)) == 'i') &&
	  (GET_CODE (PATTERN (insn)) == SET))
	{
	  /* Find Mem-to-mem copies */
	  src = SET_SRC (PATTERN (insn));
	  dest = SET_DEST (PATTERN (insn));
/*#define NEW*/
#ifdef NEW
	  if ((GET_CODE (dest) == MEM) &&
	      (GET_CODE (src) == MEM))
#else
	  if ((GET_CODE (dest) == MEM) &&
	      (GET_CODE (src) != REG) &&
	      (GET_CODE (src) != SUBREG))
#endif
	    {
	      /* Replace it with a load followed by a store */
	      mode = GET_MODE (SET_DEST (PATTERN (insn)));
	      new_reg = gen_reg_rtx (mode);
	      load_pattern = rtx_alloc (SET);
	      SET_DEST (load_pattern) = copy_rtx (new_reg);
	      SET_SRC (load_pattern) = SET_SRC (PATTERN (insn));

	      /* Insert it into the list  */
	      new_load = emit_insn_before (load_pattern, insn); 
	      recog_memoized (new_load);
	      insn_extract (new_load);
	      if (! constrain_operands (INSN_CODE (new_load), reload_completed))
		{
		  delete_insn (new_load);
		  break;
		}

	      if (jlo_splitting_verbose)
		{
		  fprintf (stderr, "Splitting insn %d, new register is: ",
			   INSN_UID (insn));
		  print_rtl (stderr, new_reg);
		  fprintf (stderr, "\n");
		}

	      SET_SRC (PATTERN (insn)) = new_reg;

/* load */
/*	      new_load = make_insn_raw (load_pattern);
	      NEXT_INSN (PREV_INSN (insn)) = new_load;
	      PREV_INSN (new_load) = PREV_INSN (insn);
	      PREV_INSN (insn) = new_load;
	      NEXT_INSN (new_load) = insn;*/
	      new_store = insn;
	      if (jlo_splitting_verbose)
		{
		  fprintf (stderr, "New load is insn %d\n",
			   INSN_UID (new_load));
		}

	      /* INSN_CODE fld[4] */
	      /* check that these are correct codes (should be 89) */
	      INSN_CODE (new_load) = -1;
	      INSN_CODE (new_store) = -1;
	      recog_memoized (new_load);
	      recog_memoized (new_store);

	      /* fld[5] : LOG_LINKS */
	      /* Reevaluate the LOG_LINKS? */
	      if (LOG_LINKS (new_store) == NULL)
		{
		  LOG_LINKS (new_load) = NULL;
		} else {
		  LOG_LINKS (new_load) = copy_rtx (LOG_LINKS (new_store));
		}
	      newlink = rtx_alloc (INSN_LIST);
	      XEXP (newlink, 0) = new_load;
	      XEXP (newlink, 1) = LOG_LINKS (new_store);
/*	      LOG_LINKS (new_store) = newlink;
*/
/* Update these reg_notes? fld[6]*/ 
/*	      update_flow_info (REG_NOTES (new_store), 
				new_load, new_store, insn);
*/
	      /* The insn might have REG_NOTES since the address for the
		 mem operation might use a register. */
/*	      if (REG_NOTES (new_store) != NULL)
		{
		  if (jlo_splitting_verbose)
		    {
		      fprintf (stderr, "REG_NOTES != NULL for insn %d...\n",
			       INSN_UID (new_store));
		      print_rtl (stderr, REG_NOTES (new_store));
		    }
		} */
	      REG_NOTES (new_load) = NULL;
	      REG_NOTES (new_store) = NULL;

	      /* fld[7] : INV_LINKS */
	      /* Free insn? */
	      /* */
	    }
	}
    }  
} 


rtx
graph_delete_notes (rtx_first)
     rtx rtx_first;
{
  rtx tmp_rtx;
  rtx first = rtx_first;
  rtx last = get_last_insn();

  for (tmp_rtx = rtx_first; NULL != tmp_rtx; tmp_rtx = NEXT_INSN (tmp_rtx)) {
    rtx x;
      
    /***
     *** Delete all notes except NOTE_INSN_FUNCTION_BEG.  GCC's instruction schedule depends on this one.
     ***/
    if (   GET_CODE (tmp_rtx) == NOTE
	&& NOTE_LINE_NUMBER(tmp_rtx) < 0
	&& NOTE_LINE_NUMBER(tmp_rtx) != NOTE_INSN_LOOP_BEG /* Required to do flow analysis */
	&& NOTE_LINE_NUMBER(tmp_rtx) != NOTE_INSN_LOOP_END
	&& NOTE_LINE_NUMBER(tmp_rtx) != NOTE_INSN_SETJMP /* Makrs a setjump */
	&& NOTE_LINE_NUMBER(tmp_rtx) != NOTE_INSN_LOOP_CONT
	&& NOTE_LINE_NUMBER(tmp_rtx) != NOTE_INSN_LOOP_VTOP
	&& NOTE_LINE_NUMBER(tmp_rtx) != NOTE_INSN_FUNCTION_BEG
	&& NOTE_LINE_NUMBER(tmp_rtx) != NOTE_INSN_FUNCTION_END
	&& NOTE_LINE_NUMBER(tmp_rtx) != NOTE_INSN_BLOCK_BEG /* Required for entry/exit code */
	&& NOTE_LINE_NUMBER(tmp_rtx) != NOTE_INSN_BLOCK_END
	) {
/* #define DO_REAL_DELETE */
#ifdef DO_REAL_DELETE
      if (NULL != NEXT_INSN (tmp_rtx))
	PREV_INSN (NEXT_INSN (tmp_rtx)) = PREV_INSN (tmp_rtx);
      
      if (NULL != PREV_INSN (tmp_rtx))
	NEXT_INSN (PREV_INSN (tmp_rtx)) = NEXT_INSN (tmp_rtx);
#else
      NOTE_LINE_NUMBER (tmp_rtx) = NOTE_INSN_DELETED;
#endif DO_REAL_DELETE
    }
    /**
      Deal with the case where we delete the first insn.
      **/
    if (NULL == PREV_INSN (tmp_rtx))
      first = tmp_rtx;

    if (NULL == NEXT_INSN (tmp_rtx))
      last = tmp_rtx;
  }
  set_new_first_and_last_insn(first, last);

  return first;
}

#ifdef CACHE_OPT
#ifdef OLD
/* Searches for loads starting at loop_start and quits when it
   reaches loop_end.  Each load is marked as turned off if the correct
   type of locality for the loop was found.  loop_end
   is not inclusive */

void 
loads_turn_off_bsa (p)
     predicate p;
{
  rtx curr;
  rtx end_insn;

  if (p->end_insn || NEXT_INSN (p->end_insn))
    end_insn = NEXT_INSN (p->end_insn);
  else
    end_insn = NULL;

  if (jlo_cache_opt_verbose)
    {
      fprintf (stderr, "Turning off loads between ");
      if (p->start_insn && NEXT_INSN (p->start_insn))
	fprintf (stderr, "%d and ", INSN_UID (NEXT_INSN (p->start_insn)));
      else
	fprintf (stderr, "NULL and ");


      if (end_insn)
	fprintf (stderr, "%d ", INSN_UID (end_insn));
      else
	fprintf (stderr, "NULL ");

      if (p->type == TEMPORAL_LOCALITY)
	{
	  fprintf (stderr, "for temporal locality\n");
	} else {
	  fprintf (stderr, "for spatial locality\n");
	}
    }
  if (loop_dump_stream)
    {
      fprintf (loop_dump_stream, "Turning off loads between ");
      if (p->start_insn && NEXT_INSN (p->start_insn))
	fprintf (loop_dump_stream, "%d and ", INSN_UID (NEXT_INSN (p->start_insn)));
      else
	fprintf (loop_dump_stream, "NULL and ");

      if (end_insn)
	fprintf (loop_dump_stream, "%d ", INSN_UID (end_insn));
      else
	fprintf (loop_dump_stream, "NULL ");

      if (p->type == TEMPORAL_LOCALITY)
	{
	  fprintf (loop_dump_stream, "for temporal locality\n");
	} else {
	  fprintf (loop_dump_stream, "for spatial locality\n");
	}
    }

  if (!p->start_insn || !(NEXT_INSN (p->start_insn)))
    return;

  for (curr = NEXT_INSN (p->start_insn); 
       curr && curr != end_insn; 
       curr = NEXT_INSN (curr))
    {
      if (is_load (curr))
	{
	  INSN_TURN_OFF_BSA (curr) = 1;
	}
    }
}
#endif /* 0 */

void
load_set_bsa (p, option)
     predicate p;
     int option;
{
  /* Under these conditions, then we skip this function.  When the
     if condition is false, we don't allow any loads to be turned off. */   

  if (! (jlo_turn_on_all))
    {
      if (p->load_insn)
	{
	  INSN_TURN_OFF_BSA (p->load_insn) = option;
	  if (jlo_cache_opt_verbose)
	    fprintf (stderr, "Turning %s load %d\n",
		     (option == TURN_OFF_BSA) ? "off" : "on",
		     INSN_UID (p->load_insn));
	  if (loop_dump_stream)
	    fprintf (loop_dump_stream, "Turning %s load %d\n",
		     (option == TURN_OFF_BSA) ? "off" : "on",
		     INSN_UID (p->load_insn));
	} else {
	  if (jlo_cache_opt_verbose)
	    {
	      fprintf (stderr, "No load_insn for predicate:\n");
	      predicate_print (stderr, p);
	    }
	  if (loop_dump_stream)
	    {
	      fprintf (loop_dump_stream, "No load_insn for predicate:\n");
	      predicate_print (loop_dump_stream, p);
	    }
	}
    }
}      

#ifdef OLD
/* Searches for loads starting at loop_start and quits when it
   reaches loop_end.  Each load is marked as turned on if the correct
   type of locality for the loop was found.  loop_end
   is not inclusive */
/* turn on beginning with first insn after start_insn.
   also turn on insn after end_insn.  This is because of the way the
   rtl is generated and the actual start and end insns aren't yet available
   as rtls when we see them during parsing/rtl generation phase.*/

void 
loads_turn_on_bsa (p)
     predicate p;
{
  rtx curr;
  rtx end_insn;

  if (p->end_insn || NEXT_INSN (p->end_insn))
    end_insn = NEXT_INSN (p->end_insn);
  else
    end_insn = NULL;

  if (jlo_cache_opt_verbose)
    {
      fprintf (stderr, "Turning on loads between ");
      if (p->start_insn && NEXT_INSN (p->start_insn))
	fprintf (stderr, "%d and ", INSN_UID (NEXT_INSN (p->start_insn)));
      else
	fprintf (stderr, "NULL and ");

      if (end_insn)
	fprintf (stderr, "%d ", INSN_UID (end_insn));
      else
	fprintf (stderr, "NULL ");

      if (p->type == TEMPORAL_LOCALITY)
	{
	  fprintf (stderr, "for temporal locality\n");
	} else {
	  fprintf (stderr, "for spatial locality\n");
	}
    }
  if (loop_dump_stream)
    {
      fprintf (loop_dump_stream, "Turning on loads between ");
      if (p->start_insn && NEXT_INSN (p->start_insn))
	fprintf (loop_dump_stream, "%d and ", INSN_UID (NEXT_INSN (p->start_insn)));
      else
	fprintf (loop_dump_stream, "NULL and ");

      if (end_insn)
	fprintf (loop_dump_stream, "%d ", INSN_UID (end_insn));
      else
	fprintf (loop_dump_stream, "NULL ");

      if (p->type == TEMPORAL_LOCALITY)
	{
	  fprintf (loop_dump_stream, "for temporal locality\n");
	} else {
	  fprintf (loop_dump_stream, "for spatial locality\n");
	}
    }

  if (!p->start_insn || !(NEXT_INSN (p->start_insn)))
    return;

  for (curr = NEXT_INSN (p->start_insn); 
       curr && curr != end_insn; 
       curr = NEXT_INSN (curr))
    {
      if (is_load (curr))
	{
	  INSN_TURN_OFF_BSA (curr) = 0;
	}
    }
}
#endif /* 0 */

int
reg_used (r, regs_defed)
     rtx r; 
     int *regs_defed;
{
  rtx op0, op1;

  if (!r)
    return 0;
  switch (GET_CODE (r))
    {
    case MULT:
    case PLUS:
    case MINUS:
    case DIV:
    case MOD:
    case UDIV:
    case UMOD:
    case ASHIFT:
    case AND:
    case IOR:
    case XOR:
      op0 = XEXP (r, 0);
      op1 = XEXP (r, 1);
      return ((reg_used (op0, regs_defed)) ||
	      (reg_used (op1, regs_defed)));
      break;
    case REG:
      return (regs_defed [REGNO (r)]);
      break;
    case MEM:
    case FLOAT:
    case ABS:
    case SQRT:
    case NEG:
    case NOT:
    case FLOAT_EXTEND:
    case CONST:
      op0 = XEXP (r, 0);
      return (reg_used (op0, regs_defed));
      break;
    case LO_SUM:
      op0 = XEXP (r, 0);
      op1 = XEXP (r, 1);
      return ((reg_used (op0, regs_defed)) ||
	      (reg_used (op1, regs_defed)));
      break;
    default:
      return 0;
    }
}

void
find_load_for_predicate (p)
     predicate p;
{
  rtx curr;
  int *regs_defed;
  int *array_reg;
  rtx src;
  rtx op0;
  rtx op1;
  int found_load = 0;
  int first_pass = 1;

  regs_defed = (int *) alloca (max_reg_num () * sizeof (int));
  bzero (regs_defed, max_reg_num () * sizeof (int));
  array_reg = (int *) alloca (max_reg_num () * sizeof (int));
  bzero (array_reg, max_reg_num () * sizeof (int));

  if (!p->start_insn)
    {
      fprintf (stderr, "WARNING, start_insn is null\n");
      return;
    } else {
      if (jlo_cache_opt_verbose)
	{
	  fprintf (stderr, "In find_load_for_predicate, start_insn is %d, ", 
		   INSN_UID (p->start_insn));
	  fprintf (stderr, "next is %d\n", 
		   INSN_UID (NEXT_INSN (p->start_insn)));
	}
      if (loop_dump_stream)
	{
	  fprintf (loop_dump_stream, 
		   "In find_load_for_predicate, start_insn is %d, ", 
		   INSN_UID (p->start_insn));
	  fprintf (loop_dump_stream, "next is %d\n", 
		   INSN_UID (NEXT_INSN (p->start_insn)));
	}
    }

  regs_defed [p->iterator_reg] = 1;
  
  first_pass = 1;
  while (!found_load)
    {
      if (first_pass)
	curr = NEXT_INSN (p->start_insn);
      else
	curr = p->start_insn;

      for (;
	   curr;
	   curr = NEXT_INSN (curr))
	{
	  /* stop when we hit a code label. This speeds up our move to
	   the second pass. */ 
	  /*	  if (GET_CODE (curr) == CODE_LABEL)
	    {
	      curr = NULL;
	      break;
	    }*/

	  /* If this instruction references the array, then mark the
	     destination register as arr_refed. */
	  if ((GET_CODE (curr) == INSN) &&
	      (GET_CODE (PATTERN (curr)) == SET) &&
	      (GET_CODE (SET_DEST (PATTERN (curr))) == REG))
	    {
	      if (insn_uses_array_ref (SET_SRC (PATTERN (curr)), 
				       p->arr_ref, array_reg))
		{
		  array_reg [REGNO (SET_DEST (PATTERN (curr)))] = 1;
		}
	    }
	  if (is_load (curr))
	    {
	      src = SET_SRC (PATTERN (curr));
	      if (GET_CODE (src) == FLOAT)
		{
		  src = XEXP (src,0);
		}
	      if (GET_CODE (src) == MEM)
		{
		  op0 = XEXP (src, 0);
/*		  if ((GET_CODE (op0) == REG) &&
		      (regs_defed [REGNO (op0)]))
		    break;*/
		  if ((GET_CODE (op0) == PLUS) &&
		      (((GET_CODE (XEXP (op0, 0)) == REG) &&
			(regs_defed [REGNO (XEXP (op0, 0))]) &&
			(array_reg [REGNO (XEXP (op0, 1))])) ||  
		       ((GET_CODE (XEXP (op0, 1)) == REG) &&
			(regs_defed [REGNO (XEXP (op0, 1))]) &&
			(array_reg [REGNO (XEXP (op0, 0))]))))
		    break;
		} 
	    }
	  
	  /* If this insn sets a register and uses a previously def'ed 
	     register as one of its sources, then the register is def'ed */
	  if ((GET_CODE (curr) == INSN) &&
	      (GET_CODE (PATTERN (curr)) == SET) &&
	      (GET_CODE (SET_DEST (PATTERN (curr))) == REG))
	    {
	      src = SET_SRC (PATTERN (curr));
	      if (GET_CODE (src) == HIGH)
		src = XEXP (src, 0);
	      if ((GET_CODE (src) == SYMBOL_REF) ||
		  ((GET_CODE (src) == CONST) &&
		   ((GET_CODE (XEXP (src, 0)) == PLUS) &&
		    (GET_CODE (XEXP (XEXP (src, 0), 0)) == SYMBOL_REF) &&
		    (GET_CODE (XEXP (XEXP (src, 0), 1)) == CONST_INT))) ||
		  ((GET_CODE (src) == MEM) &&
		   ((GET_CODE (XEXP (src, 0)) == SYMBOL_REF) ||
		    (GET_CODE (XEXP (src, 0)) == REG))))
		{
		  if (!first_pass || curr == NEXT_INSN (p->start_insn))
		    {
#define ADD_ITERATOR_RTL
#ifndef ADD_ITERATOR_RTL
		      regs_defed [REGNO (SET_DEST (PATTERN (curr)))] = 1;
		      if (!first_pass && loop_dump_stream)
			{
			  fprintf (loop_dump_stream, 
				   "In find_load_for_predicate, setting reg_defed");
			  fprintf (loop_dump_stream,
				   "[%d], on second pass\n",
				   REGNO (SET_DEST (PATTERN (curr))));
			}
#endif
		    }
		  else 
		    regs_defed [REGNO (SET_DEST (PATTERN (curr)))] = 
		      reg_used (src, regs_defed);
		} else {
		  regs_defed [REGNO (SET_DEST (PATTERN (curr)))] = 
		    reg_used (src, regs_defed);
		}
	    }
	}
      
      if (curr)
	{
	  if (jlo_cache_opt_verbose)
	    {
	      fprintf (stderr, "Setting load_insn %d for predicate\n",
		       INSN_UID (curr));
	      predicate_print (stderr, p);
	      fprintf (stderr, "----------------\n");
	    }
	  if (loop_dump_stream)
	    {
	      fprintf (loop_dump_stream, "Setting load_insn %d for predicate\n",
		       INSN_UID (curr));
	      predicate_print (loop_dump_stream, p);
	      fprintf (loop_dump_stream, "----------------\n");
	    }
	  p->load_insn = curr;
	  found_load = 1;
	} else {
	  if (first_pass)
	    {
	      first_pass = 0;
	    } else {
	      if (loop_dump_stream)
		{
		  fprintf (loop_dump_stream, 
			   "Couldn't find load_insn for predicate\n");
		  predicate_print (loop_dump_stream, p);
		  fprintf (loop_dump_stream, "----------------\n");
		}
	      /* Only try twice */
	      break;
	    }
	  
	}
    }
}

#endif
#endif

int
insn_uses_array_ref (r, arr_ref, array_reg)
     rtx r;
     rtx arr_ref;
     int *array_reg;
{
  switch (GET_CODE (r))
    {
    case PLUS:
    case MULT:
      return (insn_uses_array_ref (XEXP (r, 0), arr_ref, array_reg) ||
	      insn_uses_array_ref (XEXP (r, 1), arr_ref, array_reg));
      break;
    case CONST:
    case LO_SUM:
    case HIGH:
    case ASHIFT:
      return (insn_uses_array_ref (XEXP (r, 0), arr_ref, array_reg));
      break;
    case REG:
      return (r == arr_ref) || (array_reg [REGNO (r)]);
      break;
    case SYMBOL_REF:
      return (r == arr_ref);
      break;
    default:
      return 0;
    } 
}
