//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that when an object of a derived class is (implicitly)
// destructed (on exit from the block in which it is declared)
// that the destructor for the base class also gets executed.
//
// (also check that this execution doesn't seg-fault)

int derived_destructed;
int base_destructed;

struct base {
  int base_data_member;

  base()
  {
    base_data_member = 0x5e5e;
  }
  ~base()
  {
    base_destructed = 0x781f;
  }
};

struct derived : public base {
  int derived_data_member;

  derived()
  {
    derived_data_member = 0xe5e5;
  }
  ~derived()
  {
    derived_destructed = 0xf178;
  }
};


void test2 ();

int main ()
{
	test2 ();
	return ((base_destructed != 0x781f) || (derived_destructed != 0xf178));
}

void test2 ()
{
	derived derived_object;

	derived_object.derived_data_member = 99;
}
