//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that it is illegal to declare  certain operators
// as non member functions.  Operators which must be member
// functions include  operator=, operator(), operator[],
// operator-> and all type conversions operators.
//
// Check that these operators must be member functions
//  regardless of the number of formal parameters they are
// declared to have.

struct s {
	int data_member;
};

struct s2 {
	int data_member;
};

s& operator = (s2& s2_ref_arg);			// ERROR

s2& operator = (s& s_ref_arg1, s& s_ref_arg2);	// ERROR

void operator() (s s_arg1);			// ERROR

void operator() (s s_arg1, s s_arg2);		// ERROR

int operator [] (s s_arg);			// ERROR

int operator [] (s s_arg, s2 s2_arg);		// ERROR

s2* operator-> (s s_arg);			// ERROR

s2* operator-> (s s_arg1, s s_arg2);		// ERROR

operator int (s s_arg);				// ERROR

operator int (s s_arg1, s s_arg2);		// ERROR

operator s (s2 s2_arg);				// ERROR

operator s (s2 s2_arg, s2 s2_arg2);		// ERROR
