/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   Boolean
 *   XtCvtStringToFontSet()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>
#include <locale.h>

void XtWMH_Proc(str1, str2, str3, str4, str5, car)
String str1, str2, str3, str4, *str5;
Cardinal *car;
{
	avs_set_event(1,1);
}

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;



#define T_XtCvtStringToFontSet	1
char    *TestName = "XtCvtStringToFontSet";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

#if XT_X_RELEASE > 4
/* Conversion arguments and results */
Boolean status;
Display *display;
XrmValue args[2];
Cardinal num_args;
XrmValue fromVal;
XrmValue toVal;
XtPointer *closure_ret = (XtPointer *) 0;
/* String to FontSet specific */
char *locale;
char *fontName = "fixed";
XFontSet fontset;
pid_t pid2;
#endif
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtCvtStringToFontSet-1.(C)");
	report_assertion("If the implementation is X11R5 or later: A successful call");
	report_assertion("to Boolean XtCvtStringToFontSet(display, args, num_args,");
	report_assertion("from, to, converter_data) when to->addr is not NULL and");
	report_assertion("to->size is large enough to store an XtRFontSet type shall");
	report_assertion("convert the string specified in from to an XtRFontSet type,");
	report_assertion("store it at the location specified by to->addr, set to->size");
	report_assertion("to the actual size of the converted data, and return True.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

#if XT_X_RELEASE > 4
	FORK(pid2);
	avs_xt_hier("Tcstfset1", "XtCvtStringToFontSet");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get display");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Set up required conversion args");
	args[0].addr = (XtPointer )&display;
	args[0].size = sizeof(Display*);
	locale = (char *)setlocale(LC_ALL, "C");
	args[1].addr = (XtPointer )&locale;
	args[1].size = sizeof(char*);
	num_args = 2;
	tet_infoline("TEST: Check conversion succeeds");
	fromVal.addr = ximconfig.fontsets;
	fromVal.size = strlen(ximconfig.fontsets)+1;
	toVal.addr = (XtPointer) &fontset;
	toVal.size = sizeof(XFontSet);
	status = XtCvtStringToFontSet(display,
			&args[0],
			&num_args,
			&fromVal,
			&toVal,
			closure_ret);
	check_dec(True, status, "XtCvtStringToFontSet return value");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation not X11R5 or greater");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.362600 */
/* End of included file Mdefcode.tmc.362600 */

static void t002(){

#if XT_X_RELEASE > 4
/* Conversion arguments and results */
Boolean status;
Display *display;
XrmValue args[2];
Cardinal num_args;
XrmValue fromVal;
XrmValue toVal;
XtPointer *closure_ret = (XtPointer *) 0;
/* String to FontSet specific */
char *locale;
char *fontName = "fixed";
XFontSet fontset;
pid_t pid2;
#endif
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtCvtStringToFontSet-2.(C)");
	report_assertion("If the implementation is X11R5 or later: A call to Boolean");
	report_assertion("XtCvtStringToFontSet(display, args, num_args, from, to,");
	report_assertion("converter_data) when to->addr is not NULL and to->size is");
	report_assertion("too small for an XtRFontSet type shall not perform a");
	report_assertion("conversion, set the to->size field to the number of bytes");
	report_assertion("required to store the converted data, and return False.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

#if XT_X_RELEASE > 4
	FORK(pid2);
	avs_xt_hier("Tcstfset2", "XtCvtStringToFontSet");
	XtAppSetWarningMsgHandler(app_ctext, XtWMH_Proc);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get display");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Set up required conversion args");
	args[0].addr = (XtPointer )&display;
	args[0].size = sizeof(Display*);
	locale = (char *)setlocale(LC_ALL, "C");
	args[1].addr = (XtPointer )&locale;
	args[1].size = sizeof(char*);
	num_args = 2;
	tet_infoline("TEST: Check conversion fails");
	fromVal.addr = ximconfig.fontsets;
	fromVal.size = strlen(ximconfig.fontsets)+1;
	toVal.addr = (XtPointer) &fontset;
	toVal.size = 0;
	status = XtCvtStringToFontSet(display,
			&args[0],
			&num_args,
			&fromVal,
			&toVal,
			closure_ret);
	check_dec(False, status, "XtCvtStringToFontSet return value");
	tet_infoline("TEST: to_size");
	if (toVal.size != sizeof(XFontSet)) {
		sprintf(ebuf, "ERROR: to_size not set correctly, expected %d, received %d", sizeof(XFontSet), toVal.size);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation not X11R5 or greater");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.362600 */
/* End of included file Mdefcode.tmc.362600 */

static void t003(){

#if XT_X_RELEASE > 4
/* Conversion arguments and results */
Boolean status;
Display *display;
XrmValue args[2];
Cardinal num_args;
XrmValue fromVal;
XrmValue toVal;
XtPointer *closure_ret = (XtPointer *) 0;
/* String to FontSet specific */
char *locale;
char *fontName = "fixed";
pid_t pid2;
#endif
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtCvtStringToFontSet-3.(C)");
	report_assertion("If the implementation is X11R5 or later: A successful call");
	report_assertion("to Boolean XtCvtStringToFontSet(display, args, num_args,");
	report_assertion("from, to, converter_data) when to->addr is NULL shall");
	report_assertion("convert the string specified in from to an XtRFontSet type,");
	report_assertion("allocate space for the converted data, set to->addr to");
	report_assertion("specify the location of the data, set to->size to the size");
	report_assertion("of the coverted data, and return True.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

#if XT_X_RELEASE > 4
	FORK(pid2);
	avs_xt_hier("Tcstfset3", "XtCvtStringToFontSet");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get display");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Set up required conversion args");
	args[0].addr = (XtPointer )&display;
	args[0].size = sizeof(Display*);
	locale = (char *)setlocale(LC_ALL, "C");
	args[1].addr = (XtPointer )&locale;
	args[1].size = sizeof(char*);
	num_args = 2;
	tet_infoline("TEST: Check conversion succeeds");
	fromVal.addr = ximconfig.fontsets;
	fromVal.size = strlen(ximconfig.fontsets)+1;
	toVal.addr = (XtPointer)0;
	toVal.size = 0;
	status = XtCvtStringToFontSet(display,
			&args[0],
			&num_args,
			&fromVal,
			&toVal,
			closure_ret);
	check_dec(True, status, "XtCvtStringToFontSet return value");
	tet_infoline("TEST: to->addr and to->size are set");
	if (!toVal.addr) {
		sprintf(ebuf, "ERROR: to->addr was not set");
	tet_infoline(ebuf);
	tet_result(TET_FAIL);
	}
	if (toVal.size != sizeof(XFontSet)) {
		sprintf(ebuf, "ERROR: to_size not set correctly, expected %d, received %d", sizeof(XFontSet), toVal.size);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation not X11R5 or greater");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.362600 */
/* End of included file Mdefcode.tmc.362600 */

static void t004(){

#if XT_X_RELEASE > 4
/* Conversion arguments and results */
Boolean status;
Display *display;
XrmValue args[2];
Cardinal num_args;
XrmValue fromVal;
XrmValue toVal;
XtPointer *closure_ret = (XtPointer *) 0;
/* String to FontSet specific */
char *locale;
char *fontName = "fixed";
pid_t pid2;
#endif
pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtCvtStringToFontSet-4.(C)");
	report_assertion("If the implementation is X11R5 or later: A call to Boolean");
	report_assertion("XtCvtStringToFontSet(display, args, num_args, from, to,");
	report_assertion("converter_data) when args specifies an improper value shall");
	report_assertion("not perform a conversion, issue a warning message, and");
	report_assertion("return False.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

#if XT_X_RELEASE > 4
	FORK(pid2);
	avs_xt_hier("Tcstfset4", "XtCvtStringToFontSet");
	avs_set_event(1,0);
	XtAppSetWarningMsgHandler(app_ctext, XtWMH_Proc);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get display");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Set up required conversion args incorrectly");
	num_args = 0;
	tet_infoline("TEST: Check conversion fails");
	fromVal.addr = ximconfig.fontsets;
	fromVal.size = strlen(ximconfig.fontsets)+1;
	toVal.addr = (XtPointer)0;
	toVal.size = 0;
	status = XtCvtStringToFontSet(display,
			&args[0],
			&num_args,
			&fromVal,
			&toVal,
			closure_ret);
	check_dec(False, status, "conversion status");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Warning handler is called");
	status = avs_get_event(1);
	check_dec(1, status, "calls to warning handler count");
	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation not X11R5 or greater");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.362600 */
/* End of included file Mdefcode.tmc.362600 */

/* Including from file Mdefcode.tmc.362600 */
static void t005(){

pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtCvtStringToFontSet-5.(B)");
	report_assertion("If the implementation is X11R5 or later: On a successful");
	report_assertion("call to Boolean XtCvtStringToFontSet(display, args,");
	report_assertion("num_args, from, to, converter_data) when from specifies the");
	report_assertion("constant XtDefaultFontSet and the application resource");
	report_assertion("database contains the resource name xtDefaultFontSet, class");
	report_assertion("XtDefaultFontSet the converted value shall specify this");
	report_assertion("resource value.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.362600 */

/* Including from file Mdefcode.tmc.362600 */
static void t006(){

pid_t	pid;

 	report_purpose(6);

	report_assertion("Assertion XtCvtStringToFontSet-6.(D)");
	report_assertion("If the implementation is X11R5 or later: On a successful");
	report_assertion("call to Boolean XtCvtStringToFontSet(display, args,");
	report_assertion("num_args, from, to, converter_data) when from specifies the");
	report_assertion("constant XtDefaultFontSet and the application resource");
	report_assertion("database does not contain the resource name xtDefaultFontSet,");
	report_assertion("class XtDefaultFontSet the converted data shall specify an");
	report_assertion("implementation-defined font set.");
	report_assertion("Reason for omission: The statement in the X11 specification is not specific enough to write a test");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.362600 */

/* Including from file Mdefcode.tmc.362600 */
static void t007(){

pid_t	pid;

 	report_purpose(7);

	report_assertion("Assertion XtCvtStringToFontSet-7.(D)");
	report_assertion("If the implementation is X11R5 or later: On a successful");
	report_assertion("call to Boolean XtCvtStringToFontSet(display, args,");
	report_assertion("num_args, from, to, converter_data) when from specifies the");
	report_assertion("constant XtDefaultFontSet, the application resource database");
	report_assertion("contains the resource name xtDefaultFontSet, class");
	report_assertion("XtDefaultFontSet, and a font set could not be created from");
	report_assertion("the base font name list specified by this resource the");
	report_assertion("converted data shall specify an implementation-defined font");
	report_assertion("set.");
	report_assertion("Reason for omission: The statement in the X11 specification is not specific enough to write a test");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.362600 */

/* Including from file Mdefcode.tmc.362600 */
static void t008(){

pid_t	pid;

 	report_purpose(8);

	report_assertion("Assertion XtCvtStringToFontSet-8.(D)");
	report_assertion("If the implementation is X11R5 or later: On a call to");
	report_assertion("Boolean XtCvtStringToFontSet(display, args, num_args, from,");
	report_assertion("to, converter_data) when from specifies the constant");
	report_assertion("XtDefaultFontSet, the application resource database contains");
	report_assertion("the resource name xtDefaultFontSet, class XtDefaultFontSet,");
	report_assertion("a font set cannot be created from the base font name list");
	report_assertion("specified by this resource, and an implementation-defined");
	report_assertion("font set could not be created it shall issue a warning");
	report_assertion("message and return False.");
	report_assertion("Reason for omission: The statement in the X11 specification is not specific enough to write a test");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.362600 */

/* Including from file Mdefcode.tmc.362600 */
static void t009(){

pid_t	pid;

 	report_purpose(9);

	report_assertion("Assertion XtCvtStringToFontSet-9.(D)");
	report_assertion("If the implementation is X11R5 or later: A call to Boolean");
	report_assertion("XtCvtStringToFontSet(display, args, num_args, from, to,");
	report_assertion("converter_data) when from specifies the constant");
	report_assertion("XtDefaultFontSet and a font set could be created that has");
	report_assertion("missing character sets shall return the partial font set in");
	report_assertion("and issue a warning message.");
	report_assertion("Reason for omission: The statement in the X11 specification is not specific enough to write a test");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.362600 */

/* Including from file Mdefcode.tmc.362600 */
static void t010(){

pid_t	pid;

 	report_purpose(10);

	report_assertion("Assertion XtCvtStringToFontSet-10.(B)");
	report_assertion("If the implementation is X11R5 or later: On a call to");
	report_assertion("Boolean XtCvtStringToFontSet(display, args, num_args, from,");
	report_assertion("to, converter_data) the resource type conversion performed");
	report_assertion("shall be locale specific.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.362600 */

static void t011(){

#if XT_X_RELEASE > 4
/* Conversion arguments and results */
Boolean status;
Display *display;
XrmValue args[2];
Cardinal num_args;
XrmValue fromVal;
XrmValue toVal;
XtPointer *closure_ret = (XtPointer *) 0;
/* String to FontSet specific */
char *locale;
char *fontName = "-1";
XFontSet fontset;
pid_t pid2;
#endif
pid_t	pid;

 	report_purpose(11);

	report_assertion("Assertion XtCvtStringToFontSet-11.(C)");
	report_assertion("If the implementation is X11R5 or later: A call to Boolean");
	report_assertion("XtCvtStringToFontSet(display, args, num_args, from, to,");
	report_assertion("converter_data) when the conversion is not performed due to");
	report_assertion("an improper value specified in from shall issue a warning");
	report_assertion("message and return False.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

#if XT_X_RELEASE > 4
	FORK(pid2);
	avs_set_event(1, 0);
	avs_xt_hier("Tcstfset5", "XtCvtStringToFontSet");
	XtAppSetWarningMsgHandler(app_ctext, XtWMH_Proc);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get display");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Set up required conversion args");
	args[0].addr = (XtPointer )&display;
	args[0].size = sizeof(Display*);
	locale = (char *)setlocale(LC_ALL, "C");
	args[1].addr = (XtPointer )&locale;
	args[1].size = sizeof(char*);
	num_args = 2;
	tet_infoline("TEST: Check conversion fails");
	fromVal.addr = fontName;
	fromVal.size = strlen(fontName)+1;
	toVal.addr = (XtPointer) &fontset;
	toVal.size = sizeof(XFontSet);
	status = XtCvtStringToFontSet(display,
			&args[0],
			&num_args,
			&fromVal,
			&toVal,
			closure_ret);
	check_dec(False, status, "XtCvtStringToFontSet return value");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Warning handler is called");
	status = avs_get_event(1);
	check_dec(1, status, "calls to warning handler count");
	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation not X11R5 or greater");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.362600 */
/* End of included file Mdefcode.tmc.362600 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
