/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtRemoveCallback()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

/*
** procedure XtCBP_Proc
*/
void XtCBP_Proc(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
	sprintf(ebuf, "ERROR: Deleted Callback XtCBP_Proc was invoked");
	tet_infoline(ebuf);
	tet_result(TET_FAIL);
}
/*
** procedure XtCBP2_Proc
*/
void XtCBP2_Proc(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
	avs_set_event(1, avs_get_event(1)+1);
}


#define T_XtRemoveCallback	1
char    *TestName = "XtRemoveCallback";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Widget labelw_good;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtRemoveCallback-1.(A)");
	report_assertion("A successful call to void XtRemoveCallback(w,");
	report_assertion("callback_name, callback, client_data) shall delete the");
	report_assertion("procedure callback from the widget w's callback list");
	report_assertion("specified by callback_name that was added to the list to be");
	report_assertion("invoked with client_data as the client data argument.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Trmclback1", "XtRemoveCallback");
	tet_infoline("PREP: Create labelw_good widget Hello in boxw1 widget");
	labelw_good = (Widget) CreateLabelWidget("Hello", boxw1);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Add a callback procedure to labelw_good widget");
	XtAddCallback(labelw_good,
			XtNdestroyCallback,
			XtCBP_Proc,
			(XtPointer)labelw_good
			);
	tet_infoline("PREP: Remove the procedure XtCBP_Proc from the list");
	XtRemoveCallback(labelw_good, XtNdestroyCallback,
		 XtCBP_Proc, (XtPointer)labelw_good );
	tet_infoline("TEST: labelw_good destroyed should not invoke callback");
	XtDestroyWidget(labelw_good);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.365452 */
/* End of included file Mdefcode.tmc.365452 */

static void t002(){

Widget labelw_good;
pid_t pid2;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtRemoveCallback-2.(A)");
	report_assertion("If the procedure callback and client_data do not match");
	report_assertion("function/data pair on the list, a call to void");
	report_assertion("XtRemoveCallback(w, callback_name, callback, client_data)");
	report_assertion("shall not delete the procedure from the callback list");
	report_assertion("identified by resource callback_name for w.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Trmclback1", "XtRemoveCallback");
	tet_infoline("PREP: Create labelw_good widget Hello in boxw1 widget");
	labelw_good = (Widget) CreateLabelWidget("Hello", boxw1);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Add a callback procedure to labelw_good widget");
	XtAddCallback(labelw_good,
			XtNdestroyCallback,
			XtCBP2_Proc,
			(XtPointer)labelw_good
			);
	tet_infoline("PREP: Remove the procedure XtCBP2_Proc from the list with other client data");
	XtRemoveCallback(labelw_good, XtNdestroyCallback,
		 XtCBP2_Proc, (XtPointer)topLevel );
	tet_infoline("TEST: labelw_good destroyed should invoke function");
	XtDestroyWidget(labelw_good);
	LKROF(pid2, AVSXTTIMEOUT-2);
	if (avs_get_event(1) == 0) {
		tet_infoline("ERROR: Callback was not invoked");
		tet_result(TET_FAIL);
	}
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.365452 */
/* End of included file Mdefcode.tmc.365452 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
