/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XRotateWindowProperties(display, w, properties, num_prop, npositions)
 *   Display *display;
 *   Window w;
 *   Atom *properties;
 *   int num_prop;
 *   int npositions;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XRotateWindowProperties	1
char    *TestName = "XRotateWindowProperties";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW w
#define A_DRAWABLE w


/*
 * Arguments to the XRotateWindowProperties function
 */
static Display *display;
static Window w;
static Atom *properties;
static int num_prop;
static int npositions;


#include "X11/Xatom.h"

static Atom xrwp_list[5] = {
	0, 0, 0, 0, (unsigned)-1 };

static void
xrwp_add_property(disp, win, prop, data)
Display *disp;
Window win;
Atom prop;
unsigned long data;
{
        XChangeProperty(disp, win, prop, XA_INTEGER, 32,
                PropModeReplace,(unsigned char *)&data, 1);
        XSync(disp, True);
}


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	w = defwin(display);
	properties = (Atom *)&(xrwp_list[0]);
	num_prop = 4;
	npositions = 1;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int num_ev;
int loop;
XEvent ev, good;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XRotateWindowProperties-1.(A)");
	report_assertion("A call to XRotateWindowProperties rotates properties on the");
	report_assertion("window w and generates PropertyNotify events.");

	report_strategy("Create a window with properties, with PropertyChangeMask events selected.");
	report_strategy("Call XRotateWindowProperties to rotate the window properties.");
	report_strategy("Verify that PropertyNotify events were genereated.");
	report_strategy("Verify that the property values were rotated as expected.");

	tpstartup();
	setargs();
/* Create a window with properties, with PropertyChangeMask events selected. */
	xrwp_list[0] = XA_INTEGER;
	xrwp_list[1] = XA_COPYRIGHT;
	for(loop=0; loop<2; loop++)
		xrwp_add_property(display, w, xrwp_list[loop],
				(unsigned long)loop);

	XSelectInput(display, w, PropertyChangeMask);

/* Call xname to rotate the window properties. */
	num_prop = 2;
	startcall(display);
	if (isdeleted())
		return;
	XRotateWindowProperties(display, w, properties, num_prop, npositions);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that PropertyNotify events were genereated. */
	num_ev = getevent(display, &ev);
	if(num_ev != 2) {
		FAIL;
		report("%s did not cause the expected events",
			TestName);
		trace("Expected: 2 PropertyNotify events");
		trace("Returned: %d events", num_ev);
		for(; num_ev>0; ) {
			trace("Event: %s", eventname(ev.type));
			if(ev.type==PropertyNotify)
				trace("Property: %s",
					atomname(ev.xproperty.atom));
			num_ev = getevent(display, &ev);
		}
		return;
	} else {
		loop=0;
		do {
			good.type = PropertyNotify;
			good.xproperty.type = PropertyNotify;
			good.xproperty.atom = xrwp_list[loop++];
			good.xproperty.display = display;
			good.xproperty.window = w;
			good.xproperty.state = PropertyNewValue;
			if (checkevent(&good, &ev)) {
				FAIL;
			} else
				CHECK;
		} while(getevent(display, &ev));
	}

/* Verify that the property values were rotated as expected. */
	for(loop=0; loop<2; loop++) {
		Atom type;
		int format;
		unsigned long nitems;
		unsigned long after;
		unsigned char *value;

		XGetWindowProperty(display, w, xrwp_list[loop], 0, 1, False,
				XA_INTEGER, &type, &format, &nitems, &after,
					&value);

		if (type != XA_INTEGER || format != 32 ||
			nitems != 1 || after != 0) {
			delete("XGetWindowProperty returned unexpected values");
			trace("loop is %d", loop);
			trace("type is %s (expected XA_INTEGER)",
				atomname(type));
			trace("format is %d (expected 32)", format);
			trace("nitems is %u (expected 1)", nitems);
			trace("after is %u (expected 0)", after);
			return;
		} else {
			unsigned long tmp;

			tmp = *(unsigned long *)value;
			if (tmp != ((loop+1) % 2) ) {
				FAIL;
				report("%s did not rotate values as expected",
						TestName);
				trace("expected value %u", (loop+1) %2);
				trace("returned value %u", tmp);
			} else {
				CHECK;
				trace("expected value %u returned", tmp);
			}
		}
	}
			
	CHECKPASS(4);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int num_ev;
int loop;
XEvent ev, good;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XRotateWindowProperties-2.(A)");
	report_assertion("When npositions mod num_prop is non-zero, then a call to");
	report_assertion("XRotateWindowProperties reorders the values associated with");
	report_assertion("the properties such that the value associated with a");
	report_assertion("properties [I] becomes the value associated with the");
	report_assertion("properties [ I+ npositions] mod num_prop, and a");
	report_assertion("PropertyNotify event is generated for each member of the");
	report_assertion("properties array in the array order.");

	report_strategy("Create a window with properties, with PropertyChangeMask events selected.");
	report_strategy("Call XRotateWindowProperties to rotate the window properties.");
	report_strategy("Verify that PropertyNotify events were genereated.");
	report_strategy("Verify that the property values were rotated as expected.");

	tpstartup();
	setargs();
/* Create a window with properties, with PropertyChangeMask events selected. */
	xrwp_list[0] = XA_INTEGER;
	xrwp_list[1] = XA_COPYRIGHT;
	xrwp_list[2] = XA_WM_HINTS;
	xrwp_list[3] = XA_NOTICE;
	for(loop=0; loop<num_prop; loop++)
		xrwp_add_property(display, w, xrwp_list[loop],
				(unsigned long)loop);

	XSelectInput(display, w, PropertyChangeMask);

/* Call xname to rotate the window properties. */
	startcall(display);
	if (isdeleted())
		return;
	XRotateWindowProperties(display, w, properties, num_prop, npositions);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that PropertyNotify events were genereated. */
	num_ev = getevent(display, &ev);
	if(num_ev != num_prop) {
		FAIL;
		report("%s did not cause the expected events",
			TestName);
		trace("Expected: %d PropertyNotify events", num_prop);
		trace("Returned: %d events", num_ev);
		for(; num_ev>0; ) {
			trace("Event: %s", eventname(ev.type));
			if(ev.type==PropertyNotify)
				trace("Property: %s",
					atomname(ev.xproperty.atom));
			num_ev = getevent(display, &ev);
		}
		return;
	} else {
		loop=0;
		do {
			good.type = PropertyNotify;
			good.xproperty.type = PropertyNotify;
			good.xproperty.atom = xrwp_list[loop++];
			good.xproperty.display = display;
			good.xproperty.window = w;
			good.xproperty.state = PropertyNewValue;
			if (checkevent(&good, &ev)) {
				FAIL;
			} else
				CHECK;
		} while(getevent(display, &ev));
	}

/* Verify that the property values were rotated as expected. */
	for(loop=0; loop<num_prop; loop++) {
		Atom type;
		int format;
		unsigned long nitems;
		unsigned long after;
		unsigned char *value;
		XGetWindowProperty(display, w, xrwp_list[loop], 0, 1, False,
				XA_INTEGER, &type, &format, &nitems, &after,
					&value);

		if (type != XA_INTEGER || format != 32 ||
			nitems != 1 || after != 0) {
			delete("XGetWindowProperty returned unexpected values");
			trace("loop is %d", loop);
			trace("type is %s (expected XA_INTEGER)",
				atomname(type));
			trace("format is %d (expected 32)", format);
			trace("nitems is %u (expected 1)", nitems);
			trace("after is %u (expected 0)", after);
			return;
		} else {
			unsigned long tmp;

			/*
			 * The new value of prop[loop] is the value of the old
			 * prop[loop-npositions mod num_prop]
			 */
			tmp = *(unsigned long *)value;
			if (tmp != ((loop-npositions + num_prop) % num_prop) ) {
				FAIL;
				report("%s did not rotate values as expected",
					TestName);
				trace("expected value %u",
					(loop-npositions + num_prop) % num_prop);
				trace("returned value %u", tmp);
			} else {
				CHECK;
				trace("expected value %u returned", tmp);
			}
		}
	}

	CHECKPASS(2*num_prop);
			
	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

XEvent ev;
int loop;
int num_ev;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XRotateWindowProperties-3.(A)");
	report_assertion("When an atom occurs more than once in the properties list,");
	report_assertion("then a call to XRotateWindowProperties changes no window");
	report_assertion("properties,anda BadMatch error occurs.");

	report_strategy("Create a window with properties, and PropertyChangeMask events selected.");
	report_strategy("Ensure that the properties array contains a duplicate member.");
	report_strategy("Call XRotateWindowProperties to rotate the window properties.");
	report_strategy("Verify that a BadMatch error occurred.");
	report_strategy("Verify that no property notify events were raised.");
	report_strategy("Verify that the property values were not modified.");

	tpstartup();
	setargs();
/* Create a window with properties, and PropertyChangeMask events selected. */
	xrwp_list[0] = XA_INTEGER;
	xrwp_list[1] = XA_COPYRIGHT;
	xrwp_list[2] = XA_WM_HINTS;
	for(loop=0; loop<3; loop++)
		xrwp_add_property(display, w, xrwp_list[loop],
				(unsigned long)loop);

	XSelectInput(display, w, PropertyChangeMask);

/* Ensure that the properties array contains a duplicate member. */
	xrwp_list[3] = XA_COPYRIGHT;

/* Call xname to rotate the window properties. */
	startcall(display);
	if (isdeleted())
		return;
	XRotateWindowProperties(display, w, properties, num_prop, npositions);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

/* Verify that a BadMatch error occurred. */
	if (geterr() != BadMatch) {
		FAIL;
		report("%s did not generate a BadMatch", TestName);
		report("when the property list contained a duplicate");
	} else
		CHECK;

/* Verify that no property notify events were raised. */
	num_ev =getevent(display, &ev);
	if(num_ev != 0) {
		XEvent ev;
		FAIL;
		report("%s caused unexpected events",
			TestName);
		trace("Expected: no events");
		trace("Returned: %d events", num_ev);
		for(; num_ev>0; ) {
			trace("Event: %s", eventname(ev.type));
			if(ev.type==PropertyNotify)
				trace("Property: %s",
					atomname(ev.xproperty.atom));
			num_ev = getevent(display, &ev);
		}
		return;
	} else 
		CHECK;

/* Verify that the property values were not modified. */
	for(loop=0; loop<3; loop++) {
		Atom type;
		int format;
		unsigned long nitems;
		unsigned long after;
		unsigned char *value;
		XGetWindowProperty(display, w, xrwp_list[loop], 0, 1, False,
				XA_INTEGER, &type, &format, &nitems, &after,
					&value);

		if (type != XA_INTEGER || format != 32 ||
			nitems != 1 || after != 0) {
			delete("XGetWindowProperty returned unexpected values");
			trace("loop is %d", loop);
			trace("type is %s (expected XA_INTEGER)",
				atomname(type));
			trace("format is %d (expected 32)", format);
			trace("nitems is %u (expected 1)", nitems);
			trace("after is %u (expected 0)", after);
			return;
		} else {
			unsigned long tmp;

			tmp = *(unsigned long *)value;
			if (tmp != loop ) {
				FAIL;
				report("%s changed the property values",
					TestName);
				report("when no change was expected");
				trace("expected value %u", loop);
				trace("returned value %u", tmp);
			} else {
				CHECK;
				trace("expected property value %u", tmp);
			}
		}
	}

	CHECKPASS(5);
			
	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

int loop;
XEvent ev;
int num_ev;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XRotateWindowProperties-4.(A)");
	report_assertion("When an atom in the properties list is not a property of");
	report_assertion("the specified window w, then a call to");
	report_assertion("XRotateWindowProperties changes no window propreties, and a");
	report_assertion("BadMatch error occurs.");

	report_strategy("Create a window with properties, and PropertyChangeMask events selected.");
	report_strategy("Ensure the properties array has a member that is not a window property.");
	report_strategy("Call XRotateWindowProperties to rotate the window properties.");
	report_strategy("Verify that a BadMatch error occurred.");
	report_strategy("Verify that no property notify events were raised.");
	report_strategy("Verify that the property values were not modified.");

	tpstartup();
	setargs();
/* Create a window with properties, and PropertyChangeMask events selected. */
	xrwp_list[0] = XA_INTEGER;
	xrwp_list[1] = XA_COPYRIGHT;
	xrwp_list[2] = XA_WM_HINTS;
	for(loop=0; loop<3; loop++)
		xrwp_add_property(display, w, xrwp_list[loop],
				(unsigned long)loop);

	XSelectInput(display, w, PropertyChangeMask);

/* Ensure the properties array has a member that is not a window property. */
	xrwp_list[3] = XA_NOTICE;

/* Call xname to rotate the window properties. */
	startcall(display);
	if (isdeleted())
		return;
	XRotateWindowProperties(display, w, properties, num_prop, npositions);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

/* Verify that a BadMatch error occurred. */
	if (geterr() != BadMatch) {
		FAIL;
		report("%s did not generate a BadMatch", TestName);
		report("when the property list contained a duplicate");
	} else
		CHECK;

/* Verify that no property notify events were raised. */
	num_ev =getevent(display, &ev);
	if(num_ev != 0) {
		XEvent ev;
		FAIL;
		report("%s caused unexpected events",
			TestName);
		trace("Expected: no events");
		trace("Returned: %d events", num_ev);
		for(; num_ev>0; ) {
			trace("Event: %s", eventname(ev.type));
			if(ev.type==PropertyNotify)
				trace("Property: %s",
					atomname(ev.xproperty.atom));
			num_ev = getevent(display, &ev);
		}
		return;
	} else 
		CHECK;

/* Verify that the property values were not modified. */
	for(loop=0; loop<3; loop++) {
		Atom type;
		int format;
		unsigned long nitems;
		unsigned long after;
		unsigned char *value;
		XGetWindowProperty(display, w, xrwp_list[loop], 0, 1, False,
				XA_INTEGER, &type, &format, &nitems, &after,
					&value);

		if (type != XA_INTEGER || format != 32 ||
			nitems != 1 || after != 0) {
			delete("XGetWindowProperty returned unexpected values");
			trace("loop is %d", loop);
			trace("type is %s (expected XA_INTEGER)",
				atomname(type));
			trace("format is %d (expected 32)", format);
			trace("nitems is %u (expected 1)", nitems);
			trace("after is %u (expected 0)", after);
			return;
		} else {
			unsigned long tmp;

			tmp = *(unsigned long *)value;
			if (tmp != loop ) {
				FAIL;
				report("%s changed the property values",
					TestName);
				report("when no change was expected");
				trace("expected value %u", loop);
				trace("returned value %u", tmp);
			} else {
				CHECK;
				trace("expected property value %u", tmp);
			}
		}
	}

	CHECKPASS(5);

	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

int loop;
XEvent ev;
int num_ev;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XRotateWindowProperties-5.(A)");
	report_assertion("When an atom in the properties list is a bad atom, then a");
	report_assertion("call to XRotateWindowProperties changes no window property");
	report_assertion("values, and a BadAtom error occurs.");

	report_strategy("Create a window with properties, and PropertyChangeMask events selected.");
	report_strategy("Ensure the properties array has a member that is a bad atom (-1).");
	report_strategy("Call XRotateWindowProperties to rotate the window properties.");
	report_strategy("Verify that a BadMatch error occurred.");
	report_strategy("Verify that no property notify events were raised.");
	report_strategy("Verify that the property values were not modified.");

	tpstartup();
	setargs();
/* Create a window with properties, and PropertyChangeMask events selected. */
	xrwp_list[0] = XA_INTEGER;
	xrwp_list[1] = XA_COPYRIGHT;
	xrwp_list[2] = XA_WM_HINTS;
	for(loop=0; loop<3; loop++)
		xrwp_add_property(display, w, xrwp_list[loop],
				(unsigned long)loop);

	XSelectInput(display, w, PropertyChangeMask);

/* Ensure the properties array has a member that is a bad atom (-1). */
	xrwp_list[3] = -1L;

/* Call xname to rotate the window properties. */
	startcall(display);
	if (isdeleted())
		return;
	XRotateWindowProperties(display, w, properties, num_prop, npositions);
	endcall(display);
	if (geterr() != BadAtom) {
		report("Got %s, Expecting BadAtom", errorname(geterr()));
		FAIL;
	}

/* Verify that a BadMatch error occurred. */
	if (geterr() != BadAtom) {
		FAIL;
		report("%s did not generate a BadAtom", TestName);
		report("when the property list contained -1");
	} else
		CHECK;

/* Verify that no property notify events were raised. */
	num_ev =getevent(display, &ev);
	if(num_ev != 0) {
		XEvent ev;
		FAIL;
		report("%s caused unexpected events",
			TestName);
		trace("Expected: no events");
		trace("Returned: %d events", num_ev);
		for(; num_ev>0; ) {
			trace("Event: %s", eventname(ev.type));
			if(ev.type==PropertyNotify)
				trace("Property: %s",
					atomname(ev.xproperty.atom));
			num_ev = getevent(display, &ev);
		}
		return;
	} else 
		CHECK;

/* Verify that the property values were not modified. */
	for(loop=0; loop<3; loop++) {
		Atom type;
		int format;
		unsigned long nitems;
		unsigned long after;
		unsigned char *value;
		XGetWindowProperty(display, w, xrwp_list[loop], 0, 1, False,
				XA_INTEGER, &type, &format, &nitems, &after,
					&value);

		if (type != XA_INTEGER || format != 32 ||
			nitems != 1 || after != 0) {
			delete("XGetWindowProperty returned unexpected values");
			trace("loop is %d", loop);
			trace("type is %s (expected XA_INTEGER)",
				atomname(type));
			trace("format is %d (expected 32)", format);
			trace("nitems is %u (expected 1)", nitems);
			trace("after is %u (expected 0)", after);
			return;
		} else {
			unsigned long tmp;

			tmp = *(unsigned long *)value;
			if (tmp != loop ) {
				FAIL;
				report("%s changed the property values",
					TestName);
				report("when no change was expected");
				trace("expected value %u", loop);
				trace("returned value %u", tmp);
			} else {
				CHECK;
				trace("expected property value %u", tmp);
			}
		}
	}

	CHECKPASS(5);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EWin.mc */
/* End of included file error/EWin.mc */

/* Including from file error/EWin.mc */
static void t006(){

int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XRotateWindowProperties-6.(A)");
	report_assertion("When a window argument does not name a valid Window, then a");
	report_assertion("BadWindow error occurs.");

	report_strategy("Create a bad window by creating and destroying a window.");
	report_strategy("Call test function using bad window as the window argument.");
	report_strategy("Verify that a BadWindow error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	A_WINDOW = badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	XRotateWindowProperties(display, w, properties, num_prop, npositions);
	endcall(display);
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadWindow)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EWin.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
