/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* $XConsortium: crcltsbwsd.m,v 1.7 94/04/17 21:02:58 rws Exp $
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XCirculateSubwindowsDown(display, w)
 *   Display	*display;
 *   Window	w;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XCirculateSubwindowsDown	1
char    *TestName = "XCirculateSubwindowsDown";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW w
#define A_DRAWABLE w


/*
 * Arguments to the XCirculateSubwindowsDown function
 */
static Display	*display;
static Window	w;



static char	*SimpleTemplate[] = {
	".",
	"zero . (20,10) 40x40",
	"one . (30,20) 40x40",
	"two . (10,30) 40x40",
	"other1 . (75,10) 15x70",
};
static int	NSimpleTemplate = NELEM(SimpleTemplate);

static char	*Expose1Template[] = {
	".",
	"zero . (20,10) 40x40",
	"one . (30,20) 40x40",
	"other1 . (75,10) 15x70",
};
static int	NExpose1Template = NELEM(Expose1Template);

static char	*Expose2Template[] = {
	".",
	"two . (40,30) 40x40",
};
static int	NExpose2Template = NELEM(Expose2Template);


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	w = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
	w = ErrdefWindow;
}

static void t001(){

Window	parent;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XCirculateSubwindowsDown-1.(A)");
	report_assertion("When there is a mapped child that occludes another child,");
	report_assertion("then a call to XCirculateSubwindowsDown lowers the highest");
	report_assertion("such mapped child to the bottom of the stack.");

	report_strategy("Create a window hierarchy using buildtree.");
	report_strategy("Call XCirculateSubwindowsDown upon the parent window.");
	report_strategy("Verify that the highest occluding mapped child window was lowered.");

	tpstartup();
	setargs();
/* Create a window hierarchy using buildtree. */
	parent =  defwin(display);
	buildtree(display, parent, SimpleTemplate, NSimpleTemplate);

/* Call xname upon the parent window. */
	w = parent;
	startcall(display);
	if (isdeleted())
		return;
	XCirculateSubwindowsDown(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that the highest occluding mapped child window was lowered. */
	PIXCHECK(display, parent);

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

struct	buildtree	*tree1;
Window	parent, one;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XCirculateSubwindowsDown-2.(A)");
	report_assertion("When a call to XCirculateSubwindowsDown uncovers part of");
	report_assertion("any window that was formerly obscured, then either Expose");
	report_assertion("events are generated or the contents are restored from");
	report_assertion("backing store.");

	report_strategy("Create a window hierarchy using buildtree.");
	report_strategy("Call setforexpose on window 'one' to allow Expose event checking.");
	report_strategy("Select Expose events on window 'one'.");
	report_strategy("Call XCirculateSubwindowsDown in order to expose window 'one' by lowering window 'two'.");
	report_strategy("Use exposecheck to ensure that the window 'one' was restored correctly.");

	tpstartup();
	setargs();
/* Create a window hierarchy using buildtree. */
	parent =  defwin(display);
	tree1= buildtree(display, parent, Expose1Template, NExpose1Template);
	one = btntow(tree1, "one");

/* Call setforexpose on window 'one' to allow Expose event checking. */
	setforexpose(display, one);	
	buildtree(display, parent, Expose2Template, NExpose2Template);

/* Select Expose events on window 'one'. */
	XSelectInput(display, one, ExposureMask);

/* Call xname in order to expose window 'one' by lowering window 'two'. */
	w = parent;
	startcall(display);
	if (isdeleted())
		return;
	XCirculateSubwindowsDown(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Use exposecheck to ensure that the window 'one' was restored correctly. */
	if (!exposecheck(display, one)) {
		report("Neither Expose events or backing store processing");
		report("could correctly restore the window contents.");
		FAIL;
	} else
		CHECK;

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

Display	*client1,*client2;
struct	buildtree	*c1tree;
XImage	*image;
Window	parent, zero, one, two;
XEvent	ev;
int	numevent;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XCirculateSubwindowsDown-3.(A)");
	report_assertion("When some other client has selected");
	report_assertion("SubstructureRedirectMask on the window, then a");
	report_assertion("CirculateRequest event is generated, and no further");
	report_assertion("processing is performed.");

	report_strategy("Create client1 and client2 with a window on client1");
	report_strategy("Create a window hierarchy for client1.");
	report_strategy("Save parent window image as reference image.");
	report_strategy("Select all events other than SubstructureRedirectMask events on");
	report_strategy("	all the windows for client1, to catch rogue events.");
	report_strategy("Select SubstructureRedirectMask on the parent window for client2.");
	report_strategy("Call XCirculateSubwindowsDown on client1 in order to lower window two.");
	report_strategy("Verify that no events were delivered to client1 using getevent.");
	report_strategy("Verify that a correct CirculateRequest event was delievered to client2 using getevent and checkevent.");
	report_strategy("Verify that no further processing occurred by comparing the window and our reference image.");

	tpstartup();
	setargs();
/* Create client1 and client2 with a window on client1 */
	client1 = opendisplay();
	if (client1 == NULL) {
		delete("could not create client1");
		return;
	}
	else
		CHECK;
	client2 = opendisplay();
	if (client2 == NULL) {
		delete("could not create client2");
		return;
	}
	else
		CHECK;

/* Create a window hierarchy for client1. */
	parent = defwin(client1);
	c1tree = buildtree(client1, parent, SimpleTemplate, NSimpleTemplate);
	zero = btntow(c1tree, "zero");
	one  = btntow(c1tree, "one");
	two  = btntow(c1tree, "two");

/* Save parent window image as reference image. */
	image= savimage(client1, parent);

/* Select all events other than SubstructureRedirectMask events on */
/* 	all the windows for client1, to catch rogue events. */
	XSelectInput(client1, parent, ALLEVENTS & ~(SubstructureRedirectMask));
	XSelectInput(client1, zero, ALLEVENTS & ~(SubstructureRedirectMask));
	XSelectInput(client1, one, ALLEVENTS & ~(SubstructureRedirectMask));
	XSelectInput(client1, two, ALLEVENTS & ~(SubstructureRedirectMask));

/* Select SubstructureRedirectMask on the parent window for client2. */
	XSelectInput(client2, parent, SubstructureRedirectMask);
	XSync(client2, True);

/* Call xname on client1 in order to lower window two. */
	display = client1;
	w = parent;
	startcall(display);
	if (isdeleted())
		return;
	XCirculateSubwindowsDown(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync(client2, False);

/* Verify that no events were delivered to client1 using getevent. */
	numevent = getevent(client1, &ev);
	if( numevent != 0 ) {
		FAIL;
		report("%d unexpected %s delivered to client1",
			numevent, (numevent==1)?"event was":"events were");
		report("%sevent was %s", (numevent!=1)?"first ":"",
			eventname(ev.type));
		while(getevent(client1, &ev) != 0)
			report("next event was %s", eventname(ev.type));
	} else
		CHECK;

/* Verify that a correct CirculateRequest event was delievered to client2 using getevent and checkevent. */
	numevent = getevent(client2, &ev);
	if( numevent != 1 ) {
		FAIL;
		report("Expecting a single CirculateRequest event");
		report("Received %d events", numevent);
		if(numevent != 0) {
			report("First event was %s", eventname(ev.type));
			while(getevent(client2, &ev) != 0)
				report("next event was %s", eventname(ev.type));
		}
	} else {
		XCirculateRequestEvent	good;

		good.type = CirculateRequest;
		good.serial = 0;
		good.send_event = False;
		good.display = client2;
		good.parent = parent;
		good.window = two;
		good.place = PlaceOnBottom;
		if ( checkevent((XEvent *)&good, &ev) )
			FAIL;
		else
			CHECK;
	}

/* Verify that no further processing occurred by comparing the window and our reference image. */
	if(!compsavimage(client1, parent, image)) {
		FAIL;
	} else {
		CHECK;
	}
	CHECKPASS(5);
	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

Display	*client1, *client2, *client3;
struct	buildtree	*tree;
Window	parent, zero, one, two;
XEvent	ev;
int	numevent;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XCirculateSubwindowsDown-4.(A)");
	report_assertion("When a child is actually restacked, then a CirculateNotify");
	report_assertion("event is generated.");

	report_strategy("Create client1, client2, and client3, with a window on client1");
	report_strategy("Create a window hierarchy using buildtree.");
	report_strategy("Select StructureNotifyMask events on the window zero on client2.");
	report_strategy("Select SubstructureNotifyMask events on the parent window on client3.");
	report_strategy("Call XCirculateSubwindowsDown in order to lower window zero.");
	report_strategy("Verify that a correct CirculateNotify event was delivered to ");
	report_strategy("	window two on client2 using getevent and checkevent.");
	report_strategy("Verify that a correct CirculateNotify event was delivered to the");
	report_strategy(" 	parent window on client3 using getevent and checkevent.");

	tpstartup();
	setargs();
/* Create client1, client2, and client3, with a window on client1 */
	client1 = opendisplay();
	if (client1 == NULL) {
		delete("could not create client1");
		return;
	}
	else
		CHECK;
	client2 = opendisplay();
	if (client2 == NULL) {
		delete("could not create client2");
		return;
	}
	else
		CHECK;
	client3 = opendisplay();
	if (client3 == NULL) {
		delete("could not create client3");
		return;
	}
	else
		CHECK;
	parent = defwin(client1);

/* Create a window hierarchy using buildtree. */
	tree = buildtree(client1, parent, SimpleTemplate, NSimpleTemplate);
	zero = btntow(tree, "zero"); trace("window zero is %0x", zero);
	one  = btntow(tree, "one");  trace("window one is %0x", one);
	two  = btntow(tree, "two");  trace("window two is %0x", two);

/* Select StructureNotifyMask events on the window zero on client2. */
	XSelectInput(client2, two, StructureNotifyMask);
	XSync(client2, True);

/* Select SubstructureNotifyMask events on the parent window on client3. */
	XSelectInput(client3, parent, SubstructureNotifyMask);
	XSync(client3 , True);

/* Call xname in order to lower window zero. */
	display = client1;
	w = parent;
	startcall(display);
	if (isdeleted())
		return;
	XCirculateSubwindowsDown(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync(client2, False);
	XSync(client3, False);

/* Verify that a correct CirculateNotify event was delivered to  */
/* 	window two on client2 using getevent and checkevent. */
	numevent = getevent(client2, &ev);
	trace("%d events were queued on client2", numevent);
	if (numevent == 0) {
		FAIL;
		report("No event was delivered to client2 when the child windows");
		report("were restacked. Expecting a CirculateNotify event");
	} else {
		XCirculateEvent	good;

		trace("Checking that:");
		trace("display==client2, event==two, window==two,");
		trace("place==PlaceOnBottom");
		good.type = CirculateNotify;
		good.serial = 0;
		good.send_event = False;
		good.display = client2;
		good.event = two;
		good.window = two;
		good.place = PlaceOnBottom;
		if ( checkevent((XEvent *)&good, &ev) )
			FAIL;
		else
			CHECK;
	}

/* Verify that a correct CirculateNotify event was delivered to the */
/* 	parent window on client3 using getevent and checkevent. */
	numevent = getevent(client3, &ev);
	trace("%d events were queued on client3", numevent);
	if (numevent == 0) {
		FAIL;
		report("No event was delivered to client3 when the child windows");
		report("were restacked. Expecting a CirculateNotify event");
	} else {
		XCirculateEvent	good;

		trace("Checking that:");
		trace("display==client3, event==parent, window==two,");
		trace("place==PlaceOnBottom");
		good.type = CirculateNotify;
		good.serial = 0;
		good.send_event = False;
		good.display = client3;
		good.event = parent;
		good.window = two;
		good.place = PlaceOnBottom;
		if ( checkevent((XEvent *)&good, &ev) )
			FAIL;
		else
			CHECK;
	}

	CHECKPASS(5);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EWin.mc */
/* End of included file error/EWin.mc */

/* Including from file error/EWin.mc */
static void t005(){

int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XCirculateSubwindowsDown-5.(A)");
	report_assertion("When a window argument does not name a valid Window, then a");
	report_assertion("BadWindow error occurs.");

	report_strategy("Create a bad window by creating and destroying a window.");
	report_strategy("Call test function using bad window as the window argument.");
	report_strategy("Verify that a BadWindow error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	A_WINDOW = badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	XCirculateSubwindowsDown(display, w);
	endcall(display);
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadWindow)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EWin.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
