/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1993 by the Hewlett-Packard Company.
* 
* Copyright 1990, 1991 UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the names of HP, and UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  HP, and UniSoft
* make no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   XFeedbackState *
 *   XGetFeedbackControl(display, device, num_feedbacks_return)
 *   Display	*display;
 *   XDevice	*device;
 *   int	*num_feedbacks_return;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XGetFeedbackControl	1
char    *TestName = "XGetFeedbackControl";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XGetFeedbackControl function
 */
static Display	*display;
static XDevice	*device;
static int	*num_feedbacks_return;


extern ExtDeviceInfo Devs;
int Nfeed;


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	device = 0;
	num_feedbacks_return = &Nfeed;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int i, j, ndevices;
XDeviceInfoPtr list;
XInputClassInfo *ip;
XFeedbackState *state;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XGetFeedbackControl-1.(B)");
	report_assertion("A call to XGetFeedbackControl returns in Nfeed the number");
	report_assertion("of feedbacks supported by the device.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Call XGetFeedbackControl to get the feedbacks supported by this device.");
	report_strategy("UNTESTED touch test only.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: No input extension key device.\n", TestName);
	    return;
	    }
	list = XListInputDevices (display, &ndevices);
	for (i=0; i<ndevices; i++,list++)
	    if (list->use == IsXExtensionDevice)
		{
		device = XOpenDevice (display, list->id);
		for (j=0, ip=device->classes; j<device->num_classes; j++,ip++)
		    if (ip->input_class == FeedbackClass)
			{
			startcall(display);
			if (isdeleted())
				return;
			state = XGetFeedbackControl(display, device, num_feedbacks_return);
			endcall(display);
			if (geterr() != Success) {
				report("Got %s, Expecting Success", errorname(geterr()));
				FAIL;
			}
			trace("Number of feedbacks reported as %d", Nfeed);
			}
		}

	report("There is no reliable test method, but a touch test was performed");

	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int 	baddevice;
XDevice bogus;
XFeedbackState *state;
int ximajor, first, err;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XGetFeedbackControl-2.(B)");
	report_assertion("A call to XGetFeedbackControl returns a BadDevice error if");
	report_assertion("an invalid device is specified.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Call XGetFeedbackControl to get the feedbacks supported by this device.");
	report_strategy("UNTESTED touch test only.");

	tpstartup();
	setargs();
	if (!XQueryExtension (display, INAME, &ximajor, &first, &err))
	    {
	    untested("%s: Input extension not supported.\n", TestName);
	    return;
	    }

	BadDevice(display,baddevice);
	bogus.device_id = -1;
	device = &bogus;
	startcall(display);
	if (isdeleted())
		return;
	state = XGetFeedbackControl(display, device, num_feedbacks_return);
	endcall(display);
	if (geterr() != baddevice) {
		report("Got %s, Expecting baddevice", errorname(geterr()));
		FAIL;
	}

	if (geterr() == baddevice)
		CHECK;
	else {
		report("No BadDevice for invalid device");
		FAIL;
		}
	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.363460 */
/* End of included file Mdefcode.tmc.363460 */

static void t003(){

XFeedbackState *state;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XGetFeedbackControl-3.(B)");
	report_assertion("A call to XGetFeedbackControl returns a BadMatch error if");
	report_assertion("the device has no feedbacks.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(NFeedMask))
	    {
	    untested("%s: No input extension device without feedbacks.\n", TestName);
	    return;
	    }
	device = Devs.NoFeedback;
	startcall(display);
	if (isdeleted())
		return;
	state = XGetFeedbackControl(display, device, num_feedbacks_return);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadMatch)
		PASS;
	else {
		report("No BadMatch error for device with no feedbacks");
		FAIL;
		}
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.363460 */
/* End of included file Mdefcode.tmc.363460 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
