unsigned char sysbench_histogram_lua[] =
  "-- Copyright (C) 2017 Alexey Kopytov <akopytov@gmail.com>\n"
  "\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; either version 2 of the License, or\n"
  "-- (at your option) any later version.\n"
  "\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "\n"
  "-- ----------------------------------------------------------------------\n"
  "-- Bounded histograms API\n"
  "-- ----------------------------------------------------------------------\n"
  "\n"
  "ffi = require(\"ffi\")\n"
  "\n"
  "sysbench.histogram = {}\n"
  "\n"
  "ffi.cdef[[\n"
  "typedef struct histogram sb_histogram_t;\n"
  "\n"
  "/*\n"
  "  Allocate a new histogram and initialize it with sb_histogram_init().\n"
  "*/\n"
  "sb_histogram_t *sb_histogram_new(size_t size, double range_min,\n"
  "                                 double range_max);\n"
  "\n"
  "/*\n"
  "  Deallocate a histogram allocated with sb_histogram_new().\n"
  "*/\n"
  "void sb_histogram_delete(sb_histogram_t *h);\n"
  "\n"
  "/* Update histogram with a given value. */\n"
  "void sb_histogram_update(sb_histogram_t *h, double value);\n"
  "\n"
  "/*\n"
  "  Print a given histogram to stdout\n"
  "*/\n"
  "void sb_histogram_print(sb_histogram_t *h);\n"
  "]]\n"
  "\n"
  "local histogram = {}\n"
  "\n"
  "function histogram:update(value)\n"
  "   ffi.C.sb_histogram_update(self, value)\n"
  "end\n"
  "\n"
  "function histogram:print()\n"
  "   ffi.C.sb_histogram_print(self)\n"
  "end\n"
  "\n"
  "local histogram_mt = {\n"
  "   __index = histogram,\n"
  "   __tostring = '<sb_histogram>'\n"
  "}\n"
  "ffi.metatype('sb_histogram_t', histogram_mt)\n"
  "\n"
  "function sysbench.histogram.new(size, range_min, range_max)\n"
  "   local h = ffi.C.sb_histogram_new(size, range_min, range_max)\n"
  "\n"
  "   return ffi.gc(h, ffi.C.sb_histogram_delete)\n"
  "end\n"
;
size_t sysbench_histogram_lua_len = sizeof(sysbench_histogram_lua) - 1;
