/* ssh-plugin.c generated by valac 0.56.17, the Vala compiler
 * generated from ssh-plugin.vala, do not modify */

/*
 * Copyright (C) 2011 Antono Vasiljev <self@antono.info>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Antono Vasiljev <self@antono.info>
 *
 */

#include "plugins.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <synapse-core.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define SYNAPSE_SSH_PLUGIN_TYPE_SSH_HOST (synapse_ssh_plugin_ssh_host_get_type ())
#define SYNAPSE_SSH_PLUGIN_SSH_HOST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_SSH_PLUGIN_TYPE_SSH_HOST, SynapseSshPluginSshHost))
#define SYNAPSE_SSH_PLUGIN_SSH_HOST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_SSH_PLUGIN_TYPE_SSH_HOST, SynapseSshPluginSshHostClass))
#define SYNAPSE_SSH_PLUGIN_IS_SSH_HOST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_SSH_PLUGIN_TYPE_SSH_HOST))
#define SYNAPSE_SSH_PLUGIN_IS_SSH_HOST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_SSH_PLUGIN_TYPE_SSH_HOST))
#define SYNAPSE_SSH_PLUGIN_SSH_HOST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_SSH_PLUGIN_TYPE_SSH_HOST, SynapseSshPluginSshHostClass))

typedef struct _SynapseSshPluginSshHost SynapseSshPluginSshHost;
typedef struct _SynapseSshPluginSshHostClass SynapseSshPluginSshHostClass;
enum  {
	SYNAPSE_SSH_PLUGIN_0_PROPERTY,
	SYNAPSE_SSH_PLUGIN_ENABLED_PROPERTY,
	SYNAPSE_SSH_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* synapse_ssh_plugin_properties[SYNAPSE_SSH_PLUGIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SynapseSshPluginParseSshConfigData SynapseSshPluginParseSshConfigData;
typedef struct _SynapseSshPluginSearchData SynapseSshPluginSearchData;
typedef struct _SynapseSshPluginSshHostPrivate SynapseSshPluginSshHostPrivate;
enum  {
	SYNAPSE_SSH_PLUGIN_SSH_HOST_0_PROPERTY,
	SYNAPSE_SSH_PLUGIN_SSH_HOST_HOST_QUERY_PROPERTY,
	SYNAPSE_SSH_PLUGIN_SSH_HOST_NUM_PROPERTIES
};
static GParamSpec* synapse_ssh_plugin_ssh_host_properties[SYNAPSE_SSH_PLUGIN_SSH_HOST_NUM_PROPERTIES];

struct _SynapseSshPluginPrivate {
	gboolean _enabled;
	GeeHashMap* hosts;
};

struct _SynapseSshPluginParseSshConfigData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseSshPlugin* self;
	GeeHashMap* _tmp0_;
	GFileInputStream* _tmp1_;
	GFile* _tmp2_;
	GFileInputStream* _tmp3_;
	GDataInputStream* dis;
	GDataInputStream* _tmp4_;
	GRegex* host_key_re;
	GRegex* _tmp5_;
	GRegex* comment_re;
	GRegex* _tmp6_;
	GRegex* ws_re;
	GRegex* _tmp7_;
	gchar* line;
	gchar* _tmp8_;
	GDataInputStream* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	GRegex* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GRegex* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	GRegex* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	GRegex* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	const gchar* _tmp30_;
	gchar** _tmp31_;
	gchar** _tmp32_;
	gchar** host_collection;
	gint host_collection_length1;
	gint _host_collection_size_;
	gint host_it;
	gchar* _tmp33_;
	gchar* host;
	gchar* host_stripped;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	gboolean _tmp36_;
	gboolean _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	GeeHashMap* _tmp42_;
	const gchar* _tmp43_;
	const gchar* _tmp44_;
	SynapseSshPluginSshHost* _tmp45_;
	SynapseSshPluginSshHost* _tmp46_;
	GError* e;
	GFile* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	GError* _tmp50_;
	const gchar* _tmp51_;
	GError* _inner_error0_;
};

struct _SynapseSshPluginSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseSshPlugin* self;
	SynapseQuery q;
	SynapseResultSet* result;
	SynapseResultSet* results;
	SynapseResultSet* _tmp0_;
	GeeList* matchers;
	SynapseQuery _tmp1_;
	const gchar* _tmp2_;
	GeeList* _tmp3_;
	GeeIterator* _host_it;
	GeeHashMap* _tmp4_;
	GeeCollection* _tmp5_;
	GeeCollection* _tmp6_;
	GeeCollection* _tmp7_;
	GeeIterator* _tmp8_;
	GeeIterator* _tmp9_;
	GeeIterator* _tmp10_;
	SynapseSshPluginSshHost* host;
	GeeIterator* _tmp11_;
	gpointer _tmp12_;
	GeeList* _matcher_list;
	GeeList* _tmp13_;
	gint _matcher_size;
	GeeList* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint _matcher_index;
	gint _tmp17_;
	gint _tmp18_;
	GeeMapEntry* matcher;
	GeeList* _tmp19_;
	gpointer _tmp20_;
	GeeMapEntry* _tmp21_;
	gconstpointer _tmp22_;
	gconstpointer _tmp23_;
	SynapseSshPluginSshHost* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	SynapseResultSet* _tmp27_;
	SynapseSshPluginSshHost* _tmp28_;
	GeeMapEntry* _tmp29_;
	gconstpointer _tmp30_;
	gconstpointer _tmp31_;
	GError* _inner_error0_;
};

struct _SynapseSshPluginSshHost {
	SynapseActionMatch parent_instance;
	SynapseSshPluginSshHostPrivate * priv;
};

struct _SynapseSshPluginSshHostClass {
	SynapseActionMatchClass parent_class;
};

struct _SynapseSshPluginSshHostPrivate {
	gchar* _host_query;
};

static gint SynapseSshPlugin_private_offset;
static gpointer synapse_ssh_plugin_parent_class = NULL;
static gint SynapseSshPluginSshHost_private_offset;
static gpointer synapse_ssh_plugin_ssh_host_parent_class = NULL;
static SynapseActivatableIface * synapse_ssh_plugin_synapse_activatable_parent_iface = NULL;
static SynapseItemProviderIface * synapse_ssh_plugin_synapse_item_provider_parent_iface = NULL;

static GType synapse_ssh_plugin_ssh_host_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void synapse_ssh_plugin_real_activate (SynapseActivatable* base);
static void synapse_ssh_plugin_parse_ssh_config (SynapseSshPlugin* self,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
static void synapse_ssh_plugin_parse_ssh_config_finish (SynapseSshPlugin* self,
                                                 GAsyncResult* _res_);
static void _synapse_ssh_plugin_handle_ssh_config_update_g_file_monitor_changed (GFileMonitor* _sender,
                                                                          GFile* file,
                                                                          GFile* other_file,
                                                                          GFileMonitorEvent event_type,
                                                                          gpointer self);
static void synapse_ssh_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_ssh_plugin_register_plugin (void);
static void _synapse_ssh_plugin_register_plugin_synapse_plugin_register_func (void);
static void synapse_ssh_plugin_parse_ssh_config_data_free (gpointer _data);
static gboolean synapse_ssh_plugin_parse_ssh_config_co (SynapseSshPluginParseSshConfigData* _data_);
static void synapse_ssh_plugin_parse_ssh_config_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static SynapseSshPluginSshHost* synapse_ssh_plugin_ssh_host_new (const gchar* host_name);
static SynapseSshPluginSshHost* synapse_ssh_plugin_ssh_host_construct (GType object_type,
                                                                const gchar* host_name);
static gboolean synapse_ssh_plugin_real_handles_query (SynapseItemProvider* base,
                                                SynapseQuery* query);
static void synapse_ssh_plugin_real_search_data_free (gpointer _data);
static void synapse_ssh_plugin_real_search (SynapseItemProvider* base,
                                     SynapseQuery* q,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
static gboolean synapse_ssh_plugin_real_search_co (SynapseSshPluginSearchData* _data_);
static gboolean _synapse_ssh_plugin_real_search_co_gsource_func (gpointer self);
static const gchar* synapse_ssh_plugin_ssh_host_get_host_query (SynapseSshPluginSshHost* self);
static void synapse_ssh_plugin_ssh_host_real_do_action (SynapseActionMatch* base);
static void synapse_ssh_plugin_ssh_host_set_host_query (SynapseSshPluginSshHost* self,
                                                 const gchar* value);
static void synapse_ssh_plugin_ssh_host_finalize (GObject * obj);
static GType synapse_ssh_plugin_ssh_host_get_type_once (void);
static void _vala_synapse_ssh_plugin_ssh_host_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_synapse_ssh_plugin_ssh_host_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);
static GObject * synapse_ssh_plugin_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static void synapse_ssh_plugin_finalize (GObject * obj);
static GType synapse_ssh_plugin_get_type_once (void);
static void _vala_synapse_ssh_plugin_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_synapse_ssh_plugin_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
synapse_ssh_plugin_get_instance_private (SynapseSshPlugin* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseSshPlugin_private_offset);
}

static void
_synapse_ssh_plugin_handle_ssh_config_update_g_file_monitor_changed (GFileMonitor* _sender,
                                                                     GFile* file,
                                                                     GFile* other_file,
                                                                     GFileMonitorEvent event_type,
                                                                     gpointer self)
{
#line 50 "ssh-plugin.vala"
	synapse_ssh_plugin_handle_ssh_config_update ((SynapseSshPlugin*) self, _sender, file, other_file, event_type);
#line 305 "ssh-plugin.c"
}

static void
synapse_ssh_plugin_real_activate (SynapseActivatable* base)
{
	SynapseSshPlugin * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GFile* _tmp3_;
	GError* _inner_error0_ = NULL;
#line 42 "ssh-plugin.vala"
	self = (SynapseSshPlugin*) base;
#line 44 "ssh-plugin.vala"
	_tmp0_ = g_get_home_dir ();
#line 44 "ssh-plugin.vala"
	_tmp1_ = g_strconcat (_tmp0_, "/.ssh/config", NULL);
#line 44 "ssh-plugin.vala"
	_tmp2_ = _tmp1_;
#line 44 "ssh-plugin.vala"
	_tmp3_ = g_file_new_for_path (_tmp2_);
#line 44 "ssh-plugin.vala"
	_g_object_unref0 (self->config_file);
#line 44 "ssh-plugin.vala"
	self->config_file = _tmp3_;
#line 44 "ssh-plugin.vala"
	_g_free0 (_tmp2_);
#line 46 "ssh-plugin.vala"
	synapse_ssh_plugin_parse_ssh_config (self, NULL, NULL);
#line 335 "ssh-plugin.c"
	{
		GFileMonitor* _tmp4_ = NULL;
		GFile* _tmp5_;
		GFileMonitor* _tmp6_;
		GFileMonitor* _tmp7_;
		GFileMonitor* _tmp8_;
#line 49 "ssh-plugin.vala"
		_tmp5_ = self->config_file;
#line 49 "ssh-plugin.vala"
		_tmp6_ = g_file_monitor_file (_tmp5_, G_FILE_MONITOR_NONE, NULL, &_inner_error0_);
#line 49 "ssh-plugin.vala"
		_tmp4_ = _tmp6_;
#line 49 "ssh-plugin.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 49 "ssh-plugin.vala"
			if (_inner_error0_->domain == G_IO_ERROR) {
#line 352 "ssh-plugin.c"
				goto __catch0_g_io_error;
			}
#line 49 "ssh-plugin.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 49 "ssh-plugin.vala"
			g_clear_error (&_inner_error0_);
#line 49 "ssh-plugin.vala"
			return;
#line 361 "ssh-plugin.c"
		}
#line 49 "ssh-plugin.vala"
		_tmp7_ = _tmp4_;
#line 49 "ssh-plugin.vala"
		_tmp4_ = NULL;
#line 49 "ssh-plugin.vala"
		_g_object_unref0 (self->monitor);
#line 49 "ssh-plugin.vala"
		self->monitor = _tmp7_;
#line 50 "ssh-plugin.vala"
		_tmp8_ = self->monitor;
#line 50 "ssh-plugin.vala"
		g_signal_connect_object (_tmp8_, "changed", (GCallback) _synapse_ssh_plugin_handle_ssh_config_update_g_file_monitor_changed, self, 0);
#line 48 "ssh-plugin.vala"
		_g_object_unref0 (_tmp4_);
#line 377 "ssh-plugin.c"
	}
	goto __finally0;
	__catch0_g_io_error:
	{
#line 48 "ssh-plugin.vala"
		g_clear_error (&_inner_error0_);
#line 54 "ssh-plugin.vala"
		g_warning ("ssh-plugin.vala:54: Failed to start monitoring changes of ssh client c" \
"onfig file");
#line 386 "ssh-plugin.c"
	}
	__finally0:
#line 48 "ssh-plugin.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 48 "ssh-plugin.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 48 "ssh-plugin.vala"
		g_clear_error (&_inner_error0_);
#line 48 "ssh-plugin.vala"
		return;
#line 397 "ssh-plugin.c"
	}
}

static void
synapse_ssh_plugin_real_deactivate (SynapseActivatable* base)
{
	SynapseSshPlugin * self;
#line 58 "ssh-plugin.vala"
	self = (SynapseSshPlugin*) base;
#line 407 "ssh-plugin.c"
}

static void
_synapse_ssh_plugin_register_plugin_synapse_plugin_register_func (void)
{
#line 62 "ssh-plugin.vala"
	synapse_ssh_plugin_register_plugin ();
#line 415 "ssh-plugin.c"
}

static void
synapse_ssh_plugin_register_plugin (void)
{
	SynapsePluginRegistry* _tmp0_;
	SynapsePluginRegistry* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 62 "ssh-plugin.vala"
	_tmp0_ = synapse_plugin_registry_get_default ();
#line 62 "ssh-plugin.vala"
	_tmp1_ = _tmp0_;
#line 62 "ssh-plugin.vala"
	_tmp2_ = g_find_program_in_path ("ssh");
#line 62 "ssh-plugin.vala"
	_tmp3_ = _tmp2_;
#line 62 "ssh-plugin.vala"
	synapse_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_SSH_PLUGIN, "SSH", _ ("Connect to host with SSH"), "terminal", _synapse_ssh_plugin_register_plugin_synapse_plugin_register_func, _tmp3_ != NULL, _ ("ssh is not installed"));
#line 62 "ssh-plugin.vala"
	_g_free0 (_tmp3_);
#line 62 "ssh-plugin.vala"
	_g_object_unref0 (_tmp1_);
#line 439 "ssh-plugin.c"
}

static void
synapse_ssh_plugin_parse_ssh_config_data_free (gpointer _data)
{
	SynapseSshPluginParseSshConfigData* _data_;
	_data_ = _data;
#line 24 "ssh-plugin.vala"
	_g_object_unref0 (_data_->self);
#line 24 "ssh-plugin.vala"
	g_slice_free (SynapseSshPluginParseSshConfigData, _data_);
#line 451 "ssh-plugin.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 24 "ssh-plugin.vala"
	return self ? g_object_ref (self) : NULL;
#line 459 "ssh-plugin.c"
}

static void
synapse_ssh_plugin_parse_ssh_config (SynapseSshPlugin* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	SynapseSshPluginParseSshConfigData* _data_;
	SynapseSshPlugin* _tmp0_;
#line 24 "ssh-plugin.vala"
	g_return_if_fail (self != NULL);
#line 24 "ssh-plugin.vala"
	_data_ = g_slice_new0 (SynapseSshPluginParseSshConfigData);
#line 24 "ssh-plugin.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 24 "ssh-plugin.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_ssh_plugin_parse_ssh_config_data_free);
#line 24 "ssh-plugin.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 24 "ssh-plugin.vala"
	_data_->self = _tmp0_;
#line 24 "ssh-plugin.vala"
	synapse_ssh_plugin_parse_ssh_config_co (_data_);
#line 483 "ssh-plugin.c"
}

static void
synapse_ssh_plugin_parse_ssh_config_finish (SynapseSshPlugin* self,
                                            GAsyncResult* _res_)
{
	SynapseSshPluginParseSshConfigData* _data_;
#line 24 "ssh-plugin.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 493 "ssh-plugin.c"
}

static void
synapse_ssh_plugin_parse_ssh_config_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	SynapseSshPluginParseSshConfigData* _data_;
#line 89 "ssh-plugin.vala"
	_data_ = _user_data_;
#line 89 "ssh-plugin.vala"
	_data_->_source_object_ = source_object;
#line 89 "ssh-plugin.vala"
	_data_->_res_ = _res_;
#line 89 "ssh-plugin.vala"
	synapse_ssh_plugin_parse_ssh_config_co (_data_);
#line 510 "ssh-plugin.c"
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 1413 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1414 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1414 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1415 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1416 "glib-2.0.vapi"
	result = _result_;
#line 1416 "glib-2.0.vapi"
	return result;
#line 531 "ssh-plugin.c"
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
#line 1184 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1184 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 1185 "glib-2.0.vapi"
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
#line 1185 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1187 "glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1187 "glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 555 "ssh-plugin.c"
		gchar* _tmp2_;
#line 1188 "glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1188 "glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1188 "glib-2.0.vapi"
		return result;
#line 563 "ssh-plugin.c"
	} else {
#line 1190 "glib-2.0.vapi"
		result = -1;
#line 1190 "glib-2.0.vapi"
		return result;
#line 569 "ssh-plugin.c"
	}
}

static gboolean
synapse_ssh_plugin_parse_ssh_config_co (SynapseSshPluginParseSshConfigData* _data_)
{
#line 74 "ssh-plugin.vala"
	switch (_data_->_state_) {
#line 74 "ssh-plugin.vala"
		case 0:
#line 580 "ssh-plugin.c"
		goto _state_0;
#line 74 "ssh-plugin.vala"
		case 1:
#line 584 "ssh-plugin.c"
		goto _state_1;
		default:
#line 74 "ssh-plugin.vala"
		g_assert_not_reached ();
#line 589 "ssh-plugin.c"
	}
	_state_0:
#line 76 "ssh-plugin.vala"
	_data_->_tmp0_ = _data_->self->priv->hosts;
#line 76 "ssh-plugin.vala"
	gee_abstract_map_clear ((GeeAbstractMap*) _data_->_tmp0_);
#line 596 "ssh-plugin.c"
	{
#line 80 "ssh-plugin.vala"
		_data_->_tmp2_ = _data_->self->config_file;
#line 80 "ssh-plugin.vala"
		_data_->_tmp3_ = g_file_read (_data_->_tmp2_, NULL, &_data_->_inner_error0_);
#line 80 "ssh-plugin.vala"
		_data_->_tmp1_ = _data_->_tmp3_;
#line 80 "ssh-plugin.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 606 "ssh-plugin.c"
			goto __catch0_g_error;
		}
#line 80 "ssh-plugin.vala"
		_data_->_tmp4_ = g_data_input_stream_new ((GInputStream*) _data_->_tmp1_);
#line 80 "ssh-plugin.vala"
		_data_->dis = _data_->_tmp4_;
#line 83 "ssh-plugin.vala"
		_data_->_tmp5_ = g_regex_new ("(host\\s)", G_REGEX_OPTIMIZE | G_REGEX_CASELESS, 0, &_data_->_inner_error0_);
#line 83 "ssh-plugin.vala"
		_data_->host_key_re = _data_->_tmp5_;
#line 83 "ssh-plugin.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 83 "ssh-plugin.vala"
			_g_object_unref0 (_data_->dis);
#line 83 "ssh-plugin.vala"
			_g_object_unref0 (_data_->_tmp1_);
#line 623 "ssh-plugin.c"
			goto __catch0_g_error;
		}
#line 84 "ssh-plugin.vala"
		_data_->_tmp6_ = g_regex_new ("#.*$", G_REGEX_OPTIMIZE, 0, &_data_->_inner_error0_);
#line 84 "ssh-plugin.vala"
		_data_->comment_re = _data_->_tmp6_;
#line 84 "ssh-plugin.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 84 "ssh-plugin.vala"
			_g_regex_unref0 (_data_->host_key_re);
#line 84 "ssh-plugin.vala"
			_g_object_unref0 (_data_->dis);
#line 84 "ssh-plugin.vala"
			_g_object_unref0 (_data_->_tmp1_);
#line 638 "ssh-plugin.c"
			goto __catch0_g_error;
		}
#line 85 "ssh-plugin.vala"
		_data_->_tmp7_ = g_regex_new ("[\\s]+", G_REGEX_OPTIMIZE, 0, &_data_->_inner_error0_);
#line 85 "ssh-plugin.vala"
		_data_->ws_re = _data_->_tmp7_;
#line 85 "ssh-plugin.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 85 "ssh-plugin.vala"
			_g_regex_unref0 (_data_->comment_re);
#line 85 "ssh-plugin.vala"
			_g_regex_unref0 (_data_->host_key_re);
#line 85 "ssh-plugin.vala"
			_g_object_unref0 (_data_->dis);
#line 85 "ssh-plugin.vala"
			_g_object_unref0 (_data_->_tmp1_);
#line 655 "ssh-plugin.c"
			goto __catch0_g_error;
		}
#line 89 "ssh-plugin.vala"
		while (TRUE) {
#line 89 "ssh-plugin.vala"
			_data_->_tmp9_ = _data_->dis;
#line 89 "ssh-plugin.vala"
			_data_->_state_ = 1;
#line 89 "ssh-plugin.vala"
			g_data_input_stream_read_line_async (_data_->_tmp9_, G_PRIORITY_DEFAULT, NULL, synapse_ssh_plugin_parse_ssh_config_ready, _data_);
#line 89 "ssh-plugin.vala"
			return FALSE;
#line 668 "ssh-plugin.c"
			_state_1:
#line 89 "ssh-plugin.vala"
			_data_->_tmp10_ = g_data_input_stream_read_line_finish (_data_->_tmp9_, _data_->_res_, NULL, &_data_->_inner_error0_);
#line 89 "ssh-plugin.vala"
			_data_->_tmp8_ = _data_->_tmp10_;
#line 89 "ssh-plugin.vala"
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 89 "ssh-plugin.vala"
				_g_free0 (_data_->line);
#line 89 "ssh-plugin.vala"
				_g_regex_unref0 (_data_->ws_re);
#line 89 "ssh-plugin.vala"
				_g_regex_unref0 (_data_->comment_re);
#line 89 "ssh-plugin.vala"
				_g_regex_unref0 (_data_->host_key_re);
#line 89 "ssh-plugin.vala"
				_g_object_unref0 (_data_->dis);
#line 89 "ssh-plugin.vala"
				_g_object_unref0 (_data_->_tmp1_);
#line 688 "ssh-plugin.c"
				goto __catch0_g_error;
			}
#line 89 "ssh-plugin.vala"
			_data_->_tmp11_ = _data_->_tmp8_;
#line 89 "ssh-plugin.vala"
			_data_->_tmp8_ = NULL;
#line 89 "ssh-plugin.vala"
			_g_free0 (_data_->line);
#line 89 "ssh-plugin.vala"
			_data_->line = _data_->_tmp11_;
#line 89 "ssh-plugin.vala"
			_data_->_tmp12_ = _data_->line;
#line 89 "ssh-plugin.vala"
			if (!(_data_->_tmp12_ != NULL)) {
#line 89 "ssh-plugin.vala"
				_g_free0 (_data_->_tmp8_);
#line 89 "ssh-plugin.vala"
				break;
#line 707 "ssh-plugin.c"
			}
#line 92 "ssh-plugin.vala"
			_data_->_tmp14_ = _data_->comment_re;
#line 92 "ssh-plugin.vala"
			_data_->_tmp15_ = _data_->line;
#line 92 "ssh-plugin.vala"
			_data_->_tmp16_ = g_regex_replace (_data_->_tmp14_, _data_->_tmp15_, (gssize) -1, 0, "", 0, &_data_->_inner_error0_);
#line 92 "ssh-plugin.vala"
			_data_->_tmp13_ = _data_->_tmp16_;
#line 92 "ssh-plugin.vala"
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 92 "ssh-plugin.vala"
				_g_free0 (_data_->_tmp8_);
#line 92 "ssh-plugin.vala"
				_g_free0 (_data_->line);
#line 92 "ssh-plugin.vala"
				_g_regex_unref0 (_data_->ws_re);
#line 92 "ssh-plugin.vala"
				_g_regex_unref0 (_data_->comment_re);
#line 92 "ssh-plugin.vala"
				_g_regex_unref0 (_data_->host_key_re);
#line 92 "ssh-plugin.vala"
				_g_object_unref0 (_data_->dis);
#line 92 "ssh-plugin.vala"
				_g_object_unref0 (_data_->_tmp1_);
#line 733 "ssh-plugin.c"
				goto __catch0_g_error;
			}
#line 92 "ssh-plugin.vala"
			_data_->_tmp17_ = _data_->_tmp13_;
#line 92 "ssh-plugin.vala"
			_data_->_tmp13_ = NULL;
#line 92 "ssh-plugin.vala"
			_g_free0 (_data_->line);
#line 92 "ssh-plugin.vala"
			_data_->line = _data_->_tmp17_;
#line 93 "ssh-plugin.vala"
			_data_->_tmp18_ = _data_->host_key_re;
#line 93 "ssh-plugin.vala"
			_data_->_tmp19_ = _data_->line;
#line 93 "ssh-plugin.vala"
			if (g_regex_match (_data_->_tmp18_, _data_->_tmp19_, 0, NULL)) {
#line 96 "ssh-plugin.vala"
				_data_->_tmp21_ = _data_->host_key_re;
#line 96 "ssh-plugin.vala"
				_data_->_tmp22_ = _data_->line;
#line 96 "ssh-plugin.vala"
				_data_->_tmp23_ = g_regex_replace (_data_->_tmp21_, _data_->_tmp22_, (gssize) -1, 0, "", 0, &_data_->_inner_error0_);
#line 96 "ssh-plugin.vala"
				_data_->_tmp20_ = _data_->_tmp23_;
#line 96 "ssh-plugin.vala"
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 96 "ssh-plugin.vala"
					_g_free0 (_data_->_tmp13_);
#line 96 "ssh-plugin.vala"
					_g_free0 (_data_->_tmp8_);
#line 96 "ssh-plugin.vala"
					_g_free0 (_data_->line);
#line 96 "ssh-plugin.vala"
					_g_regex_unref0 (_data_->ws_re);
#line 96 "ssh-plugin.vala"
					_g_regex_unref0 (_data_->comment_re);
#line 96 "ssh-plugin.vala"
					_g_regex_unref0 (_data_->host_key_re);
#line 96 "ssh-plugin.vala"
					_g_object_unref0 (_data_->dis);
#line 96 "ssh-plugin.vala"
					_g_object_unref0 (_data_->_tmp1_);
#line 776 "ssh-plugin.c"
					goto __catch0_g_error;
				}
#line 96 "ssh-plugin.vala"
				_data_->_tmp24_ = _data_->_tmp20_;
#line 96 "ssh-plugin.vala"
				_data_->_tmp20_ = NULL;
#line 96 "ssh-plugin.vala"
				_g_free0 (_data_->line);
#line 96 "ssh-plugin.vala"
				_data_->line = _data_->_tmp24_;
#line 98 "ssh-plugin.vala"
				_data_->_tmp26_ = _data_->ws_re;
#line 98 "ssh-plugin.vala"
				_data_->_tmp27_ = _data_->line;
#line 98 "ssh-plugin.vala"
				_data_->_tmp28_ = g_regex_replace (_data_->_tmp26_, _data_->_tmp27_, (gssize) -1, 0, " ", 0, &_data_->_inner_error0_);
#line 98 "ssh-plugin.vala"
				_data_->_tmp25_ = _data_->_tmp28_;
#line 98 "ssh-plugin.vala"
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 98 "ssh-plugin.vala"
					_g_free0 (_data_->_tmp20_);
#line 98 "ssh-plugin.vala"
					_g_free0 (_data_->_tmp13_);
#line 98 "ssh-plugin.vala"
					_g_free0 (_data_->_tmp8_);
#line 98 "ssh-plugin.vala"
					_g_free0 (_data_->line);
#line 98 "ssh-plugin.vala"
					_g_regex_unref0 (_data_->ws_re);
#line 98 "ssh-plugin.vala"
					_g_regex_unref0 (_data_->comment_re);
#line 98 "ssh-plugin.vala"
					_g_regex_unref0 (_data_->host_key_re);
#line 98 "ssh-plugin.vala"
					_g_object_unref0 (_data_->dis);
#line 98 "ssh-plugin.vala"
					_g_object_unref0 (_data_->_tmp1_);
#line 815 "ssh-plugin.c"
					goto __catch0_g_error;
				}
#line 98 "ssh-plugin.vala"
				_data_->_tmp29_ = string_strip (_data_->_tmp25_);
#line 98 "ssh-plugin.vala"
				_g_free0 (_data_->line);
#line 98 "ssh-plugin.vala"
				_data_->line = _data_->_tmp29_;
#line 100 "ssh-plugin.vala"
				_data_->_tmp30_ = _data_->line;
#line 100 "ssh-plugin.vala"
				_data_->_tmp32_ = _data_->_tmp31_ = g_strsplit (_data_->_tmp30_, " ", 0);
#line 828 "ssh-plugin.c"
				{
#line 100 "ssh-plugin.vala"
					_data_->host_collection_length1 = 0;
#line 100 "ssh-plugin.vala"
					_data_->_host_collection_size_ = 0;
#line 100 "ssh-plugin.vala"
					_data_->host_collection = _data_->_tmp32_;
#line 100 "ssh-plugin.vala"
					_data_->host_collection_length1 = _vala_array_length (_data_->_tmp31_);
#line 100 "ssh-plugin.vala"
					for (_data_->host_it = 0; _data_->host_it < _data_->host_collection_length1; _data_->host_it = _data_->host_it + 1) {
#line 100 "ssh-plugin.vala"
						_data_->_tmp33_ = g_strdup (_data_->host_collection[_data_->host_it]);
#line 100 "ssh-plugin.vala"
						_data_->host = _data_->_tmp33_;
#line 844 "ssh-plugin.c"
						{
#line 102 "ssh-plugin.vala"
							_data_->_tmp34_ = _data_->host;
#line 102 "ssh-plugin.vala"
							_data_->_tmp35_ = string_strip (_data_->_tmp34_);
#line 102 "ssh-plugin.vala"
							_data_->host_stripped = _data_->_tmp35_;
#line 103 "ssh-plugin.vala"
							_data_->_tmp38_ = _data_->host_stripped;
#line 103 "ssh-plugin.vala"
							if (g_strcmp0 (_data_->_tmp38_, "") != 0) {
#line 103 "ssh-plugin.vala"
								_data_->_tmp39_ = _data_->host_stripped;
#line 103 "ssh-plugin.vala"
								_data_->_tmp37_ = string_index_of (_data_->_tmp39_, "*", 0) == -1;
#line 860 "ssh-plugin.c"
							} else {
#line 103 "ssh-plugin.vala"
								_data_->_tmp37_ = FALSE;
#line 864 "ssh-plugin.c"
							}
#line 103 "ssh-plugin.vala"
							if (_data_->_tmp37_) {
#line 103 "ssh-plugin.vala"
								_data_->_tmp40_ = _data_->host_stripped;
#line 103 "ssh-plugin.vala"
								_data_->_tmp36_ = string_index_of (_data_->_tmp40_, "?", 0) == -1;
#line 872 "ssh-plugin.c"
							} else {
#line 103 "ssh-plugin.vala"
								_data_->_tmp36_ = FALSE;
#line 876 "ssh-plugin.c"
							}
#line 103 "ssh-plugin.vala"
							if (_data_->_tmp36_) {
#line 105 "ssh-plugin.vala"
								_data_->_tmp41_ = _data_->host_stripped;
#line 105 "ssh-plugin.vala"
								g_debug ("ssh-plugin.vala:105: host added: %s\n", _data_->_tmp41_);
#line 106 "ssh-plugin.vala"
								_data_->_tmp42_ = _data_->self->priv->hosts;
#line 106 "ssh-plugin.vala"
								_data_->_tmp43_ = _data_->host_stripped;
#line 106 "ssh-plugin.vala"
								_data_->_tmp44_ = _data_->host_stripped;
#line 106 "ssh-plugin.vala"
								_data_->_tmp45_ = synapse_ssh_plugin_ssh_host_new (_data_->_tmp44_);
#line 106 "ssh-plugin.vala"
								_data_->_tmp46_ = _data_->_tmp45_;
#line 106 "ssh-plugin.vala"
								gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp42_, _data_->_tmp43_, _data_->_tmp46_);
#line 106 "ssh-plugin.vala"
								_g_object_unref0 (_data_->_tmp46_);
#line 898 "ssh-plugin.c"
							}
#line 100 "ssh-plugin.vala"
							_g_free0 (_data_->host_stripped);
#line 100 "ssh-plugin.vala"
							_g_free0 (_data_->host);
#line 904 "ssh-plugin.c"
						}
					}
#line 100 "ssh-plugin.vala"
					_data_->host_collection = (_vala_array_free (_data_->host_collection, _data_->host_collection_length1, (GDestroyNotify) g_free), NULL);
#line 909 "ssh-plugin.c"
				}
#line 93 "ssh-plugin.vala"
				_g_free0 (_data_->_tmp25_);
#line 93 "ssh-plugin.vala"
				_g_free0 (_data_->_tmp20_);
#line 915 "ssh-plugin.c"
			}
#line 89 "ssh-plugin.vala"
			_g_free0 (_data_->_tmp13_);
#line 89 "ssh-plugin.vala"
			_g_free0 (_data_->_tmp8_);
#line 921 "ssh-plugin.c"
		}
#line 78 "ssh-plugin.vala"
		_g_free0 (_data_->line);
#line 78 "ssh-plugin.vala"
		_g_regex_unref0 (_data_->ws_re);
#line 78 "ssh-plugin.vala"
		_g_regex_unref0 (_data_->comment_re);
#line 78 "ssh-plugin.vala"
		_g_regex_unref0 (_data_->host_key_re);
#line 78 "ssh-plugin.vala"
		_g_object_unref0 (_data_->dis);
#line 78 "ssh-plugin.vala"
		_g_object_unref0 (_data_->_tmp1_);
#line 935 "ssh-plugin.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 78 "ssh-plugin.vala"
		_data_->e = _data_->_inner_error0_;
#line 78 "ssh-plugin.vala"
		_data_->_inner_error0_ = NULL;
#line 114 "ssh-plugin.vala"
		_data_->_tmp47_ = _data_->self->config_file;
#line 114 "ssh-plugin.vala"
		_data_->_tmp48_ = g_file_get_path (_data_->_tmp47_);
#line 114 "ssh-plugin.vala"
		_data_->_tmp49_ = _data_->_tmp48_;
#line 114 "ssh-plugin.vala"
		_data_->_tmp50_ = _data_->e;
#line 114 "ssh-plugin.vala"
		_data_->_tmp51_ = _data_->_tmp50_->message;
#line 114 "ssh-plugin.vala"
		g_warning ("ssh-plugin.vala:114: %s: %s", _data_->_tmp49_, _data_->_tmp51_);
#line 114 "ssh-plugin.vala"
		_g_free0 (_data_->_tmp49_);
#line 78 "ssh-plugin.vala"
		_g_error_free0 (_data_->e);
#line 960 "ssh-plugin.c"
	}
	__finally0:
#line 78 "ssh-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 78 "ssh-plugin.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 78 "ssh-plugin.vala"
		g_clear_error (&_data_->_inner_error0_);
#line 78 "ssh-plugin.vala"
		g_object_unref (_data_->_async_result);
#line 78 "ssh-plugin.vala"
		return FALSE;
#line 973 "ssh-plugin.c"
	}
#line 74 "ssh-plugin.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 74 "ssh-plugin.vala"
	if (_data_->_state_ != 0) {
#line 74 "ssh-plugin.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 74 "ssh-plugin.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 983 "ssh-plugin.c"
		}
	}
#line 74 "ssh-plugin.vala"
	g_object_unref (_data_->_async_result);
#line 74 "ssh-plugin.vala"
	return FALSE;
#line 990 "ssh-plugin.c"
}

void
synapse_ssh_plugin_handle_ssh_config_update (SynapseSshPlugin* self,
                                             GFileMonitor* monitor,
                                             GFile* file,
                                             GFile* other_file,
                                             GFileMonitorEvent event_type)
{
#line 118 "ssh-plugin.vala"
	g_return_if_fail (self != NULL);
#line 118 "ssh-plugin.vala"
	g_return_if_fail (monitor != NULL);
#line 118 "ssh-plugin.vala"
	g_return_if_fail (file != NULL);
#line 123 "ssh-plugin.vala"
	if (event_type == G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT) {
#line 125 "ssh-plugin.vala"
		g_message ("ssh-plugin.vala:125: ssh_config is changed, reparsing");
#line 126 "ssh-plugin.vala"
		synapse_ssh_plugin_parse_ssh_config (self, NULL, NULL);
#line 1012 "ssh-plugin.c"
	}
}

static gboolean
synapse_ssh_plugin_real_handles_query (SynapseItemProvider* base,
                                       SynapseQuery* query)
{
	SynapseSshPlugin * self;
	gboolean _tmp0_ = FALSE;
	GeeHashMap* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gboolean result;
#line 130 "ssh-plugin.vala"
	self = (SynapseSshPlugin*) base;
#line 130 "ssh-plugin.vala"
	g_return_val_if_fail (query != NULL, FALSE);
#line 132 "ssh-plugin.vala"
	_tmp1_ = self->priv->hosts;
#line 132 "ssh-plugin.vala"
	_tmp2_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp1_);
#line 132 "ssh-plugin.vala"
	_tmp3_ = _tmp2_;
#line 132 "ssh-plugin.vala"
	if (_tmp3_ > 0) {
#line 1038 "ssh-plugin.c"
		gboolean _tmp4_ = FALSE;
		SynapseQuery _tmp5_;
#line 133 "ssh-plugin.vala"
		_tmp5_ = *query;
#line 133 "ssh-plugin.vala"
		if ((_tmp5_.query_type & SYNAPSE_QUERY_FLAGS_ACTIONS) == SYNAPSE_QUERY_FLAGS_ACTIONS) {
#line 133 "ssh-plugin.vala"
			_tmp4_ = TRUE;
#line 1047 "ssh-plugin.c"
		} else {
			SynapseQuery _tmp6_;
#line 134 "ssh-plugin.vala"
			_tmp6_ = *query;
#line 134 "ssh-plugin.vala"
			_tmp4_ = (_tmp6_.query_type & SYNAPSE_QUERY_FLAGS_INTERNET) == SYNAPSE_QUERY_FLAGS_INTERNET;
#line 1054 "ssh-plugin.c"
		}
#line 133 "ssh-plugin.vala"
		_tmp0_ = _tmp4_;
#line 1058 "ssh-plugin.c"
	} else {
#line 132 "ssh-plugin.vala"
		_tmp0_ = FALSE;
#line 1062 "ssh-plugin.c"
	}
#line 132 "ssh-plugin.vala"
	result = _tmp0_;
#line 132 "ssh-plugin.vala"
	return result;
#line 1068 "ssh-plugin.c"
}

static void
synapse_ssh_plugin_real_search_data_free (gpointer _data)
{
	SynapseSshPluginSearchData* _data_;
	_data_ = _data;
#line 24 "ssh-plugin.vala"
	synapse_query_destroy (&_data_->q);
#line 24 "ssh-plugin.vala"
	_g_object_unref0 (_data_->result);
#line 24 "ssh-plugin.vala"
	_g_object_unref0 (_data_->self);
#line 24 "ssh-plugin.vala"
	g_slice_free (SynapseSshPluginSearchData, _data_);
#line 1084 "ssh-plugin.c"
}

static void
synapse_ssh_plugin_real_search (SynapseItemProvider* base,
                                SynapseQuery* q,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	SynapseSshPlugin * self;
	SynapseSshPluginSearchData* _data_;
	SynapseSshPlugin* _tmp0_;
	SynapseQuery _tmp1_;
	SynapseQuery _tmp2_;
	SynapseQuery _tmp3_ = {0};
#line 24 "ssh-plugin.vala"
	g_return_if_fail (q != NULL);
#line 24 "ssh-plugin.vala"
	self = (SynapseSshPlugin*) base;
#line 24 "ssh-plugin.vala"
	_data_ = g_slice_new0 (SynapseSshPluginSearchData);
#line 24 "ssh-plugin.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 24 "ssh-plugin.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_ssh_plugin_real_search_data_free);
#line 24 "ssh-plugin.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 24 "ssh-plugin.vala"
	_data_->self = _tmp0_;
#line 24 "ssh-plugin.vala"
	_tmp1_ = *q;
#line 24 "ssh-plugin.vala"
	_tmp2_ = _tmp1_;
#line 24 "ssh-plugin.vala"
	synapse_query_copy (&_tmp2_, &_tmp3_);
#line 24 "ssh-plugin.vala"
	synapse_query_destroy (&_data_->q);
#line 24 "ssh-plugin.vala"
	_data_->q = _tmp3_;
#line 24 "ssh-plugin.vala"
	synapse_ssh_plugin_real_search_co (_data_);
#line 1125 "ssh-plugin.c"
}

static SynapseResultSet*
synapse_ssh_plugin_search_finish (SynapseItemProvider* base,
                                  GAsyncResult* _res_,
                                  GError** error)
{
	SynapseResultSet* result;
	SynapseSshPluginSearchData* _data_;
#line 24 "ssh-plugin.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 24 "ssh-plugin.vala"
	if (NULL == _data_) {
#line 24 "ssh-plugin.vala"
		return NULL;
#line 1141 "ssh-plugin.c"
	}
#line 24 "ssh-plugin.vala"
	result = _data_->result;
#line 24 "ssh-plugin.vala"
	_data_->result = NULL;
#line 24 "ssh-plugin.vala"
	return result;
#line 1149 "ssh-plugin.c"
}

static gboolean
_synapse_ssh_plugin_real_search_co_gsource_func (gpointer self)
{
	gboolean result;
	result = synapse_ssh_plugin_real_search_co (self);
#line 139 "ssh-plugin.vala"
	return result;
#line 1159 "ssh-plugin.c"
}

static gboolean
synapse_ssh_plugin_real_search_co (SynapseSshPluginSearchData* _data_)
{
#line 137 "ssh-plugin.vala"
	switch (_data_->_state_) {
#line 137 "ssh-plugin.vala"
		case 0:
#line 1169 "ssh-plugin.c"
		goto _state_0;
#line 137 "ssh-plugin.vala"
		case 1:
#line 1173 "ssh-plugin.c"
		goto _state_1;
		default:
#line 137 "ssh-plugin.vala"
		g_assert_not_reached ();
#line 1178 "ssh-plugin.c"
	}
	_state_0:
#line 139 "ssh-plugin.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _synapse_ssh_plugin_real_search_co_gsource_func, _data_, NULL);
#line 140 "ssh-plugin.vala"
	_data_->_state_ = 1;
#line 140 "ssh-plugin.vala"
	return FALSE;
#line 1187 "ssh-plugin.c"
	_state_1:
	;
#line 141 "ssh-plugin.vala"
	synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
#line 141 "ssh-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 141 "ssh-plugin.vala"
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 141 "ssh-plugin.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 141 "ssh-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 141 "ssh-plugin.vala"
			return FALSE;
#line 1202 "ssh-plugin.c"
		} else {
#line 141 "ssh-plugin.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 141 "ssh-plugin.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 141 "ssh-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 141 "ssh-plugin.vala"
			return FALSE;
#line 1212 "ssh-plugin.c"
		}
	}
#line 143 "ssh-plugin.vala"
	_data_->_tmp0_ = synapse_result_set_new ();
#line 143 "ssh-plugin.vala"
	_data_->results = _data_->_tmp0_;
#line 145 "ssh-plugin.vala"
	_data_->_tmp1_ = _data_->q;
#line 145 "ssh-plugin.vala"
	_data_->_tmp2_ = _data_->_tmp1_.query_string;
#line 145 "ssh-plugin.vala"
	_data_->_tmp3_ = synapse_query_get_matchers_for_query (_data_->_tmp2_, 0, G_REGEX_OPTIMIZE | G_REGEX_CASELESS);
#line 145 "ssh-plugin.vala"
	_data_->matchers = _data_->_tmp3_;
#line 1227 "ssh-plugin.c"
	{
#line 148 "ssh-plugin.vala"
		_data_->_tmp4_ = _data_->self->priv->hosts;
#line 148 "ssh-plugin.vala"
		_data_->_tmp5_ = gee_abstract_map_get_values ((GeeAbstractMap*) _data_->_tmp4_);
#line 148 "ssh-plugin.vala"
		_data_->_tmp6_ = _data_->_tmp5_;
#line 148 "ssh-plugin.vala"
		_data_->_tmp7_ = _data_->_tmp6_;
#line 148 "ssh-plugin.vala"
		_data_->_tmp8_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp7_);
#line 148 "ssh-plugin.vala"
		_data_->_tmp9_ = _data_->_tmp8_;
#line 148 "ssh-plugin.vala"
		_g_object_unref0 (_data_->_tmp7_);
#line 148 "ssh-plugin.vala"
		_data_->_host_it = _data_->_tmp9_;
#line 148 "ssh-plugin.vala"
		while (TRUE) {
#line 148 "ssh-plugin.vala"
			_data_->_tmp10_ = _data_->_host_it;
#line 148 "ssh-plugin.vala"
			if (!gee_iterator_next (_data_->_tmp10_)) {
#line 148 "ssh-plugin.vala"
				break;
#line 1253 "ssh-plugin.c"
			}
#line 148 "ssh-plugin.vala"
			_data_->_tmp11_ = _data_->_host_it;
#line 148 "ssh-plugin.vala"
			_data_->_tmp12_ = gee_iterator_get (_data_->_tmp11_);
#line 148 "ssh-plugin.vala"
			_data_->host = (SynapseSshPluginSshHost*) _data_->_tmp12_;
#line 1261 "ssh-plugin.c"
			{
#line 150 "ssh-plugin.vala"
				_data_->_tmp13_ = _data_->matchers;
#line 150 "ssh-plugin.vala"
				_data_->_matcher_list = _data_->_tmp13_;
#line 150 "ssh-plugin.vala"
				_data_->_tmp14_ = _data_->_matcher_list;
#line 150 "ssh-plugin.vala"
				_data_->_tmp15_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp14_);
#line 150 "ssh-plugin.vala"
				_data_->_tmp16_ = _data_->_tmp15_;
#line 150 "ssh-plugin.vala"
				_data_->_matcher_size = _data_->_tmp16_;
#line 150 "ssh-plugin.vala"
				_data_->_matcher_index = -1;
#line 150 "ssh-plugin.vala"
				while (TRUE) {
#line 150 "ssh-plugin.vala"
					_data_->_matcher_index = _data_->_matcher_index + 1;
#line 150 "ssh-plugin.vala"
					_data_->_tmp17_ = _data_->_matcher_index;
#line 150 "ssh-plugin.vala"
					_data_->_tmp18_ = _data_->_matcher_size;
#line 150 "ssh-plugin.vala"
					if (!(_data_->_tmp17_ < _data_->_tmp18_)) {
#line 150 "ssh-plugin.vala"
						break;
#line 1289 "ssh-plugin.c"
					}
#line 150 "ssh-plugin.vala"
					_data_->_tmp19_ = _data_->_matcher_list;
#line 150 "ssh-plugin.vala"
					_data_->_tmp20_ = gee_list_get (_data_->_tmp19_, _data_->_matcher_index);
#line 150 "ssh-plugin.vala"
					_data_->matcher = (GeeMapEntry*) _data_->_tmp20_;
#line 152 "ssh-plugin.vala"
					_data_->_tmp21_ = _data_->matcher;
#line 152 "ssh-plugin.vala"
					_data_->_tmp22_ = gee_map_entry_get_key (_data_->_tmp21_);
#line 152 "ssh-plugin.vala"
					_data_->_tmp23_ = _data_->_tmp22_;
#line 152 "ssh-plugin.vala"
					_data_->_tmp24_ = _data_->host;
#line 152 "ssh-plugin.vala"
					_data_->_tmp25_ = synapse_ssh_plugin_ssh_host_get_host_query (_data_->_tmp24_);
#line 152 "ssh-plugin.vala"
					_data_->_tmp26_ = _data_->_tmp25_;
#line 152 "ssh-plugin.vala"
					if (g_regex_match ((GRegex*) _data_->_tmp23_, _data_->_tmp26_, 0, NULL)) {
#line 154 "ssh-plugin.vala"
						_data_->_tmp27_ = _data_->results;
#line 154 "ssh-plugin.vala"
						_data_->_tmp28_ = _data_->host;
#line 154 "ssh-plugin.vala"
						_data_->_tmp29_ = _data_->matcher;
#line 154 "ssh-plugin.vala"
						_data_->_tmp30_ = gee_map_entry_get_value (_data_->_tmp29_);
#line 154 "ssh-plugin.vala"
						_data_->_tmp31_ = _data_->_tmp30_;
#line 154 "ssh-plugin.vala"
						synapse_result_set_add (_data_->_tmp27_, (SynapseMatch*) _data_->_tmp28_, ((gint) ((gintptr) _data_->_tmp31_)) - SYNAPSE_MATCH_SCORE_INCREMENT_SMALL);
#line 155 "ssh-plugin.vala"
						_g_object_unref0 (_data_->matcher);
#line 155 "ssh-plugin.vala"
						break;
#line 1327 "ssh-plugin.c"
					}
#line 150 "ssh-plugin.vala"
					_g_object_unref0 (_data_->matcher);
#line 1331 "ssh-plugin.c"
				}
			}
#line 148 "ssh-plugin.vala"
			_g_object_unref0 (_data_->host);
#line 1336 "ssh-plugin.c"
		}
#line 148 "ssh-plugin.vala"
		_g_object_unref0 (_data_->_host_it);
#line 1340 "ssh-plugin.c"
	}
#line 160 "ssh-plugin.vala"
	synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
#line 160 "ssh-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 160 "ssh-plugin.vala"
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 160 "ssh-plugin.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 160 "ssh-plugin.vala"
			_g_object_unref0 (_data_->matchers);
#line 160 "ssh-plugin.vala"
			_g_object_unref0 (_data_->results);
#line 160 "ssh-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 160 "ssh-plugin.vala"
			return FALSE;
#line 1358 "ssh-plugin.c"
		} else {
#line 160 "ssh-plugin.vala"
			_g_object_unref0 (_data_->matchers);
#line 160 "ssh-plugin.vala"
			_g_object_unref0 (_data_->results);
#line 160 "ssh-plugin.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 160 "ssh-plugin.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 160 "ssh-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 160 "ssh-plugin.vala"
			return FALSE;
#line 1372 "ssh-plugin.c"
		}
	}
#line 162 "ssh-plugin.vala"
	_data_->result = _data_->results;
#line 162 "ssh-plugin.vala"
	_g_object_unref0 (_data_->matchers);
#line 162 "ssh-plugin.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 162 "ssh-plugin.vala"
	if (_data_->_state_ != 0) {
#line 162 "ssh-plugin.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 162 "ssh-plugin.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1387 "ssh-plugin.c"
		}
	}
#line 162 "ssh-plugin.vala"
	g_object_unref (_data_->_async_result);
#line 162 "ssh-plugin.vala"
	return FALSE;
#line 1394 "ssh-plugin.c"
}

SynapseSshPlugin*
synapse_ssh_plugin_construct (GType object_type)
{
	SynapseSshPlugin * self = NULL;
#line 24 "ssh-plugin.vala"
	self = (SynapseSshPlugin*) g_object_new (object_type, NULL);
#line 24 "ssh-plugin.vala"
	return self;
#line 1405 "ssh-plugin.c"
}

SynapseSshPlugin*
synapse_ssh_plugin_new (void)
{
#line 24 "ssh-plugin.vala"
	return synapse_ssh_plugin_construct (SYNAPSE_TYPE_SSH_PLUGIN);
#line 1413 "ssh-plugin.c"
}

static gboolean
synapse_ssh_plugin_real_get_enabled (SynapseActivatable* base)
{
	gboolean result;
	SynapseSshPlugin* self;
#line 26 "ssh-plugin.vala"
	self = (SynapseSshPlugin*) base;
#line 26 "ssh-plugin.vala"
	result = self->priv->_enabled;
#line 26 "ssh-plugin.vala"
	return result;
#line 1427 "ssh-plugin.c"
}

static void
synapse_ssh_plugin_real_set_enabled (SynapseActivatable* base,
                                     gboolean value)
{
	SynapseSshPlugin* self;
	gboolean old_value;
#line 26 "ssh-plugin.vala"
	self = (SynapseSshPlugin*) base;
#line 26 "ssh-plugin.vala"
	old_value = synapse_ssh_plugin_real_get_enabled (base);
#line 26 "ssh-plugin.vala"
	if (old_value != value) {
#line 26 "ssh-plugin.vala"
		self->priv->_enabled = value;
#line 26 "ssh-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_ssh_plugin_properties[SYNAPSE_SSH_PLUGIN_ENABLED_PROPERTY]);
#line 1446 "ssh-plugin.c"
	}
}

static inline gpointer
synapse_ssh_plugin_ssh_host_get_instance_private (SynapseSshPluginSshHost* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseSshPluginSshHost_private_offset);
}

static void
synapse_ssh_plugin_ssh_host_real_do_action (SynapseActionMatch* base)
{
	SynapseSshPluginSshHost * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 169 "ssh-plugin.vala"
	self = (SynapseSshPluginSshHost*) base;
#line 171 "ssh-plugin.vala"
	_tmp0_ = synapse_match_get_title ((SynapseMatch*) self);
#line 171 "ssh-plugin.vala"
	_tmp1_ = _tmp0_;
#line 171 "ssh-plugin.vala"
	_tmp2_ = g_strdup_printf ("ssh %s", _tmp1_);
#line 171 "ssh-plugin.vala"
	_tmp3_ = _tmp2_;
#line 171 "ssh-plugin.vala"
	synapse_utils_open_command_line (_tmp3_, NULL, TRUE);
#line 171 "ssh-plugin.vala"
	_g_free0 (_tmp3_);
#line 1478 "ssh-plugin.c"
}

static SynapseSshPluginSshHost*
synapse_ssh_plugin_ssh_host_construct (GType object_type,
                                       const gchar* host_name)
{
	SynapseSshPluginSshHost * self = NULL;
#line 174 "ssh-plugin.vala"
	g_return_val_if_fail (host_name != NULL, NULL);
#line 176 "ssh-plugin.vala"
	self = (SynapseSshPluginSshHost*) g_object_new (object_type, "title", host_name, "description", _ ("Connect with SSH"), "has-thumbnail", FALSE, "icon-name", "terminal", "host-query", host_name, NULL);
#line 174 "ssh-plugin.vala"
	return self;
#line 1492 "ssh-plugin.c"
}

static SynapseSshPluginSshHost*
synapse_ssh_plugin_ssh_host_new (const gchar* host_name)
{
#line 174 "ssh-plugin.vala"
	return synapse_ssh_plugin_ssh_host_construct (SYNAPSE_SSH_PLUGIN_TYPE_SSH_HOST, host_name);
#line 1500 "ssh-plugin.c"
}

static const gchar*
synapse_ssh_plugin_ssh_host_get_host_query (SynapseSshPluginSshHost* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 167 "ssh-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 167 "ssh-plugin.vala"
	_tmp0_ = self->priv->_host_query;
#line 167 "ssh-plugin.vala"
	result = _tmp0_;
#line 167 "ssh-plugin.vala"
	return result;
#line 1516 "ssh-plugin.c"
}

static void
synapse_ssh_plugin_ssh_host_set_host_query (SynapseSshPluginSshHost* self,
                                            const gchar* value)
{
	gchar* old_value;
#line 167 "ssh-plugin.vala"
	g_return_if_fail (self != NULL);
#line 167 "ssh-plugin.vala"
	old_value = synapse_ssh_plugin_ssh_host_get_host_query (self);
#line 167 "ssh-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1530 "ssh-plugin.c"
		gchar* _tmp0_;
#line 167 "ssh-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 167 "ssh-plugin.vala"
		_g_free0 (self->priv->_host_query);
#line 167 "ssh-plugin.vala"
		self->priv->_host_query = _tmp0_;
#line 167 "ssh-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_ssh_plugin_ssh_host_properties[SYNAPSE_SSH_PLUGIN_SSH_HOST_HOST_QUERY_PROPERTY]);
#line 1540 "ssh-plugin.c"
	}
}

static void
synapse_ssh_plugin_ssh_host_class_init (SynapseSshPluginSshHostClass * klass,
                                        gpointer klass_data)
{
#line 165 "ssh-plugin.vala"
	synapse_ssh_plugin_ssh_host_parent_class = g_type_class_peek_parent (klass);
#line 165 "ssh-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseSshPluginSshHost_private_offset);
#line 165 "ssh-plugin.vala"
	((SynapseActionMatchClass *) klass)->do_action = (void (*) (SynapseActionMatch*)) synapse_ssh_plugin_ssh_host_real_do_action;
#line 165 "ssh-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_ssh_plugin_ssh_host_get_property;
#line 165 "ssh-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_ssh_plugin_ssh_host_set_property;
#line 165 "ssh-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_ssh_plugin_ssh_host_finalize;
#line 165 "ssh-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_SSH_PLUGIN_SSH_HOST_HOST_QUERY_PROPERTY, synapse_ssh_plugin_ssh_host_properties[SYNAPSE_SSH_PLUGIN_SSH_HOST_HOST_QUERY_PROPERTY] = g_param_spec_string ("host-query", "host-query", "host-query", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 1562 "ssh-plugin.c"
}

static void
synapse_ssh_plugin_ssh_host_instance_init (SynapseSshPluginSshHost * self,
                                           gpointer klass)
{
#line 165 "ssh-plugin.vala"
	self->priv = synapse_ssh_plugin_ssh_host_get_instance_private (self);
#line 1571 "ssh-plugin.c"
}

static void
synapse_ssh_plugin_ssh_host_finalize (GObject * obj)
{
	SynapseSshPluginSshHost * self;
#line 165 "ssh-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_SSH_PLUGIN_TYPE_SSH_HOST, SynapseSshPluginSshHost);
#line 167 "ssh-plugin.vala"
	_g_free0 (self->priv->_host_query);
#line 165 "ssh-plugin.vala"
	G_OBJECT_CLASS (synapse_ssh_plugin_ssh_host_parent_class)->finalize (obj);
#line 1584 "ssh-plugin.c"
}

static GType
synapse_ssh_plugin_ssh_host_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseSshPluginSshHostClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_ssh_plugin_ssh_host_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseSshPluginSshHost), 0, (GInstanceInitFunc) synapse_ssh_plugin_ssh_host_instance_init, NULL };
	GType synapse_ssh_plugin_ssh_host_type_id;
	synapse_ssh_plugin_ssh_host_type_id = g_type_register_static (SYNAPSE_TYPE_ACTION_MATCH, "SynapseSshPluginSshHost", &g_define_type_info, 0);
	SynapseSshPluginSshHost_private_offset = g_type_add_instance_private (synapse_ssh_plugin_ssh_host_type_id, sizeof (SynapseSshPluginSshHostPrivate));
	return synapse_ssh_plugin_ssh_host_type_id;
}

static GType
synapse_ssh_plugin_ssh_host_get_type (void)
{
	static volatile gsize synapse_ssh_plugin_ssh_host_type_id__once = 0;
	if (g_once_init_enter (&synapse_ssh_plugin_ssh_host_type_id__once)) {
		GType synapse_ssh_plugin_ssh_host_type_id;
		synapse_ssh_plugin_ssh_host_type_id = synapse_ssh_plugin_ssh_host_get_type_once ();
		g_once_init_leave (&synapse_ssh_plugin_ssh_host_type_id__once, synapse_ssh_plugin_ssh_host_type_id);
	}
	return synapse_ssh_plugin_ssh_host_type_id__once;
}

static void
_vala_synapse_ssh_plugin_ssh_host_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	SynapseSshPluginSshHost * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_SSH_PLUGIN_TYPE_SSH_HOST, SynapseSshPluginSshHost);
#line 165 "ssh-plugin.vala"
	switch (property_id) {
#line 165 "ssh-plugin.vala"
		case SYNAPSE_SSH_PLUGIN_SSH_HOST_HOST_QUERY_PROPERTY:
#line 165 "ssh-plugin.vala"
		g_value_set_string (value, synapse_ssh_plugin_ssh_host_get_host_query (self));
#line 165 "ssh-plugin.vala"
		break;
#line 1625 "ssh-plugin.c"
		default:
#line 165 "ssh-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 165 "ssh-plugin.vala"
		break;
#line 1631 "ssh-plugin.c"
	}
}

static void
_vala_synapse_ssh_plugin_ssh_host_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	SynapseSshPluginSshHost * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_SSH_PLUGIN_TYPE_SSH_HOST, SynapseSshPluginSshHost);
#line 165 "ssh-plugin.vala"
	switch (property_id) {
#line 165 "ssh-plugin.vala"
		case SYNAPSE_SSH_PLUGIN_SSH_HOST_HOST_QUERY_PROPERTY:
#line 165 "ssh-plugin.vala"
		synapse_ssh_plugin_ssh_host_set_host_query (self, g_value_get_string (value));
#line 165 "ssh-plugin.vala"
		break;
#line 1651 "ssh-plugin.c"
		default:
#line 165 "ssh-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 165 "ssh-plugin.vala"
		break;
#line 1657 "ssh-plugin.c"
	}
}

static GObject *
synapse_ssh_plugin_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseSshPlugin * self;
	GeeHashMap* _tmp0_;
#line 37 "ssh-plugin.vala"
	parent_class = G_OBJECT_CLASS (synapse_ssh_plugin_parent_class);
#line 37 "ssh-plugin.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 37 "ssh-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_SSH_PLUGIN, SynapseSshPlugin);
#line 39 "ssh-plugin.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, SYNAPSE_SSH_PLUGIN_TYPE_SSH_HOST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 39 "ssh-plugin.vala"
	_g_object_unref0 (self->priv->hosts);
#line 39 "ssh-plugin.vala"
	self->priv->hosts = _tmp0_;
#line 37 "ssh-plugin.vala"
	return obj;
#line 1684 "ssh-plugin.c"
}

static void
synapse_ssh_plugin_class_init (SynapseSshPluginClass * klass,
                               gpointer klass_data)
{
#line 24 "ssh-plugin.vala"
	synapse_ssh_plugin_parent_class = g_type_class_peek_parent (klass);
#line 24 "ssh-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseSshPlugin_private_offset);
#line 24 "ssh-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_ssh_plugin_get_property;
#line 24 "ssh-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_ssh_plugin_set_property;
#line 24 "ssh-plugin.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_ssh_plugin_constructor;
#line 24 "ssh-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_ssh_plugin_finalize;
#line 24 "ssh-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_SSH_PLUGIN_ENABLED_PROPERTY, synapse_ssh_plugin_properties[SYNAPSE_SSH_PLUGIN_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 34 "ssh-plugin.vala"
	synapse_ssh_plugin_register_plugin ();
#line 1707 "ssh-plugin.c"
}

static void
synapse_ssh_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface,
                                                       gpointer iface_data)
{
#line 24 "ssh-plugin.vala"
	synapse_ssh_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "ssh-plugin.vala"
	iface->activate = (void (*) (SynapseActivatable*)) synapse_ssh_plugin_real_activate;
#line 24 "ssh-plugin.vala"
	iface->deactivate = (void (*) (SynapseActivatable*)) synapse_ssh_plugin_real_deactivate;
#line 24 "ssh-plugin.vala"
	iface->get_enabled = synapse_ssh_plugin_real_get_enabled;
#line 24 "ssh-plugin.vala"
	iface->set_enabled = synapse_ssh_plugin_real_set_enabled;
#line 1724 "ssh-plugin.c"
}

static void
synapse_ssh_plugin_synapse_item_provider_interface_init (SynapseItemProviderIface * iface,
                                                         gpointer iface_data)
{
#line 24 "ssh-plugin.vala"
	synapse_ssh_plugin_synapse_item_provider_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "ssh-plugin.vala"
	iface->handles_query = (gboolean (*) (SynapseItemProvider*, SynapseQuery*)) synapse_ssh_plugin_real_handles_query;
#line 24 "ssh-plugin.vala"
	iface->search = (void (*) (SynapseItemProvider*, SynapseQuery*, GAsyncReadyCallback, gpointer)) synapse_ssh_plugin_real_search;
#line 24 "ssh-plugin.vala"
	iface->search_finish = (SynapseResultSet* (*) (SynapseItemProvider*, GAsyncResult*, GError**)) synapse_ssh_plugin_search_finish;
#line 1739 "ssh-plugin.c"
}

static void
synapse_ssh_plugin_instance_init (SynapseSshPlugin * self,
                                  gpointer klass)
{
#line 24 "ssh-plugin.vala"
	self->priv = synapse_ssh_plugin_get_instance_private (self);
#line 26 "ssh-plugin.vala"
	self->priv->_enabled = TRUE;
#line 1750 "ssh-plugin.c"
}

static void
synapse_ssh_plugin_finalize (GObject * obj)
{
	SynapseSshPlugin * self;
#line 24 "ssh-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_SSH_PLUGIN, SynapseSshPlugin);
#line 27 "ssh-plugin.vala"
	_g_object_unref0 (self->priv->hosts);
#line 29 "ssh-plugin.vala"
	_g_object_unref0 (self->config_file);
#line 30 "ssh-plugin.vala"
	_g_object_unref0 (self->monitor);
#line 24 "ssh-plugin.vala"
	G_OBJECT_CLASS (synapse_ssh_plugin_parent_class)->finalize (obj);
#line 1767 "ssh-plugin.c"
}

static GType
synapse_ssh_plugin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseSshPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_ssh_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseSshPlugin), 0, (GInstanceInitFunc) synapse_ssh_plugin_instance_init, NULL };
	static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_ssh_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_item_provider_info = { (GInterfaceInitFunc) synapse_ssh_plugin_synapse_item_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_ssh_plugin_type_id;
	synapse_ssh_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseSshPlugin", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_ssh_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
	g_type_add_interface_static (synapse_ssh_plugin_type_id, SYNAPSE_TYPE_ITEM_PROVIDER, &synapse_item_provider_info);
	SynapseSshPlugin_private_offset = g_type_add_instance_private (synapse_ssh_plugin_type_id, sizeof (SynapseSshPluginPrivate));
	return synapse_ssh_plugin_type_id;
}

GType
synapse_ssh_plugin_get_type (void)
{
	static volatile gsize synapse_ssh_plugin_type_id__once = 0;
	if (g_once_init_enter (&synapse_ssh_plugin_type_id__once)) {
		GType synapse_ssh_plugin_type_id;
		synapse_ssh_plugin_type_id = synapse_ssh_plugin_get_type_once ();
		g_once_init_leave (&synapse_ssh_plugin_type_id__once, synapse_ssh_plugin_type_id);
	}
	return synapse_ssh_plugin_type_id__once;
}

static void
_vala_synapse_ssh_plugin_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	SynapseSshPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_SSH_PLUGIN, SynapseSshPlugin);
#line 24 "ssh-plugin.vala"
	switch (property_id) {
#line 24 "ssh-plugin.vala"
		case SYNAPSE_SSH_PLUGIN_ENABLED_PROPERTY:
#line 24 "ssh-plugin.vala"
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
#line 24 "ssh-plugin.vala"
		break;
#line 1812 "ssh-plugin.c"
		default:
#line 24 "ssh-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "ssh-plugin.vala"
		break;
#line 1818 "ssh-plugin.c"
	}
}

static void
_vala_synapse_ssh_plugin_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	SynapseSshPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_SSH_PLUGIN, SynapseSshPlugin);
#line 24 "ssh-plugin.vala"
	switch (property_id) {
#line 24 "ssh-plugin.vala"
		case SYNAPSE_SSH_PLUGIN_ENABLED_PROPERTY:
#line 24 "ssh-plugin.vala"
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
#line 24 "ssh-plugin.vala"
		break;
#line 1838 "ssh-plugin.c"
		default:
#line 24 "ssh-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "ssh-plugin.vala"
		break;
#line 1844 "ssh-plugin.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

