/* PluginManager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from PluginManager.vala, do not modify */

/*
 * SPDX-License-Identifier: LGPL-3.0-or-later
 * SPDX-FileCopyrightText: 2019-2025 elementary, Inc. (https://elementary.io)
 *                         2013 Mario Guerriero <mario@elementaryos.org>
 */
/* Interface implemented by all plugins  (Migrated from Peas.Activatable)*/

#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <handy.h>
#include <granite.h>
#include <libpeas.h>
#include <atk/atk.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>

#define CONSTANTS_PLUGINDIR "/usr/lib/io.elementary.code/plugins"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SCRATCH_SERVICES_TYPE_ACTIVATABLE_PLUGIN (scratch_services_activatable_plugin_get_type ())
#define SCRATCH_SERVICES_ACTIVATABLE_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCRATCH_SERVICES_TYPE_ACTIVATABLE_PLUGIN, ScratchServicesActivatablePlugin))
#define SCRATCH_SERVICES_IS_ACTIVATABLE_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCRATCH_SERVICES_TYPE_ACTIVATABLE_PLUGIN))
#define SCRATCH_SERVICES_ACTIVATABLE_PLUGIN_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SCRATCH_SERVICES_TYPE_ACTIVATABLE_PLUGIN, ScratchServicesActivatablePluginIface))

typedef struct _ScratchServicesActivatablePlugin ScratchServicesActivatablePlugin;
typedef struct _ScratchServicesActivatablePluginIface ScratchServicesActivatablePluginIface;

#define SCRATCH_SERVICES_TYPE_INTERFACE (scratch_services_interface_get_type ())
#define SCRATCH_SERVICES_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCRATCH_SERVICES_TYPE_INTERFACE, ScratchServicesInterface))
#define SCRATCH_SERVICES_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCRATCH_SERVICES_TYPE_INTERFACE, ScratchServicesInterfaceClass))
#define SCRATCH_SERVICES_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCRATCH_SERVICES_TYPE_INTERFACE))
#define SCRATCH_SERVICES_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCRATCH_SERVICES_TYPE_INTERFACE))
#define SCRATCH_SERVICES_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCRATCH_SERVICES_TYPE_INTERFACE, ScratchServicesInterfaceClass))

typedef struct _ScratchServicesInterface ScratchServicesInterface;
typedef struct _ScratchServicesInterfaceClass ScratchServicesInterfaceClass;
typedef struct _ScratchServicesInterfacePrivate ScratchServicesInterfacePrivate;

#define SCRATCH_TYPE_TEMPLATE_MANAGER (scratch_template_manager_get_type ())
#define SCRATCH_TEMPLATE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCRATCH_TYPE_TEMPLATE_MANAGER, ScratchTemplateManager))
#define SCRATCH_TEMPLATE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCRATCH_TYPE_TEMPLATE_MANAGER, ScratchTemplateManagerClass))
#define SCRATCH_IS_TEMPLATE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCRATCH_TYPE_TEMPLATE_MANAGER))
#define SCRATCH_IS_TEMPLATE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCRATCH_TYPE_TEMPLATE_MANAGER))
#define SCRATCH_TEMPLATE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCRATCH_TYPE_TEMPLATE_MANAGER, ScratchTemplateManagerClass))

typedef struct _ScratchTemplateManager ScratchTemplateManager;
typedef struct _ScratchTemplateManagerClass ScratchTemplateManagerClass;

#define SCRATCH_SERVICES_TYPE_PLUGINS_MANAGER (scratch_services_plugins_manager_get_type ())
#define SCRATCH_SERVICES_PLUGINS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCRATCH_SERVICES_TYPE_PLUGINS_MANAGER, ScratchServicesPluginsManager))
#define SCRATCH_SERVICES_PLUGINS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCRATCH_SERVICES_TYPE_PLUGINS_MANAGER, ScratchServicesPluginsManagerClass))
#define SCRATCH_SERVICES_IS_PLUGINS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCRATCH_SERVICES_TYPE_PLUGINS_MANAGER))
#define SCRATCH_SERVICES_IS_PLUGINS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCRATCH_SERVICES_TYPE_PLUGINS_MANAGER))
#define SCRATCH_SERVICES_PLUGINS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCRATCH_SERVICES_TYPE_PLUGINS_MANAGER, ScratchServicesPluginsManagerClass))

typedef struct _ScratchServicesPluginsManager ScratchServicesPluginsManager;
typedef struct _ScratchServicesPluginsManagerClass ScratchServicesPluginsManagerClass;
enum  {
	SCRATCH_SERVICES_INTERFACE_0_PROPERTY,
	SCRATCH_SERVICES_INTERFACE_TEMPLATE_MANAGER_PROPERTY,
	SCRATCH_SERVICES_INTERFACE_MANAGER_PROPERTY,
	SCRATCH_SERVICES_INTERFACE_NUM_PROPERTIES
};
static GParamSpec* scratch_services_interface_properties[SCRATCH_SERVICES_INTERFACE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SCRATCH_SERVICES_TYPE_DOCUMENT (scratch_services_document_get_type ())
#define SCRATCH_SERVICES_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCRATCH_SERVICES_TYPE_DOCUMENT, ScratchServicesDocument))
#define SCRATCH_SERVICES_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCRATCH_SERVICES_TYPE_DOCUMENT, ScratchServicesDocumentClass))
#define SCRATCH_SERVICES_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCRATCH_SERVICES_TYPE_DOCUMENT))
#define SCRATCH_SERVICES_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCRATCH_SERVICES_TYPE_DOCUMENT))
#define SCRATCH_SERVICES_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCRATCH_SERVICES_TYPE_DOCUMENT, ScratchServicesDocumentClass))

typedef struct _ScratchServicesDocument ScratchServicesDocument;
typedef struct _ScratchServicesDocumentClass ScratchServicesDocumentClass;

#define SCRATCH_TYPE_MAIN_WINDOW (scratch_main_window_get_type ())
#define SCRATCH_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCRATCH_TYPE_MAIN_WINDOW, ScratchMainWindow))
#define SCRATCH_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCRATCH_TYPE_MAIN_WINDOW, ScratchMainWindowClass))
#define SCRATCH_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCRATCH_TYPE_MAIN_WINDOW))
#define SCRATCH_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCRATCH_TYPE_MAIN_WINDOW))
#define SCRATCH_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCRATCH_TYPE_MAIN_WINDOW, ScratchMainWindowClass))

typedef struct _ScratchMainWindow ScratchMainWindow;
typedef struct _ScratchMainWindowClass ScratchMainWindowClass;

#define SCRATCH_TYPE_HEADER_BAR (scratch_header_bar_get_type ())
#define SCRATCH_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCRATCH_TYPE_HEADER_BAR, ScratchHeaderBar))
#define SCRATCH_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCRATCH_TYPE_HEADER_BAR, ScratchHeaderBarClass))
#define SCRATCH_IS_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCRATCH_TYPE_HEADER_BAR))
#define SCRATCH_IS_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCRATCH_TYPE_HEADER_BAR))
#define SCRATCH_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCRATCH_TYPE_HEADER_BAR, ScratchHeaderBarClass))

typedef struct _ScratchHeaderBar ScratchHeaderBar;
typedef struct _ScratchHeaderBarClass ScratchHeaderBarClass;

#define SCRATCH_DIALOGS_TYPE_PREFERENCES (scratch_dialogs_preferences_get_type ())
#define SCRATCH_DIALOGS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCRATCH_DIALOGS_TYPE_PREFERENCES, ScratchDialogsPreferences))
#define SCRATCH_DIALOGS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCRATCH_DIALOGS_TYPE_PREFERENCES, ScratchDialogsPreferencesClass))
#define SCRATCH_DIALOGS_IS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCRATCH_DIALOGS_TYPE_PREFERENCES))
#define SCRATCH_DIALOGS_IS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCRATCH_DIALOGS_TYPE_PREFERENCES))
#define SCRATCH_DIALOGS_PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCRATCH_DIALOGS_TYPE_PREFERENCES, ScratchDialogsPreferencesClass))

typedef struct _ScratchDialogsPreferences ScratchDialogsPreferences;
typedef struct _ScratchDialogsPreferencesClass ScratchDialogsPreferencesClass;
enum  {
	SCRATCH_SERVICES_INTERFACE_HOOK_WINDOW_SIGNAL,
	SCRATCH_SERVICES_INTERFACE_HOOK_SHARE_MENU_SIGNAL,
	SCRATCH_SERVICES_INTERFACE_HOOK_TOOLBAR_SIGNAL,
	SCRATCH_SERVICES_INTERFACE_HOOK_DOCUMENT_SIGNAL,
	SCRATCH_SERVICES_INTERFACE_HOOK_PREFERENCES_DIALOG_SIGNAL,
	SCRATCH_SERVICES_INTERFACE_HOOK_FOLDER_ITEM_CHANGE_SIGNAL,
	SCRATCH_SERVICES_INTERFACE_NUM_SIGNALS
};
static guint scratch_services_interface_signals[SCRATCH_SERVICES_INTERFACE_NUM_SIGNALS] = {0};
typedef struct _ScratchServicesPluginsManagerPrivate ScratchServicesPluginsManagerPrivate;
enum  {
	SCRATCH_SERVICES_PLUGINS_MANAGER_0_PROPERTY,
	SCRATCH_SERVICES_PLUGINS_MANAGER_PLUGIN_IFACE_PROPERTY,
	SCRATCH_SERVICES_PLUGINS_MANAGER_WINDOW_PROPERTY,
	SCRATCH_SERVICES_PLUGINS_MANAGER_NUM_PROPERTIES
};
static GParamSpec* scratch_services_plugins_manager_properties[SCRATCH_SERVICES_PLUGINS_MANAGER_NUM_PROPERTIES];
typedef struct _Block39Data Block39Data;
enum  {
	SCRATCH_SERVICES_PLUGINS_MANAGER_HOOK_WINDOW_SIGNAL,
	SCRATCH_SERVICES_PLUGINS_MANAGER_HOOK_SHARE_MENU_SIGNAL,
	SCRATCH_SERVICES_PLUGINS_MANAGER_HOOK_TOOLBAR_SIGNAL,
	SCRATCH_SERVICES_PLUGINS_MANAGER_HOOK_DOCUMENT_SIGNAL,
	SCRATCH_SERVICES_PLUGINS_MANAGER_HOOK_PREFERENCES_DIALOG_SIGNAL,
	SCRATCH_SERVICES_PLUGINS_MANAGER_HOOK_FOLDER_ITEM_CHANGE_SIGNAL,
	SCRATCH_SERVICES_PLUGINS_MANAGER_EXTENSION_ADDED_SIGNAL,
	SCRATCH_SERVICES_PLUGINS_MANAGER_EXTENSION_REMOVED_SIGNAL,
	SCRATCH_SERVICES_PLUGINS_MANAGER_NUM_SIGNALS
};
static guint scratch_services_plugins_manager_signals[SCRATCH_SERVICES_PLUGINS_MANAGER_NUM_SIGNALS] = {0};

struct _ScratchServicesActivatablePluginIface {
	GTypeInterface parent_iface;
	void (*activate) (ScratchServicesActivatablePlugin* self);
	void (*deactivate) (ScratchServicesActivatablePlugin* self);
	void (*update_state) (ScratchServicesActivatablePlugin* self);
	GObject* (*get_object) (ScratchServicesActivatablePlugin* self);
	void (*set_object) (ScratchServicesActivatablePlugin* self, GObject* value);
};

struct _ScratchServicesInterface {
	GObject parent_instance;
	ScratchServicesInterfacePrivate * priv;
};

struct _ScratchServicesInterfaceClass {
	GObjectClass parent_class;
};

struct _ScratchServicesInterfacePrivate {
	ScratchTemplateManager* _template_manager;
	ScratchServicesPluginsManager* _manager;
};

struct _ScratchServicesPluginsManager {
	GObject parent_instance;
	ScratchServicesPluginsManagerPrivate * priv;
};

struct _ScratchServicesPluginsManagerClass {
	GObjectClass parent_class;
};

struct _ScratchServicesPluginsManagerPrivate {
	PeasEngine* engine;
	PeasExtensionSet* extension_set;
	ScratchServicesInterface* _plugin_iface;
	ScratchMainWindow* _window;
};

struct _Block39Data {
	int _ref_count_;
	ScratchServicesPluginsManager* self;
	PeasPluginInfo* info;
	GtkSwitch* load_switch;
};

static gint ScratchServicesInterface_private_offset;
static gpointer scratch_services_interface_parent_class = NULL;
static gint ScratchServicesPluginsManager_private_offset;
static gpointer scratch_services_plugins_manager_parent_class = NULL;
VALA_EXTERN GSettings* scratch_settings;

VALA_EXTERN GType scratch_services_activatable_plugin_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScratchServicesActivatablePlugin, g_object_unref)
VALA_EXTERN void scratch_services_activatable_plugin_activate (ScratchServicesActivatablePlugin* self);
VALA_EXTERN void scratch_services_activatable_plugin_deactivate (ScratchServicesActivatablePlugin* self);
VALA_EXTERN void scratch_services_activatable_plugin_update_state (ScratchServicesActivatablePlugin* self);
static void scratch_services_activatable_plugin_real_update_state (ScratchServicesActivatablePlugin* self);
VALA_EXTERN GObject* scratch_services_activatable_plugin_get_object (ScratchServicesActivatablePlugin* self);
VALA_EXTERN void scratch_services_activatable_plugin_set_object (ScratchServicesActivatablePlugin* self,
                                                     GObject* value);
static GType scratch_services_activatable_plugin_get_type_once (void);
VALA_EXTERN GType scratch_services_interface_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScratchServicesInterface, g_object_unref)
VALA_EXTERN GType scratch_template_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScratchTemplateManager, g_object_unref)
VALA_EXTERN GType scratch_services_plugins_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScratchServicesPluginsManager, g_object_unref)
VALA_EXTERN ScratchServicesInterface* scratch_services_interface_new (ScratchServicesPluginsManager* _manager);
VALA_EXTERN ScratchServicesInterface* scratch_services_interface_construct (GType object_type,
                                                                ScratchServicesPluginsManager* _manager);
VALA_EXTERN GType scratch_services_document_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScratchServicesDocument, g_object_unref)
VALA_EXTERN ScratchServicesDocument* scratch_services_interface_open_file (ScratchServicesInterface* self,
                                                               GFile* file);
VALA_EXTERN ScratchServicesPluginsManager* scratch_services_interface_get_manager (ScratchServicesInterface* self);
VALA_EXTERN GType scratch_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScratchMainWindow, g_object_unref)
VALA_EXTERN ScratchMainWindow* scratch_services_plugins_manager_get_window (ScratchServicesPluginsManager* self);
VALA_EXTERN GSimpleActionGroup* scratch_main_window_get_actions (ScratchMainWindow* self);
VALA_EXTERN ScratchServicesDocument* scratch_services_document_new (GSimpleActionGroup* actions,
                                                        GFile* file);
VALA_EXTERN ScratchServicesDocument* scratch_services_document_construct (GType object_type,
                                                              GSimpleActionGroup* actions,
                                                              GFile* file);
VALA_EXTERN void scratch_main_window_open_document (ScratchMainWindow* self,
                                        ScratchServicesDocument* doc,
                                        gboolean focus,
                                        gint cursor_position,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
VALA_EXTERN void scratch_main_window_open_document_finish (ScratchMainWindow* self,
                                               GAsyncResult* _res_);
VALA_EXTERN void scratch_services_interface_close_document (ScratchServicesInterface* self,
                                                ScratchServicesDocument* doc);
VALA_EXTERN void scratch_main_window_close_document (ScratchMainWindow* self,
                                         ScratchServicesDocument* doc);
VALA_EXTERN ScratchTemplateManager* scratch_services_interface_get_template_manager (ScratchServicesInterface* self);
static void scratch_services_interface_set_template_manager (ScratchServicesInterface* self,
                                                      ScratchTemplateManager* value);
static void scratch_services_interface_set_manager (ScratchServicesInterface* self,
                                             ScratchServicesPluginsManager* value);
VALA_EXTERN GType scratch_header_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScratchHeaderBar, g_object_unref)
VALA_EXTERN GType scratch_dialogs_preferences_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScratchDialogsPreferences, g_object_unref)
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_ENUM (GClosure * closure,
                                                       GValue * return_value,
                                                       guint n_param_values,
                                                       const GValue * param_values,
                                                       gpointer invocation_hint,
                                                       gpointer marshal_data);
static GObject * scratch_services_interface_constructor (GType type,
                                                  guint n_construct_properties,
                                                  GObjectConstructParam * construct_properties);
VALA_EXTERN ScratchTemplateManager* scratch_template_manager_new (void);
VALA_EXTERN ScratchTemplateManager* scratch_template_manager_construct (GType object_type);
static void scratch_services_interface_finalize (GObject * obj);
static GType scratch_services_interface_get_type_once (void);
static void _vala_scratch_services_interface_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_scratch_services_interface_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);
VALA_EXTERN ScratchServicesPluginsManager* scratch_services_plugins_manager_new (ScratchMainWindow* _window);
VALA_EXTERN ScratchServicesPluginsManager* scratch_services_plugins_manager_construct (GType object_type,
                                                                           ScratchMainWindow* _window);
VALA_EXTERN GtkWidget* scratch_services_plugins_manager_get_view (ScratchServicesPluginsManager* self);
static GtkWidget* scratch_services_plugins_manager_get_widget_for_plugin_info (ScratchServicesPluginsManager* self,
                                                                        GObject* obj);
static GtkWidget* _scratch_services_plugins_manager_get_widget_for_plugin_info_gtk_list_box_create_widget_func (GObject* item,
                                                                                                         gpointer self);
static gint __lambda69_ (ScratchServicesPluginsManager* self,
                  GtkListBoxRow* r1,
                  GtkListBoxRow* r2);
static gint ___lambda69__gtk_list_box_sort_func (GtkListBoxRow* row1,
                                          GtkListBoxRow* row2,
                                          gpointer self);
static Block39Data* block39_data_ref (Block39Data* _data39_);
static void block39_data_unref (void * _userdata_);
static void __lambda68_ (Block39Data* _data39_);
static void ___lambda68__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
VALA_EXTERN guint scratch_services_plugins_manager_get_n_plugins (ScratchServicesPluginsManager* self);
VALA_EXTERN ScratchServicesInterface* scratch_services_plugins_manager_get_plugin_iface (ScratchServicesPluginsManager* self);
static void scratch_services_plugins_manager_set_plugin_iface (ScratchServicesPluginsManager* self,
                                                        ScratchServicesInterface* value);
static void scratch_services_plugins_manager_set_window (ScratchServicesPluginsManager* self,
                                                  ScratchMainWindow* value);
static GObject * scratch_services_plugins_manager_constructor (GType type,
                                                        guint n_construct_properties,
                                                        GObjectConstructParam * construct_properties);
static void _vala_GValue_array_free (GValue * array,
                              gssize array_length);
static void _scratch_services_plugins_manager___lambda72_ (ScratchServicesPluginsManager* self,
                                                    PeasPluginInfo* info,
                                                    GObject* ext);
static void __scratch_services_plugins_manager___lambda72__peas_extension_set_extension_added (PeasExtensionSet* _sender,
                                                                                        PeasPluginInfo* info,
                                                                                        GObject* extension,
                                                                                        gpointer self);
static void _scratch_services_plugins_manager___lambda73_ (ScratchServicesPluginsManager* self,
                                                    PeasPluginInfo* info,
                                                    GObject* ext);
static void __scratch_services_plugins_manager___lambda73__peas_extension_set_extension_removed (PeasExtensionSet* _sender,
                                                                                          PeasPluginInfo* info,
                                                                                          GObject* extension,
                                                                                          gpointer self);
static void _scratch_services_plugins_manager___lambda74_ (PeasExtensionSet* exts,
                                                    PeasPluginInfo* info,
                                                    GObject* ext);
static void __scratch_services_plugins_manager___lambda74__peas_extension_set_foreach_func (PeasExtensionSet* set,
                                                                                     PeasPluginInfo* info,
                                                                                     GObject* extension,
                                                                                     void* data);
static void _scratch_services_plugins_manager___lambda75_ (ScratchServicesPluginsManager* self,
                                                    ScratchMainWindow* w);
static void __scratch_services_plugins_manager___lambda75__scratch_services_plugins_manager_hook_window (ScratchServicesPluginsManager* _sender,
                                                                                                  ScratchMainWindow* window,
                                                                                                  gpointer self);
static void _scratch_services_plugins_manager___lambda76_ (ScratchServicesPluginsManager* self,
                                                    GMenuModel* m);
static void __scratch_services_plugins_manager___lambda76__scratch_services_plugins_manager_hook_share_menu (ScratchServicesPluginsManager* _sender,
                                                                                                      GMenuModel* menu,
                                                                                                      gpointer self);
static void _scratch_services_plugins_manager___lambda77_ (ScratchServicesPluginsManager* self,
                                                    ScratchHeaderBar* t);
static void __scratch_services_plugins_manager___lambda77__scratch_services_plugins_manager_hook_toolbar (ScratchServicesPluginsManager* _sender,
                                                                                                   ScratchHeaderBar* toolbar,
                                                                                                   gpointer self);
static void _scratch_services_plugins_manager___lambda78_ (ScratchServicesPluginsManager* self,
                                                    ScratchServicesDocument* d);
static void __scratch_services_plugins_manager___lambda78__scratch_services_plugins_manager_hook_document (ScratchServicesPluginsManager* _sender,
                                                                                                    ScratchServicesDocument* doc,
                                                                                                    gpointer self);
static void _scratch_services_plugins_manager___lambda79_ (ScratchServicesPluginsManager* self,
                                                    ScratchDialogsPreferences* d);
static void __scratch_services_plugins_manager___lambda79__scratch_services_plugins_manager_hook_preferences_dialog (ScratchServicesPluginsManager* _sender,
                                                                                                              ScratchDialogsPreferences* dialog,
                                                                                                              gpointer self);
static void _scratch_services_plugins_manager___lambda80_ (ScratchServicesPluginsManager* self,
                                                    GFile* source,
                                                    GFile* dest,
                                                    GFileMonitorEvent event);
static void __scratch_services_plugins_manager___lambda80__scratch_services_plugins_manager_hook_folder_item_change (ScratchServicesPluginsManager* _sender,
                                                                                                              GFile* file,
                                                                                                              GFile* other_file,
                                                                                                              GFileMonitorEvent event_type,
                                                                                                              gpointer self);
static void scratch_services_plugins_manager_finalize (GObject * obj);
static GType scratch_services_plugins_manager_get_type_once (void);
static void _vala_scratch_services_plugins_manager_get_property (GObject * object,
                                                          guint property_id,
                                                          GValue * value,
                                                          GParamSpec * pspec);
static void _vala_scratch_services_plugins_manager_set_property (GObject * object,
                                                          guint property_id,
                                                          const GValue * value,
                                                          GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

void
scratch_services_activatable_plugin_activate (ScratchServicesActivatablePlugin* self)
{
	ScratchServicesActivatablePluginIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SCRATCH_SERVICES_ACTIVATABLE_PLUGIN_GET_INTERFACE (self);
	if (_iface_->activate) {
		_iface_->activate (self);
	}
}

void
scratch_services_activatable_plugin_deactivate (ScratchServicesActivatablePlugin* self)
{
	ScratchServicesActivatablePluginIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SCRATCH_SERVICES_ACTIVATABLE_PLUGIN_GET_INTERFACE (self);
	if (_iface_->deactivate) {
		_iface_->deactivate (self);
	}
}

static void
scratch_services_activatable_plugin_real_update_state (ScratchServicesActivatablePlugin* self)
{
}

void
scratch_services_activatable_plugin_update_state (ScratchServicesActivatablePlugin* self)
{
	ScratchServicesActivatablePluginIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SCRATCH_SERVICES_ACTIVATABLE_PLUGIN_GET_INTERFACE (self);
	if (_iface_->update_state) {
		_iface_->update_state (self);
	}
}

GObject*
scratch_services_activatable_plugin_get_object (ScratchServicesActivatablePlugin* self)
{
	ScratchServicesActivatablePluginIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SCRATCH_SERVICES_ACTIVATABLE_PLUGIN_GET_INTERFACE (self);
	if (_iface_->get_object) {
		return _iface_->get_object (self);
	}
	return NULL;
}

void
scratch_services_activatable_plugin_set_object (ScratchServicesActivatablePlugin* self,
                                                GObject* value)
{
	ScratchServicesActivatablePluginIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SCRATCH_SERVICES_ACTIVATABLE_PLUGIN_GET_INTERFACE (self);
	if (_iface_->set_object) {
		_iface_->set_object (self, value);
	}
}

static void
scratch_services_activatable_plugin_default_init (ScratchServicesActivatablePluginIface * iface,
                                                  gpointer iface_data)
{
	g_object_interface_install_property (iface, g_param_spec_object ("object", "object", "object", G_TYPE_OBJECT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	iface->update_state = scratch_services_activatable_plugin_real_update_state;
}

 G_GNUC_NO_INLINE static GType
scratch_services_activatable_plugin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScratchServicesActivatablePluginIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_services_activatable_plugin_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType scratch_services_activatable_plugin_type_id;
	scratch_services_activatable_plugin_type_id = g_type_register_static (G_TYPE_INTERFACE, "ScratchServicesActivatablePlugin", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (scratch_services_activatable_plugin_type_id, G_TYPE_OBJECT);
	return scratch_services_activatable_plugin_type_id;
}

GType
scratch_services_activatable_plugin_get_type (void)
{
	static gsize scratch_services_activatable_plugin_type_id__once = 0;
	if (g_once_init_enter (&scratch_services_activatable_plugin_type_id__once)) {
		GType scratch_services_activatable_plugin_type_id;
		scratch_services_activatable_plugin_type_id = scratch_services_activatable_plugin_get_type_once ();
		g_once_init_leave (&scratch_services_activatable_plugin_type_id__once, scratch_services_activatable_plugin_type_id);
	}
	return scratch_services_activatable_plugin_type_id__once;
}

static inline gpointer
scratch_services_interface_get_instance_private (ScratchServicesInterface* self)
{
	return G_STRUCT_MEMBER_P (self, ScratchServicesInterface_private_offset);
}

ScratchServicesInterface*
scratch_services_interface_construct (GType object_type,
                                      ScratchServicesPluginsManager* _manager)
{
	ScratchServicesInterface * self = NULL;
	g_return_val_if_fail (_manager != NULL, NULL);
	self = (ScratchServicesInterface*) g_object_new (object_type, "manager", _manager, NULL);
	return self;
}

ScratchServicesInterface*
scratch_services_interface_new (ScratchServicesPluginsManager* _manager)
{
	return scratch_services_interface_construct (SCRATCH_SERVICES_TYPE_INTERFACE, _manager);
}

ScratchServicesDocument*
scratch_services_interface_open_file (ScratchServicesInterface* self,
                                      GFile* file)
{
	ScratchServicesDocument* doc = NULL;
	ScratchServicesPluginsManager* _tmp0_;
	ScratchMainWindow* _tmp1_;
	ScratchMainWindow* _tmp2_;
	GSimpleActionGroup* _tmp3_;
	GSimpleActionGroup* _tmp4_;
	ScratchServicesDocument* _tmp5_;
	ScratchServicesPluginsManager* _tmp6_;
	ScratchMainWindow* _tmp7_;
	ScratchMainWindow* _tmp8_;
	ScratchServicesDocument* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = self->priv->_manager;
	_tmp1_ = scratch_services_plugins_manager_get_window (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = scratch_main_window_get_actions (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = scratch_services_document_new (_tmp4_, file);
	g_object_ref_sink (_tmp5_);
	doc = _tmp5_;
	_tmp6_ = self->priv->_manager;
	_tmp7_ = scratch_services_plugins_manager_get_window (_tmp6_);
	_tmp8_ = _tmp7_;
	scratch_main_window_open_document (_tmp8_, doc, TRUE, 0, NULL, NULL);
	result = doc;
	return result;
}

void
scratch_services_interface_close_document (ScratchServicesInterface* self,
                                           ScratchServicesDocument* doc)
{
	ScratchServicesPluginsManager* _tmp0_;
	ScratchMainWindow* _tmp1_;
	ScratchMainWindow* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (doc != NULL);
	_tmp0_ = self->priv->_manager;
	_tmp1_ = scratch_services_plugins_manager_get_window (_tmp0_);
	_tmp2_ = _tmp1_;
	scratch_main_window_close_document (_tmp2_, doc);
}

ScratchTemplateManager*
scratch_services_interface_get_template_manager (ScratchServicesInterface* self)
{
	ScratchTemplateManager* result;
	ScratchTemplateManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_template_manager;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
scratch_services_interface_set_template_manager (ScratchServicesInterface* self,
                                                 ScratchTemplateManager* value)
{
	ScratchTemplateManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_services_interface_get_template_manager (self);
	if (old_value != value) {
		ScratchTemplateManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_template_manager);
		self->priv->_template_manager = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_services_interface_properties[SCRATCH_SERVICES_INTERFACE_TEMPLATE_MANAGER_PROPERTY]);
	}
}

ScratchServicesPluginsManager*
scratch_services_interface_get_manager (ScratchServicesInterface* self)
{
	ScratchServicesPluginsManager* result;
	ScratchServicesPluginsManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_manager;
	result = _tmp0_;
	return result;
}

static void
scratch_services_interface_set_manager (ScratchServicesInterface* self,
                                        ScratchServicesPluginsManager* value)
{
	ScratchServicesPluginsManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_services_interface_get_manager (self);
	if (old_value != value) {
		ScratchServicesPluginsManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_manager);
		self->priv->_manager = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_services_interface_properties[SCRATCH_SERVICES_INTERFACE_MANAGER_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT_ENUM (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT_ENUM) (gpointer data1, gpointer arg_1, gpointer arg_2, gint arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT_ENUM callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT_ENUM) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), g_value_get_enum (param_values + 3), data2);
}

static GObject *
scratch_services_interface_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ScratchServicesInterface * self;
	ScratchTemplateManager* _tmp0_;
	ScratchTemplateManager* _tmp1_;
	parent_class = G_OBJECT_CLASS (scratch_services_interface_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_SERVICES_TYPE_INTERFACE, ScratchServicesInterface);
	_tmp0_ = scratch_template_manager_new ();
	_tmp1_ = _tmp0_;
	scratch_services_interface_set_template_manager (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	return obj;
}

static void
scratch_services_interface_class_init (ScratchServicesInterfaceClass * klass,
                                       gpointer klass_data)
{
	scratch_services_interface_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ScratchServicesInterface_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_scratch_services_interface_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_scratch_services_interface_set_property;
	G_OBJECT_CLASS (klass)->constructor = scratch_services_interface_constructor;
	G_OBJECT_CLASS (klass)->finalize = scratch_services_interface_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_SERVICES_INTERFACE_TEMPLATE_MANAGER_PROPERTY, scratch_services_interface_properties[SCRATCH_SERVICES_INTERFACE_TEMPLATE_MANAGER_PROPERTY] = g_param_spec_object ("template-manager", "template-manager", "template-manager", SCRATCH_TYPE_TEMPLATE_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_SERVICES_INTERFACE_MANAGER_PROPERTY, scratch_services_interface_properties[SCRATCH_SERVICES_INTERFACE_MANAGER_PROPERTY] = g_param_spec_object ("manager", "manager", "manager", SCRATCH_SERVICES_TYPE_PLUGINS_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	scratch_services_interface_signals[SCRATCH_SERVICES_INTERFACE_HOOK_WINDOW_SIGNAL] = g_signal_new ("hook-window", SCRATCH_SERVICES_TYPE_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, SCRATCH_TYPE_MAIN_WINDOW);
	scratch_services_interface_signals[SCRATCH_SERVICES_INTERFACE_HOOK_SHARE_MENU_SIGNAL] = g_signal_new ("hook-share-menu", SCRATCH_SERVICES_TYPE_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, g_menu_model_get_type ());
	scratch_services_interface_signals[SCRATCH_SERVICES_INTERFACE_HOOK_TOOLBAR_SIGNAL] = g_signal_new ("hook-toolbar", SCRATCH_SERVICES_TYPE_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, SCRATCH_TYPE_HEADER_BAR);
	scratch_services_interface_signals[SCRATCH_SERVICES_INTERFACE_HOOK_DOCUMENT_SIGNAL] = g_signal_new ("hook-document", SCRATCH_SERVICES_TYPE_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, SCRATCH_SERVICES_TYPE_DOCUMENT);
	scratch_services_interface_signals[SCRATCH_SERVICES_INTERFACE_HOOK_PREFERENCES_DIALOG_SIGNAL] = g_signal_new ("hook-preferences-dialog", SCRATCH_SERVICES_TYPE_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, SCRATCH_DIALOGS_TYPE_PREFERENCES);
	scratch_services_interface_signals[SCRATCH_SERVICES_INTERFACE_HOOK_FOLDER_ITEM_CHANGE_SIGNAL] = g_signal_new ("hook-folder-item-change", SCRATCH_SERVICES_TYPE_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_ENUM, G_TYPE_NONE, 3, g_file_get_type (), g_file_get_type (), g_file_monitor_event_get_type ());
}

static void
scratch_services_interface_instance_init (ScratchServicesInterface * self,
                                          gpointer klass)
{
	self->priv = scratch_services_interface_get_instance_private (self);
}

static void
scratch_services_interface_finalize (GObject * obj)
{
	ScratchServicesInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_SERVICES_TYPE_INTERFACE, ScratchServicesInterface);
	_g_object_unref0 (self->priv->_template_manager);
	_g_object_unref0 (self->priv->_manager);
	G_OBJECT_CLASS (scratch_services_interface_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
scratch_services_interface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScratchServicesInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_services_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScratchServicesInterface), 0, (GInstanceInitFunc) scratch_services_interface_instance_init, NULL };
	GType scratch_services_interface_type_id;
	scratch_services_interface_type_id = g_type_register_static (G_TYPE_OBJECT, "ScratchServicesInterface", &g_define_type_info, 0);
	ScratchServicesInterface_private_offset = g_type_add_instance_private (scratch_services_interface_type_id, sizeof (ScratchServicesInterfacePrivate));
	return scratch_services_interface_type_id;
}

GType
scratch_services_interface_get_type (void)
{
	static gsize scratch_services_interface_type_id__once = 0;
	if (g_once_init_enter (&scratch_services_interface_type_id__once)) {
		GType scratch_services_interface_type_id;
		scratch_services_interface_type_id = scratch_services_interface_get_type_once ();
		g_once_init_leave (&scratch_services_interface_type_id__once, scratch_services_interface_type_id);
	}
	return scratch_services_interface_type_id__once;
}

static void
_vala_scratch_services_interface_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	ScratchServicesInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_SERVICES_TYPE_INTERFACE, ScratchServicesInterface);
	switch (property_id) {
		case SCRATCH_SERVICES_INTERFACE_TEMPLATE_MANAGER_PROPERTY:
		g_value_set_object (value, scratch_services_interface_get_template_manager (self));
		break;
		case SCRATCH_SERVICES_INTERFACE_MANAGER_PROPERTY:
		g_value_set_object (value, scratch_services_interface_get_manager (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_scratch_services_interface_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	ScratchServicesInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_SERVICES_TYPE_INTERFACE, ScratchServicesInterface);
	switch (property_id) {
		case SCRATCH_SERVICES_INTERFACE_TEMPLATE_MANAGER_PROPERTY:
		scratch_services_interface_set_template_manager (self, g_value_get_object (value));
		break;
		case SCRATCH_SERVICES_INTERFACE_MANAGER_PROPERTY:
		scratch_services_interface_set_manager (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
scratch_services_plugins_manager_get_instance_private (ScratchServicesPluginsManager* self)
{
	return G_STRUCT_MEMBER_P (self, ScratchServicesPluginsManager_private_offset);
}

ScratchServicesPluginsManager*
scratch_services_plugins_manager_construct (GType object_type,
                                            ScratchMainWindow* _window)
{
	ScratchServicesPluginsManager * self = NULL;
	g_return_val_if_fail (_window != NULL, NULL);
	self = (ScratchServicesPluginsManager*) g_object_new (object_type, "window", _window, NULL);
	return self;
}

ScratchServicesPluginsManager*
scratch_services_plugins_manager_new (ScratchMainWindow* _window)
{
	return scratch_services_plugins_manager_construct (SCRATCH_SERVICES_TYPE_PLUGINS_MANAGER, _window);
}

static GtkWidget*
_scratch_services_plugins_manager_get_widget_for_plugin_info_gtk_list_box_create_widget_func (GObject* item,
                                                                                              gpointer self)
{
	GtkWidget* result;
	result = scratch_services_plugins_manager_get_widget_for_plugin_info ((ScratchServicesPluginsManager*) self, item);
	return result;
}

static gint
__lambda69_ (ScratchServicesPluginsManager* self,
             GtkListBoxRow* r1,
             GtkListBoxRow* r2)
{
	GCompareFunc _tmp0_;
	GtkWidget* _tmp1_;
	gconstpointer _tmp2_;
	GtkWidget* _tmp3_;
	gconstpointer _tmp4_;
	gint result;
	g_return_val_if_fail (r1 != NULL, 0);
	g_return_val_if_fail (r2 != NULL, 0);
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	_tmp1_ = gtk_bin_get_child ((GtkBin*) r1);
	_tmp2_ = g_object_get_data ((GObject*) _tmp1_, "name");
	_tmp3_ = gtk_bin_get_child ((GtkBin*) r2);
	_tmp4_ = g_object_get_data ((GObject*) _tmp3_, "name");
	result = _tmp0_ ((const gchar*) _tmp2_, (const gchar*) _tmp4_);
	return result;
}

static gint
___lambda69__gtk_list_box_sort_func (GtkListBoxRow* row1,
                                     GtkListBoxRow* row2,
                                     gpointer self)
{
	gint result;
	result = __lambda69_ ((ScratchServicesPluginsManager*) self, row1, row2);
	return result;
}

GtkWidget*
scratch_services_plugins_manager_get_view (ScratchServicesPluginsManager* self)
{
	GtkListBox* list_box = NULL;
	GtkListBox* _tmp0_;
	AtkObject* _tmp1_;
	GtkScrolledWindow* scrolled_window = NULL;
	GtkWidget* _tmp2_;
	GtkScrolledWindow* _tmp3_ = NULL;
	GtkFrame* frame = NULL;
	GtkWidget* _tmp4_;
	GtkFrame* _tmp5_ = NULL;
	PeasEngine* _tmp6_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp0_);
	list_box = _tmp0_;
	_tmp1_ = gtk_widget_get_accessible ((GtkWidget*) list_box);
	g_object_set (_tmp1_, "accessible-name", _ ("Extensions"), NULL);
	_tmp2_ = _g_object_ref0 ((GtkWidget*) list_box);
	_tmp3_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_set (_tmp3_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	g_object_set ((GtkContainer*) _tmp3_, "child", _tmp2_, NULL);
	_g_object_unref0 (_tmp2_);
	g_object_ref_sink (_tmp3_);
	scrolled_window = _tmp3_;
	_tmp4_ = _g_object_ref0 ((GtkWidget*) scrolled_window);
	_tmp5_ = (GtkFrame*) gtk_frame_new (NULL);
	g_object_set ((GtkContainer*) _tmp5_, "child", _tmp4_, NULL);
	_g_object_unref0 (_tmp4_);
	g_object_ref_sink (_tmp5_);
	frame = _tmp5_;
	_tmp6_ = self->priv->engine;
	gtk_list_box_bind_model (list_box, (GListModel*) _tmp6_, _scratch_services_plugins_manager_get_widget_for_plugin_info_gtk_list_box_create_widget_func, g_object_ref (self), g_object_unref);
	gtk_list_box_set_sort_func (list_box, ___lambda69__gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	gtk_widget_show_all ((GtkWidget*) frame);
	result = (GtkWidget*) frame;
	_g_object_unref0 (scrolled_window);
	_g_object_unref0 (list_box);
	return result;
}

static Block39Data*
block39_data_ref (Block39Data* _data39_)
{
	g_atomic_int_inc (&_data39_->_ref_count_);
	return _data39_;
}

static void
block39_data_unref (void * _userdata_)
{
	Block39Data* _data39_;
	_data39_ = (Block39Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data39_->_ref_count_)) {
		ScratchServicesPluginsManager* self;
		self = _data39_->self;
		_g_object_unref0 (_data39_->load_switch);
		_g_object_unref0 (_data39_->info);
		_g_object_unref0 (self);
		g_slice_free (Block39Data, _data39_);
	}
}

static void
__lambda68_ (Block39Data* _data39_)
{
	ScratchServicesPluginsManager* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = _data39_->self;
	_tmp0_ = gtk_switch_get_active (_data39_->load_switch);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		PeasEngine* _tmp2_;
		_tmp2_ = self->priv->engine;
		peas_engine_load_plugin (_tmp2_, _data39_->info);
	} else {
		PeasEngine* _tmp3_;
		_tmp3_ = self->priv->engine;
		peas_engine_unload_plugin (_tmp3_, _data39_->info);
	}
}

static void
___lambda68__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda68_ (self);
}

static GtkWidget*
scratch_services_plugins_manager_get_widget_for_plugin_info (ScratchServicesPluginsManager* self,
                                                             GObject* obj)
{
	Block39Data* _data39_;
	PeasPluginInfo* _tmp0_;
	GtkSwitch* _tmp1_ = NULL;
	GtkImage* image = NULL;
	const gchar* _tmp2_;
	GtkImage* _tmp3_ = NULL;
	GtkLabel* name_label = NULL;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GtkLabel* _tmp6_ = NULL;
	GtkLabel* description_label = NULL;
	const gchar* _tmp7_;
	GtkLabel* _tmp8_ = NULL;
	GtkStyleContext* _tmp9_;
	GtkStyleContext* _tmp10_;
	GtkBox* description_box = NULL;
	GtkBox* _tmp11_ = NULL;
	GtkBox* content = NULL;
	GtkBox* _tmp12_ = NULL;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (obj != NULL, NULL);
	_data39_ = g_slice_new0 (Block39Data);
	_data39_->_ref_count_ = 1;
	_data39_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (obj, peas_plugin_info_get_type (), PeasPluginInfo));
	_data39_->info = _tmp0_;
	_tmp1_ = (GtkSwitch*) gtk_switch_new ();
	gtk_widget_set_valign ((GtkWidget*) _tmp1_, GTK_ALIGN_CENTER);
	gtk_switch_set_state (_tmp1_, peas_plugin_info_is_loaded (_data39_->info));
	g_object_ref_sink (_tmp1_);
	_data39_->load_switch = _tmp1_;
	_tmp2_ = peas_plugin_info_get_icon_name (_data39_->info);
	_tmp3_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp2_, (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	gtk_widget_set_valign ((GtkWidget*) _tmp3_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp3_);
	image = _tmp3_;
	_tmp4_ = peas_plugin_info_get_name (_data39_->info);
	_tmp5_ = _tmp4_;
	_tmp6_ = (GtkLabel*) gtk_label_new (_tmp5_);
	gtk_label_set_ellipsize (_tmp6_, PANGO_ELLIPSIZE_MIDDLE);
	gtk_label_set_xalign (_tmp6_, (gfloat) 0);
	g_object_ref_sink (_tmp6_);
	name_label = _tmp6_;
	_tmp7_ = peas_plugin_info_get_description (_data39_->info);
	_tmp8_ = (GtkLabel*) gtk_label_new (_tmp7_);
	gtk_label_set_ellipsize (_tmp8_, PANGO_ELLIPSIZE_END);
	gtk_label_set_lines (_tmp8_, 2);
	g_object_set (_tmp8_, "wrap", TRUE, NULL);
	gtk_label_set_xalign (_tmp8_, (gfloat) 0);
	g_object_ref_sink (_tmp8_);
	description_label = _tmp8_;
	_tmp9_ = gtk_widget_get_style_context ((GtkWidget*) description_label);
	gtk_style_context_add_class (_tmp9_, GRANITE_STYLE_CLASS_SMALL_LABEL);
	_tmp10_ = gtk_widget_get_style_context ((GtkWidget*) description_label);
	gtk_style_context_add_class (_tmp10_, GTK_STYLE_CLASS_DIM_LABEL);
	_tmp11_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp11_, TRUE);
	g_object_ref_sink (_tmp11_);
	description_box = _tmp11_;
	gtk_container_add ((GtkContainer*) description_box, (GtkWidget*) name_label);
	gtk_container_add ((GtkContainer*) description_box, (GtkWidget*) description_label);
	_tmp12_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp12_, 6);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp12_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp12_, 6);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp12_, 6);
	g_object_ref_sink (_tmp12_);
	content = _tmp12_;
	gtk_container_add ((GtkContainer*) content, (GtkWidget*) image);
	gtk_container_add ((GtkContainer*) content, (GtkWidget*) description_box);
	gtk_container_add ((GtkContainer*) content, (GtkWidget*) _data39_->load_switch);
	_tmp13_ = peas_plugin_info_get_name (_data39_->info);
	_tmp14_ = g_strdup (_tmp13_);
	g_object_set_data_full ((GObject*) content, "name", _tmp14_, g_free);
	g_signal_connect_data ((GObject*) _data39_->load_switch, "notify::active", (GCallback) ___lambda68__g_object_notify, block39_data_ref (_data39_), (GClosureNotify) block39_data_unref, 0);
	result = (GtkWidget*) content;
	_g_object_unref0 (description_box);
	_g_object_unref0 (description_label);
	_g_object_unref0 (name_label);
	_g_object_unref0 (image);
	block39_data_unref (_data39_);
	_data39_ = NULL;
	return result;
}

guint
scratch_services_plugins_manager_get_n_plugins (ScratchServicesPluginsManager* self)
{
	PeasEngine* _tmp0_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->engine;
	result = g_list_model_get_n_items ((GListModel*) _tmp0_);
	return result;
}

ScratchServicesInterface*
scratch_services_plugins_manager_get_plugin_iface (ScratchServicesPluginsManager* self)
{
	ScratchServicesInterface* result;
	ScratchServicesInterface* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_plugin_iface;
	result = _tmp0_;
	return result;
}

static void
scratch_services_plugins_manager_set_plugin_iface (ScratchServicesPluginsManager* self,
                                                   ScratchServicesInterface* value)
{
	ScratchServicesInterface* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_services_plugins_manager_get_plugin_iface (self);
	if (old_value != value) {
		ScratchServicesInterface* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_plugin_iface);
		self->priv->_plugin_iface = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_services_plugins_manager_properties[SCRATCH_SERVICES_PLUGINS_MANAGER_PLUGIN_IFACE_PROPERTY]);
	}
}

ScratchMainWindow*
scratch_services_plugins_manager_get_window (ScratchServicesPluginsManager* self)
{
	ScratchMainWindow* result;
	ScratchMainWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_window;
	result = _tmp0_;
	return result;
}

static void
scratch_services_plugins_manager_set_window (ScratchServicesPluginsManager* self,
                                             ScratchMainWindow* value)
{
	ScratchMainWindow* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_services_plugins_manager_get_window (self);
	if (old_value != value) {
		self->priv->_window = value;
		g_object_notify_by_pspec ((GObject *) self, scratch_services_plugins_manager_properties[SCRATCH_SERVICES_PLUGINS_MANAGER_WINDOW_PROPERTY]);
	}
}

static void
_vala_GValue_array_free (GValue * array,
                         gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			g_value_unset (&array[i]);
		}
	}
	g_free (array);
}

static void
_scratch_services_plugins_manager___lambda72_ (ScratchServicesPluginsManager* self,
                                               PeasPluginInfo* info,
                                               GObject* ext)
{
	g_return_if_fail (info != NULL);
	g_return_if_fail (ext != NULL);
	scratch_services_activatable_plugin_activate (G_TYPE_CHECK_INSTANCE_CAST (ext, SCRATCH_SERVICES_TYPE_ACTIVATABLE_PLUGIN, ScratchServicesActivatablePlugin));
	g_signal_emit (self, scratch_services_plugins_manager_signals[SCRATCH_SERVICES_PLUGINS_MANAGER_EXTENSION_ADDED_SIGNAL], 0, info);
}

static void
__scratch_services_plugins_manager___lambda72__peas_extension_set_extension_added (PeasExtensionSet* _sender,
                                                                                   PeasPluginInfo* info,
                                                                                   GObject* extension,
                                                                                   gpointer self)
{
	_scratch_services_plugins_manager___lambda72_ ((ScratchServicesPluginsManager*) self, info, extension);
}

static void
_scratch_services_plugins_manager___lambda73_ (ScratchServicesPluginsManager* self,
                                               PeasPluginInfo* info,
                                               GObject* ext)
{
	g_return_if_fail (info != NULL);
	g_return_if_fail (ext != NULL);
	scratch_services_activatable_plugin_deactivate (G_TYPE_CHECK_INSTANCE_CAST (ext, SCRATCH_SERVICES_TYPE_ACTIVATABLE_PLUGIN, ScratchServicesActivatablePlugin));
	g_signal_emit (self, scratch_services_plugins_manager_signals[SCRATCH_SERVICES_PLUGINS_MANAGER_EXTENSION_REMOVED_SIGNAL], 0, info);
}

static void
__scratch_services_plugins_manager___lambda73__peas_extension_set_extension_removed (PeasExtensionSet* _sender,
                                                                                     PeasPluginInfo* info,
                                                                                     GObject* extension,
                                                                                     gpointer self)
{
	_scratch_services_plugins_manager___lambda73_ ((ScratchServicesPluginsManager*) self, info, extension);
}

static void
_scratch_services_plugins_manager___lambda74_ (PeasExtensionSet* exts,
                                               PeasPluginInfo* info,
                                               GObject* ext)
{
	g_return_if_fail (exts != NULL);
	g_return_if_fail (info != NULL);
	g_return_if_fail (ext != NULL);
	scratch_services_activatable_plugin_activate (G_TYPE_CHECK_INSTANCE_CAST (ext, SCRATCH_SERVICES_TYPE_ACTIVATABLE_PLUGIN, ScratchServicesActivatablePlugin));
}

static void
__scratch_services_plugins_manager___lambda74__peas_extension_set_foreach_func (PeasExtensionSet* set,
                                                                                PeasPluginInfo* info,
                                                                                GObject* extension,
                                                                                void* data)
{
	_scratch_services_plugins_manager___lambda74_ (set, info, extension);
}

static void
_scratch_services_plugins_manager___lambda75_ (ScratchServicesPluginsManager* self,
                                               ScratchMainWindow* w)
{
	ScratchServicesInterface* _tmp0_;
	g_return_if_fail (w != NULL);
	_tmp0_ = self->priv->_plugin_iface;
	g_signal_emit (_tmp0_, scratch_services_interface_signals[SCRATCH_SERVICES_INTERFACE_HOOK_WINDOW_SIGNAL], 0, w);
}

static void
__scratch_services_plugins_manager___lambda75__scratch_services_plugins_manager_hook_window (ScratchServicesPluginsManager* _sender,
                                                                                             ScratchMainWindow* window,
                                                                                             gpointer self)
{
	_scratch_services_plugins_manager___lambda75_ ((ScratchServicesPluginsManager*) self, window);
}

static void
_scratch_services_plugins_manager___lambda76_ (ScratchServicesPluginsManager* self,
                                               GMenuModel* m)
{
	ScratchServicesInterface* _tmp0_;
	g_return_if_fail (m != NULL);
	_tmp0_ = self->priv->_plugin_iface;
	g_signal_emit (_tmp0_, scratch_services_interface_signals[SCRATCH_SERVICES_INTERFACE_HOOK_SHARE_MENU_SIGNAL], 0, m);
}

static void
__scratch_services_plugins_manager___lambda76__scratch_services_plugins_manager_hook_share_menu (ScratchServicesPluginsManager* _sender,
                                                                                                 GMenuModel* menu,
                                                                                                 gpointer self)
{
	_scratch_services_plugins_manager___lambda76_ ((ScratchServicesPluginsManager*) self, menu);
}

static void
_scratch_services_plugins_manager___lambda77_ (ScratchServicesPluginsManager* self,
                                               ScratchHeaderBar* t)
{
	ScratchServicesInterface* _tmp0_;
	g_return_if_fail (t != NULL);
	_tmp0_ = self->priv->_plugin_iface;
	g_signal_emit (_tmp0_, scratch_services_interface_signals[SCRATCH_SERVICES_INTERFACE_HOOK_TOOLBAR_SIGNAL], 0, t);
}

static void
__scratch_services_plugins_manager___lambda77__scratch_services_plugins_manager_hook_toolbar (ScratchServicesPluginsManager* _sender,
                                                                                              ScratchHeaderBar* toolbar,
                                                                                              gpointer self)
{
	_scratch_services_plugins_manager___lambda77_ ((ScratchServicesPluginsManager*) self, toolbar);
}

static void
_scratch_services_plugins_manager___lambda78_ (ScratchServicesPluginsManager* self,
                                               ScratchServicesDocument* d)
{
	ScratchServicesInterface* _tmp0_;
	g_return_if_fail (d != NULL);
	_tmp0_ = self->priv->_plugin_iface;
	g_signal_emit (_tmp0_, scratch_services_interface_signals[SCRATCH_SERVICES_INTERFACE_HOOK_DOCUMENT_SIGNAL], 0, d);
}

static void
__scratch_services_plugins_manager___lambda78__scratch_services_plugins_manager_hook_document (ScratchServicesPluginsManager* _sender,
                                                                                               ScratchServicesDocument* doc,
                                                                                               gpointer self)
{
	_scratch_services_plugins_manager___lambda78_ ((ScratchServicesPluginsManager*) self, doc);
}

static void
_scratch_services_plugins_manager___lambda79_ (ScratchServicesPluginsManager* self,
                                               ScratchDialogsPreferences* d)
{
	ScratchServicesInterface* _tmp0_;
	g_return_if_fail (d != NULL);
	_tmp0_ = self->priv->_plugin_iface;
	g_signal_emit (_tmp0_, scratch_services_interface_signals[SCRATCH_SERVICES_INTERFACE_HOOK_PREFERENCES_DIALOG_SIGNAL], 0, d);
}

static void
__scratch_services_plugins_manager___lambda79__scratch_services_plugins_manager_hook_preferences_dialog (ScratchServicesPluginsManager* _sender,
                                                                                                         ScratchDialogsPreferences* dialog,
                                                                                                         gpointer self)
{
	_scratch_services_plugins_manager___lambda79_ ((ScratchServicesPluginsManager*) self, dialog);
}

static void
_scratch_services_plugins_manager___lambda80_ (ScratchServicesPluginsManager* self,
                                               GFile* source,
                                               GFile* dest,
                                               GFileMonitorEvent event)
{
	ScratchServicesInterface* _tmp0_;
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->_plugin_iface;
	g_signal_emit (_tmp0_, scratch_services_interface_signals[SCRATCH_SERVICES_INTERFACE_HOOK_FOLDER_ITEM_CHANGE_SIGNAL], 0, source, dest, event);
}

static void
__scratch_services_plugins_manager___lambda80__scratch_services_plugins_manager_hook_folder_item_change (ScratchServicesPluginsManager* _sender,
                                                                                                         GFile* file,
                                                                                                         GFile* other_file,
                                                                                                         GFileMonitorEvent event_type,
                                                                                                         gpointer self)
{
	_scratch_services_plugins_manager___lambda80_ ((ScratchServicesPluginsManager*) self, file, other_file, event_type);
}

static GObject *
scratch_services_plugins_manager_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ScratchServicesPluginsManager * self;
	ScratchServicesInterface* _tmp0_;
	ScratchServicesInterface* _tmp1_;
	PeasEngine* _tmp2_;
	PeasEngine* _tmp3_;
	PeasEngine* _tmp4_;
	PeasEngine* _tmp5_;
	GSettings* _tmp6_;
	PeasEngine* _tmp7_;
	PeasEngine* _tmp8_;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	ScratchServicesInterface* _tmp12_;
	GValue _tmp13_ = {0};
	GValue* _tmp14_;
	GValue* _tmp15_;
	gint _tmp15__length1;
	PeasExtensionSet* _tmp16_;
	PeasExtensionSet* _tmp17_;
	PeasExtensionSet* _tmp18_;
	PeasExtensionSet* _tmp19_;
	parent_class = G_OBJECT_CLASS (scratch_services_plugins_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_SERVICES_TYPE_PLUGINS_MANAGER, ScratchServicesPluginsManager);
	_tmp0_ = scratch_services_interface_new (self);
	_tmp1_ = _tmp0_;
	scratch_services_plugins_manager_set_plugin_iface (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = peas_engine_get_default ();
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->engine);
	self->priv->engine = _tmp3_;
	_tmp4_ = self->priv->engine;
	peas_engine_enable_loader (_tmp4_, "python");
	_tmp5_ = self->priv->engine;
	peas_engine_add_search_path (_tmp5_, CONSTANTS_PLUGINDIR, NULL);
	_tmp6_ = scratch_settings;
	_tmp7_ = self->priv->engine;
	g_settings_bind (_tmp6_, "plugins-enabled", (GObject*) _tmp7_, "loaded-plugins", G_SETTINGS_BIND_DEFAULT);
	_tmp8_ = self->priv->engine;
	_tmp9_ = g_strdup ("object");
	_tmp10_ = g_new0 (gchar*, 1 + 1);
	_tmp10_[0] = _tmp9_;
	_tmp11_ = _tmp10_;
	_tmp11__length1 = 1;
	_tmp12_ = self->priv->_plugin_iface;
	g_value_init (&_tmp13_, SCRATCH_SERVICES_TYPE_INTERFACE);
	g_value_set_object (&_tmp13_, _tmp12_);
	_tmp14_ = g_new0 (GValue, 1);
	_tmp14_[0] = _tmp13_;
	_tmp15_ = _tmp14_;
	_tmp15__length1 = 1;
	_tmp16_ = peas_extension_set_new_with_properties (_tmp8_, SCRATCH_SERVICES_TYPE_ACTIVATABLE_PLUGIN, 1, _tmp11_, _tmp15_);
	_g_object_unref0 (self->priv->extension_set);
	self->priv->extension_set = _tmp16_;
	_tmp15_ = (_vala_GValue_array_free (_tmp15_, _tmp15__length1), NULL);
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
	_tmp17_ = self->priv->extension_set;
	g_signal_connect_object (_tmp17_, "extension-added", (GCallback) __scratch_services_plugins_manager___lambda72__peas_extension_set_extension_added, self, 0);
	_tmp18_ = self->priv->extension_set;
	g_signal_connect_object (_tmp18_, "extension-removed", (GCallback) __scratch_services_plugins_manager___lambda73__peas_extension_set_extension_removed, self, 0);
	_tmp19_ = self->priv->extension_set;
	peas_extension_set_foreach (_tmp19_, __scratch_services_plugins_manager___lambda74__peas_extension_set_foreach_func, NULL);
	g_signal_connect_object (self, "hook-window", (GCallback) __scratch_services_plugins_manager___lambda75__scratch_services_plugins_manager_hook_window, self, 0);
	g_signal_connect_object (self, "hook-share-menu", (GCallback) __scratch_services_plugins_manager___lambda76__scratch_services_plugins_manager_hook_share_menu, self, 0);
	g_signal_connect_object (self, "hook-toolbar", (GCallback) __scratch_services_plugins_manager___lambda77__scratch_services_plugins_manager_hook_toolbar, self, 0);
	g_signal_connect_object (self, "hook-document", (GCallback) __scratch_services_plugins_manager___lambda78__scratch_services_plugins_manager_hook_document, self, 0);
	g_signal_connect_object (self, "hook-preferences-dialog", (GCallback) __scratch_services_plugins_manager___lambda79__scratch_services_plugins_manager_hook_preferences_dialog, self, 0);
	g_signal_connect_object (self, "hook-folder-item-change", (GCallback) __scratch_services_plugins_manager___lambda80__scratch_services_plugins_manager_hook_folder_item_change, self, 0);
	return obj;
}

static void
scratch_services_plugins_manager_class_init (ScratchServicesPluginsManagerClass * klass,
                                             gpointer klass_data)
{
	scratch_services_plugins_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ScratchServicesPluginsManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_scratch_services_plugins_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_scratch_services_plugins_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = scratch_services_plugins_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = scratch_services_plugins_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_SERVICES_PLUGINS_MANAGER_PLUGIN_IFACE_PROPERTY, scratch_services_plugins_manager_properties[SCRATCH_SERVICES_PLUGINS_MANAGER_PLUGIN_IFACE_PROPERTY] = g_param_spec_object ("plugin-iface", "plugin-iface", "plugin-iface", SCRATCH_SERVICES_TYPE_INTERFACE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_SERVICES_PLUGINS_MANAGER_WINDOW_PROPERTY, scratch_services_plugins_manager_properties[SCRATCH_SERVICES_PLUGINS_MANAGER_WINDOW_PROPERTY] = g_param_spec_object ("window", "window", "window", SCRATCH_TYPE_MAIN_WINDOW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	scratch_services_plugins_manager_signals[SCRATCH_SERVICES_PLUGINS_MANAGER_HOOK_WINDOW_SIGNAL] = g_signal_new ("hook-window", SCRATCH_SERVICES_TYPE_PLUGINS_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, SCRATCH_TYPE_MAIN_WINDOW);
	scratch_services_plugins_manager_signals[SCRATCH_SERVICES_PLUGINS_MANAGER_HOOK_SHARE_MENU_SIGNAL] = g_signal_new ("hook-share-menu", SCRATCH_SERVICES_TYPE_PLUGINS_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, g_menu_model_get_type ());
	scratch_services_plugins_manager_signals[SCRATCH_SERVICES_PLUGINS_MANAGER_HOOK_TOOLBAR_SIGNAL] = g_signal_new ("hook-toolbar", SCRATCH_SERVICES_TYPE_PLUGINS_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, SCRATCH_TYPE_HEADER_BAR);
	scratch_services_plugins_manager_signals[SCRATCH_SERVICES_PLUGINS_MANAGER_HOOK_DOCUMENT_SIGNAL] = g_signal_new ("hook-document", SCRATCH_SERVICES_TYPE_PLUGINS_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, SCRATCH_SERVICES_TYPE_DOCUMENT);
	scratch_services_plugins_manager_signals[SCRATCH_SERVICES_PLUGINS_MANAGER_HOOK_PREFERENCES_DIALOG_SIGNAL] = g_signal_new ("hook-preferences-dialog", SCRATCH_SERVICES_TYPE_PLUGINS_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, SCRATCH_DIALOGS_TYPE_PREFERENCES);
	scratch_services_plugins_manager_signals[SCRATCH_SERVICES_PLUGINS_MANAGER_HOOK_FOLDER_ITEM_CHANGE_SIGNAL] = g_signal_new ("hook-folder-item-change", SCRATCH_SERVICES_TYPE_PLUGINS_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_ENUM, G_TYPE_NONE, 3, g_file_get_type (), g_file_get_type (), g_file_monitor_event_get_type ());
	scratch_services_plugins_manager_signals[SCRATCH_SERVICES_PLUGINS_MANAGER_EXTENSION_ADDED_SIGNAL] = g_signal_new ("extension-added", SCRATCH_SERVICES_TYPE_PLUGINS_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, peas_plugin_info_get_type ());
	scratch_services_plugins_manager_signals[SCRATCH_SERVICES_PLUGINS_MANAGER_EXTENSION_REMOVED_SIGNAL] = g_signal_new ("extension-removed", SCRATCH_SERVICES_TYPE_PLUGINS_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, peas_plugin_info_get_type ());
}

static void
scratch_services_plugins_manager_instance_init (ScratchServicesPluginsManager * self,
                                                gpointer klass)
{
	self->priv = scratch_services_plugins_manager_get_instance_private (self);
}

static void
scratch_services_plugins_manager_finalize (GObject * obj)
{
	ScratchServicesPluginsManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_SERVICES_TYPE_PLUGINS_MANAGER, ScratchServicesPluginsManager);
	_g_object_unref0 (self->priv->engine);
	_g_object_unref0 (self->priv->extension_set);
	_g_object_unref0 (self->priv->_plugin_iface);
	G_OBJECT_CLASS (scratch_services_plugins_manager_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
scratch_services_plugins_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScratchServicesPluginsManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_services_plugins_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScratchServicesPluginsManager), 0, (GInstanceInitFunc) scratch_services_plugins_manager_instance_init, NULL };
	GType scratch_services_plugins_manager_type_id;
	scratch_services_plugins_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "ScratchServicesPluginsManager", &g_define_type_info, 0);
	ScratchServicesPluginsManager_private_offset = g_type_add_instance_private (scratch_services_plugins_manager_type_id, sizeof (ScratchServicesPluginsManagerPrivate));
	return scratch_services_plugins_manager_type_id;
}

GType
scratch_services_plugins_manager_get_type (void)
{
	static gsize scratch_services_plugins_manager_type_id__once = 0;
	if (g_once_init_enter (&scratch_services_plugins_manager_type_id__once)) {
		GType scratch_services_plugins_manager_type_id;
		scratch_services_plugins_manager_type_id = scratch_services_plugins_manager_get_type_once ();
		g_once_init_leave (&scratch_services_plugins_manager_type_id__once, scratch_services_plugins_manager_type_id);
	}
	return scratch_services_plugins_manager_type_id__once;
}

static void
_vala_scratch_services_plugins_manager_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec)
{
	ScratchServicesPluginsManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_SERVICES_TYPE_PLUGINS_MANAGER, ScratchServicesPluginsManager);
	switch (property_id) {
		case SCRATCH_SERVICES_PLUGINS_MANAGER_PLUGIN_IFACE_PROPERTY:
		g_value_set_object (value, scratch_services_plugins_manager_get_plugin_iface (self));
		break;
		case SCRATCH_SERVICES_PLUGINS_MANAGER_WINDOW_PROPERTY:
		g_value_set_object (value, scratch_services_plugins_manager_get_window (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_scratch_services_plugins_manager_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec)
{
	ScratchServicesPluginsManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_SERVICES_TYPE_PLUGINS_MANAGER, ScratchServicesPluginsManager);
	switch (property_id) {
		case SCRATCH_SERVICES_PLUGINS_MANAGER_PLUGIN_IFACE_PROPERTY:
		scratch_services_plugins_manager_set_plugin_iface (self, g_value_get_object (value));
		break;
		case SCRATCH_SERVICES_PLUGINS_MANAGER_WINDOW_PROPERTY:
		scratch_services_plugins_manager_set_window (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

