/*
Copyright The cert-manager Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// NameConstraintItemApplyConfiguration represents a declarative configuration of the NameConstraintItem type for use
// with apply.
type NameConstraintItemApplyConfiguration struct {
	DNSDomains     []string `json:"dnsDomains,omitempty"`
	IPRanges       []string `json:"ipRanges,omitempty"`
	EmailAddresses []string `json:"emailAddresses,omitempty"`
	URIDomains     []string `json:"uriDomains,omitempty"`
}

// NameConstraintItemApplyConfiguration constructs a declarative configuration of the NameConstraintItem type for use with
// apply.
func NameConstraintItem() *NameConstraintItemApplyConfiguration {
	return &NameConstraintItemApplyConfiguration{}
}

// WithDNSDomains adds the given value to the DNSDomains field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the DNSDomains field.
func (b *NameConstraintItemApplyConfiguration) WithDNSDomains(values ...string) *NameConstraintItemApplyConfiguration {
	for i := range values {
		b.DNSDomains = append(b.DNSDomains, values[i])
	}
	return b
}

// WithIPRanges adds the given value to the IPRanges field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the IPRanges field.
func (b *NameConstraintItemApplyConfiguration) WithIPRanges(values ...string) *NameConstraintItemApplyConfiguration {
	for i := range values {
		b.IPRanges = append(b.IPRanges, values[i])
	}
	return b
}

// WithEmailAddresses adds the given value to the EmailAddresses field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the EmailAddresses field.
func (b *NameConstraintItemApplyConfiguration) WithEmailAddresses(values ...string) *NameConstraintItemApplyConfiguration {
	for i := range values {
		b.EmailAddresses = append(b.EmailAddresses, values[i])
	}
	return b
}

// WithURIDomains adds the given value to the URIDomains field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the URIDomains field.
func (b *NameConstraintItemApplyConfiguration) WithURIDomains(values ...string) *NameConstraintItemApplyConfiguration {
	for i := range values {
		b.URIDomains = append(b.URIDomains, values[i])
	}
	return b
}
