/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client;

import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpClientConfigDefaults;
import com.ning.http.client.AsyncHttpProviderConfig;
import com.ning.http.client.ConnectionsPool;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.ProxyServerSelector;
import com.ning.http.client.Realm;
import com.ning.http.client.SSLEngineFactory;
import com.ning.http.client.filter.IOExceptionFilter;
import com.ning.http.client.filter.RequestFilter;
import com.ning.http.client.filter.ResponseFilter;
import com.ning.http.util.ProxyUtils;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncHttpClientConfigBean
extends AsyncHttpClientConfig {
    public AsyncHttpClientConfigBean() {
        this.configureExecutors();
        this.configureDefaults();
        this.configureFilters();
    }

    void configureFilters() {
        this.requestFilters = new LinkedList();
        this.responseFilters = new LinkedList();
        this.ioExceptionFilters = new LinkedList();
    }

    void configureDefaults() {
        this.maxTotalConnections = AsyncHttpClientConfigDefaults.defaultMaxTotalConnections();
        this.maxConnectionPerHost = AsyncHttpClientConfigDefaults.defaultMaxConnectionPerHost();
        this.connectionTimeOutInMs = AsyncHttpClientConfigDefaults.defaultConnectionTimeOutInMs();
        this.webSocketIdleTimeoutInMs = AsyncHttpClientConfigDefaults.defaultWebSocketIdleTimeoutInMs();
        this.idleConnectionInPoolTimeoutInMs = AsyncHttpClientConfigDefaults.defaultIdleConnectionInPoolTimeoutInMs();
        this.idleConnectionTimeoutInMs = AsyncHttpClientConfigDefaults.defaultIdleConnectionTimeoutInMs();
        this.requestTimeoutInMs = AsyncHttpClientConfigDefaults.defaultRequestTimeoutInMs();
        this.maxConnectionLifeTimeInMs = AsyncHttpClientConfigDefaults.defaultMaxConnectionLifeTimeInMs();
        this.redirectEnabled = AsyncHttpClientConfigDefaults.defaultRedirectEnabled();
        this.maxRedirects = AsyncHttpClientConfigDefaults.defaultMaxRedirects();
        this.compressionEnabled = AsyncHttpClientConfigDefaults.defaultCompressionEnabled();
        this.userAgent = AsyncHttpClientConfigDefaults.defaultUserAgent();
        this.allowPoolingConnection = AsyncHttpClientConfigDefaults.defaultAllowPoolingConnection();
        this.useRelativeURIsWithConnectProxies = AsyncHttpClientConfigDefaults.defaultUseRelativeURIsWithConnectProxies();
        this.requestCompressionLevel = AsyncHttpClientConfigDefaults.defaultRequestCompressionLevel();
        this.maxRequestRetry = AsyncHttpClientConfigDefaults.defaultMaxRequestRetry();
        this.ioThreadMultiplier = AsyncHttpClientConfigDefaults.defaultIoThreadMultiplier();
        this.allowSslConnectionPool = AsyncHttpClientConfigDefaults.defaultAllowSslConnectionPool();
        this.useRawUrl = AsyncHttpClientConfigDefaults.defaultUseRawUrl();
        this.removeQueryParamOnRedirect = AsyncHttpClientConfigDefaults.defaultRemoveQueryParamOnRedirect();
        this.strict302Handling = AsyncHttpClientConfigDefaults.defaultStrict302Handling();
        this.hostnameVerifier = AsyncHttpClientConfigDefaults.defaultHostnameVerifier();
        if (AsyncHttpClientConfigDefaults.defaultUseProxySelector()) {
            this.proxyServerSelector = ProxyUtils.getJdkDefaultProxyServerSelector();
        } else if (AsyncHttpClientConfigDefaults.defaultUseProxyProperties()) {
            this.proxyServerSelector = ProxyUtils.createProxyServerSelector(System.getProperties());
        }
    }

    void configureExecutors() {
        this.applicationThreadPool = Executors.newCachedThreadPool(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "AsyncHttpClient-Callback");
                t.setDaemon(true);
                return t;
            }
        });
    }

    public AsyncHttpClientConfigBean setMaxTotalConnections(int maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
        return this;
    }

    public AsyncHttpClientConfigBean setMaxConnectionPerHost(int maxConnectionPerHost) {
        this.maxConnectionPerHost = maxConnectionPerHost;
        return this;
    }

    public AsyncHttpClientConfigBean setConnectionTimeOutInMs(int connectionTimeOutInMs) {
        this.connectionTimeOutInMs = connectionTimeOutInMs;
        return this;
    }

    public AsyncHttpClientConfigBean setIdleConnectionInPoolTimeoutInMs(int idleConnectionInPoolTimeoutInMs) {
        this.idleConnectionInPoolTimeoutInMs = idleConnectionInPoolTimeoutInMs;
        return this;
    }

    public AsyncHttpClientConfigBean setStrict302Handling(boolean strict302Handling) {
        this.strict302Handling = strict302Handling;
        return this;
    }

    public AsyncHttpClientConfigBean setIdleConnectionTimeoutInMs(int idleConnectionTimeoutInMs) {
        this.idleConnectionTimeoutInMs = idleConnectionTimeoutInMs;
        return this;
    }

    public AsyncHttpClientConfigBean setRequestTimeoutInMs(int requestTimeoutInMs) {
        this.requestTimeoutInMs = requestTimeoutInMs;
        return this;
    }

    public AsyncHttpClientConfigBean setMaxConnectionLifeTimeInMs(int maxConnectionLifeTimeInMs) {
        this.maxConnectionLifeTimeInMs = maxConnectionLifeTimeInMs;
        return this;
    }

    public AsyncHttpClientConfigBean setRedirectEnabled(boolean redirectEnabled) {
        this.redirectEnabled = redirectEnabled;
        return this;
    }

    public AsyncHttpClientConfigBean setMaxRedirects(int maxRedirects) {
        this.maxRedirects = maxRedirects;
        return this;
    }

    public AsyncHttpClientConfigBean setCompressionEnabled(boolean compressionEnabled) {
        this.compressionEnabled = compressionEnabled;
        return this;
    }

    public AsyncHttpClientConfigBean setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public AsyncHttpClientConfigBean setAllowPoolingConnection(boolean allowPoolingConnection) {
        this.allowPoolingConnection = allowPoolingConnection;
        return this;
    }

    public AsyncHttpClientConfigBean setApplicationThreadPool(ExecutorService applicationThreadPool) {
        if (this.applicationThreadPool != null) {
            this.applicationThreadPool.shutdownNow();
        }
        this.applicationThreadPool = applicationThreadPool;
        return this;
    }

    public AsyncHttpClientConfigBean setProxyServer(ProxyServer proxyServer) {
        this.proxyServerSelector = ProxyUtils.createProxyServerSelector(proxyServer);
        return this;
    }

    public AsyncHttpClientConfigBean setProxyServerSelector(ProxyServerSelector proxyServerSelector) {
        this.proxyServerSelector = proxyServerSelector;
        return this;
    }

    public AsyncHttpClientConfigBean setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public AsyncHttpClientConfigBean setSslEngineFactory(SSLEngineFactory sslEngineFactory) {
        this.sslEngineFactory = sslEngineFactory;
        return this;
    }

    public AsyncHttpClientConfigBean setProviderConfig(AsyncHttpProviderConfig<?, ?> providerConfig) {
        this.providerConfig = providerConfig;
        return this;
    }

    public AsyncHttpClientConfigBean setConnectionsPool(ConnectionsPool<?, ?> connectionsPool) {
        this.connectionsPool = connectionsPool;
        return this;
    }

    public AsyncHttpClientConfigBean setRealm(Realm realm) {
        this.realm = realm;
        return this;
    }

    public AsyncHttpClientConfigBean addRequestFilter(RequestFilter requestFilter) {
        this.requestFilters.add(requestFilter);
        return this;
    }

    public AsyncHttpClientConfigBean addResponseFilters(ResponseFilter responseFilter) {
        this.responseFilters.add(responseFilter);
        return this;
    }

    public AsyncHttpClientConfigBean addIoExceptionFilters(IOExceptionFilter ioExceptionFilter) {
        this.ioExceptionFilters.add(ioExceptionFilter);
        return this;
    }

    public AsyncHttpClientConfigBean setRequestCompressionLevel(int requestCompressionLevel) {
        this.requestCompressionLevel = requestCompressionLevel;
        return this;
    }

    public AsyncHttpClientConfigBean setMaxRequestRetry(int maxRequestRetry) {
        this.maxRequestRetry = maxRequestRetry;
        return this;
    }

    public AsyncHttpClientConfigBean setAllowSslConnectionPool(boolean allowSslConnectionPool) {
        this.allowSslConnectionPool = allowSslConnectionPool;
        return this;
    }

    public AsyncHttpClientConfigBean setUseRawUrl(boolean useRawUrl) {
        this.useRawUrl = useRawUrl;
        return this;
    }

    public AsyncHttpClientConfigBean setRemoveQueryParamOnRedirect(boolean removeQueryParamOnRedirect) {
        this.removeQueryParamOnRedirect = removeQueryParamOnRedirect;
        return this;
    }

    public AsyncHttpClientConfigBean setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    public AsyncHttpClientConfigBean setIoThreadMultiplier(int ioThreadMultiplier) {
        this.ioThreadMultiplier = ioThreadMultiplier;
        return this;
    }
}

