/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.utils;

import java.io.IOException;
import org.apache.tez.common.ProtoConverters;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.recovery.records.RecoveryProtos;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.events.CompositeDataMovementEvent;
import org.apache.tez.runtime.api.events.DataMovementEvent;
import org.apache.tez.runtime.api.events.EventProtos;
import org.apache.tez.runtime.api.events.InputDataInformationEvent;
import org.apache.tez.runtime.api.events.InputInitializerEvent;
import org.apache.tez.runtime.api.events.VertexManagerEvent;
import org.apache.tez.runtime.api.impl.EventMetaData;
import org.apache.tez.runtime.api.impl.EventType;
import org.apache.tez.runtime.api.impl.TezEvent;

public class TezEventUtils {
    public static RecoveryProtos.TezEventProto toProto(TezEvent event) throws IOException {
        RecoveryProtos.TezEventProto.Builder evtBuilder = RecoveryProtos.TezEventProto.newBuilder();
        if (event.getEventType().equals((Object)EventType.COMPOSITE_DATA_MOVEMENT_EVENT)) {
            evtBuilder.setCompositeDataMovementEvent(ProtoConverters.convertCompositeDataMovementEventToProto((CompositeDataMovementEvent)((CompositeDataMovementEvent)event.getEvent())));
        } else if (event.getEventType().equals((Object)EventType.DATA_MOVEMENT_EVENT)) {
            evtBuilder.setDataMovementEvent(ProtoConverters.convertDataMovementEventToProto((DataMovementEvent)((DataMovementEvent)event.getEvent())));
        } else if (event.getEventType().equals((Object)EventType.ROOT_INPUT_INITIALIZER_EVENT)) {
            evtBuilder.setInputInitializerEvent(ProtoConverters.convertRootInputInitializerEventToProto((InputInitializerEvent)((InputInitializerEvent)event.getEvent())));
        } else if (event.getEventType().equals((Object)EventType.VERTEX_MANAGER_EVENT)) {
            evtBuilder.setVmEvent(ProtoConverters.convertVertexManagerEventToProto((VertexManagerEvent)((VertexManagerEvent)event.getEvent())));
        } else if (event.getEventType().equals((Object)EventType.ROOT_INPUT_DATA_INFORMATION_EVENT)) {
            evtBuilder.setRootInputDataInformationEvent(ProtoConverters.convertRootInputDataInformationEventToProto((InputDataInformationEvent)((InputDataInformationEvent)event.getEvent())));
        } else {
            throw new IOException("Unsupported TezEvent type:" + event.getEventType());
        }
        if (event.getSourceInfo() != null) {
            evtBuilder.setSourceInfo(TezEventUtils.convertEventMetaDataToProto(event.getSourceInfo()));
        }
        if (event.getDestinationInfo() != null) {
            evtBuilder.setDestinationInfo(TezEventUtils.convertEventMetaDataToProto(event.getDestinationInfo()));
        }
        evtBuilder.setEventTime(event.getEventReceivedTime());
        return evtBuilder.build();
    }

    public static TezEvent fromProto(RecoveryProtos.TezEventProto eventProto) throws IOException {
        CompositeDataMovementEvent evt = null;
        if (eventProto.hasCompositeDataMovementEvent()) {
            evt = ProtoConverters.convertCompositeDataMovementEventFromProto((EventProtos.CompositeEventProto)eventProto.getCompositeDataMovementEvent());
        } else if (eventProto.hasDataMovementEvent()) {
            evt = ProtoConverters.convertDataMovementEventFromProto((EventProtos.DataMovementEventProto)eventProto.getDataMovementEvent());
        } else if (eventProto.hasInputInitializerEvent()) {
            evt = ProtoConverters.convertRootInputInitializerEventFromProto((EventProtos.RootInputInitializerEventProto)eventProto.getInputInitializerEvent());
        } else if (eventProto.hasVmEvent()) {
            evt = ProtoConverters.convertVertexManagerEventFromProto((EventProtos.VertexManagerEventProto)eventProto.getVmEvent());
        } else if (eventProto.hasRootInputDataInformationEvent()) {
            evt = ProtoConverters.convertRootInputDataInformationEventFromProto((EventProtos.RootInputDataInformationEventProto)eventProto.getRootInputDataInformationEvent());
        } else {
            throw new IOException("Unsupported TezEvent type");
        }
        EventMetaData sourceInfo = null;
        EventMetaData destinationInfo = null;
        if (eventProto.hasSourceInfo()) {
            sourceInfo = TezEventUtils.convertEventMetaDataFromProto(eventProto.getSourceInfo());
        }
        if (eventProto.hasDestinationInfo()) {
            destinationInfo = TezEventUtils.convertEventMetaDataFromProto(eventProto.getDestinationInfo());
        }
        TezEvent tezEvent = new TezEvent((Event)evt, sourceInfo, eventProto.getEventTime());
        tezEvent.setDestinationInfo(destinationInfo);
        return tezEvent;
    }

    public static RecoveryProtos.EventMetaDataProto convertEventMetaDataToProto(EventMetaData eventMetaData) {
        RecoveryProtos.EventMetaDataProto.Builder builder = RecoveryProtos.EventMetaDataProto.newBuilder().setProducerConsumerType(eventMetaData.getEventGenerator().ordinal()).setEdgeVertexName(eventMetaData.getEdgeVertexName()).setTaskVertexName(eventMetaData.getTaskVertexName());
        if (eventMetaData.getTaskAttemptID() != null) {
            builder.setTaskAttemptId(eventMetaData.getTaskAttemptID().toString());
        }
        return builder.build();
    }

    public static EventMetaData convertEventMetaDataFromProto(RecoveryProtos.EventMetaDataProto proto) {
        TezTaskAttemptID attemptID = null;
        if (proto.hasTaskAttemptId()) {
            attemptID = TezTaskAttemptID.fromString((String)proto.getTaskAttemptId());
        }
        return new EventMetaData(EventMetaData.EventProducerConsumerType.values()[proto.getProducerConsumerType()], proto.getTaskVertexName(), proto.getEdgeVertexName(), attemptID);
    }
}

