/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.speculation.legacy;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.tez.dag.api.oldrecords.TaskAttemptState;
import org.apache.tez.dag.app.dag.Task;
import org.apache.tez.dag.app.dag.TaskAttempt;
import org.apache.tez.dag.app.dag.speculation.legacy.StartEndTimesBase;
import org.apache.tez.dag.records.TezTaskAttemptID;

public class LegacyTaskRuntimeEstimator
extends StartEndTimesBase {
    private final Map<TaskAttempt, AtomicLong> attemptRuntimeEstimates = new ConcurrentHashMap<TaskAttempt, AtomicLong>();
    private final ConcurrentHashMap<TaskAttempt, AtomicLong> attemptRuntimeEstimateVariances = new ConcurrentHashMap();

    @Override
    public void updateAttempt(TezTaskAttemptID attemptID, TaskAttemptState state, long timestamp) {
        long start;
        super.updateAttempt(attemptID, state, timestamp);
        Task task = this.vertex.getTask(attemptID.getTaskID());
        if (task == null) {
            return;
        }
        TaskAttempt taskAttempt = task.getAttempt(attemptID);
        if (taskAttempt == null) {
            return;
        }
        float progress = taskAttempt.getProgress();
        Long boxedStart = (Long)this.startTimes.get(attemptID);
        long l = start = boxedStart == null ? Long.MIN_VALUE : boxedStart;
        if (taskAttempt.getState() == TaskAttemptState.RUNNING) {
            AtomicLong estimateContainer = this.attemptRuntimeEstimates.get(taskAttempt);
            AtomicLong estimateVarianceContainer = this.attemptRuntimeEstimateVariances.get(taskAttempt);
            if (estimateContainer == null && this.attemptRuntimeEstimates.get(taskAttempt) == null) {
                this.attemptRuntimeEstimates.put(taskAttempt, new AtomicLong());
                estimateContainer = this.attemptRuntimeEstimates.get(taskAttempt);
            }
            if (estimateVarianceContainer == null) {
                this.attemptRuntimeEstimateVariances.putIfAbsent(taskAttempt, new AtomicLong());
                estimateVarianceContainer = this.attemptRuntimeEstimateVariances.get(taskAttempt);
            }
            long estimate = -1L;
            long varianceEstimate = -1L;
            if (start > 0L && timestamp > start) {
                estimate = (long)((double)(timestamp - start) / Math.max(1.0E-4, (double)progress));
                varianceEstimate = (long)((float)estimate * progress / 10.0f);
            }
            if (estimateContainer != null) {
                estimateContainer.set(estimate);
            }
            if (estimateVarianceContainer != null) {
                estimateVarianceContainer.set(varianceEstimate);
            }
        }
    }

    private long storedPerAttemptValue(Map<TaskAttempt, AtomicLong> data, TezTaskAttemptID attemptID) {
        Task task = this.vertex.getTask(attemptID.getTaskID());
        if (task == null) {
            return -1L;
        }
        TaskAttempt taskAttempt = task.getAttempt(attemptID);
        if (taskAttempt == null) {
            return -1L;
        }
        AtomicLong estimate = data.get(taskAttempt);
        return estimate == null ? -1L : estimate.get();
    }

    @Override
    public long estimatedRuntime(TezTaskAttemptID attemptID) {
        return this.storedPerAttemptValue(this.attemptRuntimeEstimates, attemptID);
    }

    @Override
    public long runtimeEstimateVariance(TezTaskAttemptID attemptID) {
        return this.storedPerAttemptValue(this.attemptRuntimeEstimateVariances, attemptID);
    }
}

