/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.metrics;

import java.util.List;
import org.apache.hadoop.fs.FileSystem;
import org.apache.tez.common.counters.FileSystemCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;

public class FileSystemStatisticUpdater {
    private List<FileSystem.Statistics> stats;
    private TezCounter readBytesCounter;
    private TezCounter writeBytesCounter;
    private TezCounter readOpsCounter;
    private TezCounter largeReadOpsCounter;
    private TezCounter writeOpsCounter;
    private String scheme;
    private TezCounters counters;

    FileSystemStatisticUpdater(TezCounters counters, List<FileSystem.Statistics> stats, String scheme) {
        this.stats = stats;
        this.scheme = scheme;
        this.counters = counters;
    }

    void updateCounters() {
        if (this.readBytesCounter == null) {
            this.readBytesCounter = this.counters.findCounter(this.scheme, FileSystemCounter.BYTES_READ);
        }
        if (this.writeBytesCounter == null) {
            this.writeBytesCounter = this.counters.findCounter(this.scheme, FileSystemCounter.BYTES_WRITTEN);
        }
        if (this.readOpsCounter == null) {
            this.readOpsCounter = this.counters.findCounter(this.scheme, FileSystemCounter.READ_OPS);
        }
        if (this.largeReadOpsCounter == null) {
            this.largeReadOpsCounter = this.counters.findCounter(this.scheme, FileSystemCounter.LARGE_READ_OPS);
        }
        if (this.writeOpsCounter == null) {
            this.writeOpsCounter = this.counters.findCounter(this.scheme, FileSystemCounter.WRITE_OPS);
        }
        long readBytes = 0L;
        long writeBytes = 0L;
        long readOps = 0L;
        long largeReadOps = 0L;
        long writeOps = 0L;
        for (FileSystem.Statistics stat : this.stats) {
            readBytes += stat.getBytesRead();
            writeBytes += stat.getBytesWritten();
            readOps += (long)stat.getReadOps();
            largeReadOps += (long)stat.getLargeReadOps();
            writeOps += (long)stat.getWriteOps();
        }
        this.readBytesCounter.setValue(readBytes);
        this.writeBytesCounter.setValue(writeBytes);
        this.readOpsCounter.setValue(readOps);
        this.largeReadOpsCounter.setValue(largeReadOps);
        this.writeOpsCounter.setValue(writeOps);
    }
}

