/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.examples;

import java.text.DecimalFormat;
import org.apache.hadoop.util.ProgramDriver;
import org.apache.tez.examples.CartesianProduct;
import org.apache.tez.examples.HashJoinExample;
import org.apache.tez.examples.JoinDataGen;
import org.apache.tez.examples.JoinValidate;
import org.apache.tez.examples.OrderedWordCount;
import org.apache.tez.examples.SimpleSessionExample;
import org.apache.tez.examples.SortMergeJoinExample;
import org.apache.tez.examples.WordCount;

public class ExampleDriver {
    private static final DecimalFormat formatter = new DecimalFormat("###.##%");

    public static void main(String[] argv) {
        int exitCode = -1;
        ProgramDriver pgd = new ProgramDriver();
        try {
            pgd.addClass("wordcount", WordCount.class, "A native Tez wordcount program that counts the words in the input files.");
            pgd.addClass("orderedwordcount", OrderedWordCount.class, "Word Count with words sorted on frequency");
            pgd.addClass("simplesessionexample", SimpleSessionExample.class, "Example to run multiple dags in a session");
            pgd.addClass("hashjoin", HashJoinExample.class, "Identify all occurences of lines in file1 which also occur in file2 using hash join");
            pgd.addClass("sortmergejoin", SortMergeJoinExample.class, "Identify all occurences of lines in file1 which also occur in file2 using sort merge join");
            pgd.addClass("joindatagen", JoinDataGen.class, "Generate data to run the joinexample");
            pgd.addClass("joinvalidate", JoinValidate.class, "Validate data generated by joinexample and joindatagen");
            pgd.addClass("cartesianproduct", CartesianProduct.class, "Cartesian product of two datasets");
            exitCode = pgd.run(argv);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        System.exit(exitCode);
    }
}

