/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.hadoop.shim;

import com.google.common.annotations.VisibleForTesting;
import java.util.ServiceLoader;
import java.util.StringTokenizer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.VersionInfo;
import org.apache.tez.hadoop.shim.DefaultHadoopShim;
import org.apache.tez.hadoop.shim.HadoopShim;
import org.apache.tez.hadoop.shim.HadoopShimProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HadoopShimsLoader {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopShimsLoader.class);
    private static ServiceLoader<HadoopShimProvider> shimLoader = ServiceLoader.load(HadoopShimProvider.class);
    private final HadoopShim currentShim;
    private final HadoopShimProvider currentShimProvider;
    public static final String TEZ_HADOOP_SHIM_PROVIDER_CLASS = "tez.hadoop.shim.provider.class";
    @InterfaceAudience.Private
    @VisibleForTesting
    static final String TEZ_HADOOP_SHIM_HADOOP_VERSION_OVERRIDE = "tez.hadoop.shim.hadoop.version.override";

    public HadoopShimsLoader(Configuration conf) {
        this(conf, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    HadoopShimsLoader(Configuration conf, boolean useReflection) {
        String overrideProviderClassStr = conf.get(TEZ_HADOOP_SHIM_PROVIDER_CLASS);
        if (overrideProviderClassStr != null && !overrideProviderClassStr.isEmpty()) {
            LOG.info("HadoopShim Selection is overridden, using Configured Provider=" + overrideProviderClassStr);
        } else {
            overrideProviderClassStr = null;
        }
        String versionStr = VersionInfo.getVersion();
        String overrideVersionStr = conf.get(TEZ_HADOOP_SHIM_HADOOP_VERSION_OVERRIDE);
        if (overrideVersionStr != null && !overrideVersionStr.isEmpty()) {
            LOG.warn("Using overridden hadoop version instead of actual version, realVersion=" + versionStr + ", overrideVersion=" + overrideVersionStr);
            versionStr = overrideVersionStr;
        }
        Version version = new Version(versionStr);
        HadoopShim selectedShim = null;
        HadoopShimProvider selectedShimProvider = null;
        LOG.info("Trying to locate HadoopShimProvider for hadoopVersion=" + versionStr + ", majorVersion=" + version.majorVersion + ", minorVersion=" + version.minorVersion);
        ServiceLoader<HadoopShimProvider> serviceLoader = shimLoader;
        synchronized (serviceLoader) {
            for (HadoopShimProvider provider : shimLoader) {
                if (overrideProviderClassStr != null && !provider.getClass().getName().equals(overrideProviderClassStr)) {
                    LOG.debug("Skipping HadoopShimProvider : " + provider.getClass().getName() + " as config provided to override selection");
                    continue;
                }
                LOG.debug("Trying HadoopShimProvider : " + provider.getClass().getName());
                HadoopShim hadoopShim = null;
                try {
                    hadoopShim = provider.createHadoopShim(versionStr, version.majorVersion, version.minorVersion);
                    if (hadoopShim != null) {
                        selectedShim = hadoopShim;
                        selectedShimProvider = provider;
                        break;
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Cannot pick " + provider.getClass().getName() + " as the HadoopShimProvider - returned null hadoop shim");
                }
                catch (Exception e) {
                    LOG.info("Failed to use " + provider.getClass().getName() + " due to error: ", (Throwable)e);
                }
            }
            if (selectedShim == null && useReflection && overrideProviderClassStr != null) {
                try {
                    LOG.debug("Using Reflection to create HadoopShim from provider class=" + overrideProviderClassStr);
                    Class<?> clazz = Class.forName(overrideProviderClassStr, true, Thread.currentThread().getContextClassLoader());
                    selectedShimProvider = (HadoopShimProvider)clazz.newInstance();
                    selectedShim = selectedShimProvider.createHadoopShim(versionStr, version.majorVersion, version.minorVersion);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to create HadoopShim from provider class: " + overrideProviderClassStr, e);
                }
            }
            if (selectedShim == null) {
                this.currentShim = new DefaultHadoopShim();
                this.currentShimProvider = null;
            } else {
                this.currentShim = selectedShim;
                this.currentShimProvider = selectedShimProvider;
            }
        }
        LOG.info("Picked HadoopShim " + this.currentShim.getClass().getName() + ", providerName=" + (this.currentShimProvider != null ? this.currentShimProvider.getClass().getName() : "null") + ", overrideProviderViaConfig=" + overrideProviderClassStr + ", hadoopVersion=" + versionStr + ", majorVersion=" + version.majorVersion + ", minorVersion=" + version.minorVersion);
    }

    public HadoopShim getHadoopShim() {
        return this.currentShim;
    }

    private static class Version {
        int majorVersion = -1;
        int minorVersion = -1;

        public Version(String versionString) {
            String token;
            int index = 0;
            StringTokenizer tokenizer = new StringTokenizer(versionString, ".-", true);
            while (tokenizer.hasMoreTokens() && !(token = tokenizer.nextToken()).equals("-")) {
                if (token.equals(".")) continue;
                try {
                    int i = Integer.parseInt(token);
                    if (index == 0) {
                        this.majorVersion = i;
                    } else if (index == 1) {
                        this.minorVersion = i;
                        break;
                    }
                    ++index;
                }
                catch (NumberFormatException nfe) {
                    break;
                }
            }
        }
    }
}

