/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Private
public final class ConfigUtils {
    private ConfigUtils() {
    }

    public static Class<? extends CompressionCodec> getIntermediateOutputCompressorClass(Configuration conf, Class<DefaultCodec> defaultValue) {
        Class<DefaultCodec> codecClass = defaultValue;
        String name = conf.get("tez.runtime.compress.codec");
        if (name != null) {
            try {
                codecClass = conf.getClassByName(name).asSubclass(CompressionCodec.class);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Compression codec " + name + " was not found.", e);
            }
        }
        return codecClass;
    }

    public static boolean shouldCompressIntermediateOutput(Configuration conf) {
        return conf.getBoolean("tez.runtime.compress", false);
    }

    public static <V> Class<V> getIntermediateOutputValueClass(Configuration conf) {
        return conf.getClass("tez.runtime.value.class", null, Object.class);
    }

    public static <V> Class<V> getIntermediateInputValueClass(Configuration conf) {
        return conf.getClass("tez.runtime.value.class", null, Object.class);
    }

    public static <K> Class<K> getIntermediateOutputKeyClass(Configuration conf) {
        return conf.getClass("tez.runtime.key.class", null, Object.class);
    }

    public static <K> Class<K> getIntermediateInputKeyClass(Configuration conf) {
        return conf.getClass("tez.runtime.key.class", null, Object.class);
    }

    public static <K> RawComparator<K> getIntermediateOutputKeyComparator(Configuration conf) {
        Class theClass = conf.getClass("tez.runtime.key.comparator.class", null, RawComparator.class);
        if (theClass != null) {
            return (RawComparator)ReflectionUtils.newInstance((Class)theClass, (Configuration)conf);
        }
        return WritableComparator.get(ConfigUtils.getIntermediateOutputKeyClass(conf).asSubclass(WritableComparable.class), (Configuration)conf);
    }

    public static <K> RawComparator<K> getIntermediateInputKeyComparator(Configuration conf) {
        Class theClass = conf.getClass("tez.runtime.key.comparator.class", null, RawComparator.class);
        if (theClass != null) {
            return (RawComparator)ReflectionUtils.newInstance((Class)theClass, (Configuration)conf);
        }
        return WritableComparator.get(ConfigUtils.getIntermediateInputKeyClass(conf).asSubclass(WritableComparable.class), (Configuration)conf);
    }

    public static <V> RawComparator<V> getInputKeySecondaryGroupingComparator(Configuration conf) {
        Class theClass = conf.getClass("tez.runtime.key.secondary.comparator.class", null, RawComparator.class);
        if (theClass == null) {
            return ConfigUtils.getIntermediateInputKeyComparator(conf);
        }
        return (RawComparator)ReflectionUtils.newInstance((Class)theClass, (Configuration)conf);
    }

    public static boolean useNewApi(Configuration conf) {
        return conf.getBoolean("mapred.mapper.new-api", false);
    }

    @InterfaceAudience.Private
    public static Map<String, String> extractConfigurationMap(Map<String, String> confMap, Set<String> allowedKeys) {
        Objects.requireNonNull(confMap, "ConfMap cannot be null");
        Objects.requireNonNull(allowedKeys, "Valid key set cannot be empty");
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : confMap.entrySet()) {
            if (!allowedKeys.contains(entry.getKey())) continue;
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    @InterfaceAudience.Private
    public static void addConfigMapToConfiguration(Configuration conf, Map<String, String> confMap) {
        Objects.requireNonNull(conf, "Configuration cannot be null");
        Objects.requireNonNull(confMap, "Configuration map cannot be null");
        for (Map.Entry<String, String> entry : confMap.entrySet()) {
            conf.set(entry.getKey(), entry.getValue());
        }
    }

    @InterfaceAudience.Private
    public static Map<String, String> extractConfigurationMap(Map<String, String> confMap, List<Set<String>> validKeySets, List<String> allowedPrefixes) {
        Objects.requireNonNull(confMap, "ConfMap cannot be null");
        Objects.requireNonNull(validKeySets, "Valid key set cannot be empty");
        Objects.requireNonNull(allowedPrefixes, "Allowed prefixes cannot be null");
        return ConfigUtils.extractConfigurationMapInternal(confMap.entrySet(), validKeySets, allowedPrefixes);
    }

    @InterfaceAudience.Private
    public static Map<String, String> extractConfigurationMap(Configuration conf, List<Set<String>> validKeySets, List<String> allowedPrefixes) {
        Objects.requireNonNull(conf, "conf cannot be null");
        Objects.requireNonNull(validKeySets, "Valid key set cannot be empty");
        Objects.requireNonNull(allowedPrefixes, "Allowed prefixes cannot be null");
        return ConfigUtils.extractConfigurationMapInternal((Iterable<Map.Entry<String, String>>)conf, validKeySets, allowedPrefixes);
    }

    @InterfaceAudience.Private
    public static boolean doesKeyQualify(String key, List<Set<String>> validKeySets, List<String> allowedPrefixes) {
        Objects.requireNonNull(key, "key cannot be null");
        Objects.requireNonNull(validKeySets, "Valid key set cannot be empty");
        Objects.requireNonNull(allowedPrefixes, "Allowed prefixes cannot be null");
        for (Set<String> set : validKeySets) {
            if (!set.contains(key)) continue;
            return true;
        }
        for (String prefix : allowedPrefixes) {
            if (!key.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    @InterfaceAudience.Private
    public static void mergeConfsWithExclusions(Configuration destConf, Map<String, String> srcConf, Set<String> excludedKeySet) {
        Objects.requireNonNull(destConf, "Destination conf cannot be null");
        Objects.requireNonNull(srcConf, "Source conf cannot be null");
        for (Map.Entry<String, String> entry : srcConf.entrySet()) {
            if (excludedKeySet.contains(entry.getKey())) continue;
            destConf.set(entry.getKey(), entry.getValue());
        }
    }

    public static void mergeConfs(Configuration destConf, Configuration srcConf) {
        Objects.requireNonNull(destConf, "Destination conf cannot be null");
        Objects.requireNonNull(srcConf, "Source conf cannot be null");
        for (Map.Entry entry : srcConf) {
            String val = srcConf.get((String)entry.getKey());
            destConf.set((String)entry.getKey(), val);
        }
    }

    private static Map<String, String> extractConfigurationMapInternal(Iterable<Map.Entry<String, String>> iterable, List<Set<String>> validKeySets, List<String> allowedPrefixes) {
        HashSet<String> validKeys = new HashSet<String>();
        for (Set<String> set : validKeySets) {
            validKeys.addAll(set);
        }
        HashMap<String, String> localConfMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : iterable) {
            if (validKeys.contains(entry.getKey())) {
                localConfMap.put(entry.getKey(), entry.getValue());
                continue;
            }
            for (String prefix : allowedPrefixes) {
                if (!entry.getKey().startsWith(prefix)) continue;
                localConfMap.put(entry.getKey(), entry.getValue());
            }
        }
        return localConfMap;
    }
}

