/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.hadoop;

import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.tez.common.counters.CounterGroup;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.mapreduce.hadoop.IDConverter;

public final class TezTypeConverters {
    private TezTypeConverters() {
    }

    public static JobID toJobID(TezDAGID id) {
        return new JobID(String.valueOf(id.getApplicationId().getClusterTimestamp()), id.getId());
    }

    public static TaskAttemptId toYarn(TezTaskAttemptID taskAttemptId) {
        org.apache.hadoop.mapred.TaskAttemptID mrTaskAttemptId = IDConverter.toMRTaskAttemptId(taskAttemptId);
        return TypeConverter.toYarn((org.apache.hadoop.mapred.TaskAttemptID)mrTaskAttemptId);
    }

    public static TezTaskAttemptID toTez(TaskAttemptId taskAttemptId) {
        org.apache.hadoop.mapred.TaskAttemptID mrTaskAttemptId = TypeConverter.fromYarn((TaskAttemptId)taskAttemptId);
        return IDConverter.fromMRTaskAttemptId((TaskAttemptID)mrTaskAttemptId);
    }

    public static Counters fromTez(TezCounters tezCounters) {
        if (tezCounters == null) {
            return null;
        }
        Counters counters = new Counters();
        for (CounterGroup xGrp : tezCounters) {
            counters.addGroup(xGrp.getName(), xGrp.getDisplayName());
            for (TezCounter xCounter : xGrp) {
                Counter counter = counters.findCounter(xGrp.getName(), xCounter.getName());
                counter.setValue(xCounter.getValue());
            }
        }
        return counters;
    }
}

