/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.records;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.tez.dag.records.DAGIDAware;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezID;
import org.apache.tez.util.FastNumberFormat;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class TezVertexID
extends TezID
implements DAGIDAware {
    public static final String VERTEX = "vertex";
    static final ThreadLocal<FastNumberFormat> tezVertexIdFormat = new ThreadLocal<FastNumberFormat>(){

        @Override
        public FastNumberFormat initialValue() {
            FastNumberFormat fmt = FastNumberFormat.getInstance();
            fmt.setMinimumIntegerDigits(2);
            return fmt;
        }
    };
    private static Interner<TezVertexID> tezVertexIDCache = Interners.newWeakInterner();
    private TezDAGID dagId;

    public TezVertexID() {
    }

    public static TezVertexID getInstance(TezDAGID dagId, int id) {
        Objects.requireNonNull(dagId, "DagID cannot be null");
        return (TezVertexID)tezVertexIDCache.intern((Object)new TezVertexID(dagId, id));
    }

    private TezVertexID(TezDAGID dagId, int id) {
        super(id);
        this.dagId = dagId;
    }

    @Override
    public TezDAGID getDAGID() {
        return this.dagId;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        TezVertexID that = (TezVertexID)o;
        return this.dagId.equals(that.dagId);
    }

    @Override
    public int compareTo(TezID o) {
        TezVertexID that = (TezVertexID)o;
        return this.dagId.compareTo(that.dagId);
    }

    @Override
    public String toString() {
        return this.appendTo(new StringBuilder(VERTEX)).toString();
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.dagId = TezDAGID.readTezDAGID(in);
        super.readFields(in);
    }

    public static TezVertexID readTezVertexID(DataInput in) throws IOException {
        TezDAGID dagID = TezDAGID.readTezDAGID(in);
        int vertexIdInt = TezID.readID(in);
        return TezVertexID.getInstance(dagID, vertexIdInt);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        this.dagId.write(out);
        super.write(out);
    }

    protected StringBuilder appendTo(StringBuilder builder) {
        this.dagId.appendTo(builder);
        builder.append('_');
        return tezVertexIdFormat.get().format(this.id, builder);
    }

    @Override
    public int hashCode() {
        return this.dagId.hashCode() * 530017 + this.id;
    }

    public static TezVertexID fromString(String vertexIdStr) {
        try {
            int pos1 = vertexIdStr.indexOf(95);
            int pos2 = vertexIdStr.indexOf(95, pos1 + 1);
            int pos3 = vertexIdStr.indexOf(95, pos2 + 1);
            int pos4 = vertexIdStr.indexOf(95, pos3 + 1);
            String rmId = vertexIdStr.substring(pos1 + 1, pos2);
            int appId = Integer.parseInt(vertexIdStr.substring(pos2 + 1, pos3));
            int dagId = Integer.parseInt(vertexIdStr.substring(pos3 + 1, pos4));
            int id = Integer.parseInt(vertexIdStr.substring(pos4 + 1));
            return TezVertexID.getInstance(TezDAGID.getInstance(rmId, appId, dagId), id);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

