/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.logging.ats;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntityGroupId;
import org.apache.hadoop.yarn.server.timeline.NameValuePair;
import org.apache.hadoop.yarn.server.timeline.TimelineEntityGroupPlugin;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.history.logging.EntityTypes;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimelineCachePluginImpl
extends TimelineEntityGroupPlugin
implements Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(TimelineCachePluginImpl.class);
    private static Set<String> summaryEntityTypes;
    private static Set<String> knownEntityTypes;
    private Configuration conf;
    private Set<Integer> allNumGroupsPerDag;

    public TimelineCachePluginImpl() {
        this.setConf((Configuration)new TezConfiguration());
    }

    private Set<TimelineEntityGroupId> createTimelineEntityGroupIds(TezDAGID dagId) {
        ApplicationId appId = dagId.getApplicationId();
        HashSet groupIds = Sets.newHashSet((Object[])new TimelineEntityGroupId[]{TimelineEntityGroupId.newInstance((ApplicationId)appId, (String)dagId.toString())});
        for (int numGroupsPerDag : this.allNumGroupsPerDag) {
            groupIds.add(TimelineEntityGroupId.newInstance((ApplicationId)appId, (String)dagId.getGroupId(numGroupsPerDag)));
        }
        return groupIds;
    }

    private Set<TimelineEntityGroupId> convertToTimelineEntityGroupIds(String entityType, String entityId) {
        if (entityType == null || entityType.isEmpty() || entityId == null || entityId.isEmpty()) {
            return null;
        }
        if (entityType.equals(EntityTypes.TEZ_DAG_ID.name()) || entityType.equals(EntityTypes.TEZ_DAG_EXTRA_INFO.name())) {
            TezDAGID dagId = TezDAGID.fromString((String)entityId);
            if (dagId != null) {
                return this.createTimelineEntityGroupIds(dagId);
            }
        } else if (entityType.equals(EntityTypes.TEZ_VERTEX_ID.name())) {
            TezVertexID vertexID = TezVertexID.fromString((String)entityId);
            if (vertexID != null) {
                return this.createTimelineEntityGroupIds(vertexID.getDAGID());
            }
        } else if (entityType.equals(EntityTypes.TEZ_TASK_ID.name())) {
            TezTaskID taskID = TezTaskID.fromString((String)entityId);
            if (taskID != null) {
                return this.createTimelineEntityGroupIds(taskID.getDAGID());
            }
        } else if (entityType.equals(EntityTypes.TEZ_TASK_ATTEMPT_ID.name())) {
            TezTaskAttemptID taskAttemptID = TezTaskAttemptID.fromString((String)entityId);
            if (taskAttemptID != null) {
                return this.createTimelineEntityGroupIds(taskAttemptID.getDAGID());
            }
        } else if (entityType.equals(EntityTypes.TEZ_CONTAINER_ID.name())) {
            ContainerId containerId;
            String cId = entityId;
            if (cId.startsWith("tez_")) {
                cId = cId.substring(4);
            }
            if ((containerId = ContainerId.fromString((String)cId)) != null) {
                return Sets.newHashSet((Object[])new TimelineEntityGroupId[]{TimelineEntityGroupId.newInstance((ApplicationId)containerId.getApplicationAttemptId().getApplicationId(), (String)containerId.getApplicationAttemptId().getApplicationId().toString())});
            }
        }
        return null;
    }

    public Set<TimelineEntityGroupId> getTimelineEntityGroupId(String entityType, NameValuePair primaryFilter, Collection<NameValuePair> secondaryFilters) {
        if (!knownEntityTypes.contains(entityType) || primaryFilter == null || !knownEntityTypes.contains(primaryFilter.getName()) || summaryEntityTypes.contains(entityType)) {
            return null;
        }
        return this.convertToTimelineEntityGroupIds(primaryFilter.getName(), primaryFilter.getValue().toString());
    }

    public Set<TimelineEntityGroupId> getTimelineEntityGroupId(String entityId, String entityType) {
        if (!knownEntityTypes.contains(entityType) || summaryEntityTypes.contains(entityType)) {
            return null;
        }
        return this.convertToTimelineEntityGroupIds(entityType, entityId);
    }

    public Set<TimelineEntityGroupId> getTimelineEntityGroupId(String entityType, SortedSet<String> entityIds, Set<String> eventTypes) {
        if (!knownEntityTypes.contains(entityType) || summaryEntityTypes.contains(entityType) || entityIds == null || entityIds.isEmpty()) {
            return null;
        }
        HashSet<TimelineEntityGroupId> groupIds = new HashSet<TimelineEntityGroupId>();
        for (String entityId : entityIds) {
            Set<TimelineEntityGroupId> groupId = this.convertToTimelineEntityGroupIds(entityType, entityId);
            if (groupId == null) continue;
            groupIds.addAll(groupId);
        }
        return groupIds;
    }

    public void setConf(Configuration conf) {
        this.conf = conf instanceof TezConfiguration ? conf : new TezConfiguration(conf);
        this.allNumGroupsPerDag = this.loadAllNumDagsPerGroup();
    }

    private Set<Integer> loadAllNumDagsPerGroup() {
        int[] usedNumGroups;
        HashSet<Integer> allNumDagsPerGroup = new HashSet<Integer>();
        int numDagsPerGroup = this.conf.getInt("tez.history.logging.timeline.num-dags-per-group", 1);
        if (numDagsPerGroup > 1) {
            allNumDagsPerGroup.add(numDagsPerGroup);
        }
        if ((usedNumGroups = this.conf.getInts("tez.history.logging.timeline-cache-plugin.old-num-dags-per-group")) != null) {
            for (int i = 0; i < usedNumGroups.length; ++i) {
                allNumDagsPerGroup.add(usedNumGroups[i]);
            }
        }
        if (allNumDagsPerGroup.size() > 3) {
            LOG.warn("Too many entries in tez.history.logging.timeline-cache-plugin.old-num-dags-per-group, this can result in slower lookup from Yarn Timeline server or slower load times in TezUI.");
        }
        return allNumDagsPerGroup;
    }

    public Configuration getConf() {
        return this.conf;
    }

    static {
        knownEntityTypes = Sets.newHashSet((Object[])new String[]{EntityTypes.TEZ_DAG_ID.name(), EntityTypes.TEZ_DAG_EXTRA_INFO.name(), EntityTypes.TEZ_VERTEX_ID.name(), EntityTypes.TEZ_TASK_ID.name(), EntityTypes.TEZ_TASK_ATTEMPT_ID.name(), EntityTypes.TEZ_CONTAINER_ID.name()});
        summaryEntityTypes = Sets.newHashSet((Object[])new String[]{EntityTypes.TEZ_DAG_ID.name(), EntityTypes.TEZ_APPLICATION_ATTEMPT.name(), EntityTypes.TEZ_APPLICATION.name()});
    }
}

