/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.ComputationCPInstruction;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.lineage.LineageItemUtils;
import org.apache.sysds.runtime.matrix.data.FrameBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.transform.encode.EncoderFactory;
import org.apache.sysds.runtime.transform.encode.MultiColumnEncoder;

public class MultiReturnParameterizedBuiltinCPInstruction
extends ComputationCPInstruction {
    protected final ArrayList<CPOperand> _outputs;

    private MultiReturnParameterizedBuiltinCPInstruction(Operator op, CPOperand input1, CPOperand input2, ArrayList<CPOperand> outputs, String opcode, String istr) {
        super(CPInstruction.CPType.MultiReturnBuiltin, op, input1, input2, outputs.get(0), opcode, istr);
        this._outputs = outputs;
    }

    public CPOperand getOutput(int i) {
        return this._outputs.get(i);
    }

    public List<CPOperand> getOutputs() {
        return this._outputs;
    }

    public String[] getOutputNames() {
        return (String[])this._outputs.stream().map(CPOperand::getName).toArray(String[]::new);
    }

    public static MultiReturnParameterizedBuiltinCPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        ArrayList<CPOperand> outputs = new ArrayList<CPOperand>();
        String opcode = parts[0];
        if (opcode.equalsIgnoreCase("transformencode")) {
            CPOperand in1 = new CPOperand(parts[1]);
            CPOperand in2 = new CPOperand(parts[2]);
            outputs.add(new CPOperand(parts[3], Types.ValueType.FP64, Types.DataType.MATRIX));
            outputs.add(new CPOperand(parts[4], Types.ValueType.STRING, Types.DataType.FRAME));
            return new MultiReturnParameterizedBuiltinCPInstruction(null, in1, in2, outputs, opcode, str);
        }
        throw new DMLRuntimeException("Invalid opcode in MultiReturnBuiltin instruction: " + opcode);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        FrameBlock fin = ec.getFrameInput(this.input1.getName());
        String spec = ec.getScalarInput(this.input2).getStringValue();
        String[] colnames = fin.getColumnNames();
        MultiColumnEncoder encoder = EncoderFactory.createEncoder(spec, colnames, fin.getNumColumns(), null);
        MatrixBlock data = encoder.encode(fin);
        FrameBlock meta = encoder.getMetaData(new FrameBlock(fin.getNumColumns(), Types.ValueType.STRING));
        meta.setColumnNames(colnames);
        ec.releaseFrameInput(this.input1.getName());
        ec.setMatrixOutput(this.getOutput(0).getName(), data);
        ec.setFrameOutput(this.getOutput(1).getName(), meta);
    }

    @Override
    public boolean hasSingleLineage() {
        return false;
    }

    public Pair[] getLineageItems(ExecutionContext ec) {
        LineageItem[] inputLineage = LineageItemUtils.getLineage(ec, this.input1, this.input2, this.input3);
        ArrayList<Pair> items = new ArrayList<Pair>();
        for (CPOperand out : this._outputs) {
            items.add(Pair.of((Object)out.getName(), (Object)new LineageItem(this.getOpcode(), inputLineage)));
        }
        return items.toArray(new Pair[0]);
    }
}

