/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupCompressed;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCSingle;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCSingleZeros;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCZeros;
import org.apache.sysds.runtime.compress.colgroup.ColGroupValue;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ADictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.colgroup.offset.AIterator;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;

public class ColGroupDDC
extends ColGroupValue {
    private static final long serialVersionUID = -3204391646123465004L;
    protected AMapToData _data;

    protected ColGroupDDC(int numRows) {
        super(numRows);
    }

    protected ColGroupDDC(int[] colIndices, int numRows, ADictionary dict, AMapToData data, int[] cachedCounts) {
        super(colIndices, numRows, dict, cachedCounts);
        this._zeros = false;
        this._data = data;
    }

    @Override
    public AColGroup.CompressionType getCompType() {
        return AColGroup.CompressionType.DDC;
    }

    @Override
    protected void decompressToBlockUnSafeSparseDictionary(MatrixBlock target, int rl, int ru, int offT, SparseBlock sb) {
        int tCol = target.getNumColumns();
        double[] c = target.getDenseBlockValues();
        offT *= tCol;
        int i = rl;
        while (i < ru) {
            int rowIndex = this._data.getIndex(i);
            if (!sb.isEmpty(rowIndex)) {
                int apos = sb.pos(rowIndex);
                int alen = sb.size(rowIndex) + apos;
                double[] avals = sb.values(rowIndex);
                int[] aix = sb.indexes(rowIndex);
                for (int j = apos; j < alen; ++j) {
                    int n = offT + this._colIndexes[aix[j]];
                    c[n] = c[n] + avals[j];
                }
            }
            ++i;
            offT += tCol;
        }
    }

    @Override
    protected void decompressToBlockUnSafeDenseDictionary(MatrixBlock target, int rl, int ru, int offT, double[] values) {
        int nCol = this._colIndexes.length;
        int tCol = target.getNumColumns();
        double[] c = target.getDenseBlockValues();
        offT *= tCol;
        int i = rl;
        while (i < ru) {
            int rowIndex = this._data.getIndex(i) * nCol;
            for (int j = 0; j < nCol; ++j) {
                int n = offT + this._colIndexes[j];
                c[n] = c[n] + values[rowIndex + j];
            }
            ++i;
            offT += tCol;
        }
    }

    @Override
    public double get(int r, int c) {
        int ix = Arrays.binarySearch(this._colIndexes, c);
        if (ix < 0) {
            throw new RuntimeException("Column index " + c + " not in DDC group.");
        }
        int index = this._data.getIndex(r);
        if (index < this.getNumValues()) {
            return this._dict.getValue(index * this._colIndexes.length + ix);
        }
        return 0.0;
    }

    @Override
    public void countNonZerosPerRow(int[] rnnz, int rl, int ru) {
        int ncol = this._colIndexes.length;
        int numVals = this.getNumValues();
        double[] values = this._dict.getValues();
        for (int i = rl; i < ru; ++i) {
            int lnnz = 0;
            int index = this._data.getIndex(i);
            if (index < numVals) {
                for (int colIx = index; colIx < ncol + index; ++colIx) {
                    lnnz += values[colIx] != 0.0 ? 1 : 0;
                }
            }
            int n = i - rl;
            rnnz[n] = rnnz[n] + lnnz;
        }
    }

    @Override
    protected void computeRowSums(double[] c, boolean square, int rl, int ru) {
        double[] vals = this._dict.sumAllRowsToDouble(square, this._colIndexes.length);
        for (int rix = rl; rix < ru; ++rix) {
            int n = rix;
            c[n] = c[n] + vals[this._data.getIndex(rix)];
        }
    }

    @Override
    protected void computeRowMxx(double[] c, Builtin builtin, int rl, int ru) {
        int nCol = this.getNumCols();
        double[] preAggregatedRows = this._dict.aggregateTuples(builtin, nCol);
        for (int i = rl; i < ru; ++i) {
            c[i] = builtin.execute(c[i], preAggregatedRows[this._data.getIndex(i)]);
        }
    }

    @Override
    public int[] getCounts(int[] counts) {
        return this.getCounts(0, this._numRows, counts);
    }

    @Override
    public int[] getCounts(int rl, int ru, int[] counts) {
        for (int i = rl; i < ru; ++i) {
            int index;
            int n = index = this._data.getIndex(i);
            counts[n] = counts[n] + 1;
        }
        return counts;
    }

    @Override
    protected void preAggregate(MatrixBlock m, MatrixBlock preAgg, int rl, int ru) {
        if (m.isInSparseFormat()) {
            this.preAggregateSparse(m.getSparseBlock(), preAgg, rl, ru);
        } else {
            this.preAggregateDense(m, preAgg, rl, ru);
        }
    }

    private void preAggregateDense(MatrixBlock m, MatrixBlock preAgg, int rl, int ru) {
        double[] preAV = preAgg.getDenseBlockValues();
        double[] mV = m.getDenseBlockValues();
        int numVals = this.getNumValues();
        int rowLeft = rl;
        int offOut = 0;
        while (rowLeft < ru) {
            int rc = 0;
            int offLeft = rowLeft * this._numRows;
            while (rc < this._numRows) {
                int n = offOut + this._data.getIndex(rc);
                preAV[n] = preAV[n] + mV[offLeft];
                ++rc;
                ++offLeft;
            }
            ++rowLeft;
            offOut += numVals;
        }
    }

    private void preAggregateSparse(SparseBlock sb, MatrixBlock preAgg, int rl, int ru) {
        double[] preAV = preAgg.getDenseBlockValues();
        int numVals = this.getNumValues();
        int rowLeft = rl;
        int offOut = 0;
        while (rowLeft < ru) {
            if (!sb.isEmpty(rowLeft)) {
                int apos = sb.pos(rowLeft);
                int alen = sb.size(rowLeft) + apos;
                int[] aix = sb.indexes(rowLeft);
                double[] avals = sb.values(rowLeft);
                for (int j = apos; j < alen; ++j) {
                    int n = offOut + this._data.getIndex(aix[j]);
                    preAV[n] = preAV[n] + avals[j];
                }
            }
            ++rowLeft;
            offOut += numVals;
        }
    }

    @Override
    public Dictionary preAggregateThatDDCStructure(ColGroupDDC that, Dictionary ret) {
        int nCol = that._colIndexes.length;
        for (int r = 0; r < this._numRows; ++r) {
            that._dict.addToEntry(ret, that._data.getIndex(r), this._data.getIndex(r), nCol);
        }
        return ret;
    }

    @Override
    public Dictionary preAggregateThatSDCStructure(ColGroupSDC that, Dictionary ret, boolean preModified) {
        AIterator itThat = that._indexes.getIterator();
        int offsetToDefault = that.getNumValues() - 1;
        int nCol = that._colIndexes.length;
        if (preModified) {
            while (itThat.hasNext()) {
                int to = this._data.getIndex(itThat.value());
                int fr = that._data.getIndex(itThat.getDataIndexAndIncrement());
                that._dict.addToEntry(ret, fr, to, nCol);
            }
        } else {
            int i;
            for (i = 0; i < this._numRows && itThat.hasNext(); ++i) {
                int fr = itThat.value() == i ? that._data.getIndex(itThat.getDataIndexAndIncrement()) : offsetToDefault;
                that._dict.addToEntry(ret, fr, this._data.getIndex(i), nCol);
            }
            while (i < this._numRows) {
                that._dict.addToEntry(ret, offsetToDefault, this._data.getIndex(i), nCol);
                ++i;
            }
        }
        return ret;
    }

    @Override
    public Dictionary preAggregateThatSDCZerosStructure(ColGroupSDCZeros that, Dictionary ret) {
        AIterator itThat = that._indexes.getIterator();
        int nCol = that._colIndexes.length;
        while (itThat.hasNext()) {
            int to = this._data.getIndex(itThat.value());
            int fr = that._data.getIndex(itThat.getDataIndexAndIncrement());
            that._dict.addToEntry(ret, fr, to, nCol);
        }
        return ret;
    }

    @Override
    public Dictionary preAggregateThatSDCSingleZerosStructure(ColGroupSDCSingleZeros that, Dictionary ret) {
        AIterator itThat = that._indexes.getIterator();
        int nCol = that._colIndexes.length;
        while (itThat.hasNext()) {
            int to = this._data.getIndex(itThat.value());
            itThat.next();
            that._dict.addToEntry(ret, 0, to, nCol);
        }
        return ret;
    }

    @Override
    public Dictionary preAggregateThatSDCSingleStructure(ColGroupSDCSingle that, Dictionary ret, boolean preModified) {
        AIterator itThat = that._indexes.getIterator();
        int nCol = that._colIndexes.length;
        if (preModified) {
            while (itThat.hasNext()) {
                int to = this._data.getIndex(itThat.value());
                itThat.next();
                that._dict.addToEntry(ret, 0, to, nCol);
            }
        } else {
            int i;
            for (i = 0; i < this._numRows && itThat.hasNext(); ++i) {
                if (itThat.value() == i) {
                    that._dict.addToEntry(ret, 0, this._data.getIndex(i), nCol);
                    itThat.next();
                    continue;
                }
                that._dict.addToEntry(ret, 1, this._data.getIndex(i), nCol);
            }
            while (i < this._numRows) {
                that._dict.addToEntry(ret, 1, this._data.getIndex(i), nCol);
                ++i;
            }
        }
        return ret;
    }

    @Override
    public boolean sameIndexStructure(ColGroupCompressed that) {
        return that instanceof ColGroupDDC && ((ColGroupDDC)that)._data == this._data;
    }

    @Override
    public int getIndexStructureHash() {
        return this._data.hashCode();
    }

    @Override
    public AColGroup.ColGroupType getColGroupType() {
        return AColGroup.ColGroupType.DDC;
    }

    @Override
    public long estimateInMemorySize() {
        long size = super.estimateInMemorySize();
        return size += this._data.getInMemorySize();
    }

    @Override
    public AColGroup scalarOperation(ScalarOperator op) {
        return new ColGroupDDC(this._colIndexes, this._numRows, this.applyScalarOp(op), this._data, this.getCachedCounts());
    }

    @Override
    public AColGroup binaryRowOp(BinaryOperator op, double[] v, boolean sparseSafe, boolean left) {
        ADictionary aDict = this.applyBinaryRowOp(op, v, true, left);
        return new ColGroupDDC(this._colIndexes, this._numRows, aDict, this._data, this.getCachedCounts());
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        this._data.write(out);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this._data = MapToFactory.readIn(in);
    }

    @Override
    public long getExactSizeOnDisk() {
        long ret = super.getExactSizeOnDisk();
        return ret += this._data.getExactSizeOnDisk();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(String.format("\n%15s ", "Data: "));
        sb.append(this._data);
        return sb.toString();
    }
}

