/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.transform.encode;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.apache.sysds.runtime.matrix.data.FrameBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.transform.encode.ColumnEncoder;
import org.apache.sysds.runtime.util.UtilFunctions;

public class ColumnEncoderBin
extends ColumnEncoder {
    public static final String MIN_PREFIX = "min";
    public static final String MAX_PREFIX = "max";
    public static final String NBINS_PREFIX = "nbins";
    private static final long serialVersionUID = 1917445005206076078L;
    protected int _numBin = -1;
    private double[] _binMins = null;
    private double[] _binMaxs = null;
    private double _colMins = -1.0;
    private double _colMaxs = -1.0;

    public ColumnEncoderBin() {
        super(-1);
    }

    public ColumnEncoderBin(int colID, int numBin) {
        super(colID);
        this._numBin = numBin;
    }

    public ColumnEncoderBin(int colID, int numBin, double[] binMins, double[] binMaxs) {
        super(colID);
        this._numBin = numBin;
        this._binMins = binMins;
        this._binMaxs = binMaxs;
    }

    public double getColMins() {
        return this._colMins;
    }

    public double getColMaxs() {
        return this._colMaxs;
    }

    public double[] getBinMins() {
        return this._binMins;
    }

    public double[] getBinMaxs() {
        return this._binMaxs;
    }

    @Override
    public void build(FrameBlock in) {
        if (!this.isApplicable()) {
            return;
        }
        double[] pairMinMax = ColumnEncoderBin.getMinMaxOfCol(in, this._colID, 0, -1);
        this.computeBins(pairMinMax[0], pairMinMax[1]);
    }

    private static double[] getMinMaxOfCol(FrameBlock in, int colID, int startRow, int blockSize) {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int i = startRow; i < UtilFunctions.getEndIndex(in.getNumRows(), startRow, blockSize); ++i) {
            double inVal = UtilFunctions.objectToDouble(in.getSchema()[colID - 1], in.get(i, colID - 1));
            min = Math.min(min, inVal);
            max = Math.max(max, inVal);
        }
        return new double[]{min, max};
    }

    @Override
    public List<Callable<Object>> getPartialBuildTasks(FrameBlock in, int blockSize) {
        ArrayList<Callable<Object>> tasks = new ArrayList<Callable<Object>>();
        for (int i = 0; i < in.getNumRows(); i += blockSize) {
            tasks.add(new BinPartialBuildTask(in, this._colID, i, blockSize));
        }
        if (in.getNumRows() % blockSize != 0) {
            tasks.add(new BinPartialBuildTask(in, this._colID, in.getNumRows() - in.getNumRows() % blockSize, -1));
        }
        return tasks;
    }

    @Override
    public void mergeBuildPartial(List<Future<Object>> futurePartials, int start, int end) throws ExecutionException, InterruptedException {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int i = start; i < end; ++i) {
            double[] pairMinMax = (double[])futurePartials.get(i).get();
            min = Math.min(min, pairMinMax[0]);
            max = Math.max(max, pairMinMax[1]);
        }
        this.computeBins(min, max);
    }

    public void computeBins(double min, double max) {
        if (this._binMins == null || this._binMaxs == null) {
            this._binMins = new double[this._numBin];
            this._binMaxs = new double[this._numBin];
        }
        for (int i = 0; i < this._numBin; ++i) {
            this._binMins[i] = min + (double)i * (max - min) / (double)this._numBin;
            this._binMaxs[i] = min + (double)(i + 1) * (max - min) / (double)this._numBin;
        }
    }

    @Override
    public void prepareBuildPartial() {
        this._colMins = -1.0;
        this._colMaxs = -1.0;
    }

    @Override
    public void buildPartial(FrameBlock in) {
        if (!this.isApplicable()) {
            return;
        }
        double[] pairMinMax = ColumnEncoderBin.getMinMaxOfCol(in, this._colID, 0, -1);
        this._colMins = pairMinMax[0];
        this._colMaxs = pairMinMax[1];
    }

    @Override
    public MatrixBlock apply(FrameBlock in, MatrixBlock out, int outputCol) {
        return this.apply(in, out, outputCol, 0, -1);
    }

    @Override
    public MatrixBlock apply(MatrixBlock in, MatrixBlock out, int outputCol) {
        return this.apply(in, out, outputCol, 0, -1);
    }

    @Override
    public MatrixBlock apply(FrameBlock in, MatrixBlock out, int outputCol, int rowStart, int blk) {
        for (int i = rowStart; i < UtilFunctions.getEndIndex(in.getNumRows(), rowStart, blk); ++i) {
            double inVal = UtilFunctions.objectToDouble(in.getSchema()[this._colID - 1], in.get(i, this._colID - 1));
            int ix = Arrays.binarySearch(this._binMaxs, inVal);
            int binID = (ix < 0 ? Math.abs(ix + 1) : ix) + 1;
            out.quickSetValueThreadSafe(i, outputCol, binID);
        }
        return out;
    }

    @Override
    public MatrixBlock apply(MatrixBlock in, MatrixBlock out, int outputCol, int rowStart, int blk) {
        int end = blk <= 0 ? in.getNumRows() : (in.getNumRows() < rowStart + blk ? in.getNumRows() : rowStart + blk);
        for (int i = rowStart; i < end; ++i) {
            double inVal = in.quickGetValueThreadSafe(i, this._colID - 1);
            int ix = Arrays.binarySearch(this._binMaxs, inVal);
            int binID = (ix < 0 ? Math.abs(ix + 1) : ix) + 1;
            out.quickSetValueThreadSafe(i, outputCol, binID);
        }
        return out;
    }

    @Override
    public void mergeAt(ColumnEncoder other) {
        if (other instanceof ColumnEncoderBin) {
            ColumnEncoderBin otherBin = (ColumnEncoderBin)other;
            assert (other._colID == this._colID);
            MutableTriple entry = new MutableTriple((Object)this._numBin, (Object)this._binMins[0], (Object)this._binMaxs[this._binMaxs.length - 1]);
            entry.middle = Math.min((Double)entry.middle, otherBin._binMins[0]);
            entry.right = Math.max((Double)entry.right, otherBin._binMaxs[otherBin._binMaxs.length - 1]);
            this._numBin = (Integer)entry.left;
            this._binMins = new double[this._numBin];
            this._binMaxs = new double[this._numBin];
            double min = (Double)entry.middle;
            double max = (Double)entry.right;
            for (int j = 0; j < this._numBin; ++j) {
                this._binMins[j] = min + (double)j * (max - min) / (double)this._numBin;
                this._binMaxs[j] = min + (double)(j + 1) * (max - min) / (double)this._numBin;
            }
            return;
        }
        super.mergeAt(other);
    }

    @Override
    public FrameBlock getMetaData(FrameBlock meta) {
        meta.ensureAllocatedColumns(this._binMaxs.length);
        meta.getColumnMetadata(this._colID - 1).setNumDistinct(this._numBin);
        for (int i = 0; i < this._binMaxs.length; ++i) {
            String sb = this._binMins[i] + "\u00b7" + this._binMaxs[i];
            meta.set(i, this._colID - 1, sb);
        }
        return meta;
    }

    @Override
    public void initMetaData(FrameBlock meta) {
        if (meta == null || this._binMaxs != null) {
            return;
        }
        int nbins = (int)meta.getColumnMetadata()[this._colID - 1].getNumDistinct();
        this._binMins = new double[nbins];
        this._binMaxs = new double[nbins];
        for (int i = 0; i < nbins; ++i) {
            String[] tmp = meta.get(i, this._colID - 1).toString().split("\u00b7");
            this._binMins[i] = Double.parseDouble(tmp[0]);
            this._binMaxs[i] = Double.parseDouble(tmp[1]);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this._numBin);
        out.writeBoolean(this._binMaxs != null);
        if (this._binMaxs != null) {
            for (int j = 0; j < this._binMaxs.length; ++j) {
                out.writeDouble(this._binMaxs[j]);
                out.writeDouble(this._binMins[j]);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        super.readExternal(in);
        this._numBin = in.readInt();
        boolean minmax = in.readBoolean();
        this._binMaxs = minmax ? new double[this._numBin] : null;
        double[] dArray = this._binMins = minmax ? new double[this._numBin] : null;
        if (!minmax) {
            return;
        }
        for (int j = 0; j < this._binMaxs.length; ++j) {
            this._binMaxs[j] = in.readDouble();
            this._binMins[j] = in.readDouble();
        }
    }

    private static class BinPartialBuildTask
    implements Callable<Object> {
        private final FrameBlock _input;
        private final int _blockSize;
        private final int _startRow;
        private final int _colID;

        protected BinPartialBuildTask(FrameBlock input, int colID, int startRow, int blocksize) {
            this._input = input;
            this._blockSize = blocksize;
            this._colID = colID;
            this._startRow = startRow;
        }

        @Override
        public double[] call() throws Exception {
            return ColumnEncoderBin.getMinMaxOfCol(this._input, this._colID, this._startRow, this._blockSize);
        }
    }
}

