/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.impl.vlt.serialization;

import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.jackrabbit.vault.fs.io.DocViewParserHandler;
import org.apache.jackrabbit.vault.util.DocViewNode2;
import org.apache.jackrabbit.vault.util.DocViewProperty2;
import org.apache.sling.ide.transport.RepositoryPath;
import org.apache.sling.ide.transport.ResourceProxy;

public class ResourceProxyParserHandler
implements DocViewParserHandler {
    private ResourceProxy root;
    private NameResolver nameResolver;
    private final Deque<ResourceProxy> resourceQueue = new LinkedList<ResourceProxy>();
    private static final Map<Integer, TypeHint> TYPE_HINT_MAP = new HashMap<Integer, TypeHint>();

    @Override
    public void setNameResolver(NameResolver nameResolver) {
        this.nameResolver = nameResolver;
    }

    @Override
    public void startDocViewNode(String nodePath, DocViewNode2 docViewNode, Optional<DocViewNode2> parentDocViewNode, int line, int column) throws IOException, RepositoryException {
        ResourceProxy currentResource = new ResourceProxy(new RepositoryPath(nodePath));
        for (DocViewProperty2 property : docViewNode.getProperties()) {
            Object value = TypeHint.convertDocViewPropertyToTypedValue(property);
            if (value == null) continue;
            currentResource.addProperty(this.nameResolver.getJCRName(property.getName()), value);
        }
        if (this.root == null) {
            this.root = currentResource;
        } else {
            ResourceProxy parent = this.resourceQueue.peekLast();
            parent.addChild(currentResource);
        }
        this.resourceQueue.add(currentResource);
    }

    @Override
    public void endDocViewNode(String nodePath, DocViewNode2 docViewNode, Optional<DocViewNode2> parentDocViewNode, int line, int column) throws IOException, RepositoryException {
        this.resourceQueue.removeLast();
    }

    public ResourceProxy getRoot() {
        return this.root;
    }

    static {
        for (TypeHint hint : EnumSet.allOf(TypeHint.class)) {
            TYPE_HINT_MAP.put(hint.propertyType, hint);
        }
    }

    static enum TypeHint {
        UNDEFINED(0){

            @Override
            Object parseValues(String[] values, boolean explicitMultiValue) {
                return STRING.parseValues(values, explicitMultiValue);
            }
        }
        ,
        STRING(1){

            @Override
            Object parseValues(String[] values, boolean explicitMultiValue) {
                if (values.length == 1 && !explicitMultiValue) {
                    return values[0];
                }
                return values;
            }
        }
        ,
        BINARY(2){

            @Override
            Object parseValues(String[] values, boolean explicitMultiValue) {
                return null;
            }
        }
        ,
        BOOLEAN(6){

            @Override
            Object parseValues(String[] values, boolean explicitMultiValue) {
                if (values.length == 1 && !explicitMultiValue) {
                    return Boolean.valueOf(values[0]);
                }
                Boolean[] ret = new Boolean[values.length];
                for (int i = 0; i < values.length; ++i) {
                    ret[i] = Boolean.parseBoolean(values[i]);
                }
                return ret;
            }
        }
        ,
        DATE(5){

            @Override
            Object parseValues(String[] values, boolean explicitMultiValue) {
                if (values.length == 1 && !explicitMultiValue) {
                    return ISO8601.parse(values[0]);
                }
                Calendar[] ret = new Calendar[values.length];
                for (int i = 0; i < values.length; ++i) {
                    ret[i] = ISO8601.parse(values[i]);
                }
                return ret;
            }
        }
        ,
        DOUBLE(4){

            @Override
            Object parseValues(String[] values, boolean explicitMultiValue) {
                if (values.length == 1 && !explicitMultiValue) {
                    return Double.parseDouble(values[0]);
                }
                Double[] ret = new Double[values.length];
                for (int i = 0; i < values.length; ++i) {
                    ret[i] = Double.parseDouble(values[i]);
                }
                return ret;
            }
        }
        ,
        LONG(3){

            @Override
            Object parseValues(String[] values, boolean explicitMultiValue) {
                if (values.length == 1 && !explicitMultiValue) {
                    return Long.valueOf(values[0]);
                }
                Long[] ret = new Long[values.length];
                for (int i = 0; i < values.length; ++i) {
                    ret[i] = Long.valueOf(values[i]);
                }
                return ret;
            }
        }
        ,
        DECIMAL(12){

            @Override
            Object parseValues(String[] values, boolean explicitMultiValue) {
                if (values.length == 1 && !explicitMultiValue) {
                    return new BigDecimal(values[0]);
                }
                BigDecimal[] ret = new BigDecimal[values.length];
                for (int i = 0; i < values.length; ++i) {
                    ret[i] = new BigDecimal(values[i]);
                }
                return ret;
            }
        }
        ,
        NAME(7){

            @Override
            Object parseValues(String[] values, boolean explicitMultiValue) {
                if (values.length == 1 && !explicitMultiValue) {
                    return values[0];
                }
                return values;
            }
        }
        ,
        PATH(8){

            @Override
            Object parseValues(String[] values, boolean explicitMultiValue) {
                return NAME.parseValues(values, explicitMultiValue);
            }
        }
        ,
        REFERENCE(9){

            @Override
            Object parseValues(String[] values, boolean explicitMultiValue) {
                if (values.length == 1 && !explicitMultiValue) {
                    return UUID.fromString(values[0]);
                }
                UUID[] refs = new UUID[values.length];
                for (int i = 0; i < values.length; ++i) {
                    String value = values[i];
                    refs[i] = UUID.fromString(value);
                }
                return refs;
            }
        }
        ,
        WEAKREFERENCE(10){

            @Override
            Object parseValues(String[] values, boolean explicitMultiValue) {
                return REFERENCE.parseValues(values, explicitMultiValue);
            }
        }
        ,
        URI(11){

            @Override
            Object parseValues(String[] values, boolean explicitMultiValue) {
                try {
                    if (values.length == 1 && !explicitMultiValue) {
                        return new URI(values[0]);
                    }
                    URI[] refs = new URI[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        String value = values[i];
                        refs[i] = new URI(value);
                    }
                    return refs;
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("Given value cannot be converted to URI", e);
                }
            }
        };

        private final int propertyType;

        static Object convertDocViewPropertyToTypedValue(DocViewProperty2 property) {
            TypeHint hint = TYPE_HINT_MAP.get(property.getType());
            if (hint == null) {
                throw new IllegalArgumentException("Unknown type value '" + property.getType() + "'");
            }
            return hint.parseValues(property.getStringValues().toArray(new String[0]), property.isMultiValue());
        }

        private TypeHint(int propertyType) {
            this.propertyType = propertyType;
        }

        abstract Object parseValues(String[] var1, boolean var2);
    }
}

