/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import javax.jcr.Binary;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.jcr2spi.ItemImpl;
import org.apache.jackrabbit.jcr2spi.ItemLifeCycleListener;
import org.apache.jackrabbit.jcr2spi.SessionImpl;
import org.apache.jackrabbit.jcr2spi.operation.Operation;
import org.apache.jackrabbit.jcr2spi.operation.SetPropertyValue;
import org.apache.jackrabbit.jcr2spi.state.PropertyState;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.value.ValueFormat;
import org.apache.jackrabbit.value.ValueHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyImpl
extends ItemImpl
implements Property {
    private static Logger log = LoggerFactory.getLogger(PropertyImpl.class);
    public static final int UNDEFINED_PROPERTY_LENGTH = -1;

    public PropertyImpl(SessionImpl session, PropertyState state, ItemLifeCycleListener[] listeners) {
        super(session, state, listeners);
    }

    @Override
    public String getName() throws RepositoryException {
        this.checkStatus();
        Name name = this.getQName();
        return this.session.getNameResolver().getJCRName(name);
    }

    @Override
    public void accept(ItemVisitor visitor) throws RepositoryException {
        this.checkStatus();
        visitor.visit(this);
    }

    @Override
    public boolean isNode() {
        return false;
    }

    @Override
    public void setValue(Value value) throws ValueFormatException, VersionException, LockException, RepositoryException {
        this.checkIsWritable(false);
        int valueType = value != null ? value.getType() : 0;
        int reqType = this.getRequiredType(valueType);
        this.setValue(value, reqType);
    }

    @Override
    public void setValue(Value[] values) throws ValueFormatException, VersionException, LockException, RepositoryException {
        int targetType;
        this.checkIsWritable(true);
        int valueType = 0;
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == null) continue;
                if (valueType == 0) {
                    valueType = values[i].getType();
                    continue;
                }
                if (valueType == values[i].getType()) continue;
                String msg = "Inhomogeneous type of values (" + this.safeGetJCRPath() + ")";
                log.debug(msg);
                throw new ValueFormatException(msg);
            }
        }
        if ((targetType = this.getDefinition().getRequiredType()) == 0) {
            targetType = valueType == 0 ? 1 : valueType;
        }
        QValue[] qValues = null;
        if (values != null) {
            Value[] vs = ValueHelper.convert(values, targetType, this.session.getValueFactory());
            qValues = ValueFormat.getQValues(vs, this.session.getNamePathResolver(), this.session.getQValueFactory());
        }
        this.setInternalValues(qValues, targetType);
    }

    @Override
    public void setValue(String value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkIsWritable(false);
        int reqType = this.getRequiredType(1);
        if (value == null) {
            this.setInternalValues(null, reqType);
        } else {
            this.setValue(this.session.getValueFactory().createValue(value), reqType);
        }
    }

    @Override
    public void setValue(String[] values) throws ValueFormatException, VersionException, LockException, RepositoryException {
        this.checkIsWritable(true);
        int reqType = this.getRequiredType(1);
        QValue[] qValues = null;
        if (values != null) {
            qValues = new QValue[values.length];
            for (int i = 0; i < values.length; ++i) {
                String string = values[i];
                QValue qValue = null;
                if (string != null) {
                    if (reqType != 1) {
                        Value v = ValueHelper.convert(string, reqType, this.session.getValueFactory());
                        qValue = ValueFormat.getQValue(v, this.session.getNamePathResolver(), this.session.getQValueFactory());
                    } else {
                        qValue = this.session.getQValueFactory().create(string, 1);
                    }
                }
                qValues[i] = qValue;
            }
        }
        this.setInternalValues(qValues, reqType);
    }

    @Override
    public void setValue(InputStream value) throws ValueFormatException, VersionException, LockException, RepositoryException {
        this.checkIsWritable(false);
        int reqType = this.getRequiredType(2);
        if (value == null) {
            this.setInternalValues(null, reqType);
        } else {
            this.setValue(this.session.getValueFactory().createValue(value), reqType);
        }
    }

    @Override
    public void setValue(Binary value) throws RepositoryException {
        this.checkIsWritable(false);
        int reqType = this.getRequiredType(2);
        if (value == null) {
            this.setInternalValues(null, reqType);
        } else {
            this.setValue(this.session.getValueFactory().createValue(value), reqType);
        }
    }

    @Override
    public void setValue(long value) throws ValueFormatException, VersionException, LockException, RepositoryException {
        this.checkIsWritable(false);
        int reqType = this.getRequiredType(3);
        this.setValue(this.session.getValueFactory().createValue(value), reqType);
    }

    @Override
    public void setValue(double value) throws ValueFormatException, VersionException, LockException, RepositoryException {
        this.checkIsWritable(false);
        int reqType = this.getRequiredType(4);
        this.setValue(this.session.getValueFactory().createValue(value), reqType);
    }

    @Override
    public void setValue(BigDecimal value) throws RepositoryException {
        this.checkIsWritable(false);
        int reqType = this.getRequiredType(12);
        this.setValue(this.session.getValueFactory().createValue(value), reqType);
    }

    @Override
    public void setValue(Calendar value) throws ValueFormatException, VersionException, LockException, RepositoryException {
        this.checkIsWritable(false);
        int reqType = this.getRequiredType(5);
        if (value == null) {
            this.setInternalValues(null, reqType);
        } else {
            this.setValue(this.session.getValueFactory().createValue(value), reqType);
        }
    }

    @Override
    public void setValue(boolean value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkIsWritable(false);
        int reqType = this.getRequiredType(6);
        this.setValue(this.session.getValueFactory().createValue(value), reqType);
    }

    @Override
    public void setValue(Node value) throws ValueFormatException, VersionException, LockException, RepositoryException {
        this.checkIsWritable(false);
        int reqType = this.getRequiredType(9);
        if (value == null) {
            this.setInternalValues(null, reqType);
        } else {
            PropertyImpl.checkValidReference(value, reqType, this.session.getNameResolver());
            QValue qValue = this.session.getQValueFactory().create(value.getUUID(), 9);
            this.setInternalValues(new QValue[]{qValue}, reqType);
        }
    }

    @Override
    public Value getValue() throws ValueFormatException, RepositoryException {
        QValue value = this.getQValue();
        return ValueFormat.getJCRValue(value, this.session.getNamePathResolver(), this.session.getJcrValueFactory());
    }

    @Override
    public Value[] getValues() throws ValueFormatException, RepositoryException {
        QValue[] qValues = this.getQValues();
        Value[] values = new Value[qValues.length];
        for (int i = 0; i < qValues.length; ++i) {
            values[i] = ValueFormat.getJCRValue(qValues[i], this.session.getNamePathResolver(), this.session.getJcrValueFactory());
        }
        return values;
    }

    @Override
    public String getString() throws ValueFormatException, RepositoryException {
        return this.getValue().getString();
    }

    @Override
    public InputStream getStream() throws ValueFormatException, RepositoryException {
        return this.getValue().getStream();
    }

    @Override
    public Binary getBinary() throws RepositoryException {
        return this.getValue().getBinary();
    }

    @Override
    public long getLong() throws ValueFormatException, RepositoryException {
        return this.getValue().getLong();
    }

    @Override
    public double getDouble() throws ValueFormatException, RepositoryException {
        return this.getValue().getDouble();
    }

    @Override
    public BigDecimal getDecimal() throws RepositoryException {
        return this.getValue().getDecimal();
    }

    @Override
    public Calendar getDate() throws ValueFormatException, RepositoryException {
        return this.getValue().getDate();
    }

    @Override
    public boolean getBoolean() throws ValueFormatException, RepositoryException {
        return this.getValue().getBoolean();
    }

    @Override
    public Node getNode() throws ValueFormatException, RepositoryException {
        Value value = this.getValue();
        switch (value.getType()) {
            case 9: 
            case 10: {
                return this.session.getNodeByIdentifier(value.getString());
            }
            case 7: 
            case 8: {
                String path = value.getString();
                Path p = this.session.getPathResolver().getQPath(path);
                try {
                    return p.isAbsolute() ? this.session.getNode(path) : this.getParent().getNode(path);
                }
                catch (PathNotFoundException e) {
                    throw new ItemNotFoundException(path);
                }
            }
            case 1: {
                try {
                    Value refValue = ValueHelper.convert(value, 9, this.session.getValueFactory());
                    return this.session.getNodeByIdentifier(refValue.getString());
                }
                catch (ItemNotFoundException e) {
                    throw e;
                }
                catch (RepositoryException e) {
                    Value pathValue = ValueHelper.convert(value, 8, this.session.getValueFactory());
                    Path p = this.session.getPathResolver().getQPath(pathValue.getString());
                    try {
                        return p.isAbsolute() ? this.session.getNode(pathValue.getString()) : this.getParent().getNode(pathValue.getString());
                    }
                    catch (PathNotFoundException e1) {
                        throw new ItemNotFoundException(pathValue.getString());
                    }
                }
            }
        }
        throw new ValueFormatException("Property value cannot be converted to a PATH, REFERENCE or WEAKREFERENCE");
    }

    @Override
    public Property getProperty() throws RepositoryException {
        boolean absolute;
        Value value = this.getValue();
        Value pathValue = ValueHelper.convert(value, 8, this.session.getValueFactory());
        String path = pathValue.getString();
        try {
            Path p = this.session.getPathResolver().getQPath(path);
            absolute = p.isAbsolute();
        }
        catch (RepositoryException e) {
            throw new ValueFormatException("Property value cannot be converted to a PATH");
        }
        try {
            return absolute ? this.session.getProperty(path) : this.getParent().getProperty(path);
        }
        catch (PathNotFoundException e) {
            throw new ItemNotFoundException(path);
        }
    }

    @Override
    public long getLength() throws ValueFormatException, RepositoryException {
        return this.getLength(this.getQValue());
    }

    @Override
    public long[] getLengths() throws ValueFormatException, RepositoryException {
        QValue[] values = this.getQValues();
        long[] lengths = new long[values.length];
        for (int i = 0; i < values.length; ++i) {
            lengths[i] = this.getLength(values[i]);
        }
        return lengths;
    }

    private long getLength(QValue value) throws RepositoryException {
        long length;
        switch (value.getType()) {
            case 7: 
            case 8: {
                String jcrString = ValueFormat.getJCRString(value, this.session.getNamePathResolver());
                length = jcrString.length();
                break;
            }
            default: {
                length = value.getLength();
            }
        }
        return length;
    }

    @Override
    public PropertyDefinition getDefinition() throws RepositoryException {
        this.checkStatus();
        QPropertyDefinition qpd = this.getPropertyState().getDefinition();
        return this.session.getNodeTypeManager().getPropertyDefinition(qpd);
    }

    @Override
    public int getType() throws RepositoryException {
        this.checkStatus();
        return this.getPropertyState().getType();
    }

    @Override
    public boolean isMultiple() {
        return this.getPropertyState().isMultiValued();
    }

    @Override
    Name getQName() {
        return this.getPropertyState().getName();
    }

    private void checkIsWritable(boolean multiValues) throws RepositoryException {
        this.checkIsWritable();
        if (this.isMultiple() != multiValues) {
            throw new ValueFormatException(this.getPath() + "Multivalue definition of " + this.safeGetJCRPath() + " does not match to given value(s).");
        }
    }

    private int getRequiredType(int defaultType) throws RepositoryException {
        int reqType = this.getDefinition().getRequiredType();
        if (reqType == 0) {
            reqType = defaultType == 0 ? 1 : defaultType;
        }
        return reqType;
    }

    private QValue getQValue() throws ValueFormatException, RepositoryException {
        this.checkStatus();
        if (this.isMultiple()) {
            throw new ValueFormatException(this.safeGetJCRPath() + " is multi-valued and can therefore only be retrieved as an array of values");
        }
        return this.getPropertyState().getValue();
    }

    private QValue[] getQValues() throws ValueFormatException, RepositoryException {
        this.checkStatus();
        if (!this.isMultiple()) {
            throw new ValueFormatException(this.safeGetJCRPath() + " is not multi-valued and can therefore only be retrieved as single value");
        }
        return this.getPropertyState().getValues();
    }

    private void setValue(Value value, int requiredType) throws RepositoryException {
        QValue qValue;
        if (requiredType == 0) {
            throw new IllegalArgumentException("Property type of a value cannot be undefined (" + this.safeGetJCRPath() + ").");
        }
        if (value == null) {
            this.setInternalValues(null, requiredType);
            return;
        }
        if (requiredType != value.getType()) {
            Value v = ValueHelper.convert(value, requiredType, this.session.getValueFactory());
            qValue = ValueFormat.getQValue(v, this.session.getNamePathResolver(), this.session.getQValueFactory());
        } else {
            qValue = ValueFormat.getQValue(value, this.session.getNamePathResolver(), this.session.getQValueFactory());
        }
        this.setInternalValues(new QValue[]{qValue}, requiredType);
    }

    private void setInternalValues(QValue[] qValues, int valueType) throws ConstraintViolationException, RepositoryException {
        if (qValues == null) {
            this.remove();
            return;
        }
        Operation op = SetPropertyValue.create(this.getPropertyState(), qValues, valueType);
        this.session.getSessionItemStateManager().execute(op);
    }

    private PropertyState getPropertyState() {
        return (PropertyState)this.getItemState();
    }

    static void checkValidReference(Node value, int propertyType, NameResolver resolver) throws ValueFormatException, RepositoryException {
        if (propertyType == 9) {
            String jcrName = resolver.getJCRName(NameConstants.MIX_REFERENCEABLE);
            if (!value.isNodeType(jcrName)) {
                throw new ValueFormatException("Target node must be of node type mix:referenceable");
            }
        } else {
            throw new ValueFormatException("Property must be of type REFERENCE.");
        }
    }
}

