/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin;

import java.lang.reflect.Method;
import java.util.concurrent.ForkJoinTask;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;

public abstract class AbstractThreadingPoolInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        if (this.notToEnhance(allArguments)) {
            return;
        }
        Object wrappedObject = this.wrap(allArguments[0]);
        if (wrappedObject != null) {
            allArguments[0] = wrappedObject;
        }
    }

    public abstract Object wrap(Object var1);

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        if (this.notToEnhance(allArguments)) {
            return;
        }
        ContextManager.activeSpan().log(t);
    }

    private boolean notToEnhance(Object[] allArguments) {
        if (!ContextManager.isActive()) {
            return true;
        }
        if (allArguments == null || allArguments.length < 1) {
            return true;
        }
        Object argument = allArguments[0];
        return argument instanceof EnhancedInstance && ((EnhancedInstance)argument).getSkyWalkingDynamicField() instanceof ContextSnapshot && !(argument instanceof ForkJoinTask);
    }
}

