/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.provider.springmvc.reference;

import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.annotations.VisibleForTesting;
import io.netty.handler.codec.http.QueryStringDecoder;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.Part;
import jakarta.ws.rs.core.Response;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.common.rest.codec.RestCodec;
import org.apache.servicecomb.common.rest.definition.RestOperationMeta;
import org.apache.servicecomb.common.rest.locator.OperationLocator;
import org.apache.servicecomb.common.rest.locator.ServicePathManager;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.definition.InvocationRuntimeType;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.invocation.InvocationFactory;
import org.apache.servicecomb.core.provider.consumer.InvokerUtils;
import org.apache.servicecomb.core.provider.consumer.MicroserviceReferenceConfig;
import org.apache.servicecomb.core.provider.consumer.ReferenceConfig;
import org.apache.servicecomb.provider.springmvc.reference.CommonToHttpServletRequest;
import org.apache.servicecomb.provider.springmvc.reference.CseClientHttpResponse;
import org.apache.servicecomb.provider.springmvc.reference.RequestMeta;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.context.InvocationContext;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;
import org.apache.servicecomb.swagger.invocation.exception.ExceptionFactory;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;

public class CseClientHttpRequest
implements ClientHttpRequest {
    private URI uri;
    private String path;
    private HttpMethod method;
    private HttpHeaders httpHeaders = new HttpHeaders();
    private InvocationContext context;
    private Object requestBody;
    private Map<String, List<String>> queryParams;
    private RequestMeta requestMeta;
    private Type responseType;

    public CseClientHttpRequest() {
    }

    public CseClientHttpRequest(URI uri, HttpMethod method) {
        this.uri = uri;
        this.method = method;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    protected RequestMeta getRequestMeta() {
        return this.requestMeta;
    }

    @VisibleForTesting
    public void setRequestMeta(RequestMeta requestMeta) {
        this.requestMeta = requestMeta;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    protected void setQueryParams(Map<String, List<String>> queryParams) {
        this.queryParams = queryParams;
    }

    public InvocationContext getContext() {
        return this.context;
    }

    public void setContext(InvocationContext context) {
        this.context = context;
    }

    public Type getResponseType() {
        return this.responseType;
    }

    public void setResponseType(Type responseType) {
        this.responseType = responseType;
    }

    public void setRequestBody(Object requestBody) {
        this.requestBody = requestBody;
    }

    public void setHttpHeaders(HttpHeaders headers) {
        if (headers != null) {
            this.httpHeaders = headers;
        }
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public URI getURI() {
        return this.uri;
    }

    public Map<String, Object> getAttributes() {
        return Collections.emptyMap();
    }

    public HttpHeaders getHeaders() {
        return this.httpHeaders;
    }

    public OutputStream getBody() {
        return null;
    }

    public ClientHttpResponse execute() {
        this.path = this.findUriPath(this.uri);
        this.requestMeta = this.createRequestMeta(this.method.name(), this.uri);
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(this.uri.getRawSchemeSpecificPart());
        this.queryParams = queryStringDecoder.parameters();
        Map<String, Object> swaggerArguments = this.collectArguments();
        return this.invoke(swaggerArguments);
    }

    protected RequestMeta createRequestMeta(String httpMethod, URI uri) {
        String microserviceName = this.parseMicroserviceName(uri);
        MicroserviceReferenceConfig microserviceReferenceConfig = SCBEngine.getInstance().getOrCreateReferenceConfig(microserviceName);
        if (microserviceReferenceConfig == null) {
            throw new InvocationException((Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, (Object)new CommonExceptionData(String.format("Failed to invoke service %s. Maybe service not registered or no active instance.", microserviceName)));
        }
        MicroserviceMeta microserviceMeta = microserviceReferenceConfig.getMicroserviceMeta();
        ServicePathManager servicePathManager = ServicePathManager.getServicePathManager((MicroserviceMeta)microserviceMeta);
        if (servicePathManager == null) {
            throw new Error(String.format("no schema defined for %s:%s", microserviceMeta.getAppId(), microserviceMeta.getMicroserviceName()));
        }
        OperationLocator locator = servicePathManager.consumerLocateOperation(this.path, httpMethod);
        RestOperationMeta swaggerRestOperation = locator.getOperation();
        OperationMeta operationMeta = locator.getOperation().getOperationMeta();
        ReferenceConfig referenceConfig = microserviceReferenceConfig.createReferenceConfig(operationMeta);
        Map pathParams = locator.getPathVarMap();
        return new RequestMeta(referenceConfig, swaggerRestOperation, pathParams);
    }

    private String parseMicroserviceName(URI uri) {
        String microserviceName = uri.getAuthority();
        return microserviceName.replace("~", ":");
    }

    protected String findUriPath(URI uri) {
        return uri.getRawPath();
    }

    protected Invocation prepareInvocation(Map<String, Object> swaggerArguments) {
        Invocation invocation = InvocationFactory.forConsumer((ReferenceConfig)this.requestMeta.getReferenceConfig(), (OperationMeta)this.requestMeta.getOperationMeta(), (InvocationRuntimeType)this.requestMeta.getOperationMeta().buildBaseConsumerRuntimeType(), swaggerArguments);
        invocation.getHandlerContext().put("rest-client-request-path", this.path + (String)(this.uri.getRawQuery() == null ? "" : "?" + this.uri.getRawQuery()));
        if (this.context != null) {
            invocation.addContext(this.context.getContext());
            invocation.addLocalContext(this.context.getLocalContext());
        }
        if (!(this.responseType == null || this.responseType instanceof Class && Part.class.isAssignableFrom((Class)this.responseType))) {
            invocation.setSuccessResponseType(TypeFactory.defaultInstance().constructType(this.responseType));
        }
        invocation.getHandlerContext().put("servicecomb-rest-consumer-header", this.httpHeaders.toSingleValueMap());
        return invocation;
    }

    @VisibleForTesting
    CseClientHttpResponse invoke(Map<String, Object> swaggerArguments) {
        Invocation invocation = this.prepareInvocation(swaggerArguments);
        Response response = this.doInvoke(invocation);
        if (response.isSucceed()) {
            return new CseClientHttpResponse(response);
        }
        throw ExceptionFactory.convertConsumerException((Throwable)((Throwable)response.getResult()));
    }

    protected Response doInvoke(Invocation invocation) {
        return InvokerUtils.innerSyncInvoke((Invocation)invocation);
    }

    protected Map<String, Object> collectArguments() {
        CommonToHttpServletRequest mockRequest = new CommonToHttpServletRequest(this.requestMeta.getPathParams(), this.queryParams, (Map<String, List<String>>)this.httpHeaders, this.requestBody, this.requestMeta.getSwaggerRestOperation().getFileKeys());
        return RestCodec.restToArgs((HttpServletRequest)mockRequest, (RestOperationMeta)this.requestMeta.getSwaggerRestOperation());
    }
}

