/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.highway;

import jakarta.ws.rs.core.Response;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.servicecomb.codec.protobuf.definition.OperationProtobuf;
import org.apache.servicecomb.codec.protobuf.definition.ProtobufManager;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.exception.Exceptions;
import org.apache.servicecomb.core.filter.AbstractFilter;
import org.apache.servicecomb.core.filter.ConsumerFilter;
import org.apache.servicecomb.core.filter.EdgeFilter;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.foundation.common.utils.AsyncUtils;
import org.apache.servicecomb.foundation.vertx.client.tcp.TcpData;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.apache.servicecomb.transport.highway.HighwayClient;
import org.apache.servicecomb.transport.highway.HighwayClientConnection;
import org.apache.servicecomb.transport.highway.HighwayClientPackage;
import org.apache.servicecomb.transport.highway.HighwayCodec;
import org.apache.servicecomb.transport.highway.HighwayTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HighwayClientFilter
extends AbstractFilter
implements ConsumerFilter,
EdgeFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HighwayClientFilter.class);
    public static final String NAME = "highway-client";

    public String getName() {
        return NAME;
    }

    public boolean enabledForTransport(String transport) {
        return "highway".equals(transport);
    }

    public int getOrder() {
        return 2000;
    }

    public CompletableFuture<Response> onFilter(Invocation invocation, FilterNode nextNode) {
        LOGGER.debug("Sending request by highway, operation={}, endpoint={}.", (Object)invocation.getMicroserviceQualifiedName(), (Object)invocation.getEndpoint().getEndpoint());
        OperationProtobuf operationProtobuf = ProtobufManager.getOrCreateOperation((Invocation)invocation);
        return ((CompletableFuture)this.send(invocation, operationProtobuf).thenApply(tcpData -> this.convertToResponse(invocation, operationProtobuf, (TcpData)tcpData))).thenApply(this::convertFailedResponseToException);
    }

    protected CompletableFuture<TcpData> send(Invocation invocation, OperationProtobuf operationProtobuf) {
        invocation.getInvocationStageTrace().startConsumerConnection();
        HighwayClient highwayClient = ((HighwayTransport)invocation.getTransport()).getHighwayClient();
        HighwayClientPackage clientPackage = highwayClient.createClientPackage(invocation, operationProtobuf);
        HighwayClientConnection clientConnection = highwayClient.findClientPool(invocation);
        invocation.getInvocationStageTrace().finishConsumerConnection();
        invocation.onStartSendRequest();
        invocation.getInvocationStageTrace().startConsumerSendRequest();
        CompletionStage sendFuture = clientConnection.send(clientPackage).whenComplete((r, e) -> invocation.getInvocationStageTrace().finishWaitResponse());
        invocation.getInvocationStageTrace().finishConsumerSendRequest();
        invocation.getInvocationStageTrace().startWaitResponse();
        return invocation.optimizeSyncConsumerThread((CompletableFuture)sendFuture);
    }

    protected Response convertToResponse(Invocation invocation, OperationProtobuf operationProtobuf, TcpData tcpData) {
        try {
            invocation.getInvocationStageTrace().startConsumerDecodeResponse();
            Response result = HighwayCodec.decodeResponse(invocation, operationProtobuf, tcpData);
            invocation.getInvocationStageTrace().finishConsumerDecodeResponse();
            return result;
        }
        catch (Exception e) {
            throw AsyncUtils.rethrow((Throwable)e);
        }
    }

    protected Response convertFailedResponseToException(Response response) {
        if (response.isFailed()) {
            Object errorData = response.getResult();
            if (errorData instanceof InvocationException) {
                errorData = ((InvocationException)errorData).getErrorData();
            }
            throw Exceptions.create((Response.StatusType)response.getStatus(), (Object)errorData);
        }
        return response;
    }
}

