/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core.meter;

import io.micrometer.core.instrument.Measurement;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.foundation.metrics.publish.MeasurementNode;
import org.apache.servicecomb.foundation.metrics.publish.MeasurementTree;
import org.apache.servicecomb.metrics.core.publish.model.ThreadPoolPublishModel;

public class ThreadPoolMonitorPublishModelFactory {
    public static Map<String, ThreadPoolPublishModel> create(MeasurementTree tree) {
        HashMap<String, ThreadPoolPublishModel> result = new HashMap<String, ThreadPoolPublishModel>(8);
        ThreadPoolMonitorPublishModelFactory.readMeasurement(result, tree, "taskCount", (model, measurement) -> model.setAvgTaskCount(measurement.getValue()));
        ThreadPoolMonitorPublishModelFactory.readMeasurement(result, tree, "completedTaskCount", (model, measurement) -> model.setAvgCompletedTaskCount(measurement.getValue()));
        ThreadPoolMonitorPublishModelFactory.readMeasurement(result, tree, "currentThreadsBusy", (model, measurement) -> model.setCurrentThreadsBusy((int)measurement.getValue()));
        ThreadPoolMonitorPublishModelFactory.readMeasurement(result, tree, "maxThreads", (model, measurement) -> model.setMaxThreads((int)measurement.getValue()));
        ThreadPoolMonitorPublishModelFactory.readMeasurement(result, tree, "poolSize", (model, measurement) -> model.setPoolSize((int)measurement.getValue()));
        ThreadPoolMonitorPublishModelFactory.readMeasurement(result, tree, "corePoolSize", (model, measurement) -> model.setCorePoolSize((int)measurement.getValue()));
        ThreadPoolMonitorPublishModelFactory.readMeasurement(result, tree, "queueSize", (model, measurement) -> model.setQueueSize((int)measurement.getValue()));
        ThreadPoolMonitorPublishModelFactory.readMeasurement(result, tree, "rejectedCount", (model, measurement) -> model.setRejected(measurement.getValue()));
        return result;
    }

    protected static void readMeasurement(Map<String, ThreadPoolPublishModel> threadPools, MeasurementTree tree, String name, Setter setter) {
        MeasurementNode node = tree.findChild("servicecomb.threadpool");
        if (node == null) {
            return;
        }
        for (String threadPoolName : node.getChildren().keySet()) {
            MeasurementNode measure = node.findChild(new String[]{threadPoolName, name});
            if (measure == null) continue;
            ThreadPoolPublishModel model = threadPools.computeIfAbsent(threadPoolName, tpn -> new ThreadPoolPublishModel());
            setter.set(model, (Measurement)measure.getMeasurements().get(0));
        }
    }

    static interface Setter {
        public void set(ThreadPoolPublishModel var1, Measurement var2);
    }
}

