/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.huaweicloud.dashboard.monitor;

import java.util.HashMap;
import java.util.List;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.servicecomb.config.ConfigUtil;
import org.apache.servicecomb.dashboard.client.DashboardAddressManager;
import org.apache.servicecomb.dashboard.client.DashboardClient;
import org.apache.servicecomb.foundation.auth.AuthHeaderProvider;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.http.client.auth.RequestAuthHeaderProvider;
import org.apache.servicecomb.http.client.common.HttpConfiguration;
import org.apache.servicecomb.http.client.common.HttpTransport;
import org.apache.servicecomb.http.client.common.HttpTransportFactory;
import org.apache.servicecomb.huaweicloud.dashboard.monitor.TransportUtils;
import org.apache.servicecomb.huaweicloud.dashboard.monitor.data.MonitorConstant;
import org.apache.servicecomb.huaweicloud.dashboard.monitor.model.MonitorDataProvider;
import org.apache.servicecomb.huaweicloud.dashboard.monitor.model.MonitorDataPublisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

public class DefaultMonitorDataPublisher
implements MonitorDataPublisher {
    private static final String SSL_KEY = "mc.consumer";
    private DashboardClient dashboardClient;
    private MonitorConstant monitorConstant;
    private Environment environment;

    @Autowired
    public void setMonitorConstant(MonitorConstant monitorConstant) {
        this.monitorConstant = monitorConstant;
    }

    @Autowired
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Override
    public void init() {
        DashboardAddressManager addressManager = this.createDashboardAddressManager();
        RequestConfig.Builder requestBuilder = HttpTransportFactory.defaultRequestConfig();
        requestBuilder.setConnectionRequestTimeout(1000);
        requestBuilder.setSocketTimeout(10000);
        HttpTransport httpTransport = this.createHttpTransport(addressManager, requestBuilder.build(), this.environment);
        this.dashboardClient = new DashboardClient(addressManager, httpTransport);
    }

    private DashboardAddressManager createDashboardAddressManager() {
        List addresses = ConfigUtil.parseArrayValue((String)this.environment.getProperty("DashboardService", ""));
        if (addresses.isEmpty()) {
            throw new IllegalStateException("dashboard address is not configured.");
        }
        return new DashboardAddressManager(addresses, EventManager.getEventBus());
    }

    private HttpTransport createHttpTransport(DashboardAddressManager addressManager, RequestConfig requestConfig, Environment environment) {
        List authHeaderProviders = SPIServiceUtils.getOrLoadSortedService(AuthHeaderProvider.class);
        if (this.monitorConstant.isProxyEnable().booleanValue()) {
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig);
            HttpHost proxy = new HttpHost(this.monitorConstant.getProxyHost(), this.monitorConstant.getProxyPort(), "http");
            httpClientBuilder.setProxy(proxy);
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(proxy), (Credentials)new UsernamePasswordCredentials(this.monitorConstant.getProxyUsername(), this.monitorConstant.getProxyPasswd()));
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            return HttpTransportFactory.createHttpTransport((HttpConfiguration.SSLProperties)TransportUtils.createSSLProperties(addressManager.sslEnabled(), environment, SSL_KEY), (RequestAuthHeaderProvider)DefaultMonitorDataPublisher.getRequestAuthHeaderProvider(authHeaderProviders), (HttpClientBuilder)httpClientBuilder);
        }
        return HttpTransportFactory.createHttpTransport((HttpConfiguration.SSLProperties)TransportUtils.createSSLProperties(this.monitorConstant.sslEnabled(), environment, SSL_KEY), (RequestAuthHeaderProvider)DefaultMonitorDataPublisher.getRequestAuthHeaderProvider(authHeaderProviders), (RequestConfig)requestConfig);
    }

    private static RequestAuthHeaderProvider getRequestAuthHeaderProvider(List<AuthHeaderProvider> authHeaderProviders) {
        return signRequest -> {
            HashMap headers = new HashMap();
            authHeaderProviders.forEach(provider -> headers.putAll(provider.authHeaders()));
            return headers;
        };
    }

    @Override
    public void publish(MonitorDataProvider provider) {
        this.dashboardClient.sendData(provider.getURL(), provider.getData());
    }
}

