/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance;

import java.util.ArrayList;
import java.util.Map;
import org.apache.servicecomb.governance.marker.GovernanceRequestExtractor;
import org.apache.servicecomb.governance.policy.AbstractPolicy;
import org.apache.servicecomb.governance.service.MatchersService;

public class MatchersManager {
    private MatchersService matchersService;

    public MatchersManager(MatchersService matchersService) {
        this.matchersService = matchersService;
    }

    public <T extends AbstractPolicy> T match(GovernanceRequestExtractor requestExtractor, Map<String, T> policies) {
        ArrayList<T> sortPolicies = new ArrayList<T>(policies.size());
        sortPolicies.addAll(policies.values());
        sortPolicies.sort(AbstractPolicy::compareTo);
        for (AbstractPolicy policy : sortPolicies) {
            if (!this.matchersService.checkMatch(requestExtractor, policy.getName())) continue;
            return (T)policy;
        }
        return null;
    }
}

