/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.consumer;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.servicecomb.foundation.common.net.IpPort;
import org.apache.servicecomb.foundation.common.net.NetUtils;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.registry.consumer.MicroserviceInstancePing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class SimpleMicroserviceInstancePing
implements MicroserviceInstancePing {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleMicroserviceInstancePing.class);

    @Override
    public int getOrder() {
        return 100;
    }

    @Override
    public boolean ping(MicroserviceInstance instance) {
        if (!CollectionUtils.isEmpty(instance.getEndpoints())) {
            for (String endpoint : instance.getEndpoints()) {
                boolean bl;
                IpPort ipPort = NetUtils.parseIpPortFromURI((String)endpoint);
                Socket s = new Socket();
                try {
                    s.connect(new InetSocketAddress(ipPort.getHostOrIp(), ipPort.getPort()), 3000);
                    bl = true;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        LOGGER.warn("ping instance {} endpoint {} failed", (Object)instance.getInstanceId(), (Object)endpoint);
                    }
                }
                s.close();
                return bl;
            }
        }
        return false;
    }
}

