/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.concurrency;

import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuppressedRunnableWrapper
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SuppressedRunnableWrapper.class);
    private final Runnable target;
    private final Consumer<Throwable> errorHandler;

    public SuppressedRunnableWrapper(Runnable runnable) {
        this(runnable, null);
    }

    public SuppressedRunnableWrapper(Runnable runnable, Consumer<Throwable> errorHandler) {
        this.target = runnable;
        this.errorHandler = errorHandler;
    }

    @Override
    public void run() {
        try {
            this.target.run();
        }
        catch (Throwable e) {
            this.handleError(e);
        }
    }

    private void handleError(Throwable e) {
        if (null == this.errorHandler) {
            LOGGER.error("task {} execute error!", (Object)this.target, (Object)e);
            return;
        }
        this.errorHandler.accept(e);
    }
}

