/*
 * Decompiled with CFR 0.152.
 */
package brave.internal.handler;

import brave.ErrorParser;
import brave.Span;
import brave.handler.MutableSpan;
import brave.internal.Nullable;
import zipkin2.Endpoint;
import zipkin2.Span;

public final class MutableSpanConverter {
    final ErrorParser errorParser;
    final String localServiceName;
    @Nullable
    final String localIp;
    final int localPort;
    final Endpoint localEndpoint;

    public MutableSpanConverter(ErrorParser errorParser, String localServiceName, String localIp, int localPort) {
        if (errorParser == null) {
            throw new NullPointerException("errorParser == null");
        }
        this.errorParser = errorParser;
        if (localServiceName == null) {
            throw new NullPointerException("localServiceName == null");
        }
        this.localServiceName = localServiceName;
        this.localIp = localIp;
        this.localPort = localPort;
        this.localEndpoint = Endpoint.newBuilder().serviceName(localServiceName).ip(localIp).port(localPort).build();
    }

    void convert(MutableSpan span, Span.Builder result) {
        String errorTag;
        Span.Kind kind;
        result.name(span.name());
        long start = span.startTimestamp();
        long finish = span.finishTimestamp();
        result.timestamp(start);
        if (start != 0L && finish != 0L) {
            result.duration(Math.max(finish - start, 1L));
        }
        if ((kind = span.kind()) != null && kind.ordinal() < Span.Kind.values().length) {
            result.kind(Span.Kind.values()[kind.ordinal()]);
        }
        this.addLocalEndpoint(span.localServiceName(), span.localIp(), span.localPort(), result);
        String remoteServiceName = span.remoteServiceName();
        String remoteIp = span.remoteIp();
        if (remoteServiceName != null || remoteIp != null) {
            result.remoteEndpoint(Endpoint.newBuilder().serviceName(remoteServiceName).ip(remoteIp).port(span.remotePort()).build());
        }
        if ((errorTag = span.tag("error")) == null && span.error() != null) {
            this.errorParser.error(span.error(), span);
        }
        span.forEachTag(Consumer.INSTANCE, result);
        span.forEachAnnotation(Consumer.INSTANCE, result);
        if (span.shared()) {
            result.shared(true);
        }
    }

    void addLocalEndpoint(String serviceName, @Nullable String ip, int port, Span.Builder span) {
        if (serviceName == null) {
            serviceName = this.localServiceName;
        }
        if (ip == null) {
            ip = this.localIp;
        }
        if (port <= 0) {
            port = this.localPort;
        }
        if (this.localServiceName.equals(serviceName) && (this.localIp == null ? ip == null : this.localIp.equals(ip)) && this.localPort == port) {
            span.localEndpoint(this.localEndpoint);
        } else {
            span.localEndpoint(Endpoint.newBuilder().serviceName(serviceName).ip(ip).port(port).build());
        }
    }

    static enum Consumer implements MutableSpan.TagConsumer<Span.Builder>,
    MutableSpan.AnnotationConsumer<Span.Builder>
    {
        INSTANCE;


        @Override
        public void accept(Span.Builder target, String key, String value) {
            target.putTag(key, value);
        }

        @Override
        public void accept(Span.Builder target, long timestamp, String value) {
            target.addAnnotation(timestamp, value);
        }
    }
}

