/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.servo;

import com.netflix.servo.monitor.MaxGauge;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.StepCounter;
import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Statistic;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.servo.ServoMeter;
import com.netflix.spectator.servo.ServoRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

class ServoDistributionSummary
implements DistributionSummary,
ServoMeter {
    private final Clock clock;
    private final Id id;
    private final AtomicLong count;
    private final AtomicLong totalAmount;
    private final StepCounter servoCount;
    private final StepCounter servoTotal;
    private final StepCounter servoTotalOfSquares;
    private final MaxGauge servoMax;
    private final AtomicLong lastUpdated;

    ServoDistributionSummary(ServoRegistry r, Id id) {
        this.clock = r.clock();
        this.id = id;
        this.count = new AtomicLong(0L);
        this.totalAmount = new AtomicLong(0L);
        this.servoCount = new StepCounter(r.toMonitorConfig(id.withTag((Tag)Statistic.count), null));
        this.servoTotal = new StepCounter(r.toMonitorConfig(id.withTag((Tag)Statistic.totalAmount), null));
        this.servoTotalOfSquares = new StepCounter(r.toMonitorConfig(id.withTag((Tag)Statistic.totalOfSquares), null));
        this.servoMax = new MaxGauge(r.toMonitorConfig(id.withTag((Tag)Statistic.max), null));
        this.lastUpdated = new AtomicLong(this.clock.wallTime());
    }

    @Override
    public void addMonitors(List<Monitor<?>> monitors) {
        monitors.add((Monitor<?>)this.servoCount);
        monitors.add((Monitor<?>)this.servoTotal);
        monitors.add((Monitor<?>)this.servoTotalOfSquares);
        monitors.add((Monitor<?>)this.servoMax);
    }

    public Id id() {
        return this.id;
    }

    public boolean hasExpired() {
        long now = this.clock.wallTime();
        return now - this.lastUpdated.get() > ServoRegistry.EXPIRATION_TIME_MILLIS;
    }

    public void record(long amount) {
        if (amount >= 0L) {
            this.totalAmount.addAndGet(amount);
            this.count.incrementAndGet();
            this.servoTotal.increment(amount);
            this.servoTotalOfSquares.increment(amount * amount);
            this.servoCount.increment();
            this.servoMax.update(amount);
            this.lastUpdated.set(this.clock.wallTime());
        }
    }

    public Iterable<Measurement> measure() {
        long now = this.clock.wallTime();
        ArrayList<Measurement> ms = new ArrayList<Measurement>(2);
        ms.add(new Measurement(this.id.withTag((Tag)Statistic.count), now, (double)this.count.get()));
        ms.add(new Measurement(this.id.withTag((Tag)Statistic.totalAmount), now, (double)this.totalAmount.get()));
        return ms;
    }

    public long count() {
        return this.count.get();
    }

    public long totalAmount() {
        return this.totalAmount.get();
    }
}

