/****************************************************************************
 * libs/libnx/nxfonts/nxfonts_sans40x49b.h
 *
 *   Copyright (C) 2011-2012 NX Engineering, S.A., All rights reserved.
 *   Author: Jose Pablo Carballo Gomez <jcarballo@nx-engineering.com>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name NuttX nor the names of its contributors may be
 *    used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT}
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING}
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

#ifndef __LIBNX_NXFONTS_NXFONTS_SANS40X49B_H
#define __LIBNX_NXFONTS_NXFONTS_SANS40X49B_H

/****************************************************************************
 * Included Files
 ****************************************************************************/

/****************************************************************************
 * Pre-Processor Definitions
 ****************************************************************************/

/* Font ID */

#define NXFONT_ID         FONTID_SANS40X49B

/* Ranges of 7-bit and 8-bit fonts */

#define NXFONT_MIN7BIT    33
#define NXFONT_MAX7BIT    126

#define NXFONT_MIN8BIT    161
#define NXFONT_MAX8BIT    255

/* Maximum height and width of any glyph in the set */

#define NXFONT_MAXHEIGHT  49
#define NXFONT_MAXWIDTH   40

/* The width of a space */

#define NXFONT_SPACEWIDTH 9

/* exclam (33) */
#define NXFONT_METRICS_33 {1, 5, 25, 3, 12, 0}
#define NXFONT_BITMAP_33 {0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x0, 0x0, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8}

/* quotedbl (34) */
#define NXFONT_METRICS_34 {2, 11, 9, 2, 12, 0}
#define NXFONT_BITMAP_34 {0xf1, 0xe0, 0xf1, 0xe0, 0xf1, 0xe0, 0xf1, 0xe0, 0xf1, 0xe0, 0xf1, 0xe0, 0xf1, 0xe0, 0x60, 0xc0, 0x60, 0xc0}

/* numbersign (35) */
#define NXFONT_METRICS_35 {3, 18, 25, 0, 13, 0}
#define NXFONT_BITMAP_35 {0x3, 0xc7, 0x0, 0x3, 0xc7, 0x0, 0x3, 0x8f, 0x0, 0x3, 0x8f, 0x0, 0x7, 0x8f, 0x0, 0x7, 0x8e, 0x0, 0x7, 0x8e, 0x0, 0x7f, 0xff, 0xc0, 0x7f, 0xff, 0xc0, 0x7f, 0xff, 0xc0, 0x7f, 0xff, 0xc0, 0xf, 0x1c, 0x0, 0xe, 0x1c, 0x0, 0xe, 0x1c, 0x0, 0xe, 0x3c, 0x0, 0xff, 0xff, 0x80, 0xff, 0xff, 0x80, 0xff, 0xff, 0x80, 0xff, 0xff, 0x80, 0x1c, 0x78, 0x0, 0x3c, 0x78, 0x0, 0x3c, 0x70, 0x0, 0x3c, 0x70, 0x0, 0x38, 0xf0, 0x0, 0x38, 0xf0, 0x0}

/* dollar (36) */
#define NXFONT_METRICS_36 {2, 16, 28, 1, 12, 0}
#define NXFONT_BITMAP_36 {0x1, 0x80, 0x1, 0x80, 0xf, 0xf0, 0x3f, 0xfc, 0x7f, 0xfe, 0xfd, 0xbe, 0xf9, 0x9f, 0xf1, 0x9f, 0xf1, 0x8f, 0xf9, 0x80, 0xff, 0x80, 0x7f, 0xc0, 0x3f, 0xf0, 0xf, 0xfc, 0x1, 0xfe, 0x1, 0xff, 0x1, 0x9f, 0x1, 0x8f, 0xf1, 0x8f, 0xf1, 0x9f, 0xf9, 0x9f, 0x7f, 0xfe, 0x7f, 0xfe, 0x3f, 0xf8, 0x7, 0xe0, 0x1, 0x80, 0x1, 0x80, 0x1, 0x80}

/* percent (37) */
#define NXFONT_METRICS_37 {4, 26, 23, 1, 14, 0}
#define NXFONT_BITMAP_37 {0xe, 0x0, 0x30, 0x0, 0x3f, 0x80, 0x70, 0x0, 0x7f, 0xc0, 0x60, 0x0, 0x71, 0xc0, 0xe0, 0x0, 0xe0, 0xe0, 0xc0, 0x0, 0xe0, 0xe1, 0xc0, 0x0, 0xe0, 0xe3, 0x80, 0x0, 0xe0, 0xe3, 0x80, 0x0, 0x71, 0xc7, 0x0, 0x0, 0x7f, 0xc6, 0x0, 0x0, 0x3f, 0x8e, 0x0, 0x0, 0xe, 0xc, 0x1c, 0x0, 0x0, 0x1c, 0x7f, 0x0, 0x0, 0x18, 0xff, 0x80, 0x0, 0x38, 0xe3, 0x80, 0x0, 0x31, 0xc1, 0xc0, 0x0, 0x71, 0xc1, 0xc0, 0x0, 0x61, 0xc1, 0xc0, 0x0, 0xe1, 0xc1, 0xc0, 0x1, 0xc0, 0xe3, 0x80, 0x1, 0xc0, 0xff, 0x80, 0x3, 0x80, 0x7f, 0x0, 0x3, 0x0, 0x1c, 0x0}

/* ampersand (38) */
#define NXFONT_METRICS_38 {3, 20, 25, 2, 12, 0}
#define NXFONT_BITMAP_38 {0x3, 0xe0, 0x0, 0xf, 0xf8, 0x0, 0x1f, 0xfc, 0x0, 0x1f, 0xfc, 0x0, 0x1e, 0x3c, 0x0, 0x3e, 0x3c, 0x0, 0x3e, 0x3c, 0x0, 0x1f, 0x3c, 0x0, 0x1f, 0xf8, 0x0, 0xf, 0xf8, 0x0, 0xf, 0xf0, 0x0, 0xf, 0xe0, 0x0, 0x3f, 0xf1, 0xe0, 0x7f, 0xf1, 0xe0, 0x7c, 0xf9, 0xc0, 0xf8, 0xff, 0xc0, 0xf0, 0x7f, 0xc0, 0xf0, 0x3f, 0x80, 0xf0, 0x1f, 0x0, 0xf8, 0xf, 0x80, 0xfc, 0x3f, 0xc0, 0x7f, 0xff, 0xe0, 0x7f, 0xfb, 0xe0, 0x1f, 0xf1, 0xf0, 0x7, 0xc0, 0x0}

/* quotesingle (39) */
#define NXFONT_METRICS_39 {1, 4, 9, 2, 12, 0}
#define NXFONT_BITMAP_39 {0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0x60, 0x60}

/* parenleft (40) */
#define NXFONT_METRICS_40 {1, 8, 31, 1, 12, 0}
#define NXFONT_BITMAP_40 {0x7, 0xf, 0x1e, 0x1e, 0x3c, 0x3c, 0x38, 0x78, 0x78, 0x78, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf8, 0x78, 0x78, 0x78, 0x78, 0x3c, 0x3c, 0x1c, 0x1e, 0xe, 0xf, 0x7}

/* parenright (41) */
#define NXFONT_METRICS_41 {1, 8, 31, 1, 12, 0}
#define NXFONT_BITMAP_41 {0xe0, 0xf0, 0x78, 0x78, 0x3c, 0x3c, 0x1c, 0x1e, 0x1e, 0x1e, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1f, 0x1e, 0x1e, 0x1e, 0x1c, 0x3c, 0x3c, 0x38, 0x78, 0x70, 0xf0, 0xe0}

/* asterisk (42) */
#define NXFONT_METRICS_42 {2, 10, 11, 1, 13, 0}
#define NXFONT_BITMAP_42 {0xc, 0x0, 0xc, 0x0, 0x4c, 0x80, 0xed, 0xc0, 0xff, 0xc0, 0x7f, 0x80, 0x1e, 0x0, 0x3f, 0x0, 0x7f, 0x80, 0x73, 0x80, 0x21, 0x0}

/* plus (43) */
#define NXFONT_METRICS_43 {2, 16, 16, 1, 21, 0}
#define NXFONT_BITMAP_43 {0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0}

/* comma (44) */
#define NXFONT_METRICS_44 {1, 5, 11, 2, 32, 0}
#define NXFONT_BITMAP_44 {0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0x18, 0x18, 0x38, 0x70, 0xe0, 0x80}

/* hyphen (45) */
#define NXFONT_METRICS_45 {2, 9, 5, 1, 25, 0}
#define NXFONT_BITMAP_45 {0xff, 0x80, 0xff, 0x80, 0xff, 0x80, 0xff, 0x80, 0xff, 0x80}

/* period (46) */
#define NXFONT_METRICS_46 {1, 5, 5, 2, 32, 0}
#define NXFONT_BITMAP_46 {0xf8, 0xf8, 0xf8, 0xf8, 0xf8}

/* slash (47) */
#define NXFONT_METRICS_47 {1, 8, 25, 0, 12, 0}
#define NXFONT_BITMAP_47 {0x3, 0x3, 0x3, 0x3, 0x6, 0x6, 0x6, 0xe, 0xc, 0xc, 0xc, 0x1c, 0x18, 0x18, 0x18, 0x30, 0x30, 0x30, 0x70, 0x60, 0x60, 0x60, 0xc0, 0xc0, 0xc0}

/* zero (48) */
#define NXFONT_METRICS_48 {2, 15, 24, 1, 13, 0}
#define NXFONT_BITMAP_48 {0xf, 0xe0, 0x1f, 0xf0, 0x3f, 0xf8, 0x7f, 0xfc, 0x7c, 0x7c, 0xf8, 0x3e, 0xf8, 0x3e, 0xf8, 0x3e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf8, 0x3e, 0xf8, 0x3e, 0xf8, 0x3e, 0x7c, 0x7c, 0x7f, 0xfc, 0x3f, 0xf8, 0x1f, 0xf0, 0xf, 0xe0}

/* one (49) */
#define NXFONT_METRICS_49 {2, 10, 23, 2, 14, 0}
#define NXFONT_BITMAP_49 {0x1, 0xc0, 0x3, 0xc0, 0x7, 0xc0, 0x1f, 0xc0, 0xff, 0xc0, 0xff, 0xc0, 0xff, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0}

/* two (50) */
#define NXFONT_METRICS_50 {2, 16, 24, 1, 13, 0}
#define NXFONT_BITMAP_50 {0xf, 0xe0, 0x3f, 0xf8, 0x7f, 0xfc, 0x7f, 0xfe, 0xfc, 0x7e, 0xf8, 0x3f, 0xf8, 0x1f, 0xf0, 0x1f, 0xf0, 0x1f, 0x0, 0x3f, 0x0, 0x3e, 0x0, 0x7e, 0x0, 0xfc, 0x1, 0xf8, 0x7, 0xf0, 0xf, 0xe0, 0x1f, 0x80, 0x3f, 0x0, 0x7e, 0x0, 0xfc, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff}

/* three (51) */
#define NXFONT_METRICS_51 {2, 16, 24, 1, 13, 0}
#define NXFONT_BITMAP_51 {0xf, 0xe0, 0x3f, 0xf8, 0x7f, 0xfc, 0x7f, 0xfc, 0xf8, 0x3e, 0xf0, 0x3e, 0xf0, 0x1e, 0xf0, 0x1e, 0x0, 0x3e, 0x0, 0x7c, 0x3, 0xf8, 0x3, 0xf0, 0x3, 0xfc, 0x0, 0x7e, 0x0, 0x3f, 0x0, 0x1f, 0xf0, 0x1f, 0xf0, 0x1f, 0xf0, 0x3f, 0xf8, 0x3e, 0x7f, 0xfe, 0x7f, 0xfc, 0x3f, 0xf8, 0xf, 0xe0}

/* four (52) */
#define NXFONT_METRICS_52 {2, 16, 24, 1, 13, 0}
#define NXFONT_BITMAP_52 {0x0, 0xf8, 0x0, 0xf8, 0x1, 0xf8, 0x3, 0xf8, 0x3, 0xf8, 0x7, 0xf8, 0xf, 0x78, 0xe, 0x78, 0x1e, 0x78, 0x1c, 0x78, 0x3c, 0x78, 0x78, 0x78, 0x70, 0x78, 0xf0, 0x78, 0xe0, 0x78, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x78, 0x0, 0x78, 0x0, 0x78, 0x0, 0x78, 0x0, 0x78}

/* five (53) */
#define NXFONT_METRICS_53 {2, 15, 24, 1, 13, 0}
#define NXFONT_BITMAP_53 {0x3f, 0xfc, 0x3f, 0xfc, 0x3f, 0xfc, 0x3f, 0xfc, 0x38, 0x0, 0x78, 0x0, 0x78, 0x0, 0x78, 0x0, 0x7b, 0xe0, 0x7f, 0xf8, 0x7f, 0xfc, 0x7f, 0xfc, 0x78, 0x7e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x1e, 0x0, 0x1e, 0xf0, 0x3e, 0xf0, 0x3e, 0xf8, 0x7c, 0x7f, 0xfc, 0x7f, 0xf8, 0x3f, 0xf0, 0xf, 0xc0}

/* six (54) */
#define NXFONT_METRICS_54 {2, 15, 24, 1, 13, 0}
#define NXFONT_BITMAP_54 {0x7, 0xe0, 0x1f, 0xf8, 0x3f, 0xfc, 0x3f, 0xfe, 0x7c, 0x3e, 0x78, 0x1e, 0xf0, 0x0, 0xf0, 0x0, 0xf3, 0xe0, 0xf7, 0xf8, 0xff, 0xfc, 0xff, 0xfc, 0xfc, 0x7e, 0xf8, 0x3e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf8, 0x3e, 0x7c, 0x7c, 0x7f, 0xfc, 0x3f, 0xf8, 0x1f, 0xf0, 0x7, 0xc0}

/* seven (55) */
#define NXFONT_METRICS_55 {2, 16, 24, 1, 13, 0}
#define NXFONT_BITMAP_55 {0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x1e, 0x0, 0x3e, 0x0, 0x3c, 0x0, 0x78, 0x0, 0xf8, 0x0, 0xf0, 0x1, 0xf0, 0x1, 0xe0, 0x3, 0xe0, 0x3, 0xc0, 0x7, 0xc0, 0x7, 0xc0, 0x7, 0x80, 0xf, 0x80, 0xf, 0x80, 0xf, 0x80, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0}

/* eight (56) */
#define NXFONT_METRICS_56 {3, 17, 24, 0, 13, 0}
#define NXFONT_BITMAP_56 {0x7, 0xf0, 0x0, 0x1f, 0xfc, 0x0, 0x3f, 0xfe, 0x0, 0x3e, 0x3e, 0x0, 0x7c, 0x1f, 0x0, 0x78, 0xf, 0x0, 0x78, 0xf, 0x0, 0x78, 0xf, 0x0, 0x7c, 0x1f, 0x0, 0x3e, 0x3e, 0x0, 0x1f, 0xfc, 0x0, 0x1f, 0xfc, 0x0, 0x3f, 0xfe, 0x0, 0x7c, 0x1f, 0x0, 0xf8, 0xf, 0x80, 0xf0, 0x7, 0x80, 0xf0, 0x7, 0x80, 0xf0, 0x7, 0x80, 0xf8, 0xf, 0x80, 0x7e, 0x3f, 0x0, 0x7f, 0xfe, 0x0, 0x3f, 0xfe, 0x0, 0x1f, 0xfc, 0x0, 0x7, 0xf0, 0x0}

/* nine (57) */
#define NXFONT_METRICS_57 {2, 15, 24, 1, 13, 0}
#define NXFONT_BITMAP_57 {0x7, 0xc0, 0x1f, 0xf0, 0x3f, 0xf8, 0x7f, 0xfc, 0x7c, 0x7c, 0xf8, 0x3e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf8, 0x3e, 0xfc, 0x7e, 0x7f, 0xfe, 0x7f, 0xfe, 0x3f, 0xde, 0x7, 0x9e, 0x0, 0x1e, 0x0, 0x1e, 0xf0, 0x3c, 0xf8, 0x7c, 0x7f, 0xf8, 0x7f, 0xf8, 0x1f, 0xf0, 0x7, 0xc0}

/* colon (58) */
#define NXFONT_METRICS_58 {1, 5, 17, 3, 20, 0}
#define NXFONT_BITMAP_58 {0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8}

/* semicolon (59) */
#define NXFONT_METRICS_59 {1, 5, 23, 3, 20, 0}
#define NXFONT_BITMAP_59 {0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0x18, 0x18, 0x38, 0x70, 0xe0, 0x80}

/* less (60) */
#define NXFONT_METRICS_60 {2, 16, 16, 1, 21, 0}
#define NXFONT_BITMAP_60 {0x0, 0x3, 0x0, 0x1f, 0x0, 0x7f, 0x3, 0xff, 0xf, 0xfe, 0x7f, 0xf8, 0xff, 0xc0, 0xfe, 0x0, 0xfe, 0x0, 0xff, 0xc0, 0x7f, 0xf0, 0xf, 0xfe, 0x3, 0xff, 0x0, 0x7f, 0x0, 0x1f, 0x0, 0x3}

/* equal (61) */
#define NXFONT_METRICS_61 {2, 15, 12, 2, 23, 0}
#define NXFONT_BITMAP_61 {0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe}

/* greater (62) */
#define NXFONT_METRICS_62 {2, 16, 16, 1, 21, 0}
#define NXFONT_BITMAP_62 {0xc0, 0x0, 0xf0, 0x0, 0xfe, 0x0, 0xff, 0xc0, 0x7f, 0xf0, 0x1f, 0xfe, 0x3, 0xff, 0x0, 0x7f, 0x0, 0x7f, 0x3, 0xff, 0x1f, 0xfe, 0x7f, 0xf0, 0xff, 0xc0, 0xfe, 0x0, 0xf0, 0x0, 0xc0, 0x0}

/* question (63) */
#define NXFONT_METRICS_63 {2, 16, 25, 2, 12, 0}
#define NXFONT_BITMAP_63 {0xf, 0xe0, 0x3f, 0xf8, 0x7f, 0xfc, 0x7f, 0xfe, 0xfc, 0x7e, 0xf8, 0x3f, 0xf8, 0x1f, 0xf0, 0x1f, 0xf0, 0x1f, 0x0, 0x3f, 0x0, 0x7e, 0x0, 0xfe, 0x1, 0xfc, 0x1, 0xf8, 0x3, 0xe0, 0x3, 0xc0, 0x7, 0xc0, 0x7, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xc0, 0x7, 0xc0, 0x7, 0xc0, 0x7, 0xc0, 0x7, 0xc0}

/* at (64) */
#define NXFONT_METRICS_64 {4, 29, 30, 1, 12, 0}
#define NXFONT_BITMAP_64 {0x0, 0xf, 0xe0, 0x0, 0x0, 0x7f, 0xfc, 0x0, 0x1, 0xff, 0xfe, 0x0, 0x3, 0xf0, 0x3f, 0x80, 0x7, 0xc0, 0x7, 0xc0, 0xf, 0x0, 0x3, 0xc0, 0x1e, 0x0, 0x1, 0xe0, 0x1c, 0x0, 0x0, 0xf0, 0x3c, 0x7, 0xdc, 0x70, 0x38, 0x1f, 0xfc, 0x70, 0x70, 0x3c, 0xfc, 0x38, 0x70, 0x78, 0x78, 0x38, 0xf0, 0xf0, 0x38, 0x38, 0xe0, 0xe0, 0x38, 0x38, 0xe1, 0xe0, 0x38, 0x38, 0xe1, 0xc0, 0x70, 0x78, 0xe1, 0xc0, 0x70, 0x70, 0xe1, 0xc0, 0x70, 0x70, 0xe1, 0xe0, 0xf0, 0xe0, 0xf1, 0xe1, 0xf1, 0xe0, 0x70, 0xff, 0xff, 0xc0, 0x78, 0x7f, 0x3f, 0x80, 0x38, 0x3e, 0x1e, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x0, 0xf, 0x80, 0x0, 0x0, 0xf, 0xf0, 0x3c, 0x0, 0x3, 0xff, 0xfc, 0x0, 0x1, 0xff, 0xfc, 0x0, 0x0, 0x7f, 0xe0, 0x0}

/* A (65) */
#define NXFONT_METRICS_65 {3, 22, 25, 0, 12, 0}
#define NXFONT_BITMAP_65 {0x0, 0xfc, 0x0, 0x0, 0xfc, 0x0, 0x1, 0xfe, 0x0, 0x1, 0xfe, 0x0, 0x1, 0xfe, 0x0, 0x3, 0xff, 0x0, 0x3, 0xff, 0x0, 0x3, 0xff, 0x0, 0x7, 0xcf, 0x80, 0x7, 0xcf, 0x80, 0x7, 0xcf, 0x80, 0xf, 0x87, 0x80, 0xf, 0x87, 0xc0, 0xf, 0x87, 0xc0, 0x1f, 0x3, 0xc0, 0x1f, 0x3, 0xe0, 0x1f, 0xff, 0xe0, 0x1f, 0xff, 0xe0, 0x3f, 0xff, 0xf0, 0x3f, 0xff, 0xf0, 0x3e, 0x1, 0xf0, 0x7c, 0x0, 0xf8, 0x7c, 0x0, 0xf8, 0xfc, 0x0, 0xfc, 0xf8, 0x0, 0x7c}

/* B (66) */
#define NXFONT_METRICS_66 {3, 19, 25, 3, 12, 0}
#define NXFONT_BITMAP_66 {0xff, 0xfc, 0x0, 0xff, 0xff, 0x0, 0xff, 0xff, 0x80, 0xff, 0xff, 0x80, 0xf8, 0xf, 0xc0, 0xf8, 0x7, 0xc0, 0xf8, 0x7, 0xc0, 0xf8, 0x7, 0xc0, 0xf8, 0x7, 0xc0, 0xf8, 0xf, 0x80, 0xff, 0xff, 0x0, 0xff, 0xff, 0x0, 0xff, 0xff, 0x80, 0xff, 0xff, 0xc0, 0xf8, 0x7, 0xc0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x7, 0xe0, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xc0, 0xff, 0xff, 0x80, 0xff, 0xfe, 0x0}

/* C (67) */
#define NXFONT_METRICS_67 {3, 21, 25, 1, 12, 0}
#define NXFONT_BITMAP_67 {0x1, 0xfe, 0x0, 0x7, 0xff, 0x80, 0xf, 0xff, 0xc0, 0x1f, 0xff, 0xe0, 0x3f, 0x87, 0xf0, 0x3e, 0x1, 0xf0, 0x7c, 0x1, 0xf8, 0x7c, 0x0, 0xf8, 0x7c, 0x0, 0xf8, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x7c, 0x0, 0xf8, 0x7c, 0x0, 0xf8, 0x7e, 0x1, 0xf8, 0x3e, 0x1, 0xf0, 0x3f, 0x87, 0xf0, 0x1f, 0xff, 0xe0, 0xf, 0xff, 0xc0, 0x7, 0xff, 0x80, 0x1, 0xfe, 0x0}

/* D (68) */
#define NXFONT_METRICS_68 {3, 21, 25, 2, 12, 0}
#define NXFONT_BITMAP_68 {0xff, 0xf8, 0x0, 0xff, 0xff, 0x0, 0xff, 0xff, 0x80, 0xff, 0xff, 0xc0, 0xf8, 0xf, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xf0, 0xf8, 0x1, 0xf0, 0xf8, 0x1, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x1, 0xf8, 0xf8, 0x1, 0xf0, 0xf8, 0x3, 0xf0, 0xf8, 0x3, 0xe0, 0xf8, 0xf, 0xe0, 0xff, 0xff, 0xc0, 0xff, 0xff, 0x80, 0xff, 0xff, 0x0, 0xff, 0xf8, 0x0}

/* E (69) */
#define NXFONT_METRICS_69 {3, 18, 25, 2, 12, 0}
#define NXFONT_BITMAP_69 {0xff, 0xff, 0x80, 0xff, 0xff, 0x80, 0xff, 0xff, 0x80, 0xff, 0xff, 0x80, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xff, 0xff, 0x0, 0xff, 0xff, 0x0, 0xff, 0xff, 0x0, 0xff, 0xff, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xc0}

/* F (70) */
#define NXFONT_METRICS_70 {2, 16, 25, 2, 12, 0}
#define NXFONT_BITMAP_70 {0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x0, 0xf8, 0x0, 0xf8, 0x0, 0xf8, 0x0, 0xf8, 0x0, 0xf8, 0x0, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xf8, 0x0, 0xf8, 0x0, 0xf8, 0x0, 0xf8, 0x0, 0xf8, 0x0, 0xf8, 0x0, 0xf8, 0x0, 0xf8, 0x0, 0xf8, 0x0, 0xf8, 0x0, 0xf8, 0x0}

/* G (71) */
#define NXFONT_METRICS_71 {3, 22, 25, 1, 12, 0}
#define NXFONT_BITMAP_71 {0x0, 0xff, 0x0, 0x3, 0xff, 0xc0, 0xf, 0xff, 0xe0, 0x1f, 0xff, 0xf0, 0x1f, 0xc3, 0xf8, 0x3f, 0x0, 0xf8, 0x7e, 0x0, 0x7c, 0x7c, 0x0, 0x7c, 0xfc, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0xf, 0xfc, 0xf8, 0xf, 0xfc, 0xf8, 0xf, 0xfc, 0xf8, 0xf, 0xfc, 0xfc, 0x0, 0x7c, 0x7c, 0x0, 0x7c, 0x7e, 0x0, 0x7c, 0x7e, 0x0, 0xfc, 0x3f, 0x83, 0xfc, 0x3f, 0xff, 0xfc, 0x1f, 0xff, 0xdc, 0x7, 0xff, 0x9c, 0x3, 0xfe, 0x1c}

/* H (72) */
#define NXFONT_METRICS_72 {3, 19, 25, 2, 12, 0}
#define NXFONT_BITMAP_72 {0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xff, 0xff, 0xe0, 0xff, 0xff, 0xe0, 0xff, 0xff, 0xe0, 0xff, 0xff, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0}

/* I (73) */
#define NXFONT_METRICS_73 {1, 5, 25, 2, 12, 0}
#define NXFONT_BITMAP_73 {0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8}

/* J (74) */
#define NXFONT_METRICS_74 {2, 15, 25, 1, 12, 0}
#define NXFONT_BITMAP_74 {0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0xf8, 0x3e, 0xf8, 0x3e, 0xf8, 0x3e, 0xf8, 0x3e, 0xf8, 0x3e, 0xfc, 0x7e, 0xff, 0xfc, 0x7f, 0xfc, 0x3f, 0xf8, 0xf, 0xe0}

/* K (75) */
#define NXFONT_METRICS_75 {3, 20, 25, 2, 12, 0}
#define NXFONT_BITMAP_75 {0xf8, 0x7, 0xe0, 0xf8, 0x7, 0xe0, 0xf8, 0xf, 0xc0, 0xf8, 0x1f, 0x80, 0xf8, 0x3f, 0x0, 0xf8, 0x7e, 0x0, 0xf8, 0xfc, 0x0, 0xf8, 0xf8, 0x0, 0xf9, 0xf8, 0x0, 0xfb, 0xf0, 0x0, 0xff, 0xe0, 0x0, 0xff, 0xe0, 0x0, 0xff, 0xf0, 0x0, 0xff, 0xf0, 0x0, 0xff, 0xf8, 0x0, 0xfc, 0xfc, 0x0, 0xf8, 0x7e, 0x0, 0xf8, 0x7e, 0x0, 0xf8, 0x3f, 0x0, 0xf8, 0x1f, 0x80, 0xf8, 0xf, 0x80, 0xf8, 0xf, 0xc0, 0xf8, 0x7, 0xe0, 0xf8, 0x3, 0xf0, 0xf8, 0x3, 0xf0}

/* L (76) */
#define NXFONT_METRICS_76 {2, 16, 25, 2, 12, 0}
#define NXFONT_BITMAP_76 {0xf8, 0x0, 0xf8, 0x0, 0xf8, 0x0, 0xf8, 0x0, 0xf8, 0x0, 0xf8, 0x0, 0xf8, 0x0, 0xf8, 0x0, 0xf8, 0x0, 0xf8, 0x0, 0xf8, 0x0, 0xf8, 0x0, 0xf8, 0x0, 0xf8, 0x0, 0xf8, 0x0, 0xf8, 0x0, 0xf8, 0x0, 0xf8, 0x0, 0xf8, 0x0, 0xf8, 0x0, 0xf8, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff}

/* M (77) */
#define NXFONT_METRICS_77 {3, 23, 25, 2, 12, 0}
#define NXFONT_BITMAP_77 {0xfe, 0x0, 0xfe, 0xfe, 0x0, 0xfe, 0xff, 0x1, 0xfe, 0xff, 0x1, 0xfe, 0xff, 0x1, 0xfe, 0xff, 0x1, 0xfe, 0xff, 0x83, 0xfe, 0xff, 0x83, 0xfe, 0xfb, 0x83, 0xbe, 0xfb, 0x83, 0xbe, 0xfb, 0xc7, 0xbe, 0xfb, 0xc7, 0xbe, 0xfb, 0xc7, 0xbe, 0xf9, 0xc7, 0x3e, 0xf9, 0xef, 0x3e, 0xf9, 0xef, 0x3e, 0xf9, 0xef, 0x3e, 0xf9, 0xef, 0x3e, 0xf8, 0xee, 0x3e, 0xf8, 0xfe, 0x3e, 0xf8, 0xfe, 0x3e, 0xf8, 0xfe, 0x3e, 0xf8, 0x7c, 0x3e, 0xf8, 0x7c, 0x3e, 0xf8, 0x7c, 0x3e}

/* N (78) */
#define NXFONT_METRICS_78 {3, 19, 25, 2, 12, 0}
#define NXFONT_BITMAP_78 {0xf8, 0x3, 0xe0, 0xfc, 0x3, 0xe0, 0xfc, 0x3, 0xe0, 0xfe, 0x3, 0xe0, 0xfe, 0x3, 0xe0, 0xff, 0x3, 0xe0, 0xff, 0x3, 0xe0, 0xff, 0x83, 0xe0, 0xff, 0xc3, 0xe0, 0xfb, 0xc3, 0xe0, 0xfb, 0xe3, 0xe0, 0xf9, 0xe3, 0xe0, 0xf9, 0xf3, 0xe0, 0xf8, 0xf3, 0xe0, 0xf8, 0xfb, 0xe0, 0xf8, 0x7b, 0xe0, 0xf8, 0x3f, 0xe0, 0xf8, 0x3f, 0xe0, 0xf8, 0x1f, 0xe0, 0xf8, 0x1f, 0xe0, 0xf8, 0xf, 0xe0, 0xf8, 0xf, 0xe0, 0xf8, 0x7, 0xe0, 0xf8, 0x7, 0xe0, 0xf8, 0x3, 0xe0}

/* O (79) */
#define NXFONT_METRICS_79 {3, 23, 25, 1, 12, 0}
#define NXFONT_BITMAP_79 {0x1, 0xff, 0x0, 0x7, 0xff, 0xc0, 0xf, 0xff, 0xe0, 0x1f, 0xff, 0xf0, 0x3f, 0xc7, 0xf8, 0x3f, 0x1, 0xf8, 0x7e, 0x0, 0xfc, 0x7c, 0x0, 0x7c, 0x7c, 0x0, 0x7c, 0xf8, 0x0, 0x3e, 0xf8, 0x0, 0x3e, 0xf8, 0x0, 0x3e, 0xf8, 0x0, 0x3e, 0xf8, 0x0, 0x3e, 0xf8, 0x0, 0x3e, 0xf8, 0x0, 0x3e, 0x7c, 0x0, 0x7c, 0x7c, 0x0, 0x7c, 0x7e, 0x0, 0xfc, 0x3f, 0x1, 0xf8, 0x3f, 0xc7, 0xf8, 0x1f, 0xff, 0xf0, 0xf, 0xff, 0xe0, 0x7, 0xff, 0xc0, 0x1, 0xff, 0x0}

/* P (80) */
#define NXFONT_METRICS_80 {3, 18, 25, 2, 12, 0}
#define NXFONT_BITMAP_80 {0xff, 0xf8, 0x0, 0xff, 0xfe, 0x0, 0xff, 0xff, 0x0, 0xff, 0xff, 0x80, 0xf8, 0x1f, 0x80, 0xf8, 0xf, 0xc0, 0xf8, 0x7, 0xc0, 0xf8, 0x7, 0xc0, 0xf8, 0x7, 0xc0, 0xf8, 0x7, 0xc0, 0xf8, 0xf, 0xc0, 0xf8, 0x1f, 0x80, 0xff, 0xff, 0x80, 0xff, 0xff, 0x0, 0xff, 0xfc, 0x0, 0xff, 0xf0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0}

/* Q (81) */
#define NXFONT_METRICS_81 {3, 23, 26, 1, 12, 0}
#define NXFONT_BITMAP_81 {0x1, 0xff, 0x0, 0x7, 0xff, 0xc0, 0xf, 0xff, 0xe0, 0x1f, 0xff, 0xf0, 0x3f, 0xc7, 0xf8, 0x3f, 0x1, 0xf8, 0x7e, 0x0, 0xfc, 0x7c, 0x0, 0x7c, 0xfc, 0x0, 0x7e, 0xf8, 0x0, 0x3e, 0xf8, 0x0, 0x3e, 0xf8, 0x0, 0x3e, 0xf8, 0x0, 0x3e, 0xf8, 0x0, 0x3e, 0xf8, 0x0, 0x3e, 0xf8, 0x2, 0x3e, 0xfc, 0x7, 0x3e, 0x7c, 0xf, 0xbc, 0x7e, 0xf, 0xfc, 0x3f, 0x7, 0xf8, 0x3f, 0xc3, 0xf0, 0x1f, 0xff, 0xf8, 0xf, 0xff, 0xfc, 0x7, 0xff, 0xfe, 0x1, 0xff, 0x3c, 0x0, 0x0, 0x18}

/* R (82) */
#define NXFONT_METRICS_82 {3, 19, 25, 2, 12, 0}
#define NXFONT_BITMAP_82 {0xff, 0xfe, 0x0, 0xff, 0xff, 0x80, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xc0, 0xf8, 0x7, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x7, 0xc0, 0xf8, 0xf, 0xc0, 0xff, 0xff, 0x80, 0xff, 0xff, 0x0, 0xff, 0xff, 0x0, 0xff, 0xff, 0x80, 0xf8, 0xf, 0xc0, 0xf8, 0x7, 0xc0, 0xf8, 0x7, 0xc0, 0xf8, 0x7, 0xc0, 0xf8, 0x7, 0xc0, 0xf8, 0x7, 0xc0, 0xf8, 0x7, 0xc0, 0xf8, 0x7, 0xc0, 0xf8, 0x7, 0xe0, 0xf8, 0x3, 0xe0}

/* S (83) */
#define NXFONT_METRICS_83 {3, 19, 25, 1, 12, 0}
#define NXFONT_BITMAP_83 {0x3, 0xf8, 0x0, 0xf, 0xfe, 0x0, 0x1f, 0xff, 0x0, 0x3f, 0xff, 0x80, 0x3e, 0x1f, 0x80, 0x7c, 0x7, 0xc0, 0x78, 0x7, 0xc0, 0x78, 0x3, 0xc0, 0x7c, 0x0, 0x0, 0x7f, 0x0, 0x0, 0x3f, 0xf0, 0x0, 0x3f, 0xfe, 0x0, 0x1f, 0xff, 0x80, 0x3, 0xff, 0xc0, 0x0, 0x3f, 0xc0, 0x0, 0x7, 0xe0, 0x0, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0x7c, 0x3, 0xe0, 0x7e, 0xf, 0xc0, 0x3f, 0xff, 0xc0, 0x1f, 0xff, 0x80, 0xf, 0xff, 0x0, 0x3, 0xf8, 0x0}

/* T (84) */
#define NXFONT_METRICS_84 {3, 19, 25, 0, 12, 0}
#define NXFONT_BITMAP_84 {0xff, 0xff, 0xe0, 0xff, 0xff, 0xe0, 0xff, 0xff, 0xe0, 0xff, 0xff, 0xe0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0}

/* U (85) */
#define NXFONT_METRICS_85 {3, 19, 25, 2, 12, 0}
#define NXFONT_BITMAP_85 {0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xfc, 0x7, 0xe0, 0x7f, 0x1f, 0xc0, 0x7f, 0xff, 0xc0, 0x3f, 0xff, 0x80, 0x1f, 0xff, 0x0, 0x7, 0xfc, 0x0}

/* V (86) */
#define NXFONT_METRICS_86 {3, 20, 25, 1, 12, 0}
#define NXFONT_BITMAP_86 {0xf8, 0x1, 0xf0, 0xf8, 0x1, 0xf0, 0x7c, 0x3, 0xe0, 0x7c, 0x3, 0xe0, 0x7c, 0x3, 0xe0, 0x3c, 0x3, 0xc0, 0x3e, 0x7, 0xc0, 0x3e, 0x7, 0xc0, 0x1e, 0x7, 0x80, 0x1f, 0xf, 0x80, 0x1f, 0xf, 0x80, 0xf, 0xf, 0x0, 0xf, 0xf, 0x0, 0xf, 0xf, 0x0, 0x7, 0x9e, 0x0, 0x7, 0x9e, 0x0, 0x7, 0x9e, 0x0, 0x7, 0xfe, 0x0, 0x3, 0xfc, 0x0, 0x3, 0xfc, 0x0, 0x3, 0xfc, 0x0, 0x1, 0xf8, 0x0, 0x1, 0xf8, 0x0, 0x1, 0xf8, 0x0, 0x0, 0xf0, 0x0}

/* W (87) */
#define NXFONT_METRICS_87 {4, 29, 25, 1, 12, 0}
#define NXFONT_BITMAP_87 {0xf8, 0x1f, 0x81, 0xf8, 0xf8, 0x1f, 0x81, 0xf8, 0x78, 0x1f, 0x81, 0xf0, 0x78, 0x1f, 0x81, 0xf0, 0x78, 0x1f, 0x81, 0xf0, 0x7c, 0x3f, 0xc3, 0xe0, 0x7c, 0x3f, 0xc3, 0xe0, 0x7c, 0x3f, 0xc3, 0xe0, 0x3c, 0x3f, 0xc3, 0xe0, 0x3c, 0x39, 0xc3, 0xc0, 0x3e, 0x79, 0xe3, 0xc0, 0x3e, 0x79, 0xe7, 0xc0, 0x1e, 0x79, 0xe7, 0xc0, 0x1e, 0x79, 0xe7, 0x80, 0x1e, 0x70, 0xe7, 0x80, 0x1e, 0x70, 0xe7, 0x80, 0xf, 0xf0, 0xff, 0x0, 0xf, 0xf0, 0xff, 0x0, 0xf, 0xf0, 0xff, 0x0, 0xf, 0xe0, 0x7f, 0x0, 0x7, 0xe0, 0x7e, 0x0, 0x7, 0xe0, 0x7e, 0x0, 0x7, 0xe0, 0x7e, 0x0, 0x3, 0xc0, 0x3c, 0x0, 0x3, 0xc0, 0x3c, 0x0}

/* X (88) */
#define NXFONT_METRICS_88 {3, 20, 25, 1, 12, 0}
#define NXFONT_BITMAP_88 {0xfc, 0x3, 0xe0, 0x7e, 0x7, 0xe0, 0x7e, 0x7, 0xc0, 0x3f, 0xf, 0xc0, 0x1f, 0xf, 0x80, 0x1f, 0x9f, 0x0, 0xf, 0x9f, 0x0, 0xf, 0xbe, 0x0, 0x7, 0xfe, 0x0, 0x7, 0xfc, 0x0, 0x3, 0xfc, 0x0, 0x3, 0xf8, 0x0, 0x1, 0xf8, 0x0, 0x3, 0xf8, 0x0, 0x3, 0xfc, 0x0, 0x7, 0xfc, 0x0, 0x7, 0xfe, 0x0, 0xf, 0xbf, 0x0, 0x1f, 0x9f, 0x0, 0x1f, 0x1f, 0x80, 0x3f, 0xf, 0x80, 0x3e, 0xf, 0xc0, 0x7e, 0x7, 0xc0, 0xfc, 0x7, 0xe0, 0xfc, 0x3, 0xf0}

/* Y (89) */
#define NXFONT_METRICS_89 {3, 20, 25, 1, 12, 0}
#define NXFONT_BITMAP_89 {0xfc, 0x3, 0xf0, 0xfc, 0x3, 0xe0, 0x7e, 0x7, 0xe0, 0x3e, 0x7, 0xc0, 0x3f, 0xf, 0xc0, 0x3f, 0xf, 0x80, 0x1f, 0xf, 0x80, 0x1f, 0x9f, 0x0, 0xf, 0x9f, 0x0, 0xf, 0xfe, 0x0, 0x7, 0xfe, 0x0, 0x7, 0xfc, 0x0, 0x3, 0xfc, 0x0, 0x3, 0xf8, 0x0, 0x3, 0xf8, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0}

/* Z (90) */
#define NXFONT_METRICS_90 {3, 17, 25, 1, 12, 0}
#define NXFONT_BITMAP_90 {0xff, 0xff, 0x80, 0xff, 0xff, 0x80, 0xff, 0xff, 0x80, 0xff, 0xff, 0x80, 0x0, 0xf, 0x80, 0x0, 0x1f, 0x80, 0x0, 0x3f, 0x0, 0x0, 0x7e, 0x0, 0x0, 0x7c, 0x0, 0x0, 0xfc, 0x0, 0x1, 0xf8, 0x0, 0x3, 0xf0, 0x0, 0x3, 0xf0, 0x0, 0x7, 0xe0, 0x0, 0xf, 0xc0, 0x0, 0xf, 0x80, 0x0, 0x1f, 0x80, 0x0, 0x3f, 0x0, 0x0, 0x7e, 0x0, 0x0, 0x7e, 0x0, 0x0, 0xfc, 0x0, 0x0, 0xff, 0xff, 0x80, 0xff, 0xff, 0x80, 0xff, 0xff, 0x80, 0xff, 0xff, 0x80}

/* bracketleft (91) */
#define NXFONT_METRICS_91 {1, 8, 31, 2, 12, 0}
#define NXFONT_BITMAP_91 {0xff, 0xff, 0xff, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xff, 0xff, 0xff}

/* backslash (92) */
#define NXFONT_METRICS_92 {2, 9, 25, 0, 12, 0}
#define NXFONT_BITMAP_92 {0xc0, 0x0, 0xc0, 0x0, 0xe0, 0x0, 0x60, 0x0, 0x60, 0x0, 0x70, 0x0, 0x70, 0x0, 0x30, 0x0, 0x38, 0x0, 0x38, 0x0, 0x18, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0xc, 0x0, 0xc, 0x0, 0xe, 0x0, 0xe, 0x0, 0x6, 0x0, 0x7, 0x0, 0x7, 0x0, 0x3, 0x0, 0x3, 0x80, 0x3, 0x80, 0x1, 0x80, 0x1, 0x80}

/* bracketright (93) */
#define NXFONT_METRICS_93 {1, 8, 31, 0, 12, 0}
#define NXFONT_BITMAP_93 {0xff, 0xff, 0xff, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xff, 0xff, 0xff}

/* asciicircum (94) */
#define NXFONT_METRICS_94 {2, 14, 14, 2, 14, 0}
#define NXFONT_BITMAP_94 {0x7, 0x80, 0xf, 0xc0, 0xf, 0xc0, 0xf, 0xc0, 0x1f, 0xe0, 0x1f, 0xe0, 0x3c, 0xf0, 0x3c, 0xf0, 0x38, 0x70, 0x78, 0x78, 0x78, 0x78, 0x70, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c}

/* underscore (95) */
#define NXFONT_METRICS_95 {3, 18, 2, 0, 41, 0}
#define NXFONT_BITMAP_95 {0xff, 0xff, 0xc0, 0xff, 0xff, 0xc0}

/* grave (96) */
#define NXFONT_METRICS_96 {1, 5, 5, 2, 12, 0}
#define NXFONT_BITMAP_96 {0xe0, 0xf0, 0x70, 0x78, 0x38}

/* a (97) */
#define NXFONT_METRICS_97 {2, 15, 18, 1, 19, 0}
#define NXFONT_BITMAP_97 {0xf, 0xf0, 0x3f, 0xfc, 0x7f, 0xfc, 0x7c, 0x3e, 0xf8, 0x1e, 0xf8, 0x1e, 0x0, 0xfe, 0xf, 0xfe, 0x3f, 0xfe, 0x7f, 0x1e, 0xf8, 0x1e, 0xf8, 0x1e, 0xf0, 0x3e, 0xf8, 0x7e, 0xff, 0xfe, 0xff, 0xfe, 0x7f, 0xde, 0x3f, 0x1e}

/* b (98) */
#define NXFONT_METRICS_98 {2, 16, 25, 2, 12, 0}
#define NXFONT_BITMAP_98 {0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf3, 0xf0, 0xf7, 0xfc, 0xff, 0xfc, 0xff, 0xfe, 0xfc, 0x3e, 0xf8, 0x1f, 0xf0, 0x1f, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0x1f, 0xf0, 0x1f, 0xf8, 0x3e, 0xff, 0xfe, 0xff, 0xfc, 0xf7, 0xf8, 0xf1, 0xf0}

/* c (99) */
#define NXFONT_METRICS_99 {2, 15, 18, 1, 19, 0}
#define NXFONT_BITMAP_99 {0x7, 0xe0, 0x1f, 0xf8, 0x3f, 0xfc, 0x3f, 0xfc, 0x7c, 0x3e, 0x78, 0x3e, 0xf0, 0x1e, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x1e, 0xf8, 0x1e, 0x7c, 0x3e, 0x7f, 0xfc, 0x3f, 0xf8, 0x1f, 0xf8, 0x7, 0xe0}

/* d (100) */
#define NXFONT_METRICS_100 {2, 16, 25, 1, 12, 0}
#define NXFONT_BITMAP_100 {0x0, 0xf, 0x0, 0xf, 0x0, 0xf, 0x0, 0xf, 0x0, 0xf, 0x0, 0xf, 0x0, 0xf, 0xf, 0xcf, 0x1f, 0xef, 0x3f, 0xff, 0x7f, 0xff, 0x7c, 0x3f, 0xf8, 0x1f, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf8, 0x1f, 0x7c, 0x3f, 0x7f, 0xff, 0x3f, 0xef, 0x1f, 0xef, 0xf, 0x8f}

/* e (101) */
#define NXFONT_METRICS_101 {2, 16, 18, 1, 19, 0}
#define NXFONT_BITMAP_101 {0x7, 0xe0, 0x1f, 0xf8, 0x3f, 0xfc, 0x7f, 0xfe, 0x7c, 0x3e, 0xf8, 0x1f, 0xf0, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0, 0xf0, 0x0, 0xf8, 0x1e, 0x7c, 0x3e, 0x7f, 0xfc, 0x3f, 0xfc, 0x1f, 0xf0, 0x7, 0xc0}

/* f (102) */
#define NXFONT_METRICS_102 {2, 10, 25, 0, 12, 0}
#define NXFONT_BITMAP_102 {0x7, 0xc0, 0xf, 0xc0, 0x1f, 0xc0, 0x1f, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0xff, 0xc0, 0xff, 0xc0, 0xff, 0xc0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0}

/* g (103) */
#define NXFONT_METRICS_103 {2, 16, 25, 1, 19, 0}
#define NXFONT_BITMAP_103 {0xf, 0xcf, 0x1f, 0xef, 0x3f, 0xff, 0x7f, 0xff, 0x7c, 0x3f, 0xf8, 0x1f, 0xf8, 0x1f, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf8, 0x1f, 0xf8, 0x1f, 0x7c, 0x3f, 0x7f, 0xff, 0x3f, 0xff, 0x1f, 0xef, 0xf, 0xcf, 0x0, 0xf, 0xf8, 0x1f, 0xf8, 0x1f, 0x7e, 0x7e, 0x7f, 0xfe, 0x3f, 0xfc, 0xf, 0xf0}

/* h (104) */
#define NXFONT_METRICS_104 {2, 15, 25, 2, 12, 0}
#define NXFONT_BITMAP_104 {0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf1, 0xe0, 0xf7, 0xf8, 0xff, 0xfc, 0xff, 0xfc, 0xfc, 0x3e, 0xf8, 0x1e, 0xf8, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e}

/* i (105) */
#define NXFONT_METRICS_105 {1, 4, 25, 2, 12, 0}
#define NXFONT_BITMAP_105 {0xf0, 0xf0, 0xf0, 0xf0, 0x0, 0x0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0}

/* j (106) */
#define NXFONT_METRICS_106 {1, 6, 32, 0, 12, 0}
#define NXFONT_BITMAP_106 {0x3c, 0x3c, 0x3c, 0x3c, 0x0, 0x0, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0xfc, 0xfc, 0xf8, 0xf8}

/* k (107) */
#define NXFONT_METRICS_107 {2, 15, 25, 2, 12, 0}
#define NXFONT_BITMAP_107 {0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x3e, 0xf0, 0x7c, 0xf0, 0xf8, 0xf1, 0xf0, 0xf3, 0xe0, 0xf7, 0xc0, 0xff, 0x80, 0xff, 0xc0, 0xff, 0xc0, 0xff, 0xe0, 0xff, 0xe0, 0xf9, 0xf0, 0xf1, 0xf0, 0xf0, 0xf8, 0xf0, 0x78, 0xf0, 0x7c, 0xf0, 0x3e, 0xf0, 0x3e}

/* l (108) */
#define NXFONT_METRICS_108 {1, 4, 25, 2, 12, 0}
#define NXFONT_BITMAP_108 {0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0}

/* m (109) */
#define NXFONT_METRICS_109 {3, 24, 18, 2, 19, 0}
#define NXFONT_BITMAP_109 {0xf1, 0xe0, 0xf8, 0xf7, 0xfb, 0xfe, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xfc, 0x7f, 0x1f, 0xf8, 0x3e, 0xf, 0xf0, 0x3c, 0xf, 0xf0, 0x3c, 0xf, 0xf0, 0x3c, 0xf, 0xf0, 0x3c, 0xf, 0xf0, 0x3c, 0xf, 0xf0, 0x3c, 0xf, 0xf0, 0x3c, 0xf, 0xf0, 0x3c, 0xf, 0xf0, 0x3c, 0xf, 0xf0, 0x3c, 0xf, 0xf0, 0x3c, 0xf, 0xf0, 0x3c, 0xf}

/* n (110) */
#define NXFONT_METRICS_110 {2, 15, 18, 2, 19, 0}
#define NXFONT_BITMAP_110 {0xf1, 0xf0, 0xf7, 0xfc, 0xff, 0xfc, 0xff, 0xfe, 0xfc, 0x3e, 0xf8, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e}

/* o (111) */
#define NXFONT_METRICS_111 {3, 17, 18, 1, 19, 0}
#define NXFONT_BITMAP_111 {0x7, 0xf0, 0x0, 0x1f, 0xfc, 0x0, 0x3f, 0xfe, 0x0, 0x7f, 0xff, 0x0, 0x7c, 0x1f, 0x0, 0xf8, 0xf, 0x80, 0xf8, 0xf, 0x80, 0xf0, 0x7, 0x80, 0xf0, 0x7, 0x80, 0xf0, 0x7, 0x80, 0xf0, 0x7, 0x80, 0xf8, 0xf, 0x80, 0xf8, 0xf, 0x80, 0x7c, 0x1f, 0x0, 0x7f, 0xff, 0x0, 0x3f, 0xfe, 0x0, 0x1f, 0xfc, 0x0, 0x7, 0xf0, 0x0}

/* p (112) */
#define NXFONT_METRICS_112 {2, 16, 25, 2, 19, 0}
#define NXFONT_BITMAP_112 {0xf1, 0xf0, 0xf7, 0xf8, 0xff, 0xfc, 0xff, 0xfe, 0xfc, 0x3e, 0xf8, 0x1f, 0xf8, 0x1f, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf8, 0x1f, 0xf8, 0x1f, 0xfc, 0x3e, 0xff, 0xfe, 0xff, 0xfc, 0xf7, 0xf8, 0xf1, 0xf0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0}

/* q (113) */
#define NXFONT_METRICS_113 {2, 16, 25, 1, 19, 0}
#define NXFONT_BITMAP_113 {0x7, 0xcf, 0x1f, 0xef, 0x3f, 0xff, 0x7f, 0xff, 0x7c, 0x3f, 0xf8, 0x1f, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf8, 0x1f, 0x7c, 0x3f, 0x7f, 0xff, 0x3f, 0xff, 0x3f, 0xef, 0xf, 0xcf, 0x0, 0xf, 0x0, 0xf, 0x0, 0xf, 0x0, 0xf, 0x0, 0xf, 0x0, 0xf, 0x0, 0xf}

/* r (114) */
#define NXFONT_METRICS_114 {2, 10, 18, 2, 19, 0}
#define NXFONT_BITMAP_114 {0xf0, 0xc0, 0xf3, 0xc0, 0xf7, 0xc0, 0xff, 0xc0, 0xff, 0xc0, 0xfc, 0x0, 0xf8, 0x0, 0xf8, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0}

/* s (115) */
#define NXFONT_METRICS_115 {2, 16, 18, 1, 19, 0}
#define NXFONT_BITMAP_115 {0x7, 0xf0, 0x1f, 0xfc, 0x3f, 0xfe, 0x7c, 0x3e, 0x78, 0x1f, 0x78, 0x1f, 0x7c, 0x0, 0x7f, 0xc0, 0x3f, 0xf8, 0xf, 0xfe, 0x3, 0xff, 0x0, 0x3f, 0xf8, 0xf, 0xf8, 0xf, 0x7c, 0x1f, 0x7f, 0xfe, 0x3f, 0xfc, 0xf, 0xf0}

/* t (116) */
#define NXFONT_METRICS_116 {2, 9, 22, 1, 15, 0}
#define NXFONT_BITMAP_116 {0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0xff, 0x80, 0xff, 0x80, 0xff, 0x80, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3f, 0x80, 0x3f, 0x80, 0x1f, 0x80, 0xf, 0x80}

/* u (117) */
#define NXFONT_METRICS_117 {2, 15, 18, 2, 19, 0}
#define NXFONT_BITMAP_117 {0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf8, 0x3e, 0xf8, 0x7e, 0xff, 0xfe, 0x7f, 0xfe, 0x7f, 0xde, 0x1f, 0x1e}

/* v (118) */
#define NXFONT_METRICS_118 {3, 17, 18, 0, 19, 0}
#define NXFONT_BITMAP_118 {0xf8, 0xf, 0x80, 0xf8, 0xf, 0x80, 0x7c, 0x1f, 0x0, 0x7c, 0x1f, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3e, 0x3e, 0x0, 0x1e, 0x3c, 0x0, 0x1e, 0x3c, 0x0, 0x1e, 0x3c, 0x0, 0xf, 0x78, 0x0, 0xf, 0x78, 0x0, 0xf, 0x78, 0x0, 0x7, 0xf0, 0x0, 0x7, 0xf0, 0x0, 0x7, 0xf0, 0x0, 0x3, 0xe0, 0x0, 0x3, 0xe0, 0x0}

/* w (119) */
#define NXFONT_METRICS_119 {4, 25, 18, 0, 19, 0}
#define NXFONT_BITMAP_119 {0xf8, 0x3e, 0xf, 0x80, 0xf8, 0x3e, 0xf, 0x80, 0x78, 0x3e, 0xf, 0x0, 0x7c, 0x3e, 0x1f, 0x0, 0x7c, 0x7f, 0x1f, 0x0, 0x3c, 0x7f, 0x1e, 0x0, 0x3c, 0x7f, 0x1e, 0x0, 0x3c, 0x77, 0x1e, 0x0, 0x3c, 0xf7, 0x9e, 0x0, 0x1e, 0xe3, 0xbc, 0x0, 0x1e, 0xe3, 0xbc, 0x0, 0x1e, 0xe3, 0xbc, 0x0, 0x1f, 0xe3, 0xfc, 0x0, 0xf, 0xc1, 0xf8, 0x0, 0xf, 0xc1, 0xf8, 0x0, 0xf, 0xc1, 0xf8, 0x0, 0x7, 0x80, 0xf0, 0x0, 0x7, 0x80, 0xf0, 0x0}

/* x (120) */
#define NXFONT_METRICS_120 {2, 16, 18, 1, 19, 0}
#define NXFONT_BITMAP_120 {0xf8, 0x1f, 0xfc, 0x3f, 0x7c, 0x3e, 0x3e, 0x7c, 0x3e, 0x78, 0x1f, 0xf8, 0xf, 0xf0, 0x7, 0xe0, 0x3, 0xc0, 0x7, 0xe0, 0xf, 0xe0, 0xf, 0xf0, 0x1f, 0xf8, 0x3e, 0x78, 0x3e, 0x7c, 0x7c, 0x3e, 0xfc, 0x3f, 0xf8, 0x1f}

/* y (121) */
#define NXFONT_METRICS_121 {2, 16, 25, 1, 19, 0}
#define NXFONT_BITMAP_121 {0xf8, 0x1f, 0xf8, 0x1f, 0xf8, 0x1e, 0x78, 0x3e, 0x7c, 0x3e, 0x7c, 0x3c, 0x3c, 0x3c, 0x3e, 0x7c, 0x3e, 0x78, 0x1e, 0x78, 0x1e, 0x78, 0x1f, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xe0, 0x7, 0xe0, 0x7, 0xe0, 0x7, 0xc0, 0x7, 0xc0, 0x7, 0xc0, 0xf, 0x80, 0x3f, 0x80, 0x3f, 0x0, 0x3f, 0x0, 0x3c, 0x0}

/* z (122) */
#define NXFONT_METRICS_122 {2, 14, 18, 1, 19, 0}
#define NXFONT_BITMAP_122 {0xff, 0xfc, 0xff, 0xfc, 0xff, 0xfc, 0xff, 0xfc, 0x0, 0xf8, 0x1, 0xf0, 0x3, 0xf0, 0x7, 0xe0, 0xf, 0xc0, 0x1f, 0x80, 0x1f, 0x0, 0x3e, 0x0, 0x7c, 0x0, 0xf8, 0x0, 0xff, 0xfc, 0xff, 0xfc, 0xff, 0xfc, 0xff, 0xfc}

/* braceleft (123) */
#define NXFONT_METRICS_123 {2, 9, 32, 2, 12, 0}
#define NXFONT_BITMAP_123 {0xf, 0x80, 0x1f, 0x80, 0x3f, 0x80, 0x3e, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x7c, 0x0, 0x78, 0x0, 0xe0, 0x0, 0x78, 0x0, 0x7c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3f, 0x80, 0x1f, 0x80, 0xf, 0x80}

/* bar (124) */
#define NXFONT_METRICS_124 {1, 3, 31, 3, 12, 0}
#define NXFONT_BITMAP_124 {0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0}

/* braceright (125) */
#define NXFONT_METRICS_125 {2, 9, 32, 2, 12, 0}
#define NXFONT_BITMAP_125 {0xf8, 0x0, 0xfc, 0x0, 0xfe, 0x0, 0x3e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1f, 0x0, 0xf, 0x0, 0x3, 0x80, 0xf, 0x0, 0x1f, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0xfe, 0x0, 0xfc, 0x0, 0xf8, 0x0}

/* asciitilde (126) */
#define NXFONT_METRICS_126 {2, 14, 6, 2, 26, 0}
#define NXFONT_BITMAP_126 {0x38, 0x0, 0x7e, 0xc, 0xff, 0x9c, 0xe7, 0xfc, 0xc1, 0xf8, 0x0, 0x70}

/* exclamdown (161) */
#define NXFONT_METRICS_161 {1, 5, 24, 2, 19, 0}
#define NXFONT_BITMAP_161 {0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0x0, 0x0, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8}

/* cent (162) */
#define NXFONT_METRICS_162 {2, 15, 24, 1, 16, 0}
#define NXFONT_BITMAP_162 {0x0, 0x20, 0x0, 0x20, 0x0, 0x60, 0x7, 0xf0, 0x1f, 0xf8, 0x3f, 0xfc, 0x7f, 0xfc, 0x7c, 0xbe, 0xf8, 0x9e, 0xf9, 0x9e, 0xf1, 0x80, 0xf1, 0x80, 0xf3, 0x0, 0xf3, 0x0, 0xf3, 0x1e, 0xfa, 0x1e, 0x7e, 0x3e, 0x7f, 0xfc, 0x3f, 0xf8, 0x1f, 0xf0, 0xf, 0xc0, 0xc, 0x0, 0x8, 0x0, 0x8, 0x0}

/* sterling (163) */
#define NXFONT_METRICS_163 {3, 17, 24, 0, 13, 0}
#define NXFONT_BITMAP_163 {0x3, 0xf0, 0x0, 0x1f, 0xfc, 0x0, 0x3f, 0xfe, 0x0, 0x3f, 0xff, 0x0, 0x7e, 0x1f, 0x0, 0x7c, 0xf, 0x80, 0x7c, 0xf, 0x80, 0x7c, 0x7, 0x80, 0x7c, 0x0, 0x0, 0x7e, 0x0, 0x0, 0x3e, 0x0, 0x0, 0xff, 0xf0, 0x0, 0xff, 0xf0, 0x0, 0x1f, 0x0, 0x0, 0xf, 0x0, 0x0, 0xf, 0x0, 0x0, 0xf, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x3d, 0xe3, 0x0, 0x7f, 0xff, 0x80, 0xff, 0xff, 0x80, 0xff, 0xff, 0x0, 0x60, 0x7e, 0x0}

/* currency (164) */
#define NXFONT_METRICS_164 {2, 15, 15, 1, 18, 0}
#define NXFONT_BITMAP_164 {0xe0, 0xe, 0xf7, 0xde, 0xff, 0xfe, 0x7f, 0xfc, 0x3c, 0x78, 0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c, 0x3c, 0x78, 0x7f, 0xfc, 0xff, 0xfe, 0xf7, 0xde, 0xe0, 0xe}

/* yen (165) */
#define NXFONT_METRICS_165 {3, 18, 24, 0, 13, 0}
#define NXFONT_BITMAP_165 {0xf8, 0x7, 0xc0, 0xf8, 0x7, 0xc0, 0x7c, 0xf, 0x80, 0x3c, 0xf, 0x0, 0x1e, 0x1e, 0x0, 0x1e, 0x1e, 0x0, 0xf, 0x3c, 0x0, 0xf, 0x3c, 0x0, 0x7, 0xf8, 0x0, 0x7, 0xf8, 0x0, 0x3, 0xf0, 0x0, 0x1, 0xe0, 0x0, 0x3f, 0xff, 0x0, 0x3f, 0xff, 0x0, 0x1, 0xe0, 0x0, 0x1, 0xe0, 0x0, 0x3f, 0xff, 0x0, 0x3f, 0xff, 0x0, 0x1, 0xe0, 0x0, 0x1, 0xe0, 0x0, 0x1, 0xe0, 0x0, 0x1, 0xe0, 0x0, 0x1, 0xe0, 0x0, 0x1, 0xe0, 0x0}

/* brokenbar (166) */
#define NXFONT_METRICS_166 {1, 3, 31, 3, 12, 0}
#define NXFONT_BITMAP_166 {0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0}

/* section (167) */
#define NXFONT_METRICS_167 {2, 16, 32, 1, 12, 0}
#define NXFONT_BITMAP_167 {0xf, 0xf0, 0x1f, 0xf8, 0x3f, 0xf8, 0x7e, 0x7c, 0x7c, 0x3c, 0x7c, 0x3c, 0x7e, 0x0, 0x7f, 0x0, 0x3f, 0xc0, 0x1f, 0xe0, 0x3f, 0xf8, 0x7f, 0xfc, 0x71, 0xfe, 0xf0, 0xff, 0xf0, 0x3f, 0xf8, 0x1f, 0xfc, 0xf, 0x7f, 0xf, 0x7f, 0x9f, 0x3f, 0xfe, 0x1f, 0xf8, 0x7, 0xfc, 0x1, 0xfe, 0x0, 0x7e, 0x0, 0x3e, 0x78, 0x1e, 0x78, 0x1e, 0x7c, 0x3e, 0x3f, 0xfc, 0x3f, 0xfc, 0x1f, 0xf8, 0x7, 0xe0}

/* dieresis (168) */
#define NXFONT_METRICS_168 {2, 10, 4, 0, 12, 0}
#define NXFONT_BITMAP_168 {0xf3, 0xc0, 0xf3, 0xc0, 0xf3, 0xc0, 0xf3, 0xc0}

/* copyright (169) */
#define NXFONT_METRICS_169 {4, 26, 25, 0, 12, 0}
#define NXFONT_BITMAP_169 {0x0, 0x7f, 0x80, 0x0, 0x3, 0xff, 0xe0, 0x0, 0x7, 0x80, 0xf8, 0x0, 0x1f, 0x0, 0x3c, 0x0, 0x1c, 0x0, 0xe, 0x0, 0x38, 0x0, 0x7, 0x0, 0x70, 0x3f, 0x3, 0x0, 0x70, 0x7f, 0x83, 0x80, 0xe0, 0xf3, 0xc1, 0x80, 0xe1, 0xc0, 0xe1, 0xc0, 0xc1, 0xc0, 0xe0, 0xc0, 0xc3, 0x80, 0x0, 0xc0, 0xc3, 0x80, 0x0, 0xc0, 0xc3, 0x80, 0x0, 0xc0, 0xc3, 0x80, 0x0, 0xc0, 0xc1, 0xc0, 0xe0, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0xe0, 0xf3, 0xc3, 0x80, 0x60, 0x7f, 0x83, 0x80, 0x70, 0x3f, 0x7, 0x0, 0x38, 0x0, 0xe, 0x0, 0x1e, 0x0, 0x3c, 0x0, 0xf, 0x80, 0xf8, 0x0, 0x7, 0xff, 0xe0, 0x0, 0x1, 0xff, 0x80, 0x0}

/* ordfeminine (170) */
#define NXFONT_METRICS_170 {2, 9, 16, 1, 12, 0}
#define NXFONT_BITMAP_170 {0x3e, 0x0, 0x7f, 0x0, 0xe3, 0x80, 0xc3, 0x80, 0x1f, 0x80, 0x7f, 0x80, 0xf3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xff, 0x80, 0x7b, 0x80, 0x0, 0x0, 0x0, 0x0, 0xff, 0x80, 0xff, 0x80, 0xff, 0x80}

/* guillemotleft (171) */
#define NXFONT_METRICS_171 {2, 12, 13, 3, 22, 0}
#define NXFONT_BITMAP_171 {0x8, 0x10, 0x18, 0x30, 0x38, 0x70, 0x78, 0xf0, 0xf1, 0xe0, 0xe1, 0xc0, 0xe1, 0xc0, 0xf1, 0xe0, 0xf9, 0xf0, 0x78, 0xf0, 0x38, 0x70, 0x18, 0x30, 0x8, 0x10}

/* logicalnot (172) */
#define NXFONT_METRICS_172 {2, 16, 10, 1, 23, 0}
#define NXFONT_BITMAP_172 {0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0xf, 0x0, 0xf, 0x0, 0xf, 0x0, 0xf, 0x0, 0xf, 0x0, 0xf}

/* hyphen (173) */
#define NXFONT_METRICS_173 {2, 9, 5, 1, 25, 0}
#define NXFONT_BITMAP_173 {0xff, 0x80, 0xff, 0x80, 0xff, 0x80, 0xff, 0x80, 0xff, 0x80}

/* registered (174) */
#define NXFONT_METRICS_174 {4, 26, 25, 0, 12, 0}
#define NXFONT_BITMAP_174 {0x0, 0xff, 0x80, 0x0, 0x3, 0xff, 0xe0, 0x0, 0x7, 0x80, 0xf8, 0x0, 0x1e, 0x0, 0x3c, 0x0, 0x1c, 0x0, 0xe, 0x0, 0x38, 0xff, 0x87, 0x0, 0x70, 0xff, 0xc3, 0x0, 0x70, 0xe1, 0xe3, 0x80, 0xe0, 0xe0, 0xe1, 0x80, 0xe0, 0xe0, 0xe1, 0x80, 0xc0, 0xe0, 0xe1, 0xc0, 0xc0, 0xe1, 0xc1, 0xc0, 0xc0, 0xff, 0x81, 0xc0, 0xc0, 0xff, 0x1, 0xc0, 0xc0, 0xe3, 0x81, 0xc0, 0xc0, 0xe3, 0xc1, 0xc0, 0xe0, 0xe1, 0xc1, 0x80, 0xe0, 0xe0, 0xe3, 0x80, 0x70, 0xe0, 0xf3, 0x80, 0x70, 0xe0, 0x77, 0x0, 0x38, 0x0, 0xe, 0x0, 0x1e, 0x0, 0x1c, 0x0, 0xf, 0x80, 0x78, 0x0, 0x7, 0xff, 0xe0, 0x0, 0x1, 0xff, 0x80, 0x0}

/* macron (175) */
#define NXFONT_METRICS_175 {2, 10, 3, 0, 13, 0}
#define NXFONT_BITMAP_175 {0xff, 0xc0, 0xff, 0xc0, 0xff, 0xc0}

/* degree (176) */
#define NXFONT_METRICS_176 {2, 9, 10, 2, 13, 0}
#define NXFONT_BITMAP_176 {0x3e, 0x0, 0x7f, 0x0, 0x63, 0x0, 0xc1, 0x80, 0xc1, 0x80, 0xc1, 0x80, 0xc1, 0x80, 0x63, 0x0, 0x7f, 0x0, 0x3e, 0x0}

/* plusminus (177) */
#define NXFONT_METRICS_177 {2, 16, 22, 1, 15, 0}
#define NXFONT_BITMAP_177 {0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff}

/* twosuperior (178) */
#define NXFONT_METRICS_178 {2, 10, 15, 0, 13, 0}
#define NXFONT_BITMAP_178 {0x3f, 0x0, 0x7f, 0x80, 0xf3, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0x1, 0xc0, 0x3, 0xc0, 0x7, 0x80, 0xf, 0x0, 0x3e, 0x0, 0x78, 0x0, 0x70, 0x0, 0xff, 0xc0, 0xff, 0xc0, 0xff, 0xc0}

/* threesuperior (179) */
#define NXFONT_METRICS_179 {2, 10, 15, 0, 13, 0}
#define NXFONT_BITMAP_179 {0x1e, 0x0, 0x7f, 0x80, 0xf3, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0x3, 0xc0, 0xf, 0x80, 0xf, 0x80, 0x3, 0xc0, 0x1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0xf3, 0xc0, 0x7f, 0x80, 0x3e, 0x0}

/* acute (180) */
#define NXFONT_METRICS_180 {1, 6, 5, 4, 12, 0}
#define NXFONT_BITMAP_180 {0x3c, 0x78, 0x70, 0xe0, 0xe0}

/* mu (181) */
#define NXFONT_METRICS_181 {2, 15, 25, 2, 19, 0}
#define NXFONT_BITMAP_181 {0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf8, 0x3e, 0xf8, 0x7e, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xde, 0xf7, 0x9e, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0}

/* paragraph (182) */
#define NXFONT_METRICS_182 {3, 17, 31, 0, 12, 0}
#define NXFONT_BITMAP_182 {0xf, 0xff, 0x80, 0x1f, 0xff, 0x80, 0x3f, 0x8c, 0x0, 0x7f, 0x8c, 0x0, 0x7f, 0x8c, 0x0, 0xff, 0x8c, 0x0, 0xff, 0x8c, 0x0, 0xff, 0x8c, 0x0, 0xff, 0x8c, 0x0, 0xff, 0x8c, 0x0, 0x7f, 0x8c, 0x0, 0x7f, 0x8c, 0x0, 0x3f, 0x8c, 0x0, 0x3f, 0x8c, 0x0, 0xf, 0x8c, 0x0, 0x1, 0x8c, 0x0, 0x1, 0x8c, 0x0, 0x1, 0x8c, 0x0, 0x1, 0x8c, 0x0, 0x1, 0x8c, 0x0, 0x1, 0x8c, 0x0, 0x1, 0x8c, 0x0, 0x1, 0x8c, 0x0, 0x1, 0x8c, 0x0, 0x1, 0x8c, 0x0, 0x1, 0x8c, 0x0, 0x1, 0x8c, 0x0, 0x1, 0x8c, 0x0, 0x1, 0x8c, 0x0, 0x1, 0x8c, 0x0, 0x1, 0x8c, 0x0}

/* periodcentered (183) */
#define NXFONT_METRICS_183 {1, 4, 5, 2, 21, 0}
#define NXFONT_BITMAP_183 {0x60, 0xf0, 0xf0, 0xf0, 0x60}

/* cedilla (184) */
#define NXFONT_METRICS_184 {1, 7, 8, 2, 36, 0}
#define NXFONT_BITMAP_184 {0x30, 0x30, 0x30, 0x7c, 0x1e, 0xe, 0xfc, 0xf8}

/* onesuperior (185) */
#define NXFONT_METRICS_185 {1, 6, 15, 2, 13, 0}
#define NXFONT_BITMAP_185 {0x1c, 0x3c, 0xfc, 0xfc, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c}

/* ordmasculine (186) */
#define NXFONT_METRICS_186 {2, 10, 16, 1, 12, 0}
#define NXFONT_BITMAP_186 {0x3f, 0x0, 0x7f, 0x80, 0x73, 0x80, 0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0x73, 0x80, 0x7f, 0x80, 0x3f, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xc0, 0xff, 0xc0, 0xff, 0xc0}

/* guillemotright (187) */
#define NXFONT_METRICS_187 {2, 12, 12, 3, 22, 0}
#define NXFONT_BITMAP_187 {0x81, 0x0, 0xc1, 0x80, 0xe1, 0xc0, 0xf1, 0xe0, 0x78, 0xf0, 0x38, 0x70, 0x38, 0x70, 0x78, 0xf0, 0xf1, 0xe0, 0xe1, 0xc0, 0xc1, 0x80, 0x81, 0x0}

/* onequarter (188) */
#define NXFONT_METRICS_188 {4, 26, 24, 0, 13, 0}
#define NXFONT_BITMAP_188 {0x0, 0x0, 0x38, 0x0, 0x6, 0x0, 0x70, 0x0, 0x1e, 0x0, 0x70, 0x0, 0xfe, 0x0, 0xe0, 0x0, 0xfe, 0x1, 0xc0, 0x0, 0xe, 0x1, 0xc0, 0x0, 0xe, 0x3, 0x80, 0x0, 0xe, 0x3, 0x80, 0x0, 0xe, 0x7, 0x0, 0x0, 0xe, 0x7, 0x0, 0x0, 0xe, 0xe, 0x7, 0x0, 0xe, 0x1c, 0xf, 0x0, 0xe, 0x1c, 0x1f, 0x0, 0xe, 0x38, 0x1f, 0x0, 0x0, 0x38, 0x37, 0x0, 0x0, 0x70, 0x67, 0x0, 0x0, 0x70, 0xe7, 0x0, 0x0, 0xe0, 0xc7, 0x0, 0x1, 0xc1, 0x87, 0x0, 0x1, 0xc1, 0xff, 0xc0, 0x3, 0x81, 0xff, 0xc0, 0x3, 0x80, 0x7, 0x0, 0x7, 0x0, 0x7, 0x0, 0x7, 0x0, 0x7, 0x0}

/* onehalf (189) */
#define NXFONT_METRICS_189 {4, 25, 24, 1, 13, 0}
#define NXFONT_BITMAP_189 {0x0, 0x0, 0xe0, 0x0, 0xc, 0x1, 0xc0, 0x0, 0x1c, 0x1, 0xc0, 0x0, 0xfc, 0x3, 0x80, 0x0, 0xfc, 0x3, 0x80, 0x0, 0x1c, 0x7, 0x0, 0x0, 0x1c, 0xe, 0x0, 0x0, 0x1c, 0xe, 0x0, 0x0, 0x1c, 0x1c, 0x0, 0x0, 0x1c, 0x1c, 0x0, 0x0, 0x1c, 0x38, 0x7e, 0x0, 0x1c, 0x30, 0xff, 0x0, 0x1c, 0x71, 0xe7, 0x80, 0x1c, 0xe1, 0xc3, 0x80, 0x0, 0xe1, 0xc3, 0x80, 0x1, 0xc0, 0x7, 0x80, 0x1, 0xc0, 0xf, 0x0, 0x3, 0x80, 0x1e, 0x0, 0x7, 0x0, 0x3c, 0x0, 0x7, 0x0, 0x78, 0x0, 0xe, 0x0, 0xf0, 0x0, 0xe, 0x1, 0xff, 0x80, 0x1c, 0x1, 0xff, 0x80, 0x1c, 0x1, 0xff, 0x80}

/* threequarters (190) */
#define NXFONT_METRICS_190 {4, 25, 24, 1, 13, 0}
#define NXFONT_BITMAP_190 {0x3f, 0x0, 0x1c, 0x0, 0x7f, 0x80, 0x38, 0x0, 0xf3, 0xc0, 0x38, 0x0, 0xe1, 0xc0, 0x70, 0x0, 0xe1, 0xc0, 0xe0, 0x0, 0x3, 0xc0, 0xe0, 0x0, 0xf, 0x81, 0xc0, 0x0, 0xf, 0x81, 0xc0, 0x0, 0xf, 0xc3, 0x80, 0x0, 0x1, 0xc7, 0x0, 0x0, 0xe1, 0xc7, 0xe, 0x0, 0xe1, 0xce, 0x1e, 0x0, 0xf3, 0xce, 0x1e, 0x0, 0x7f, 0x9c, 0x3e, 0x0, 0x3f, 0x1c, 0x7e, 0x0, 0x0, 0x38, 0xee, 0x0, 0x0, 0x70, 0xce, 0x0, 0x0, 0x71, 0x8e, 0x0, 0x0, 0xe3, 0x8e, 0x0, 0x0, 0xe3, 0xff, 0x80, 0x1, 0xc3, 0xff, 0x80, 0x1, 0xc0, 0xe, 0x0, 0x3, 0x80, 0xe, 0x0, 0x3, 0x80, 0xe, 0x0}

/* questiondown (191) */
#define NXFONT_METRICS_191 {2, 16, 24, 1, 19, 0}
#define NXFONT_BITMAP_191 {0x3, 0xe0, 0x3, 0xe0, 0x3, 0xe0, 0x3, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x7, 0xc0, 0x1f, 0x80, 0x3f, 0x80, 0x7f, 0x0, 0x7e, 0x0, 0xfc, 0x0, 0xf8, 0xf, 0xf8, 0xf, 0xf8, 0xf, 0xfc, 0x1f, 0x7e, 0x7f, 0x7f, 0xfe, 0x3f, 0xfe, 0x3f, 0xfc, 0xf, 0xf0}

/* Agrave (192) */
#define NXFONT_METRICS_192 {3, 22, 31, 0, 6, 0}
#define NXFONT_BITMAP_192 {0x3, 0xc0, 0x0, 0x1, 0xe0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x0, 0x0, 0xfc, 0x0, 0x0, 0xfc, 0x0, 0x1, 0xfe, 0x0, 0x1, 0xfe, 0x0, 0x1, 0xfe, 0x0, 0x3, 0xff, 0x0, 0x3, 0xff, 0x0, 0x3, 0xff, 0x0, 0x7, 0xcf, 0x80, 0x7, 0xcf, 0x80, 0x7, 0xcf, 0x80, 0xf, 0x87, 0x80, 0xf, 0x87, 0xc0, 0xf, 0x87, 0xc0, 0x1f, 0x3, 0xc0, 0x1f, 0x3, 0xe0, 0x1f, 0xff, 0xe0, 0x1f, 0xff, 0xe0, 0x3f, 0xff, 0xf0, 0x3f, 0xff, 0xf0, 0x3e, 0x1, 0xf0, 0x7c, 0x0, 0xf8, 0x7c, 0x0, 0xf8, 0xfc, 0x0, 0xfc, 0xf8, 0x0, 0x7c}

/* Aacute (193) */
#define NXFONT_METRICS_193 {3, 22, 31, 0, 6, 0}
#define NXFONT_BITMAP_193 {0x0, 0xf, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x78, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xfc, 0x0, 0x0, 0xfc, 0x0, 0x1, 0xfe, 0x0, 0x1, 0xfe, 0x0, 0x1, 0xfe, 0x0, 0x3, 0xff, 0x0, 0x3, 0xff, 0x0, 0x3, 0xff, 0x0, 0x7, 0xcf, 0x80, 0x7, 0xcf, 0x80, 0x7, 0xcf, 0x80, 0xf, 0x87, 0x80, 0xf, 0x87, 0xc0, 0xf, 0x87, 0xc0, 0x1f, 0x3, 0xc0, 0x1f, 0x3, 0xe0, 0x1f, 0xff, 0xe0, 0x1f, 0xff, 0xe0, 0x3f, 0xff, 0xf0, 0x3f, 0xff, 0xf0, 0x3e, 0x1, 0xf0, 0x7c, 0x0, 0xf8, 0x7c, 0x0, 0xf8, 0xfc, 0x0, 0xfc, 0xf8, 0x0, 0x7c}

/* Acircumflex (194) */
#define NXFONT_METRICS_194 {3, 22, 31, 0, 6, 0}
#define NXFONT_BITMAP_194 {0x0, 0x30, 0x0, 0x0, 0x78, 0x0, 0x0, 0xfc, 0x0, 0x1, 0xce, 0x0, 0x3, 0x87, 0x0, 0x0, 0x0, 0x0, 0x0, 0xfc, 0x0, 0x0, 0xfc, 0x0, 0x1, 0xfe, 0x0, 0x1, 0xfe, 0x0, 0x1, 0xfe, 0x0, 0x3, 0xff, 0x0, 0x3, 0xff, 0x0, 0x3, 0xff, 0x0, 0x7, 0xcf, 0x80, 0x7, 0xcf, 0x80, 0x7, 0xcf, 0x80, 0xf, 0x87, 0x80, 0xf, 0x87, 0xc0, 0xf, 0x87, 0xc0, 0x1f, 0x3, 0xc0, 0x1f, 0x3, 0xe0, 0x1f, 0xff, 0xe0, 0x1f, 0xff, 0xe0, 0x3f, 0xff, 0xf0, 0x3f, 0xff, 0xf0, 0x3e, 0x1, 0xf0, 0x7c, 0x0, 0xf8, 0x7c, 0x0, 0xf8, 0xfc, 0x0, 0xfc, 0xf8, 0x0, 0x7c}

/* Atilde (195) */
#define NXFONT_METRICS_195 {3, 22, 30, 0, 7, 0}
#define NXFONT_BITMAP_195 {0x0, 0xf1, 0x80, 0x1, 0xff, 0x80, 0x3, 0xff, 0x0, 0x3, 0x1e, 0x0, 0x0, 0x0, 0x0, 0x0, 0xfc, 0x0, 0x0, 0xfc, 0x0, 0x1, 0xfe, 0x0, 0x1, 0xfe, 0x0, 0x1, 0xfe, 0x0, 0x3, 0xff, 0x0, 0x3, 0xff, 0x0, 0x3, 0xff, 0x0, 0x7, 0xcf, 0x80, 0x7, 0xcf, 0x80, 0x7, 0xcf, 0x80, 0xf, 0x87, 0x80, 0xf, 0x87, 0xc0, 0xf, 0x87, 0xc0, 0x1f, 0x3, 0xc0, 0x1f, 0x3, 0xe0, 0x1f, 0xff, 0xe0, 0x1f, 0xff, 0xe0, 0x3f, 0xff, 0xf0, 0x3f, 0xff, 0xf0, 0x3e, 0x1, 0xf0, 0x7c, 0x0, 0xf8, 0x7c, 0x0, 0xf8, 0xfc, 0x0, 0xfc, 0xf8, 0x0, 0x7c}

/* Adieresis (196) */
#define NXFONT_METRICS_196 {3, 22, 31, 0, 6, 0}
#define NXFONT_BITMAP_196 {0x3, 0xcf, 0x0, 0x3, 0xcf, 0x0, 0x3, 0xcf, 0x0, 0x3, 0xcf, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xfc, 0x0, 0x0, 0xfc, 0x0, 0x1, 0xfe, 0x0, 0x1, 0xfe, 0x0, 0x1, 0xfe, 0x0, 0x3, 0xff, 0x0, 0x3, 0xff, 0x0, 0x3, 0xff, 0x0, 0x7, 0xcf, 0x80, 0x7, 0xcf, 0x80, 0x7, 0xcf, 0x80, 0xf, 0x87, 0x80, 0xf, 0x87, 0xc0, 0xf, 0x87, 0xc0, 0x1f, 0x3, 0xc0, 0x1f, 0x3, 0xe0, 0x1f, 0xff, 0xe0, 0x1f, 0xff, 0xe0, 0x3f, 0xff, 0xf0, 0x3f, 0xff, 0xf0, 0x3e, 0x1, 0xf0, 0x7c, 0x0, 0xf8, 0x7c, 0x0, 0xf8, 0xfc, 0x0, 0xfc, 0xf8, 0x0, 0x7c}

/* Aring (197) */
#define NXFONT_METRICS_197 {3, 22, 31, 0, 6, 0}
#define NXFONT_BITMAP_197 {0x0, 0x78, 0x0, 0x0, 0xcc, 0x0, 0x0, 0x84, 0x0, 0x0, 0x84, 0x0, 0x0, 0xcc, 0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x0, 0x0, 0xfc, 0x0, 0x1, 0xfe, 0x0, 0x1, 0xfe, 0x0, 0x1, 0xfe, 0x0, 0x3, 0xff, 0x0, 0x3, 0xff, 0x0, 0x3, 0xff, 0x0, 0x7, 0xcf, 0x80, 0x7, 0xcf, 0x80, 0x7, 0xcf, 0x80, 0xf, 0x87, 0x80, 0xf, 0x87, 0xc0, 0xf, 0x87, 0xc0, 0x1f, 0x3, 0xc0, 0x1f, 0x3, 0xe0, 0x1f, 0xff, 0xe0, 0x1f, 0xff, 0xe0, 0x3f, 0xff, 0xf0, 0x3f, 0xff, 0xf0, 0x3e, 0x1, 0xf0, 0x7c, 0x0, 0xf8, 0x7c, 0x0, 0xf8, 0xfc, 0x0, 0xfc, 0xf8, 0x0, 0x7c}

/* AE (198) */
#define NXFONT_METRICS_198 {4, 31, 25, 0, 12, 0}
#define NXFONT_BITMAP_198 {0x0, 0xff, 0xff, 0xfc, 0x0, 0xff, 0xff, 0xfc, 0x0, 0xff, 0xff, 0xfc, 0x1, 0xff, 0xff, 0xfc, 0x1, 0xf3, 0xc0, 0x0, 0x1, 0xe3, 0xc0, 0x0, 0x3, 0xe3, 0xc0, 0x0, 0x3, 0xe3, 0xc0, 0x0, 0x3, 0xc3, 0xc0, 0x0, 0x7, 0xc3, 0xc0, 0x0, 0x7, 0xc3, 0xc0, 0x0, 0x7, 0xc3, 0xff, 0xf8, 0xf, 0x83, 0xff, 0xf8, 0xf, 0x83, 0xff, 0xf8, 0xf, 0x83, 0xff, 0xf8, 0x1f, 0x3, 0xc0, 0x0, 0x1f, 0xff, 0xc0, 0x0, 0x1f, 0xff, 0xc0, 0x0, 0x3f, 0xff, 0xc0, 0x0, 0x3f, 0xff, 0xc0, 0x0, 0x3e, 0x3, 0xc0, 0x0, 0x7c, 0x3, 0xff, 0xfe, 0x7c, 0x3, 0xff, 0xfe, 0xf8, 0x3, 0xff, 0xfe, 0xf8, 0x3, 0xff, 0xfe}

/* Ccedilla (199) */
#define NXFONT_METRICS_199 {3, 21, 32, 1, 12, 0}
#define NXFONT_BITMAP_199 {0x1, 0xfe, 0x0, 0x7, 0xff, 0x80, 0xf, 0xff, 0xc0, 0x1f, 0xff, 0xe0, 0x3f, 0x87, 0xf0, 0x3e, 0x1, 0xf0, 0x7c, 0x1, 0xf0, 0x7c, 0x0, 0xf8, 0x7c, 0x0, 0xf8, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x7c, 0x0, 0xf8, 0x7c, 0x0, 0xf8, 0x7e, 0x1, 0xf8, 0x3e, 0x1, 0xf0, 0x3f, 0x87, 0xf0, 0x1f, 0xff, 0xe0, 0xf, 0xff, 0xc0, 0x7, 0xff, 0x80, 0x1, 0xfc, 0x0, 0x0, 0x60, 0x0, 0x0, 0x60, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x1, 0xf8, 0x0, 0x1, 0xf0, 0x0}

/* Egrave (200) */
#define NXFONT_METRICS_200 {3, 18, 31, 2, 6, 0}
#define NXFONT_BITMAP_200 {0x1e, 0x0, 0x0, 0xf, 0x0, 0x0, 0x7, 0x80, 0x0, 0x3, 0xc0, 0x0, 0x1, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0x80, 0xff, 0xff, 0x80, 0xff, 0xff, 0x80, 0xff, 0xff, 0x80, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xff, 0xff, 0x0, 0xff, 0xff, 0x0, 0xff, 0xff, 0x0, 0xff, 0xff, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xc0}

/* Eacute (201) */
#define NXFONT_METRICS_201 {3, 18, 31, 2, 6, 0}
#define NXFONT_BITMAP_201 {0x0, 0x78, 0x0, 0x0, 0xf0, 0x0, 0x1, 0xe0, 0x0, 0x3, 0xc0, 0x0, 0x7, 0x80, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0x80, 0xff, 0xff, 0x80, 0xff, 0xff, 0x80, 0xff, 0xff, 0x80, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xff, 0xff, 0x0, 0xff, 0xff, 0x0, 0xff, 0xff, 0x0, 0xff, 0xff, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xc0}

/* Ecircumflex (202) */
#define NXFONT_METRICS_202 {3, 18, 31, 2, 6, 0}
#define NXFONT_BITMAP_202 {0x0, 0xc0, 0x0, 0x1, 0xe0, 0x0, 0x3, 0xf0, 0x0, 0x7, 0x38, 0x0, 0xe, 0x1c, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0x80, 0xff, 0xff, 0x80, 0xff, 0xff, 0x80, 0xff, 0xff, 0x80, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xff, 0xff, 0x0, 0xff, 0xff, 0x0, 0xff, 0xff, 0x0, 0xff, 0xff, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xc0}

/* Edieresis (203) */
#define NXFONT_METRICS_203 {3, 18, 31, 2, 6, 0}
#define NXFONT_BITMAP_203 {0x1e, 0x3c, 0x0, 0x1e, 0x3c, 0x0, 0x1e, 0x3c, 0x0, 0x1e, 0x3c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0x80, 0xff, 0xff, 0x80, 0xff, 0xff, 0x80, 0xff, 0xff, 0x80, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xff, 0xff, 0x0, 0xff, 0xff, 0x0, 0xff, 0xff, 0x0, 0xff, 0xff, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xc0}

/* Igrave (204) */
#define NXFONT_METRICS_204 {1, 8, 31, 0, 6, 0}
#define NXFONT_BITMAP_204 {0xf0, 0x78, 0x3c, 0x1e, 0xf, 0x0, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e}

/* Iacute (205) */
#define NXFONT_METRICS_205 {1, 8, 31, 2, 6, 0}
#define NXFONT_BITMAP_205 {0xf, 0x1e, 0x3c, 0x78, 0xf0, 0x0, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8}

/* Icircumflex (206) */
#define NXFONT_METRICS_206 {2, 10, 31, 0, 6, 0}
#define NXFONT_BITMAP_206 {0xc, 0x0, 0x1e, 0x0, 0x3f, 0x0, 0x73, 0x80, 0xe1, 0xc0, 0x0, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0}

/* Idieresis (207) */
#define NXFONT_METRICS_207 {2, 10, 31, 0, 6, 0}
#define NXFONT_BITMAP_207 {0xf3, 0xc0, 0xf3, 0xc0, 0xf3, 0xc0, 0xf3, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0}

/* Eth (208) -- NOTE: Xoffset should be -1, not 0. */
#define NXFONT_METRICS_208 {3, 23, 25, 0, 12, 0}
#define NXFONT_BITMAP_208 {0x1f, 0xff, 0x80, 0x1f, 0xff, 0xe0, 0x1f, 0xff, 0xf0, 0x1f, 0xff, 0xf8, 0x1f, 0x7, 0xf8, 0x1f, 0x0, 0xfc, 0x1f, 0x0, 0xfc, 0x1f, 0x0, 0x7c, 0x1f, 0x0, 0x7e, 0x1f, 0x0, 0x3e, 0x1f, 0x0, 0x3e, 0xff, 0xf0, 0x3e, 0xff, 0xf0, 0x3e, 0xff, 0xf0, 0x3e, 0x1f, 0x0, 0x3e, 0x1f, 0x0, 0x3e, 0x1f, 0x0, 0x7c, 0x1f, 0x0, 0x7c, 0x1f, 0x0, 0x7c, 0x1f, 0x0, 0xf8, 0x1f, 0x3, 0xf8, 0x1f, 0xff, 0xf0, 0x1f, 0xff, 0xf0, 0x1f, 0xff, 0xc0, 0x1f, 0xff, 0x80}

/* Ntilde (209) */
#define NXFONT_METRICS_209 {3, 19, 30, 2, 7, 0}
#define NXFONT_BITMAP_209 {0x3, 0xc6, 0x0, 0x7, 0xfe, 0x0, 0xf, 0xfc, 0x0, 0xc, 0x78, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x3, 0xe0, 0xfc, 0x3, 0xe0, 0xfc, 0x3, 0xe0, 0xfe, 0x3, 0xe0, 0xfe, 0x3, 0xe0, 0xff, 0x3, 0xe0, 0xff, 0x3, 0xe0, 0xff, 0x83, 0xe0, 0xff, 0xc3, 0xe0, 0xfb, 0xc3, 0xe0, 0xfb, 0xe3, 0xe0, 0xf9, 0xe3, 0xe0, 0xf9, 0xf3, 0xe0, 0xf8, 0xf3, 0xe0, 0xf8, 0xfb, 0xe0, 0xf8, 0x7b, 0xe0, 0xf8, 0x3f, 0xe0, 0xf8, 0x3f, 0xe0, 0xf8, 0x1f, 0xe0, 0xf8, 0x1f, 0xe0, 0xf8, 0xf, 0xe0, 0xf8, 0xf, 0xe0, 0xf8, 0x7, 0xe0, 0xf8, 0x7, 0xe0, 0xf8, 0x3, 0xe0}

/* Ograve (210) */
#define NXFONT_METRICS_210 {3, 23, 31, 1, 6, 0}
#define NXFONT_BITMAP_210 {0x1, 0xe0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x0, 0x0, 0x1, 0xff, 0x0, 0x7, 0xff, 0xc0, 0xf, 0xff, 0xe0, 0x1f, 0xff, 0xf0, 0x3f, 0xc7, 0xf8, 0x3f, 0x1, 0xf8, 0x7e, 0x0, 0xfc, 0x7c, 0x0, 0x7c, 0x7c, 0x0, 0x7c, 0xf8, 0x0, 0x3e, 0xf8, 0x0, 0x3e, 0xf8, 0x0, 0x3e, 0xf8, 0x0, 0x3e, 0xf8, 0x0, 0x3e, 0xf8, 0x0, 0x3e, 0xf8, 0x0, 0x3e, 0x7c, 0x0, 0x7c, 0x7c, 0x0, 0x7c, 0x7e, 0x0, 0xfc, 0x3f, 0x1, 0xf8, 0x3f, 0xc7, 0xf8, 0x1f, 0xff, 0xf0, 0xf, 0xff, 0xe0, 0x7, 0xff, 0xc0, 0x1, 0xff, 0x0}

/* Oacute (211) */
#define NXFONT_METRICS_211 {3, 23, 31, 1, 6, 0}
#define NXFONT_BITMAP_211 {0x0, 0x7, 0x80, 0x0, 0xf, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x0, 0x1, 0xff, 0x0, 0x7, 0xff, 0xc0, 0xf, 0xff, 0xe0, 0x1f, 0xff, 0xf0, 0x3f, 0xc7, 0xf8, 0x3f, 0x1, 0xf8, 0x7e, 0x0, 0xfc, 0x7c, 0x0, 0x7c, 0x7c, 0x0, 0x7c, 0xf8, 0x0, 0x3e, 0xf8, 0x0, 0x3e, 0xf8, 0x0, 0x3e, 0xf8, 0x0, 0x3e, 0xf8, 0x0, 0x3e, 0xf8, 0x0, 0x3e, 0xf8, 0x0, 0x3e, 0x7c, 0x0, 0x7c, 0x7c, 0x0, 0x7c, 0x7e, 0x0, 0xfc, 0x3f, 0x1, 0xf8, 0x3f, 0xc7, 0xf8, 0x1f, 0xff, 0xf0, 0xf, 0xff, 0xe0, 0x7, 0xff, 0xc0, 0x1, 0xff, 0x0}

/* Ocircumflex (212) */
#define NXFONT_METRICS_212 {3, 23, 31, 1, 6, 0}
#define NXFONT_BITMAP_212 {0x0, 0x18, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x7e, 0x0, 0x0, 0xe7, 0x0, 0x1, 0xc3, 0x80, 0x0, 0x0, 0x0, 0x1, 0xff, 0x0, 0x7, 0xff, 0xc0, 0xf, 0xff, 0xe0, 0x1f, 0xff, 0xf0, 0x3f, 0xc7, 0xf8, 0x3f, 0x1, 0xf8, 0x7e, 0x0, 0xfc, 0x7c, 0x0, 0x7c, 0x7c, 0x0, 0x7c, 0xf8, 0x0, 0x3e, 0xf8, 0x0, 0x3e, 0xf8, 0x0, 0x3e, 0xf8, 0x0, 0x3e, 0xf8, 0x0, 0x3e, 0xf8, 0x0, 0x3e, 0xf8, 0x0, 0x3e, 0x7c, 0x0, 0x7c, 0x7c, 0x0, 0x7c, 0x7e, 0x0, 0xfc, 0x3f, 0x1, 0xf8, 0x3f, 0xc7, 0xf8, 0x1f, 0xff, 0xf0, 0xf, 0xff, 0xe0, 0x7, 0xff, 0xc0, 0x1, 0xff, 0x0}

/* Otilde (213) */
#define NXFONT_METRICS_213 {3, 23, 30, 1, 7, 0}
#define NXFONT_BITMAP_213 {0x0, 0x78, 0xc0, 0x0, 0xff, 0xc0, 0x1, 0xff, 0x80, 0x1, 0x8f, 0x0, 0x0, 0x0, 0x0, 0x1, 0xff, 0x0, 0x7, 0xff, 0xc0, 0xf, 0xff, 0xe0, 0x1f, 0xff, 0xf0, 0x3f, 0xc7, 0xf8, 0x3f, 0x1, 0xf8, 0x7e, 0x0, 0xfc, 0x7c, 0x0, 0x7c, 0x7c, 0x0, 0x7c, 0xf8, 0x0, 0x3e, 0xf8, 0x0, 0x3e, 0xf8, 0x0, 0x3e, 0xf8, 0x0, 0x3e, 0xf8, 0x0, 0x3e, 0xf8, 0x0, 0x3e, 0xf8, 0x0, 0x3e, 0x7c, 0x0, 0x7c, 0x7c, 0x0, 0x7c, 0x7e, 0x0, 0xfc, 0x3f, 0x1, 0xf8, 0x3f, 0xc7, 0xf8, 0x1f, 0xff, 0xf0, 0xf, 0xff, 0xe0, 0x7, 0xff, 0xc0, 0x1, 0xff, 0x0}

/* Odieresis (214) */
#define NXFONT_METRICS_214 {3, 23, 31, 1, 6, 0}
#define NXFONT_BITMAP_214 {0x1, 0xe7, 0x80, 0x1, 0xe7, 0x80, 0x1, 0xe7, 0x80, 0x1, 0xe7, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xff, 0x0, 0x7, 0xff, 0xc0, 0xf, 0xff, 0xe0, 0x1f, 0xff, 0xf0, 0x3f, 0xc7, 0xf8, 0x3f, 0x1, 0xf8, 0x7e, 0x0, 0xfc, 0x7c, 0x0, 0x7c, 0x7c, 0x0, 0x7c, 0xf8, 0x0, 0x3e, 0xf8, 0x0, 0x3e, 0xf8, 0x0, 0x3e, 0xf8, 0x0, 0x3e, 0xf8, 0x0, 0x3e, 0xf8, 0x0, 0x3e, 0xf8, 0x0, 0x3e, 0x7c, 0x0, 0x7c, 0x7c, 0x0, 0x7c, 0x7e, 0x0, 0xfc, 0x3f, 0x1, 0xf8, 0x3f, 0xc7, 0xf8, 0x1f, 0xff, 0xf0, 0xf, 0xff, 0xe0, 0x7, 0xff, 0xc0, 0x1, 0xff, 0x0}

/* multiply (215) */
#define NXFONT_METRICS_215 {2, 15, 16, 2, 21, 0}
#define NXFONT_BITMAP_215 {0x20, 0x8, 0x70, 0x1c, 0xf8, 0x3e, 0xfc, 0x7e, 0x7e, 0xfc, 0x3f, 0xf8, 0x1f, 0xf0, 0xf, 0xe0, 0xf, 0xe0, 0x1f, 0xf0, 0x3f, 0xf8, 0x7e, 0xfc, 0xfc, 0x7e, 0xf8, 0x3e, 0x70, 0x1c, 0x20, 0x8}

/* Oslash (216) */
#define NXFONT_METRICS_216 {3, 24, 25, 1, 12, 0}
#define NXFONT_BITMAP_216 {0x1, 0xff, 0x7, 0x7, 0xff, 0xce, 0xf, 0xff, 0xfc, 0x1f, 0xff, 0xf8, 0x3f, 0xc7, 0xf8, 0x3f, 0x0, 0xf8, 0x7e, 0x1, 0xfc, 0x7c, 0x3, 0xfc, 0x7c, 0x7, 0xbc, 0xf8, 0x7, 0x3e, 0xf8, 0xe, 0x3e, 0xf8, 0x1c, 0x3e, 0xf8, 0x38, 0x3e, 0xf8, 0x70, 0x3e, 0xf8, 0xe0, 0x3e, 0xf8, 0xe0, 0x3e, 0x7d, 0xc0, 0x7c, 0x7f, 0x80, 0x7c, 0x7f, 0x0, 0xfc, 0x3f, 0x1, 0xf8, 0x3f, 0xc7, 0xf8, 0x3f, 0xff, 0xf0, 0x3f, 0xff, 0xe0, 0x77, 0xff, 0xc0, 0xe1, 0xff, 0x0}

/* Ugrave (217) */
#define NXFONT_METRICS_217 {3, 19, 31, 2, 6, 0}
#define NXFONT_BITMAP_217 {0x7, 0x80, 0x0, 0x3, 0xc0, 0x0, 0x1, 0xe0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xfc, 0x7, 0xe0, 0x7f, 0x1f, 0xc0, 0x7f, 0xff, 0xc0, 0x3f, 0xff, 0x80, 0x1f, 0xff, 0x0, 0x7, 0xfc, 0x0}

/* Uacute (218) */
#define NXFONT_METRICS_218 {3, 19, 31, 2, 6, 0}
#define NXFONT_BITMAP_218 {0x0, 0x1e, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x78, 0x0, 0x0, 0xf0, 0x0, 0x1, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xfc, 0x7, 0xe0, 0x7f, 0x1f, 0xc0, 0x7f, 0xff, 0xc0, 0x3f, 0xff, 0x80, 0x1f, 0xff, 0x0, 0x7, 0xfc, 0x0}

/* Ucircumflex (219) */
#define NXFONT_METRICS_219 {3, 19, 31, 2, 6, 0}
#define NXFONT_BITMAP_219 {0x0, 0x60, 0x0, 0x0, 0xf0, 0x0, 0x1, 0xf8, 0x0, 0x3, 0x9c, 0x0, 0x7, 0xe, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xfc, 0x7, 0xe0, 0x7f, 0x1f, 0xc0, 0x7f, 0xff, 0xc0, 0x3f, 0xff, 0x80, 0x1f, 0xff, 0x0, 0x7, 0xfc, 0x0}

/* Udieresis (220) */
#define NXFONT_METRICS_220 {3, 19, 31, 2, 6, 0}
#define NXFONT_BITMAP_220 {0xf, 0x1e, 0x0, 0xf, 0x1e, 0x0, 0xf, 0x1e, 0x0, 0xf, 0x1e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xfc, 0x7, 0xe0, 0x7f, 0x1f, 0xc0, 0x7f, 0xff, 0xc0, 0x3f, 0xff, 0x80, 0x1f, 0xff, 0x0, 0x7, 0xfc, 0x0}

/* Yacute (221) */
#define NXFONT_METRICS_221 {3, 20, 31, 1, 6, 0}
#define NXFONT_BITMAP_221 {0x0, 0x1e, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x78, 0x0, 0x0, 0xf0, 0x0, 0x1, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xfc, 0x3, 0xf0, 0xfc, 0x3, 0xf0, 0x7e, 0x7, 0xe0, 0x3e, 0x7, 0xc0, 0x3f, 0xf, 0xc0, 0x3f, 0xf, 0x80, 0x1f, 0xf, 0x80, 0x1f, 0x9f, 0x0, 0xf, 0x9f, 0x0, 0xf, 0xfe, 0x0, 0x7, 0xfe, 0x0, 0x7, 0xfc, 0x0, 0x3, 0xfc, 0x0, 0x3, 0xf8, 0x0, 0x3, 0xf8, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0}

/* Thorn (222) */
#define NXFONT_METRICS_222 {3, 18, 25, 2, 12, 0}
#define NXFONT_BITMAP_222 {0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xff, 0xf8, 0x0, 0xff, 0xfe, 0x0, 0xff, 0xff, 0x0, 0xff, 0xff, 0x80, 0xf8, 0x1f, 0x80, 0xf8, 0xf, 0xc0, 0xf8, 0x7, 0xc0, 0xf8, 0x7, 0xc0, 0xf8, 0x7, 0xc0, 0xf8, 0x7, 0xc0, 0xf8, 0xf, 0xc0, 0xf8, 0x1f, 0x80, 0xff, 0xff, 0x80, 0xff, 0xff, 0x0, 0xff, 0xfe, 0x0, 0xff, 0xfc, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0}

/* germandbls (223) */
#define NXFONT_METRICS_223 {3, 17, 25, 2, 12, 0}
#define NXFONT_BITMAP_223 {0xf, 0xc0, 0x0, 0x3f, 0xf0, 0x0, 0x7f, 0xfc, 0x0, 0xff, 0xfc, 0x0, 0xf8, 0x7e, 0x0, 0xf8, 0x3e, 0x0, 0xf0, 0x3e, 0x0, 0xf0, 0x3e, 0x0, 0xf0, 0x7c, 0x0, 0xf0, 0xfc, 0x0, 0xf1, 0xf8, 0x0, 0xf1, 0xfc, 0x0, 0xf1, 0xfe, 0x0, 0xf0, 0x7f, 0x0, 0xf0, 0x1f, 0x0, 0xf0, 0x1f, 0x80, 0xf0, 0xf, 0x80, 0xf0, 0xf, 0x80, 0xf0, 0xf, 0x80, 0xf0, 0x1f, 0x80, 0xf0, 0x3f, 0x0, 0xf1, 0xff, 0x0, 0xf1, 0xfe, 0x0, 0xf1, 0xfc, 0x0, 0xf1, 0xf0, 0x0}

/* agrave (224) */
#define NXFONT_METRICS_224 {2, 15, 25, 1, 12, 0}
#define NXFONT_BITMAP_224 {0xf, 0x0, 0x7, 0x80, 0x3, 0x80, 0x1, 0xc0, 0x0, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf0, 0x3f, 0xfc, 0x7f, 0xfc, 0x7c, 0x3e, 0xf8, 0x1e, 0xf8, 0x1e, 0x1, 0xfe, 0xf, 0xfe, 0x3f, 0xfe, 0x7f, 0x1e, 0xf8, 0x1e, 0xf0, 0x1e, 0xf0, 0x3e, 0xf8, 0x7e, 0xff, 0xfe, 0xff, 0xfe, 0x7f, 0xde, 0x3f, 0x1e}

/* aacute (225) */
#define NXFONT_METRICS_225 {2, 15, 25, 1, 12, 0}
#define NXFONT_BITMAP_225 {0x0, 0x78, 0x0, 0xf0, 0x0, 0xe0, 0x1, 0xc0, 0x3, 0x80, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf0, 0x3f, 0xfc, 0x7f, 0xfc, 0x7c, 0x3e, 0xf8, 0x1e, 0xf8, 0x1e, 0x1, 0xfe, 0xf, 0xfe, 0x3f, 0xfe, 0x7f, 0x1e, 0xf8, 0x1e, 0xf0, 0x1e, 0xf0, 0x3e, 0xf8, 0x7e, 0xff, 0xfe, 0xff, 0xfe, 0x7f, 0xde, 0x3f, 0x1e}

/* acircumflex (226) */
#define NXFONT_METRICS_226 {2, 15, 25, 1, 12, 0}
#define NXFONT_BITMAP_226 {0x1, 0x80, 0x3, 0xc0, 0x7, 0xe0, 0xe, 0x70, 0x1c, 0x38, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf0, 0x3f, 0xfc, 0x7f, 0xfc, 0x7c, 0x3e, 0xf8, 0x1e, 0xf8, 0x1e, 0x1, 0xfe, 0xf, 0xfe, 0x3f, 0xfe, 0x7f, 0x1e, 0xf8, 0x1e, 0xf0, 0x1e, 0xf0, 0x3e, 0xf8, 0x7e, 0xff, 0xfe, 0xff, 0xfe, 0x7f, 0xde, 0x3f, 0x1e}

/* atilde (227) */
#define NXFONT_METRICS_227 {2, 15, 24, 1, 13, 0}
#define NXFONT_BITMAP_227 {0x7, 0x8c, 0xf, 0xfc, 0x1f, 0xf8, 0x18, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf0, 0x3f, 0xfc, 0x7f, 0xfc, 0x7c, 0x3e, 0xf8, 0x1e, 0xf8, 0x1e, 0x1, 0xfe, 0xf, 0xfe, 0x3f, 0xfe, 0x7f, 0x1e, 0xf8, 0x1e, 0xf0, 0x1e, 0xf0, 0x3e, 0xf8, 0x7e, 0xff, 0xfe, 0xff, 0xfe, 0x7f, 0xde, 0x3f, 0x1e}

/* adieresis (228) */
#define NXFONT_METRICS_228 {2, 15, 24, 1, 13, 0}
#define NXFONT_BITMAP_228 {0x1e, 0x78, 0x1e, 0x78, 0x1e, 0x78, 0x1e, 0x78, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf0, 0x3f, 0xfc, 0x7f, 0xfc, 0x7c, 0x3e, 0xf8, 0x1e, 0xf8, 0x1e, 0x1, 0xfe, 0xf, 0xfe, 0x3f, 0xfe, 0x7f, 0x1e, 0xf8, 0x1e, 0xf0, 0x1e, 0xf0, 0x3e, 0xf8, 0x7e, 0xff, 0xfe, 0xff, 0xfe, 0x7f, 0xde, 0x3f, 0x1e}

/* aring (229) */
#define NXFONT_METRICS_229 {2, 15, 25, 1, 12, 0}
#define NXFONT_BITMAP_229 {0x3, 0xc0, 0x6, 0x60, 0x4, 0x20, 0x4, 0x20, 0x6, 0x60, 0x3, 0xc0, 0x0, 0x0, 0xf, 0xf0, 0x3f, 0xfc, 0x7f, 0xfc, 0x7c, 0x3e, 0xf8, 0x1e, 0xf8, 0x1e, 0x1, 0xfe, 0xf, 0xfe, 0x3f, 0xfe, 0x7f, 0x1e, 0xf8, 0x1e, 0xf8, 0x1e, 0xf0, 0x3e, 0xf8, 0x7e, 0xff, 0xfe, 0xff, 0xfe, 0x7f, 0xde, 0x3f, 0x1e}

/* ae (230) */
#define NXFONT_METRICS_230 {4, 26, 19, 1, 18, 0}
#define NXFONT_BITMAP_230 {0x7, 0xe0, 0xf8, 0x0, 0x1f, 0xfb, 0xfe, 0x0, 0x3f, 0xff, 0xff, 0x0, 0x3f, 0xff, 0xff, 0x0, 0x7c, 0x3f, 0xf, 0x80, 0x78, 0x1e, 0x7, 0x80, 0x78, 0x1e, 0x7, 0xc0, 0x0, 0x3e, 0x7, 0xc0, 0x7, 0xff, 0xff, 0xc0, 0x3f, 0xff, 0xff, 0xc0, 0x7f, 0xff, 0xff, 0xc0, 0x7c, 0x1e, 0x0, 0x0, 0xf8, 0x1e, 0x0, 0x0, 0xf8, 0x1e, 0x7, 0xc0, 0xfc, 0x3f, 0xf, 0xc0, 0xff, 0xff, 0xff, 0x80, 0x7f, 0xf7, 0xff, 0x0, 0x3f, 0xe3, 0xfe, 0x0, 0xf, 0x81, 0xf8, 0x0}

/* ccedilla (231) */
#define NXFONT_METRICS_231 {2, 15, 25, 1, 19, 0}
#define NXFONT_BITMAP_231 {0x7, 0xe0, 0x1f, 0xf8, 0x3f, 0xfc, 0x3f, 0xfc, 0x7c, 0x3e, 0x78, 0x1e, 0xf8, 0x1e, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf8, 0x1e, 0xf8, 0x1e, 0x7c, 0x3e, 0x7f, 0xfc, 0x3f, 0xf8, 0x1f, 0xf8, 0x7, 0xe0, 0x3, 0x0, 0x3, 0x0, 0x7, 0xc0, 0x0, 0xe0, 0x0, 0xe0, 0xf, 0xc0, 0xf, 0x80}

/* egrave (232) */
#define NXFONT_METRICS_232 {2, 16, 25, 1, 12, 0}
#define NXFONT_BITMAP_232 {0xf, 0x0, 0x7, 0x80, 0x3, 0x80, 0x1, 0xc0, 0x0, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xe0, 0x1f, 0xf8, 0x3f, 0xfc, 0x7f, 0xfe, 0x7c, 0x3e, 0xf8, 0x1e, 0xf0, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0, 0xf0, 0x0, 0xf8, 0x1e, 0x7c, 0x3e, 0x7f, 0xfe, 0x3f, 0xfc, 0x1f, 0xf0, 0x7, 0xc0}

/* eacute (233) */
#define NXFONT_METRICS_233 {2, 16, 25, 1, 12, 0}
#define NXFONT_BITMAP_233 {0x0, 0x78, 0x0, 0xf0, 0x0, 0xe0, 0x1, 0xc0, 0x3, 0x80, 0x0, 0x0, 0x0, 0x0, 0x7, 0xe0, 0x1f, 0xf8, 0x3f, 0xfc, 0x7f, 0xfe, 0x7c, 0x3e, 0xf8, 0x1e, 0xf0, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0, 0xf0, 0x0, 0xf8, 0x1e, 0x7c, 0x3e, 0x7f, 0xfe, 0x3f, 0xfc, 0x1f, 0xf0, 0x7, 0xc0}

/* ecircumflex (234) */
#define NXFONT_METRICS_234 {2, 16, 25, 1, 12, 0}
#define NXFONT_BITMAP_234 {0x1, 0x80, 0x3, 0xc0, 0x7, 0xe0, 0xe, 0x70, 0x1c, 0x38, 0x0, 0x0, 0x0, 0x0, 0x7, 0xe0, 0x1f, 0xf8, 0x3f, 0xfc, 0x7f, 0xfe, 0x7c, 0x3e, 0xf8, 0x1e, 0xf0, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0, 0xf0, 0x0, 0xf8, 0x1e, 0x7c, 0x3e, 0x7f, 0xfe, 0x3f, 0xfc, 0x1f, 0xf0, 0x7, 0xc0}

/* edieresis (235) */
#define NXFONT_METRICS_235 {2, 16, 24, 1, 13, 0}
#define NXFONT_BITMAP_235 {0x1e, 0x78, 0x1e, 0x78, 0x1e, 0x78, 0x1e, 0x78, 0x0, 0x0, 0x0, 0x0, 0x7, 0xe0, 0x1f, 0xf8, 0x3f, 0xfc, 0x7f, 0xfe, 0x7c, 0x3e, 0xf8, 0x1e, 0xf0, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0, 0xf0, 0x0, 0xf8, 0x1e, 0x7c, 0x3e, 0x7f, 0xfe, 0x3f, 0xfc, 0x1f, 0xf0, 0x7, 0xc0}

/* igrave (236) */
#define NXFONT_METRICS_236 {1, 7, 25, 1, 12, 0}
#define NXFONT_BITMAP_236 {0xf0, 0x78, 0x38, 0x1c, 0xe, 0x0, 0x0, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e}

/* iacute (237) */
#define NXFONT_METRICS_237 {1, 6, 25, 2, 12, 0}
#define NXFONT_BITMAP_237 {0x3c, 0x38, 0x70, 0x70, 0xe0, 0x0, 0x0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0}

/* icircumflex (238) -- NOTE: Xoffset should be -1, not 0. */
#define NXFONT_METRICS_238 {2, 10, 25, 0, 12, 0}
#define NXFONT_BITMAP_238 {0xc, 0x0, 0x1e, 0x0, 0x3f, 0x0, 0x73, 0x80, 0xe1, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0}

/* idieresis (239) - NOTE: Xoffset should be -1, not 0. */
#define NXFONT_METRICS_239 {2, 10, 24, 0, 13, 0}
#define NXFONT_BITMAP_239 {0xf3, 0xc0, 0xf3, 0xc0, 0xf3, 0xc0, 0xf3, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x1e, 0x0}

/* eth (240) */
#define NXFONT_METRICS_240 {3, 17, 26, 1, 11, 0}
#define NXFONT_BITMAP_240 {0x30, 0x0, 0x0, 0x78, 0x20, 0x0, 0x7c, 0xf0, 0x0, 0x3f, 0xe0, 0x0, 0x1f, 0xc0, 0x0, 0x3f, 0xe0, 0x0, 0x73, 0xf0, 0x0, 0x21, 0xf8, 0x0, 0x7, 0xfc, 0x0, 0x1f, 0xfe, 0x0, 0x3f, 0xfe, 0x0, 0x7f, 0xff, 0x0, 0x7c, 0x1f, 0x0, 0xf8, 0xf, 0x80, 0xf8, 0xf, 0x80, 0xf0, 0x7, 0x80, 0xf0, 0x7, 0x80, 0xf0, 0x7, 0x80, 0xf8, 0xf, 0x80, 0xf8, 0xf, 0x80, 0xfc, 0x1f, 0x80, 0x7e, 0x3f, 0x0, 0x7f, 0xff, 0x0, 0x3f, 0xfe, 0x0, 0x1f, 0xfc, 0x0, 0x7, 0xf0, 0x0}

/* ntilde (241) */
#define NXFONT_METRICS_241 {2, 15, 24, 2, 13, 0}
#define NXFONT_BITMAP_241 {0xf, 0x18, 0x1f, 0xf8, 0x3f, 0xf0, 0x31, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xf3, 0xf0, 0xf7, 0xf8, 0xff, 0xfc, 0xff, 0xfe, 0xfc, 0x3e, 0xf8, 0x3e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e}

/* ograve (242) */
#define NXFONT_METRICS_242 {3, 17, 25, 1, 12, 0}
#define NXFONT_BITMAP_242 {0x7, 0x80, 0x0, 0x3, 0xc0, 0x0, 0x1, 0xc0, 0x0, 0x1, 0xe0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xf0, 0x0, 0x1f, 0xfc, 0x0, 0x3f, 0xfe, 0x0, 0x7f, 0xff, 0x0, 0x7c, 0x1f, 0x0, 0xf8, 0xf, 0x80, 0xf8, 0xf, 0x80, 0xf0, 0x7, 0x80, 0xf0, 0x7, 0x80, 0xf0, 0x7, 0x80, 0xf0, 0x7, 0x80, 0xf8, 0xf, 0x80, 0xf8, 0xf, 0x80, 0x7c, 0x1f, 0x0, 0x7f, 0xff, 0x0, 0x3f, 0xfe, 0x0, 0x1f, 0xfc, 0x0, 0x7, 0xf0, 0x0}

/* oacute (243) */
#define NXFONT_METRICS_243 {3, 17, 25, 1, 12, 0}
#define NXFONT_BITMAP_243 {0x0, 0x78, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xe0, 0x0, 0x1, 0xc0, 0x0, 0x3, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xf0, 0x0, 0x1f, 0xfc, 0x0, 0x3f, 0xfe, 0x0, 0x7f, 0xff, 0x0, 0x7c, 0x1f, 0x0, 0xf8, 0xf, 0x80, 0xf8, 0xf, 0x80, 0xf0, 0x7, 0x80, 0xf0, 0x7, 0x80, 0xf0, 0x7, 0x80, 0xf0, 0x7, 0x80, 0xf8, 0xf, 0x80, 0xf8, 0xf, 0x80, 0x7c, 0x1f, 0x0, 0x7f, 0xff, 0x0, 0x3f, 0xfe, 0x0, 0x1f, 0xfc, 0x0, 0x7, 0xf0, 0x0}

/* ocircumflex (244) */
#define NXFONT_METRICS_244 {3, 17, 25, 1, 12, 0}
#define NXFONT_BITMAP_244 {0x0, 0xc0, 0x0, 0x1, 0xe0, 0x0, 0x3, 0xf0, 0x0, 0x7, 0x38, 0x0, 0xe, 0x1c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xf0, 0x0, 0x1f, 0xfc, 0x0, 0x3f, 0xfe, 0x0, 0x7f, 0xff, 0x0, 0x7c, 0x1f, 0x0, 0xf8, 0xf, 0x80, 0xf8, 0xf, 0x80, 0xf0, 0x7, 0x80, 0xf0, 0x7, 0x80, 0xf0, 0x7, 0x80, 0xf0, 0x7, 0x80, 0xf8, 0xf, 0x80, 0xf8, 0xf, 0x80, 0x7c, 0x1f, 0x0, 0x7f, 0xff, 0x0, 0x3f, 0xfe, 0x0, 0x1f, 0xfc, 0x0, 0x7, 0xf0, 0x0}

/* otilde (245) */
#define NXFONT_METRICS_245 {3, 17, 24, 1, 13, 0}
#define NXFONT_BITMAP_245 {0x7, 0x8c, 0x0, 0xf, 0xfc, 0x0, 0x1f, 0xf8, 0x0, 0x18, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xf0, 0x0, 0x1f, 0xfc, 0x0, 0x3f, 0xfe, 0x0, 0x7f, 0xff, 0x0, 0x7c, 0x1f, 0x0, 0xf8, 0xf, 0x80, 0xf8, 0xf, 0x80, 0xf0, 0x7, 0x80, 0xf0, 0x7, 0x80, 0xf0, 0x7, 0x80, 0xf0, 0x7, 0x80, 0xf8, 0xf, 0x80, 0xf8, 0xf, 0x80, 0x7c, 0x1f, 0x0, 0x7f, 0xff, 0x0, 0x3f, 0xfe, 0x0, 0x1f, 0xfc, 0x0, 0x7, 0xf0, 0x0}

/* odieresis (246) */
#define NXFONT_METRICS_246 {3, 17, 24, 1, 13, 0}
#define NXFONT_BITMAP_246 {0x1e, 0x3c, 0x0, 0x1e, 0x3c, 0x0, 0x1e, 0x3c, 0x0, 0x1e, 0x3c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xf0, 0x0, 0x1f, 0xfc, 0x0, 0x3f, 0xfe, 0x0, 0x7f, 0xff, 0x0, 0x7c, 0x1f, 0x0, 0xf8, 0xf, 0x80, 0xf8, 0xf, 0x80, 0xf0, 0x7, 0x80, 0xf0, 0x7, 0x80, 0xf0, 0x7, 0x80, 0xf0, 0x7, 0x80, 0xf8, 0xf, 0x80, 0xf8, 0xf, 0x80, 0x7c, 0x1f, 0x0, 0x7f, 0xff, 0x0, 0x3f, 0xfe, 0x0, 0x1f, 0xfc, 0x0, 0x7, 0xf0, 0x0}

/* divide (247) */
#define NXFONT_METRICS_247 {2, 16, 16, 1, 21, 0}
#define NXFONT_BITMAP_247 {0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0}

/* oslash (248) - NOTE: Xoffset should be -1, not 0. */
#define NXFONT_METRICS_248 {3, 21, 18, 0, 19, 0}
#define NXFONT_BITMAP_248 {0x1, 0xfc, 0x38, 0x7, 0xff, 0x70, 0xf, 0xff, 0xe0, 0x1f, 0xff, 0xc0, 0x1f, 0x8f, 0xc0, 0x3e, 0x7, 0xe0, 0x3e, 0xf, 0xe0, 0x3c, 0x1d, 0xe0, 0x3c, 0x39, 0xe0, 0x3c, 0x71, 0xe0, 0x3e, 0xe3, 0xe0, 0x3f, 0x83, 0xe0, 0x3f, 0x7, 0xe0, 0x1f, 0x8f, 0xc0, 0x1f, 0xff, 0xc0, 0x3f, 0xff, 0x80, 0x77, 0xff, 0x0, 0xe1, 0xfc, 0x0}

/* ugrave (249) */
#define NXFONT_METRICS_249 {2, 15, 25, 2, 12, 0}
#define NXFONT_BITMAP_249 {0x1e, 0x0, 0xf, 0x0, 0x7, 0x0, 0x3, 0x80, 0x1, 0xc0, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf8, 0x3e, 0xf8, 0x7e, 0xff, 0xfe, 0x7f, 0xfe, 0x7f, 0xde, 0x1f, 0x1e}

/* uacute (250) */
#define NXFONT_METRICS_250 {2, 15, 25, 2, 12, 0}
#define NXFONT_BITMAP_250 {0x0, 0xf0, 0x1, 0xe0, 0x1, 0xc0, 0x3, 0x80, 0x7, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf8, 0x3e, 0xf8, 0x7e, 0xff, 0xfe, 0x7f, 0xfe, 0x7f, 0xde, 0x1f, 0x1e}

/* ucircumflex (251) */
#define NXFONT_METRICS_251 {2, 15, 25, 2, 12, 0}
#define NXFONT_BITMAP_251 {0x3, 0x0, 0x7, 0x80, 0xf, 0xc0, 0x1c, 0xe0, 0x38, 0x70, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf8, 0x3e, 0xf8, 0x7e, 0xff, 0xfe, 0x7f, 0xfe, 0x7f, 0xde, 0x1f, 0x1e}

/* udieresis (252) */
#define NXFONT_METRICS_252 {2, 15, 25, 2, 12, 0}
#define NXFONT_BITMAP_252 {0x3c, 0x78, 0x3c, 0x78, 0x3c, 0x78, 0x3c, 0x78, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf0, 0x1e, 0xf8, 0x3e, 0xf8, 0x7e, 0xff, 0xfe, 0x7f, 0xfe, 0x7f, 0xde, 0x1f, 0x1e}

/* yacute (253) */
#define NXFONT_METRICS_253 {2, 16, 32, 1, 12, 0}
#define NXFONT_BITMAP_253 {0x0, 0x78, 0x0, 0xf0, 0x1, 0xe0, 0x1, 0xc0, 0x3, 0x80, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x1f, 0xf8, 0x1f, 0xf8, 0x1f, 0x78, 0x1e, 0x7c, 0x3e, 0x7c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3e, 0x78, 0x3e, 0x78, 0x1e, 0x78, 0x1f, 0xf0, 0x1f, 0xf0, 0xf, 0xf0, 0xf, 0xe0, 0x7, 0xe0, 0x7, 0xe0, 0x7, 0xc0, 0x7, 0xc0, 0x7, 0xc0, 0xf, 0x80, 0x3f, 0x80, 0x3f, 0x0, 0x3f, 0x0, 0x3c, 0x0}

/* thorn (254) */
#define NXFONT_METRICS_254 {2, 16, 32, 2, 12, 0}
#define NXFONT_BITMAP_254 {0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf3, 0xf0, 0xf7, 0xfc, 0xff, 0xfe, 0xff, 0xfe, 0xfc, 0x3f, 0xf8, 0x1f, 0xf8, 0x1f, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf8, 0x1f, 0xf8, 0x1f, 0xfc, 0x3e, 0xff, 0xfe, 0xff, 0xfc, 0xf7, 0xf8, 0xf1, 0xf0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0}

/* ydieresis (255) */
#define NXFONT_METRICS_255 {2, 16, 31, 1, 13, 0}
#define NXFONT_BITMAP_255 {0x1e, 0x78, 0x1e, 0x78, 0x1e, 0x78, 0x1e, 0x78, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x1f, 0xf8, 0x1f, 0xf8, 0x1f, 0x78, 0x3e, 0x7c, 0x3e, 0x7c, 0x3c, 0x7c, 0x3c, 0x3e, 0x7c, 0x3e, 0x78, 0x3e, 0x78, 0x1e, 0x78, 0x1f, 0xf0, 0x1f, 0xf0, 0xf, 0xf0, 0xf, 0xe0, 0x7, 0xe0, 0x7, 0xe0, 0x7, 0xc0, 0x7, 0xc0, 0x7, 0xc0, 0xf, 0x80, 0x3f, 0x80, 0x3f, 0x0, 0x3f, 0x0, 0x3c, 0x0}

/****************************************************************************
 * Public Types
 ****************************************************************************/

/****************************************************************************
 * Public Data
 ****************************************************************************/

#undef EXTERN
#if defined(__cplusplus)
#define EXTERN extern "C"
extern "C" {
#else
#define EXTERN extern
#endif

/****************************************************************************
 * Public Functions
 ****************************************************************************/

#undef EXTERN
#if defined(__cplusplus)
}
#endif

#endif /* __LIBNX_NXFONTS_NXFONTS_SANS40X49B_H */
