/****************************************************************************
 * arch/arm/src/mcx-nxxx/hardware/n236/n236_memorymap.h
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

/****************************************************************************
 * Pre-processor Definitions
 ****************************************************************************/

#ifndef __ARCH_ARM_SRC_MCX_NXXX_HARDWARE_N236_N236_MEMORYMAP_H
#define __ARCH_ARM_SRC_MCX_NXXX_HARDWARE_N236_N236_MEMORYMAP_H

#define NXXX_ADC0_BASE                    (0x4010D000u)
#define NXXX_ADC1_BASE                    (0x4010E000u)
#define NXXX_AHBSC_BASE                   (0x40120000u)
#define NXXX_AHBSC_ALIAS1_BASE            (0x40121000u)
#define NXXX_AHBSC_ALIAS2_BASE            (0x40122000u)
#define NXXX_AHBSC_ALIAS3_BASE            (0x40123000u)
#define NXXX_CAN0_BASE                    (0x400D4000u)
#define NXXX_CAN1_BASE                    (0x400D8000u)
#define NXXX_CDOG0_BASE                   (0x400BB000u)
#define NXXX_CDOG1_BASE                   (0x400BC000u)
#define NXXX_CMC0_BASE                    (0x40048000u)
#define NXXX_CRC0_BASE                    (0x400CB000u)
#define NXXX_CTIMER0_BASE                 (0x4000C000u)
#define NXXX_CTIMER1_BASE                 (0x4000D000u)
#define NXXX_CTIMER2_BASE                 (0x4000E000u)
#define NXXX_CTIMER3_BASE                 (0x4000F000u)
#define NXXX_CTIMER4_BASE                 (0x40010000u)
#define NXXX_TDET0_BASE                   (0x40058000u)
#define NXXX_DM0_BASE                     (0x400BD000u)
#define NXXX_DMA0_BASE                    (0x40080000u)
#define NXXX_DMA1_BASE                    (0x400A0000u)
#define NXXX_EIM0_BASE                    (0x4005B000u)
#define NXXX_ERM0_BASE                    (0x4005C000u)
#define NXXX_EVTG0_BASE                   (0x400D2000u)
#define NXXX_EWM0_BASE                    (0x400C0000u)
#define NXXX_FLEXIO0_BASE                 (0x40105000u)
#define NXXX_FMU0_BASE                    (0x40043000u)
#define NXXX_FMU0TEST_BASE                (0x40043000u)
#define NXXX_FREQME0_BASE                 (0x40011000u)
#define NXXX_GDET0_BASE                   (0x40024000u)
#define NXXX_GDET1_BASE                   (0x40025000u)
#define NXXX_GPIO0_BASE                   (0x40096000u)
#define NXXX_GPIO0_ALIAS1_BASE            (0x40097000u)
#define NXXX_GPIO1_BASE                   (0x40098000u)
#define NXXX_GPIO1_ALIAS1_BASE            (0x40099000u)
#define NXXX_GPIO2_BASE                   (0x4009A000u)
#define NXXX_GPIO2_ALIAS1_BASE            (0x4009B000u)
#define NXXX_GPIO3_BASE                   (0x4009C000u)
#define NXXX_GPIO3_ALIAS1_BASE            (0x4009D000u)
#define NXXX_GPIO4_BASE                   (0x4009E000u)
#define NXXX_GPIO4_ALIAS1_BASE            (0x4009F000u)
#define NXXX_GPIO5_BASE                   (0x40040000u)
#define NXXX_GPIO5_ALIAS1_BASE            (0x40041000u)
#define NXXX_SAI0_BASE                    (0x40106000u)
#define NXXX_SAI1_BASE                    (0x40107000u)
#define NXXX_I3C0_BASE                    (0x40021000u)
#define NXXX_I3C1_BASE                    (0x40022000u)
#define NXXX_INPUTMUX0_BASE               (0x40006000u)
#define NXXX_INTM0_BASE                   (0x4005D000u)
#define NXXX_ITRC0_BASE                   (0x40026000u)
#define NXXX_CMP0_BASE                    (0x40051000u)
#define NXXX_CMP1_BASE                    (0x40052000u)
#define NXXX_LPI2C0_BASE                  (0x40092800u)
#define NXXX_LPI2C1_BASE                  (0x40093800u)
#define NXXX_LPI2C2_BASE                  (0x40094800u)
#define NXXX_LPI2C3_BASE                  (0x40095800u)
#define NXXX_LPI2C4_BASE                  (0x400B4800u)
#define NXXX_LPI2C5_BASE                  (0x400B5800u)
#define NXXX_LPI2C6_BASE                  (0x400B6800u)
#define NXXX_LPI2C7_BASE                  (0x400B7800u)
#define NXXX_LPSPI0_BASE                  (0x40092000u)
#define NXXX_LPSPI1_BASE                  (0x40093000u)
#define NXXX_LPSPI2_BASE                  (0x40094000u)
#define NXXX_LPSPI3_BASE                  (0x40095000u)
#define NXXX_LPSPI4_BASE                  (0x400B4000u)
#define NXXX_LPSPI5_BASE                  (0x400B5000u)
#define NXXX_LPSPI6_BASE                  (0x400B6000u)
#define NXXX_LPSPI7_BASE                  (0x400B7000u)
#define NXXX_LPTMR0_BASE                  (0x4004A000u)
#define NXXX_LPTMR1_BASE                  (0x4004B000u)
#define NXXX_LPUART0_BASE                 (0x40092000u)
#define NXXX_LPUART1_BASE                 (0x40093000u)
#define NXXX_LPUART2_BASE                 (0x40094000u)
#define NXXX_LPUART3_BASE                 (0x40095000u)
#define NXXX_LPUART4_BASE                 (0x400B4000u)
#define NXXX_LPUART5_BASE                 (0x400B5000u)
#define NXXX_LPUART6_BASE                 (0x400B6000u)
#define NXXX_LPUART7_BASE                 (0x400B7000u)
#define NXXX_FLEXCOMM0_BASE               (0x40092000u)
#define NXXX_FLEXCOMM1_BASE               (0x40093000u)
#define NXXX_FLEXCOMM2_BASE               (0x40094000u)
#define NXXX_FLEXCOMM3_BASE               (0x40095000u)
#define NXXX_FLEXCOMM4_BASE               (0x400B4000u)
#define NXXX_FLEXCOMM5_BASE               (0x400B5000u)
#define NXXX_FLEXCOMM6_BASE               (0x400B6000u)
#define NXXX_FLEXCOMM7_BASE               (0x400B7000u)
#define NXXX_MRT0_BASE                    (0x40013000u)
#define NXXX_NPX0_BASE                    (0x400CC000u)
#define NXXX_OSTIMER0_BASE                (0x40049000u)
#define NXXX_OTPC0_BASE                   (0x400C9000u)
#define NXXX_PDM_BASE                     (0x4010C000u)
#define NXXX_PINT0_BASE                   (0x40004000u)
#define NXXX_PKC0_BASE                    (0x4002B000u)
#define NXXX_PORT0_BASE                   (0x40116000u)
#define NXXX_PORT1_BASE                   (0x40117000u)
#define NXXX_PORT2_BASE                   (0x40118000u)
#define NXXX_PORT3_BASE                   (0x40119000u)
#define NXXX_PORT4_BASE                   (0x4011A000u)
#define NXXX_PORT5_BASE                   (0x40042000u)
#define NXXX_PUF_BASE                     (0x4002C000u)
#define NXXX_PUF_ALIAS1_BASE              (0x4002D000u)
#define NXXX_PUF_ALIAS2_BASE              (0x4002E000u)
#define NXXX_PUF_ALIAS3_BASE              (0x4002F000u)
#define NXXX_PWM0_BASE                    (0x400CE000u)
#define NXXX_PWM1_BASE                    (0x400D0000u)
#define NXXX_QDC0_BASE                    (0x400CF000u)
#define NXXX_QDC1_BASE                    (0x400D1000u)
#define NXXX_RTC0_BASE                    (0x4004C000u)
#define NXXX_ELS_BASE                     (0x40054000u)
#define NXXX_ELS_ALIAS1_BASE              (0x40055000u)
#define NXXX_ELS_ALIAS2_BASE              (0x40056000u)
#define NXXX_ELS_ALIAS3_BASE              (0x40057000u)
#define NXXX_SCG0_BASE                    (0x40044000u)
#define NXXX_SMARTDMA0_BASE               (0x40033000u)
#define NXXX_SPC0_BASE                    (0x40045000u)
#define NXXX_SYSCON0_BASE                 (0x40000000u)
#define NXXX_CMX_PERFMON0_BASE            (0x400C1000u)
#define NXXX_TRDC_BASE                    (0x400C7000u)
#define NXXX_USBHS1__USBC_BASE            (0x4010B000u)
#define NXXX_USBHS1_PHY_DCD_BASE          (0x4010A000u)
#define NXXX_USBHS1__USBNC_BASE           (0x4010B200u)
#define NXXX_USBPHY_BASE                  (0x4010A000u)
#define NXXX_UTICK0_BASE                  (0x40012000u)
#define NXXX_VBAT0_BASE                   (0x40059000u)
#define NXXX_VREF0_BASE                   (0x40111000u)
#define NXXX_WUU0_BASE                    (0x40046000u)
#define NXXX_WWDT0_BASE                   (0x40016000u)
#define NXXX_WWDT1_BASE                   (0x40017000u)

#endif /* __ARCH_ARM_SRC_MCX_NXXX_HARDWARE_N236_N236_MEMORYMAP_H */
