/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.composite;

import jakarta.faces.component.UIComponent;
import jakarta.faces.view.facelets.ComponentConfig;
import jakarta.faces.view.facelets.ComponentHandler;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagException;
import java.beans.BeanDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.view.facelets.AbstractFaceletContext;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.tag.composite.CompositeComponentBeanInfo;

public class RenderFacetHandler
extends ComponentHandler {
    private static final Logger log = Logger.getLogger(RenderFacetHandler.class.getName());
    public static final String RENDER_FACET_USED = "org.apache.myfaces.RENDER_FACET_USED";
    protected final TagAttribute _name = this.getRequiredAttribute("name");
    protected final TagAttribute _required = this.getAttribute("required");

    public RenderFacetHandler(ComponentConfig config) {
        super(config);
    }

    @Override
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        if (((AbstractFaceletContext)ctx).isBuildingCompositeComponentMetadata()) {
            String facetName = this._name.getValue(ctx);
            UIComponent compositeBaseParent = FaceletCompositionContext.getCurrentInstance(ctx).getCompositeComponentFromStack();
            CompositeComponentBeanInfo beanInfo = (CompositeComponentBeanInfo)compositeBaseParent.getAttributes().get("jakarta.faces.component.BEANINFO_KEY");
            if (beanInfo == null) {
                if (log.isLoggable(Level.SEVERE)) {
                    log.severe("Cannot find composite bean descriptor UIComponent.BEANINFO_KEY ");
                }
                return;
            }
            BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
            ArrayList<String> facetList = (ArrayList<String>)beanDescriptor.getValue(RENDER_FACET_USED);
            if (facetList == null) {
                facetList = new ArrayList<String>(5);
                beanDescriptor.setValue(RENDER_FACET_USED, facetList);
            }
            facetList.add(facetName);
        } else {
            super.apply(ctx, parent);
        }
    }

    @Override
    public void onComponentPopulated(FaceletContext ctx, UIComponent c, UIComponent parent) {
        if (!((AbstractFaceletContext)ctx).isBuildingCompositeComponentMetadata()) {
            UIComponent parentCompositeComponent = FaceletCompositionContext.getCurrentInstance(ctx).getCompositeComponentFromStack();
            String facetName = this._name.getValue(ctx);
            if (this._required != null && this._required.getBoolean(ctx) && parentCompositeComponent.getFacet(facetName) == null) {
                throw new TagException(this.tag, "Cannot find facet with name '" + facetName + "' in composite component");
            }
            c.getAttributes().put("jakarta.faces.component.FACETS_KEY", facetName);
        }
    }
}

