/*
 * Decompiled with CFR 0.152.
 */
package jakarta.enterprise.inject.spi.configurator;

import jakarta.enterprise.inject.spi.AnnotatedConstructor;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.configurator.AnnotatedConstructorConfigurator;
import jakarta.enterprise.inject.spi.configurator.AnnotatedFieldConfigurator;
import jakarta.enterprise.inject.spi.configurator.AnnotatedMethodConfigurator;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;

public interface AnnotatedTypeConfigurator<T> {
    public AnnotatedType<T> getAnnotated();

    public AnnotatedTypeConfigurator<T> add(Annotation var1);

    public AnnotatedTypeConfigurator<T> remove(Predicate<Annotation> var1);

    default public AnnotatedTypeConfigurator<T> removeAll() {
        this.remove(e -> true);
        return this;
    }

    public Set<AnnotatedMethodConfigurator<? super T>> methods();

    default public Stream<AnnotatedMethodConfigurator<? super T>> filterMethods(Predicate<AnnotatedMethod<? super T>> predicate) {
        return this.methods().stream().filter(c -> predicate.test(c.getAnnotated()));
    }

    public Set<AnnotatedFieldConfigurator<? super T>> fields();

    default public Stream<AnnotatedFieldConfigurator<? super T>> filterFields(Predicate<AnnotatedField<? super T>> predicate) {
        return this.fields().stream().filter(f -> predicate.test(f.getAnnotated()));
    }

    public Set<AnnotatedConstructorConfigurator<T>> constructors();

    default public Stream<AnnotatedConstructorConfigurator<T>> filterConstructors(Predicate<AnnotatedConstructor<T>> predicate) {
        return this.constructors().stream().filter(c -> predicate.test(c.getAnnotated()));
    }
}

