/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.el;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.PropertyNotWritableException;
import jakarta.el.ValueExpression;
import jakarta.el.ValueReference;
import jakarta.faces.FacesWrapper;
import jakarta.faces.view.Location;
import jakarta.faces.view.facelets.TagAttribute;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.myfaces.view.facelets.el.ContextAware;
import org.apache.myfaces.view.facelets.el.ContextAwareELException;
import org.apache.myfaces.view.facelets.el.ContextAwarePropertyNotFoundException;
import org.apache.myfaces.view.facelets.el.ContextAwarePropertyNotWritableException;

public class ContextAwareTagValueExpression
extends ValueExpression
implements Externalizable,
FacesWrapper<ValueExpression>,
ContextAware {
    private static final long serialVersionUID = 1L;
    private ValueExpression _wrapped;
    private Location _location;
    private String _qName;

    public ContextAwareTagValueExpression() {
    }

    public ContextAwareTagValueExpression(TagAttribute tagAttribute, ValueExpression valueExpression) {
        this._location = tagAttribute.getLocation();
        this._qName = tagAttribute.getQName();
        this._wrapped = valueExpression;
    }

    public Class<?> getExpectedType() {
        return this._wrapped.getExpectedType();
    }

    public Class<?> getType(ELContext context) {
        try {
            return this._wrapped.getType(context);
        }
        catch (PropertyNotFoundException pnfe) {
            throw new ContextAwarePropertyNotFoundException(this.getLocation(), this.getLocalExpressionString(), this.getQName(), pnfe);
        }
        catch (ELException e) {
            throw new ContextAwareELException(this.getLocation(), this.getLocalExpressionString(), this.getQName(), e);
        }
    }

    public Object getValue(ELContext context) {
        try {
            return this._wrapped.getValue(context);
        }
        catch (PropertyNotFoundException pnfe) {
            throw new ContextAwarePropertyNotFoundException(this.getLocation(), this.getLocalExpressionString(), this.getQName(), pnfe);
        }
        catch (ELException e) {
            throw new ContextAwareELException(this.getLocation(), this.getLocalExpressionString(), this.getQName(), e);
        }
    }

    private String getLocalExpressionString() {
        String expressionString = null;
        try {
            expressionString = this.getExpressionString();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return expressionString;
    }

    public boolean isReadOnly(ELContext context) {
        try {
            return this._wrapped.isReadOnly(context);
        }
        catch (PropertyNotFoundException pnfe) {
            throw new ContextAwarePropertyNotFoundException(this.getLocation(), this.getLocalExpressionString(), this.getQName(), pnfe);
        }
        catch (ELException e) {
            throw new ContextAwareELException(this.getLocation(), this.getLocalExpressionString(), this.getQName(), e);
        }
    }

    public void setValue(ELContext context, Object value) {
        try {
            this._wrapped.setValue(context, value);
        }
        catch (PropertyNotFoundException pnfe) {
            throw new ContextAwarePropertyNotFoundException(this.getLocation(), this.getLocalExpressionString(), this.getQName(), pnfe);
        }
        catch (PropertyNotWritableException pnwe) {
            throw new ContextAwarePropertyNotWritableException(this.getLocation(), this.getLocalExpressionString(), this.getQName(), pnwe);
        }
        catch (ELException e) {
            throw new ContextAwareELException(this.getLocation(), this.getLocalExpressionString(), this.getQName(), e);
        }
    }

    public boolean equals(Object obj) {
        return this._wrapped.equals(obj);
    }

    @Override
    public String getExpressionString() {
        return this._wrapped.getExpressionString();
    }

    public int hashCode() {
        return this._wrapped.hashCode();
    }

    public boolean isLiteralText() {
        return this._wrapped.isLiteralText();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._wrapped = (ValueExpression)in.readObject();
        this._location = (Location)in.readObject();
        this._qName = in.readUTF();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._wrapped);
        out.writeObject(this._location);
        out.writeUTF(this._qName);
    }

    public String toString() {
        return this._location + ": " + this._wrapped;
    }

    public ValueExpression getWrapped() {
        return this._wrapped;
    }

    @Override
    public Location getLocation() {
        return this._location;
    }

    @Override
    public String getQName() {
        return this._qName;
    }

    public ValueReference getValueReference(ELContext context) {
        try {
            return this.getWrapped().getValueReference(context);
        }
        catch (PropertyNotFoundException pnfe) {
            throw new ContextAwarePropertyNotFoundException(this.getLocation(), this.getExpressionString(), this.getQName(), pnfe);
        }
        catch (ELException e) {
            throw new ContextAwareELException(this.getLocation(), this.getExpressionString(), this.getQName(), e);
        }
    }
}

