/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config.annotation;

import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.faces.bean.ManagedBean;
import jakarta.faces.component.FacesComponent;
import jakarta.faces.component.behavior.FacesBehavior;
import jakarta.faces.convert.FacesConverter;
import jakarta.faces.render.FacesBehaviorRenderer;
import jakarta.faces.render.FacesRenderer;
import jakarta.faces.validator.FacesValidator;
import jakarta.faces.view.facelets.FaceletsResourceResolver;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.myfaces.config.element.NamedEvent;

public class CdiAnnotationProviderExtension
implements Extension {
    public static final String USE_CDI_FOR_ANNOTATION_SCANNING = "org.apache.myfaces.annotation.USE_CDI_FOR_ANNOTATION_SCANNING";
    private final Map<Class<? extends Annotation>, Set<Class<?>>> map = new HashMap();
    private final Class<? extends Annotation>[] annotationsToScan = new Class[]{FacesComponent.class, FacesBehavior.class, FacesConverter.class, FacesValidator.class, FacesRenderer.class, ManagedBean.class, NamedEvent.class, FacesBehaviorRenderer.class, FaceletsResourceResolver.class};

    <T> void processAnnotatedType(@Observes ProcessAnnotatedType<T> pat) {
        AnnotatedType type = pat.getAnnotatedType();
        for (Class<? extends Annotation> annotation : this.annotationsToScan) {
            if (!type.isAnnotationPresent(annotation)) continue;
            Set<Class<?>> set = this.map.get(annotation);
            if (set == null) {
                set = new HashSet();
                this.map.put(annotation, set);
            }
            set.add(type.getJavaClass());
        }
    }

    public Map<Class<? extends Annotation>, Set<Class<?>>> getMap() {
        return this.map;
    }
}

