/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.scope;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.faces.context.FacesContext;
import java.util.HashMap;
import java.util.Map;
import org.apache.myfaces.cdi.scope.ViewTransientScopedContextImpl;
import org.apache.myfaces.cdi.util.ContextualInstanceInfo;
import org.apache.myfaces.cdi.util.ContextualStorage;

public class ViewTransientScopeBeanHolder {
    public static final String VIEW_TRANSIENT_SCOPE_MAP = "oam.VIEW_TRANSIENT_SCOPE_MAP";
    public static final String VIEW_TRANSIENT_SCOPE_MAP_INFO = "oam.VIEW_TRANSIENT_SCOPE_MAP_INFO";

    public void init() {
    }

    public static ContextualStorage getContextualStorage(BeanManager beanManager, FacesContext facesContext) {
        ContextualStorage contextualStorage = (ContextualStorage)facesContext.getViewRoot().getTransientStateHelper().getTransient((Object)VIEW_TRANSIENT_SCOPE_MAP);
        if (contextualStorage == null) {
            contextualStorage = new ContextualStorage(beanManager, false, false);
            facesContext.getViewRoot().getTransientStateHelper().putTransient((Object)VIEW_TRANSIENT_SCOPE_MAP, (Object)contextualStorage);
        }
        return contextualStorage;
    }

    public ContextualStorage getContextualStorageNoCreate(BeanManager beanManager, FacesContext facesContext) {
        return (ContextualStorage)facesContext.getViewRoot().getTransientStateHelper().getTransient((Object)VIEW_TRANSIENT_SCOPE_MAP);
    }

    public Map<Object, Object> getFacesScopeMap(BeanManager beanManager, FacesContext facesContext, boolean create) {
        HashMap map = null;
        if (create) {
            ContextualStorage contextualStorage = ViewTransientScopeBeanHolder.getContextualStorage(beanManager, facesContext);
            ContextualInstanceInfo<Object> info = contextualStorage.getStorage().get(VIEW_TRANSIENT_SCOPE_MAP_INFO);
            if (info == null) {
                info = new ContextualInstanceInfo();
                contextualStorage.getStorage().put(VIEW_TRANSIENT_SCOPE_MAP_INFO, info);
            }
            if ((map = (HashMap)info.getContextualInstance()) == null) {
                map = new HashMap();
                info.setContextualInstance(map);
            }
        } else {
            ContextualInstanceInfo<?> info;
            ContextualStorage contextualStorage = this.getContextualStorageNoCreate(beanManager, facesContext);
            if (contextualStorage != null && (info = contextualStorage.getStorage().get(VIEW_TRANSIENT_SCOPE_MAP_INFO)) != null) {
                map = (Map)info.getContextualInstance();
            }
        }
        return map;
    }

    public ContextualStorage forceNewStorage(FacesContext facesContext) {
        return (ContextualStorage)facesContext.getViewRoot().getTransientStateHelper().putTransient((Object)VIEW_TRANSIENT_SCOPE_MAP, null);
    }

    public void destroyBeans(FacesContext facesContext) {
        ContextualStorage oldWindowContextStorages = this.forceNewStorage(facesContext);
        if (oldWindowContextStorages != null) {
            ViewTransientScopedContextImpl.destroyAllActive(oldWindowContextStorages);
        }
    }
}

