/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.push.cdi;

import jakarta.annotation.PreDestroy;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.faces.view.ViewScoped;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.push.cdi.WebsocketApplicationSessionHolder;
import org.apache.myfaces.push.cdi.WebsocketChannel;
import org.apache.myfaces.push.cdi.WebsocketChannelMetadata;
import org.apache.myfaces.push.cdi.WebsocketSessionBean;

@ViewScoped
public class WebsocketViewBean
implements Serializable {
    private Map<String, List<WebsocketChannel>> channelTokenListMap = new HashMap<String, List<WebsocketChannel>>(2);
    private Map<String, WebsocketChannelMetadata> tokenList = new HashMap<String, WebsocketChannelMetadata>(2);

    public void registerToken(String token, WebsocketChannelMetadata metadata) {
        this.tokenList.put(token, metadata);
    }

    public void registerWebsocketSession(String token, WebsocketChannelMetadata metadata) {
        if ("view".equals(metadata.getScope())) {
            this.channelTokenListMap.putIfAbsent(metadata.getChannel(), new ArrayList(1));
            this.channelTokenListMap.get(metadata.getChannel()).add(new WebsocketChannel(token, metadata));
        }
    }

    public boolean isSessionTokenValid(String token) {
        boolean valid = false;
        for (List<WebsocketChannel> chlist : this.channelTokenListMap.values()) {
            if (!chlist.contains(token)) continue;
            valid = true;
            break;
        }
        return valid;
    }

    public boolean isChannelAvailable(String channel) {
        return this.channelTokenListMap.containsKey(channel);
    }

    public List<String> getChannelTokensFor(String channel) {
        List<WebsocketChannel> list = this.channelTokenListMap.get(channel);
        if (list != null && !list.isEmpty()) {
            ArrayList<String> value = new ArrayList<String>(list.size());
            for (WebsocketChannel md : list) {
                value.add(md.getChannelToken());
            }
            return value;
        }
        return Collections.emptyList();
    }

    public String getChannelToken(WebsocketChannelMetadata metadata) {
        if (!metadata.isConnected()) {
            return null;
        }
        String token = null;
        for (Map.Entry<String, WebsocketChannelMetadata> entry : this.tokenList.entrySet()) {
            if (!metadata.equals(entry.getValue())) continue;
            token = entry.getKey();
            break;
        }
        return token;
    }

    public <S extends Serializable> List<String> getChannelTokensFor(String channel, S user) {
        List<WebsocketChannel> list = this.channelTokenListMap.get(channel);
        if (list != null && !list.isEmpty()) {
            ArrayList<String> value = new ArrayList<String>(list.size());
            for (WebsocketChannel md : list) {
                if (!user.equals(md.getUser())) continue;
                value.add(md.getChannelToken());
            }
            return value;
        }
        return null;
    }

    @PreDestroy
    public void destroy() {
        WebsocketSessionBean sessionHandler = CDIUtils.lookup(CDI.current().getBeanManager(), WebsocketSessionBean.class);
        if (sessionHandler != null) {
            for (String token : this.tokenList.keySet()) {
                sessionHandler.destroyChannelToken(token);
            }
        }
        for (String token : this.tokenList.keySet()) {
            WebsocketApplicationSessionHolder.removeSession(token);
        }
        this.channelTokenListMap.clear();
        this.tokenList.clear();
    }
}

